/***************************************************************************
                          tablewidget.cpp  -  description
                             -------------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "tablewidget.h"
#include "xml_base.h"

#include <klocale.h>

TableWidget::TableWidget(int numRows, int numCols, QWidget *parent, const char *name)
	: QTable(numRows, numCols, parent, name)
{
	QHeader * pHeaderHorizontal = horizontalHeader();
	pHeaderHorizontal->setLabel( 0, i18n("Attribute name") );
	pHeaderHorizontal->setLabel( 1, i18n("Attribute value") );
}

/** Called, when mouse event occurs in widget */
void TableWidget::contentsMousePressEvent(QMouseEvent *e)
{
	if(e->button() == QMouseEvent::RightButton)
		{ QPoint vp = contentsToViewport(e->pos());
		  emit sigRightButtonPressed(viewport()->mapToGlobal(vp));

		  return;
		}

	QTable::contentsMousePressEvent(e);
}

void TableWidget::slotChange( XmlElement * const pElement )
{
	QListIterator<XmlAttribute> it( * pElement->GetListOfAttributes() );

	setNumRows( it.count() );

	for( int nRow = 0; it.current(); ++it )
	{
		setText( nRow, 0, it.current()->name() );
		setText( nRow, 1, it.current()->value() );
		adjustRow( nRow );
		nRow++;
	}

}
