/***************************************************************************
                          kxmleditor.h  -  description
                             -------------------
    begin                : t ec 10 12:39:26 CEST 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXMLEDITOR_H
#define KXMLEDITOR_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt

// include files for KDE
#include <kapp.h>
#include <kmainwindow.h>
#include <kaccel.h>
#include <kurl.h>

#include "kxmleditoractions.h"

// forward declaration of the KXMLEditor classes
class KXMLEditorDoc;
class KXMLEditorView;
class KXmlEditorComboAction;
class XmlTreeItem;

/**
  * The base class for KXMLEditor application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of KXMLEditorView creates your center view, which is connected
  * to the window's Doc object.
  * KXMLEditorApp reimplements the methods that KMainWindow provides for main window handling and supports
  * full session management as well as using KActions.
  * @see KMainWindow
  * @see KApplication
  * @see KConfig
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 1.2 code generation
  */
class KXMLEditorApp : public KMainWindow
{
  Q_OBJECT

  friend class KXMLEditorView;

  public:
    /** construtor of KXMLEditorApp, calls all init functions to create the application.
     */
    KXMLEditorApp(QWidget* parent=0, const char* name=0);
    ~KXMLEditorApp();
    /** opens a file specified by commandline option
     */
    void openDocumentFile(const KURL& url = 0, const QString & = 0);

    /** returns a pointer to the current document connected to the KTMainWindow instance and is used by
     * the View class to access the document object's methods
     */	
    KXMLEditorDoc *getDocument() const;

    KXMLEditorView *currentView() const { return view; }

  	/** Return path from combo */
  	QString path();

protected:
    /** save general Options like all bar positions and status as well as the geometry and the recent file list to the configuration
     * file
     */
    void saveOptions();
    /** read general Options again and initialize all variables like the recent file list
     */
    void readOptions();

    /** initializes the KActions of the application */
    void initActions();
    /** sets up the statusbar for the main window by initialzing a statuslabel.
     */
    void initStatusBar();
    /** initializes the document object of the main window that is connected to the view in initView().
     * @see initView();
     */
    void initDocument();
    /** creates the centerwidget of the KTMainWindow instance and sets it as the view
     */
    void initView();
    /** queryClose is called by KTMainWindow on each closeEvent of a window. Against the
     * default implementation (only returns true), this calles saveModified() on the document object to ask if the document shall
     * be saved if Modified; on cancel the closeEvent is rejected.
     * @see KTMainWindow#queryClose
     * @see KTMainWindow#closeEvent
     */
    virtual bool queryClose();
    /** queryExit is called by KTMainWindow when the last window of the application is going to be closed during the closeEvent().
     * Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's	
     * properties.
     * @see KTMainWindow#queryExit
     * @see KTMainWindow#closeEvent
     */
    virtual bool queryExit();
    /** saves the window properties for each open window during session end to the session config file, including saving the currently
     * opened file by a temporary filename provided by KApplication.
     * @see KTMainWindow#saveProperties
     */
    virtual void saveProperties(KConfig *_cfg);
    /** reads the session config file and restores the application's state including the last opened files and documents by reading the
     * temporary files saved by saveProperties()
     * @see KTMainWindow#readProperties
     */
    virtual void readProperties(KConfig *_cfg);

  /** Retreive pointer to toolbart from name */
  KToolBar * toolBarByName(const char *);

  /** Show/Hide tool bar */
  void toggleBar(const char *);

  /** Show/Hide tool bar */
  void setToolBarState(const char *, bool);

public slots:
    /** open a new application window by creating a new instance of KXMLEditorApp */
    //void slotFileNewWindow();

    /** clears the document in the actual view to reuse it as the new document */
    void slotFileNew();
    /** open a file and load it into the document*/
    void slotFileOpen();
    /** opens a file from the recent files menu */
    void slotFileOpenRecent(const KURL& url);
    /** save a document */
    void slotFileSave();
    /** save a document by a new filename*/
    void slotFileSaveAs();
    /** asks for saving if the file is modified, then closes the actual file and window*/
    void slotFileClose();
    /** print the actual file */
    void slotFilePrint();
    /** closes all open windows by calling close() on each memberList item until the list is empty, then quits the application.
     * If queryClose() returns false because the user canceled the saveModified() dialog, the closing breaks.
     */
    void slotFileQuit();
    /** put the marked text/object into the clipboard and remove
     *	it from the document
     */
    void slotEditCut();
    /** put the marked text/object into the clipboard
     */
    void slotEditCopy();
    /** paste the clipboard into the document
     */
    void slotEditPaste();
    /** toggles the toolbar
     */

    void slotViewStatusBar();
    /** changes the statusbar contents for the standard label permanently, used to indicate current actions.
     * @param text the text that is displayed in the statusbar
     */
    void slotStatusMsg(const QString &text);

   /** Called, when selected element in XML tree view is changed */
  void slotSelectedElementChanged( const XmlTreeItem * const pElement );

  /** Called, when user press Apply or Ok button in Options dialog */
  void slotConfigurationChanged();

  private:
    /** the configuration object of the application */
    KConfig *config;
    /** view is the main widget which represents your working area. The View
     * class should handle all events of the view widget.  It is kept empty so
     * you can create your view according to your application's needs by
     * changing the view class.
     */
    KXMLEditorView *view;
    /** doc represents your actual document and is created only once. It keeps
     * information such as filename and does the serialization of your files.
     */
    KXMLEditorDoc *doc;

    // KAction to enable/disable actions
    KXMLEditorActions m_Actions;

protected slots: // Protected slots

	/** Display Search dialog and find string in XML document */
  void slotEditFind();

	/** Find next occurence of string in XML document */
  void slotEditFindNext();

	/** Move selected item Up to parent item */
  void slotUp();

	/** Edit XML atttribute properties */
  void slotXmlEditAttribute();

  /** Insert XML Attribute into element list */
  void slotXmlInsertAttribute();

	/** Delete XML attribute from element */
  void slotXmlDeleteAttribute();

  /** Insert XML element into document */
  void slotXmlInsertElement();

  /** Edit XML element propetries */
  void slotXmlEditElement();

	/** Delete XML element from document */
  void slotXmlDeleteElement();

  /** Insert XML element contents */
  void slotXmlInsertContents();

  /** Edit XML element contents */
  void slotXmlEditContents();

  /** Delete XML element contents */
  void slotXmlDeleteContents();

  /** Move item in tree view Down */
  void slotXmlMoveItemDown();

  /** Move item in tree view Up */
  void slotXmlMoveItemUp();

  /** Called, when path combo is activated */
  void slotPathComboActivated( const QString & );

  /** Clear location bar */
  void slotClearLocationBar();

  /** Toggle bookmark on selected item */
  void slotToggleBookmark();

  /** Collapse tree item subtree */
  void slotCollapseNode();

  /** Expand tree item subtree */
  void slotExpandNode();

  /** Search next bookmark */
  void slotBookmarkNext();

  /** Search previous bookmark */
  void slotBookmarkPrev();

  /** Called when menu item from Expand Node button is selected */
  void slotExpandNodeActivated(int);

  /** Called when menu item from Collapse Node button is selected */
  void slotCollapseNodeActivated(int);

  /** Configure application toolbars */
  void slotConfigToolbars();

	void slotShowToolBar();

  void slotShowXmlToolBar();

  void slotShowLocationBar();

  /** Configure XML Explorer options */
  void slotConfigure();

  /** Configure key bindings */
  void slotConfigureKeys();

  /** Delete XML Processing Instruction */
  void slotXmlDeleteProcInstruction();

  /** Edit XML Peocessing Instruction */
  void slotXmlEditProcInstruction();

  /** Insert new XML Processing instruction */
  void slotXmlInsertProcInstruction();

  /** Changes the caption and enables the svae action. */
  void slotDocumentModified();
};
 
#endif // KXMLEDITOR_H
