/***************************************************************************
                          optionsdialog.cpp  -  description
                             -------------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "optionsdialog.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qvalidator.h>
#include <qlistview.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>

#include <klocale.h>
#include <kiconloader.h>
#include <kconfig.h>

OptionsDialog::SAppOptionsTreeView			OptionsDialog::m_AppOptionsTreeView;
OptionsDialog::SAppOptionsTarGzExt 	OptionsDialog::m_AppOptionsTarGzExt;
OptionsDialog::SAppOptionsSpecChars	OptionsDialog::m_AppOptionsSpecChars;
OptionsDialog::SAppOptionsXml				OptionsDialog::m_AppOptionsXml;

OptionsDialog::OptionsDialog(QWidget *parent, const char *name, bool bModal)
 : KDialogBase(IconList,
               i18n("Configure"),
               Apply | Ok | Cancel | Help,
               Ok,
               parent,
               name,
               bModal,
               true
              )
{
	setupXmlPage();
	setupTreeViewPage();
	setupTarGzExtPage();
	setupSpecCharactersPage();
}

OptionsDialog::~OptionsDialog()
{
}

/** Setup page with TreeView. options  */
void OptionsDialog::setupTreeViewPage()
{
	QFrame *pPage = addPage(i18n("Tree View"),
													i18n("Tree View properties"),
													KGlobal::instance()->iconLoader()->loadIcon("view_tree", KIcon::NoGroup, KIcon::SizeMedium)
												 );
	QVBoxLayout *pTopLayout = new QVBoxLayout(pPage, 0, spacingHint());
	if(pTopLayout == 0)
		return;
		
	QGridLayout *pGbox = new QGridLayout(4, 2);
	pTopLayout->addLayout(pGbox);
	
	m_WidgetsTreeView.pCheckBoxRootDecorated = new QCheckBox(i18n("Set root element &decorated"), pPage, "setrootdecorated");
	m_WidgetsTreeView.pCheckBoxRootDecorated->setChecked(m_AppOptionsTreeView.bRootDecorated);
	pGbox->addWidget(m_WidgetsTreeView.pCheckBoxRootDecorated, 0, 0);

	pGbox->addWidget(new QLabel(i18n("After open file, expand to level:"), pPage, "expandtolabel"), 1, 0);
	m_WidgetsTreeView.pLineEditExpandToLevel = new QLineEdit(pPage, "expandtolevel");
	m_WidgetsTreeView.pLineEditExpandToLevel->setMaxLength(2);
	QIntValidator *pIntValidator = new QIntValidator(m_WidgetsTreeView.pLineEditExpandToLevel);
	pIntValidator->setRange(0, 99);
	m_WidgetsTreeView.pLineEditExpandToLevel->setValidator(pIntValidator);
	m_WidgetsTreeView.pLineEditExpandToLevel->setText(QString().setNum(m_AppOptionsTreeView.iExpandToLevel));
	pGbox->addWidget(m_WidgetsTreeView.pLineEditExpandToLevel, 1, 1);
	
	m_WidgetsTreeView.pCheckBoxEnableDragDrop = new QCheckBox(i18n("Enable &Drag and Drop"), pPage, "enablednd");
	m_WidgetsTreeView.pCheckBoxEnableDragDrop->setChecked(m_AppOptionsTreeView.bEnableDragDrop);
	pGbox->addWidget(m_WidgetsTreeView.pCheckBoxEnableDragDrop, 2, 0);
	
	m_WidgetsTreeView.pButtonGroupElemDisplayMode = new QButtonGroup(i18n("XML Elements - what display in tree"), pPage);
	pGbox->addWidget(m_WidgetsTreeView.pButtonGroupElemDisplayMode, 3, 0);
	pTopLayout->addStretch(1);
	QGridLayout *pGridLayoutRadio = new QGridLayout(m_WidgetsTreeView.pButtonGroupElemDisplayMode, 3, 1, 20);	
	
	m_WidgetsTreeView.pRadioBtnDisplOnlyElements = new QRadioButton(i18n("Only element name"), m_WidgetsTreeView.pButtonGroupElemDisplayMode);
	pGridLayoutRadio->addWidget(m_WidgetsTreeView.pRadioBtnDisplOnlyElements, 1, 0, AlignTop);
	m_WidgetsTreeView.pRadioBtnDisplAttrNames = new QRadioButton(i18n("Element, attribute names"), m_WidgetsTreeView.pButtonGroupElemDisplayMode);
	pGridLayoutRadio->addWidget(m_WidgetsTreeView.pRadioBtnDisplAttrNames, 2, 0, AlignTop);
	m_WidgetsTreeView.pRadioBtnDisplAttrValues = new QRadioButton(i18n("Element, attributes names and its values"), m_WidgetsTreeView.pButtonGroupElemDisplayMode);
	pGridLayoutRadio->addWidget(m_WidgetsTreeView.pRadioBtnDisplAttrValues, 3, 0, AlignTop);
	switch(m_AppOptionsTreeView.iElemDisplayMode)
		{ case 0:	m_WidgetsTreeView.pRadioBtnDisplOnlyElements->setChecked(true);
							break;
							
			case 1:	m_WidgetsTreeView.pRadioBtnDisplAttrNames->setChecked(true);
							break;
							
			case 2:	m_WidgetsTreeView.pRadioBtnDisplAttrValues->setChecked(true);
							break;
							
			default: ASSERT(false);
		}
}

/** Setup page for list of files extensions that is TarGz */
void OptionsDialog::setupTarGzExtPage()
{
	QFrame *pPage = addPage(i18n("TarGz Extensions"),
													i18n("Define TarGz file extensions"),
													KGlobal::instance()->iconLoader()->loadIcon("filetypes", KIcon::NoGroup, KIcon::SizeMedium)
    										 );
  QVBoxLayout *pTopLayout = new QVBoxLayout(pPage, 0, spacingHint());

	pTopLayout->addWidget(new QLabel(i18n("Archive files extensions:"), pPage));
	
	m_WidgetsTarGzExt.pListView = new QListView(pPage);
	pTopLayout->addWidget(m_WidgetsTarGzExt.pListView);
	m_WidgetsTarGzExt.pListView->addColumn( i18n("Extension"));
  m_WidgetsTarGzExt.pListView->setAllColumnsShowFocus(true);
  m_WidgetsTarGzExt.pListView->setFrameStyle(QFrame::WinPanel + QFrame::Sunken);
  m_WidgetsTarGzExt.pListView->setSorting(-1);
	connect(m_WidgetsTarGzExt.pListView, SIGNAL(selectionChanged()), this, SLOT(slotListTarGzExtSelChanged()));

	QString strExtension;
  for(strExtension = m_AppOptionsTarGzExt.strListOfTarGzExtensions.first();
  		strExtension != 0;
  		strExtension = m_AppOptionsTarGzExt.strListOfTarGzExtensions.next())
  		 	{ new QListViewItem(m_WidgetsTarGzExt.pListView, strExtension);
  		 	}
	
	QGridLayout *pGbox = new QGridLayout(pTopLayout, 2, 2);
  pGbox->setColStretch(1, 10);

  m_WidgetsTarGzExt.pLabelExtension = new QLabel(i18n("Extension:"), pPage );
  m_WidgetsTarGzExt.pLabelExtension->setEnabled(false);
  pGbox->addWidget(m_WidgetsTarGzExt.pLabelExtension, 0, 0);
  m_WidgetsTarGzExt.pEditExtension = new QLineEdit(pPage);
  m_WidgetsTarGzExt.pEditExtension->setEnabled(false);
  connect(m_WidgetsTarGzExt.pEditExtension, SIGNAL(textChanged(const QString&)), this, SLOT(slotExtensionChanged(const QString&)));
  pGbox->addWidget(m_WidgetsTarGzExt.pEditExtension, 0, 1);


  QWidget *pWidgetHelper = new QWidget(pPage);
  pGbox->addWidget(pWidgetHelper, 2, 1 );
  QHBoxLayout *pHLayout = new QHBoxLayout(pWidgetHelper, 0, spacingHint());
  QPushButton *pPushButton = new QPushButton(i18n("&New"), pWidgetHelper);
  connect(pPushButton, SIGNAL(clicked()), this, SLOT(slotNewExtension()) );
  pPushButton->setAutoDefault( false );
  pHLayout->addWidget(pPushButton);
  pPushButton = new QPushButton(i18n("Dele&te"), pWidgetHelper);
  connect(pPushButton, SIGNAL(clicked()), this, SLOT(slotDeleteExtension()));
  pPushButton->setAutoDefault( false );
  pHLayout->addWidget(pPushButton);
  pHLayout->addStretch(10);

  pTopLayout->addSpacing(spacingHint() * 2);
}

/** Called, when text in edit line changed  */
void OptionsDialog::slotExtensionChanged(const QString &text)
{
	if(m_WidgetsTarGzExt.pItemCurrent != 0)
  	{ m_WidgetsTarGzExt.pItemCurrent->setText(0, text);
  	}
}

/** Called, when New button clicked */
void OptionsDialog::slotNewExtension()
{
	QListViewItem *listItem = new QListViewItem(m_WidgetsTarGzExt.pListView, "");
  m_WidgetsTarGzExt.pListView->setCurrentItem(listItem);
  m_WidgetsTarGzExt.pListView->setSelected(listItem, true);

  m_WidgetsTarGzExt.pItemCurrent = m_WidgetsTarGzExt.pListView->selectedItem();
  if( m_WidgetsTarGzExt.pItemCurrent != 0)
  	{ m_WidgetsTarGzExt.pEditExtension->setEnabled(true);
    	m_WidgetsTarGzExt.pLabelExtension->setEnabled(true);
    	m_WidgetsTarGzExt.pEditExtension->setFocus();
  	}
}

/** Called, when Delete button clicked */
void OptionsDialog::slotDeleteExtension()
{
	if( m_WidgetsTarGzExt.pItemCurrent != 0 )
  {
    QListViewItem *pItemNext = m_WidgetsTarGzExt.pItemCurrent->itemAbove();
    if( pItemNext == 0 )
    	{ pItemNext = m_WidgetsTarGzExt.pItemCurrent->itemBelow();
    	}

    m_WidgetsTarGzExt.pEditExtension->clear();
    m_WidgetsTarGzExt.pEditExtension->setEnabled(false);
    m_WidgetsTarGzExt.pLabelExtension->setEnabled(false);

    m_WidgetsTarGzExt.pListView->takeItem(m_WidgetsTarGzExt.pItemCurrent );
    m_WidgetsTarGzExt.pItemCurrent = 0;

    if(pItemNext != 0)
    	{ m_WidgetsTarGzExt.pListView->setSelected(pItemNext, true );
    	}
  }
}

/** Called, when user select item in list of extensions */
void OptionsDialog::slotListTarGzExtSelChanged()
{
	m_WidgetsTarGzExt.pItemCurrent = m_WidgetsTarGzExt.pListView->selectedItem();
  if(m_WidgetsTarGzExt.pItemCurrent != 0 )
  	{ m_WidgetsTarGzExt.pEditExtension->setText(m_WidgetsTarGzExt.pItemCurrent->text(0));
    	m_WidgetsTarGzExt.pListView->setEnabled(true);
    	m_WidgetsTarGzExt.pLabelExtension->setEnabled(true);
    	m_WidgetsTarGzExt.pEditExtension->setEnabled(true);
  	}
}

/** Setup page for defining special characters list */
void OptionsDialog::setupSpecCharactersPage()
{
QFrame *pPage = addPage(i18n("Spec. Characters"),
													i18n("Define Special Characters List"),
													KGlobal::instance()->iconLoader()->loadIcon("charset", KIcon::NoGroup, KIcon::SizeMedium)
    										 );
  QVBoxLayout *pTopLayout = new QVBoxLayout(pPage, 0, spacingHint());

	pTopLayout->addWidget(new QLabel(i18n("Special Characters:"), pPage));
	
	m_WidgetsSpecChars.pListView = new QListView(pPage, "SpecCharslist");
	pTopLayout->addWidget(m_WidgetsSpecChars.pListView);
	m_WidgetsSpecChars.pListView->addColumn( i18n("Special Character"));
  m_WidgetsSpecChars.pListView->setAllColumnsShowFocus(true);
  m_WidgetsSpecChars.pListView->setFrameStyle(QFrame::WinPanel + QFrame::Sunken);
  m_WidgetsSpecChars.pListView->setSorting(-1);
	connect(m_WidgetsSpecChars.pListView, SIGNAL(selectionChanged()), this, SLOT(slotListSpecCharsSelChanged()));

	QString strSpecCharacter;
  for(strSpecCharacter = m_AppOptionsSpecChars.strListOfSpecCharacters.first();
  		strSpecCharacter != 0;
  		strSpecCharacter = m_AppOptionsSpecChars.strListOfSpecCharacters.next())
  		 	{ new QListViewItem(m_WidgetsSpecChars.pListView, strSpecCharacter);
  		 	}

	QGridLayout *pGbox = new QGridLayout(pTopLayout, 2, 2);
  pGbox->setColStretch(1, 10);

  m_WidgetsSpecChars.pLabelSpecCharacter = new QLabel(i18n("Special Character:"), pPage );
  m_WidgetsSpecChars.pLabelSpecCharacter->setEnabled(false);
  pGbox->addWidget(m_WidgetsSpecChars.pLabelSpecCharacter, 0, 0);
  m_WidgetsSpecChars.pEditSpecCharacter = new QLineEdit(pPage);
  m_WidgetsSpecChars.pEditSpecCharacter->setEnabled(false);
  connect(m_WidgetsSpecChars.pEditSpecCharacter, SIGNAL(textChanged(const QString&)), this, SLOT(slotSpecCharacterChanged(const QString&)));
  pGbox->addWidget(m_WidgetsSpecChars.pEditSpecCharacter, 0, 1);


  QWidget *pWidgetHelper = new QWidget(pPage);
  pGbox->addWidget(pWidgetHelper, 2, 1 );
  QHBoxLayout *pHLayout = new QHBoxLayout(pWidgetHelper, 0, spacingHint());
  QPushButton *pPushButton = new QPushButton(i18n("&New"), pWidgetHelper);
  connect(pPushButton, SIGNAL(clicked()), this, SLOT(slotNewSpecCharacter()) );
  pPushButton->setAutoDefault( false );
  pHLayout->addWidget(pPushButton);
  pPushButton = new QPushButton(i18n("Dele&te"), pWidgetHelper);
  connect(pPushButton, SIGNAL(clicked()), this, SLOT(slotDeleteSpecCharacter()));
  pPushButton->setAutoDefault(false);
  pHLayout->addWidget(pPushButton);
  pHLayout->addStretch(10);

  pTopLayout->addSpacing(spacingHint() * 2);	
}

/** Called, when text in edit line changed  */
void OptionsDialog::slotSpecCharacterChanged(const QString &text)
{
	if(m_WidgetsSpecChars.pItemCurrent != 0)
  	{ m_WidgetsSpecChars.pItemCurrent->setText(0, text);
  	}
}

/** Called, when New button clicked */
void OptionsDialog::slotNewSpecCharacter()
{
	QListViewItem *listItem = new QListViewItem(m_WidgetsSpecChars.pListView, "");
  m_WidgetsSpecChars.pListView->setCurrentItem(listItem);
  m_WidgetsSpecChars.pListView->setSelected(listItem, true);

  m_WidgetsSpecChars.pItemCurrent = m_WidgetsSpecChars.pListView->selectedItem();
  if(m_WidgetsSpecChars.pItemCurrent != 0)
  	{ m_WidgetsSpecChars.pEditSpecCharacter->setEnabled(true);
    	m_WidgetsSpecChars.pLabelSpecCharacter->setEnabled(true);
    	m_WidgetsSpecChars.pEditSpecCharacter->setFocus();
  	}
}

/** Called, when Delete button clicked */
void OptionsDialog::slotDeleteSpecCharacter()
{
	if(m_WidgetsSpecChars.pItemCurrent != 0 )
  {
    QListViewItem *pItemNext = m_WidgetsSpecChars.pItemCurrent->itemAbove();
    if( pItemNext == 0 )
    	{ pItemNext = m_WidgetsSpecChars.pItemCurrent->itemBelow();
    	}

    m_WidgetsSpecChars.pEditSpecCharacter->clear();
    m_WidgetsSpecChars.pEditSpecCharacter->setEnabled(false);
    m_WidgetsSpecChars.pEditSpecCharacter->setEnabled(false);

    m_WidgetsSpecChars.pListView->takeItem(m_WidgetsSpecChars.pItemCurrent );
    m_WidgetsSpecChars.pItemCurrent = 0;

    if(pItemNext != 0)
    	{ m_WidgetsSpecChars.pListView->setSelected(pItemNext, true );
    	}
  }
}
/** Called, when user select item in list of extensions */
void OptionsDialog::slotListSpecCharsSelChanged()
{
	m_WidgetsSpecChars.pItemCurrent = m_WidgetsSpecChars.pListView->selectedItem();
  if(m_WidgetsSpecChars.pItemCurrent != 0 )
  	{ m_WidgetsSpecChars.pEditSpecCharacter->setText(m_WidgetsSpecChars.pItemCurrent->text(0));
    	m_WidgetsSpecChars.pListView->setEnabled(true);
    	m_WidgetsSpecChars.pLabelSpecCharacter->setEnabled(true);
    	m_WidgetsSpecChars.pEditSpecCharacter->setEnabled(true);
  	}
}

void OptionsDialog::setupXmlPage()
{
	QFrame *pPage = addPage(i18n("XML"),
													i18n("XML properties"),
													KGlobal::instance()->iconLoader()->loadIcon("kxmleditor", KIcon::NoGroup, KIcon::SizeMedium)
												 );
	QVBoxLayout *pTopLayout = new QVBoxLayout(pPage, 0, spacingHint());
	if(pTopLayout == 0)
		return;
		
	QGridLayout *pGbox = new QGridLayout(3, 2);
	pTopLayout->addLayout(pGbox);

	m_WidgetsXml.pButtonGroupParser = new QButtonGroup(i18n("XML Parser"), pPage);
	pGbox->addWidget(m_WidgetsXml.pButtonGroupParser, 0, 0);
	pTopLayout->addStretch(1);
	QGridLayout *pGridLayoutRadio = new QGridLayout(m_WidgetsXml.pButtonGroupParser, 2, 1, 20);	
	
	m_WidgetsXml.pRadioBtnParserSAX2 = new QRadioButton(i18n("SAX2"), m_WidgetsXml.pButtonGroupParser);
	pGridLayoutRadio->addWidget(m_WidgetsXml.pRadioBtnParserSAX2, 1, 0, AlignTop);
	m_WidgetsXml.pRadioBtnParserDOM = new QRadioButton(i18n("DOM"), m_WidgetsXml.pButtonGroupParser);
	pGridLayoutRadio->addWidget(m_WidgetsXml.pRadioBtnParserDOM, 2, 0, AlignTop);
	switch(m_AppOptionsXml.eParser)
		{ case parserSAX2:	m_WidgetsXml.pRadioBtnParserSAX2->setChecked(true);
												break;
							
			case parserDOM:		m_WidgetsXml.pRadioBtnParserDOM->setChecked(true);
												break;
							
			default: ASSERT(false);
		}
		
	m_WidgetsXml.pCheckBoxDontConvertAmpersand = new QCheckBox(i18n("Don't convert ampersand"), pPage);
	m_WidgetsXml.pCheckBoxDontConvertAmpersand->setChecked(m_AppOptionsXml.bDontConvertAmpersand);
	pGbox->addWidget(m_WidgetsXml.pCheckBoxDontConvertAmpersand, 1, 0);
	
	m_WidgetsXml.pCheckBoxAppendCRLF = new QCheckBox(i18n("&Append CR LF at end of line"), pPage, "appendcrlf");
	m_WidgetsXml.pCheckBoxAppendCRLF->setChecked(m_AppOptionsXml.bAppendCRLF);
	pGbox->addWidget(m_WidgetsXml.pCheckBoxAppendCRLF, 2, 0);
	
}

/** Called when user press OK button */
void OptionsDialog::slotOk()
{
	slotApply();
	accept();
}

/** Called when user press Apply button */
void OptionsDialog::slotApply()
{
	// Xml page
	if(m_WidgetsXml.pRadioBtnParserSAX2->isChecked())
		m_AppOptionsXml.eParser = parserSAX2;
	else
		m_AppOptionsXml.eParser = parserDOM;

	m_AppOptionsXml.bDontConvertAmpersand = m_WidgetsXml.pCheckBoxDontConvertAmpersand->isChecked();
	m_AppOptionsXml.bAppendCRLF = m_WidgetsXml.pCheckBoxAppendCRLF->isChecked();
	
	// TreeView page
	m_AppOptionsTreeView.bRootDecorated = m_WidgetsTreeView.pCheckBoxRootDecorated->isChecked();
	m_AppOptionsTreeView.iExpandToLevel = m_WidgetsTreeView.pLineEditExpandToLevel->text().toInt();
	m_AppOptionsTreeView.bEnableDragDrop = m_WidgetsTreeView.pCheckBoxEnableDragDrop->isChecked();

	if(m_WidgetsTreeView.pRadioBtnDisplOnlyElements->isChecked())
		m_AppOptionsTreeView.iElemDisplayMode = 0;
	else
	{
		if(m_WidgetsTreeView.pRadioBtnDisplAttrNames->isChecked())
			m_AppOptionsTreeView.iElemDisplayMode = 1;
		else
			m_AppOptionsTreeView.iElemDisplayMode = 2;
	}

	// TarGz page
	m_AppOptionsTarGzExt.strListOfTarGzExtensions.clear();

	QListViewItem *pTarGzItem = m_WidgetsTarGzExt.pListView->firstChild();
	while(pTarGzItem)
	{
		m_AppOptionsTarGzExt.strListOfTarGzExtensions.append(pTarGzItem->text(0));
		pTarGzItem = pTarGzItem->nextSibling();
	}

	// SpecChars page
	m_AppOptionsSpecChars.strListOfSpecCharacters.clear();

	QListViewItem *pSpecCharsItem = m_WidgetsSpecChars.pListView->firstChild();
	while(pSpecCharsItem)
	{
		m_AppOptionsSpecChars.strListOfSpecCharacters.append(pSpecCharsItem->text(0));
		pSpecCharsItem = pSpecCharsItem->nextSibling();
	}

	emit configurationChanged();
}

void OptionsDialog::readConfiguration( KConfig * pConfig )
{
	pConfig->setGroup("XML");
	m_AppOptionsXml.eParser = static_cast <enXmlParser> (pConfig->readNumEntry("Parser", 0)) ;
	m_AppOptionsXml.bDontConvertAmpersand = pConfig->readBoolEntry("Don't convert ampersand", false);
	m_AppOptionsXml.bAppendCRLF = pConfig->readBoolEntry("Append CR LF", false);
	
	pConfig->setGroup("Tree View");
	m_AppOptionsTreeView.iExpandToLevel = pConfig->readNumEntry("Expand to level", 5);
	m_AppOptionsTreeView.bRootDecorated = pConfig->readBoolEntry("Root decorated", false);
	m_AppOptionsTreeView.bEnableDragDrop = pConfig->readBoolEntry("Enable DnD", true);
	m_AppOptionsTreeView.iElemDisplayMode = pConfig->readNumEntry("Element display mode", 0);

	pConfig->setGroup("TarGz Extensions");
	pConfig->readListEntry("Extensions", m_AppOptionsTarGzExt.strListOfTarGzExtensions);

	pConfig->setGroup("Spec. Characters");
	pConfig->readListEntry("Characters", m_AppOptionsSpecChars.strListOfSpecCharacters);
}

void OptionsDialog::saveConfiguration( KConfig * pConfig )
{
	pConfig->setGroup("XML");
	pConfig->writeEntry("Parser", m_AppOptionsXml.eParser);
	pConfig->writeEntry("Don't convert ampersand", m_AppOptionsXml.bDontConvertAmpersand);
	pConfig->writeEntry("Append CR LF", m_AppOptionsXml.bAppendCRLF);
	
	pConfig->setGroup("Tree View");
	pConfig->writeEntry("Root decorated", m_AppOptionsTreeView.bRootDecorated);
	pConfig->writeEntry("Expand to level", m_AppOptionsTreeView.iExpandToLevel);
	pConfig->writeEntry("Enable DnD", m_AppOptionsTreeView.bEnableDragDrop);
	pConfig->writeEntry("Element display mode", m_AppOptionsTreeView.iElemDisplayMode);

	pConfig->setGroup("TarGz Extensions");
	pConfig->writeEntry("Extensions", m_AppOptionsTarGzExt.strListOfTarGzExtensions);

	pConfig->setGroup("Spec. Characters");
	pConfig->writeEntry("Characters", m_AppOptionsSpecChars.strListOfSpecCharacters);

	pConfig->sync();
}

bool OptionsDialog::getTreeViewRootDecorated() { return m_AppOptionsTreeView.bRootDecorated; }
unsigned int OptionsDialog::getTreeViewExpandToLevel() { return m_AppOptionsTreeView.iExpandToLevel; }
bool OptionsDialog::getTreeViewEnableDragDrop() { return m_AppOptionsTreeView.bEnableDragDrop; }
int OptionsDialog::getTreeViewElemDisplayMode() { return m_AppOptionsTreeView.iElemDisplayMode; }
QStrList OptionsDialog::getListOfTarGzExtensions() { return m_AppOptionsTarGzExt.strListOfTarGzExtensions; }
QStrList OptionsDialog::getListOfSpecCharacters() { return m_AppOptionsSpecChars.strListOfSpecCharacters; }
OptionsDialog::enXmlParser OptionsDialog::getXmlParser() { return m_AppOptionsXml.eParser; }
bool OptionsDialog::getXmlDontConvertAmpersand() { return m_AppOptionsXml.bDontConvertAmpersand; }
bool OptionsDialog::getXmlAppendCRLF() { return m_AppOptionsXml.bAppendCRLF; }
