/***************************************************************************
                          kxmleditorpart.cpp  -  description
                             -------------------
    begin                : Wed Sep 19 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : OleBowle@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kxmleditorpart.h"
#include "kxmleditorfactory.h"

#include "kxe_viewelement.h"
#include "kxe_viewprocinstr.h"
#include "optionsdialog.h"
#include "actions.h"

#include <kdebug.h>
#include <klocale.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kpopupmenu.h>

#include <qsplitter.h>
#include <qtabwidget.h>
#include <qmultilinedit.h>

#include "xmlstructureparser.h" // TODO remove later
#include "kxmleditordoc.h" // TODO remove later
#include "xml_base.h" // TODO remove later
#include <qpixmap.h> // TODO remove later
#include <kiconloader.h> // TODO remove later


KXMLEditorPart::KXMLEditorPart( QWidget * pParent, const char * pszName )
	: KParts::ReadOnlyPart(pParent,pszName)
{
	//////////////////////////////
	// INIT PART
	//////////////////////////////

	setInstance( KXMLEditorFactory::instance() );

	new KXMLEditorBrowserExtension(this);

	OptionsDialog::readConfiguration( instance()->config() );

	//////////////////////////////
	// CREATE ACTIONS
	//////////////////////////////

	// edit actions
	m_pActEditFind = KStdAction::find( this, SLOT(slotEditFind()), actionCollection(), "find" );
	m_pActEditFindNext = KStdAction::findNext( this, SLOT(slotEditFindNext()), actionCollection(), "findNext" );
	m_pActEditDeselect = new KAction( i18n("&Deselect Node"), 0, this,
	                                SLOT(slotEditDeselect()), actionCollection(), "deselect" );

	// view actions
	m_pActViewNodeUp = new KAction( i18n("To &Parent Node"), "up", 0, this,
	                                SLOT(slotViewNodeUp()), actionCollection(), "treeitem_up" );

	m_pActViewExpNode = new KToolBarPopupAction( i18n("&Expand Node"), "expand_node", CTRL+Key_Plus, this,
	                                             SLOT(slotViewExpNode()), actionCollection(), "treeitem_expand" );
	KPopupMenu * pMenuExpNode = m_pActViewExpNode->popupMenu();
	connect( pMenuExpNode, SIGNAL(activated(int)), this, SLOT(slotViewExpNode(int)) );
	for ( uint i = 1; i <= 8; i++ )
		pMenuExpNode->insertItem( i18n("Expand to level %1").arg(i), i+1 );

	m_pActViewColNode = new KToolBarPopupAction( i18n("&Collapse Node"), "collapse_node", CTRL+Key_Minus, this,
	                                             SLOT(slotViewColNode()), actionCollection(), "treeitem_collapse" );
	KPopupMenu * pMenuColNode = m_pActViewColNode->popupMenu();
	connect( pMenuColNode, SIGNAL(activated(int)), this, SLOT(slotViewColNode(int)) );
	for ( uint i = 1; i <= 8; i++ )
		pMenuColNode->insertItem( i18n("Collapse to level %1").arg(i), i+1 );

	// bookmark actions
	m_pActBookmarksToggle = new KAction( i18n("&Toggle Bookmark"), "bookmark_add", CTRL+Key_B, this,
	                                   SLOT(slotBookmarksToggle()), actionCollection(), "bookmark_toggle" );
	m_pActBookmarksPrev = new KAction( i18n("&Previous Bookmark"), "bookmark_prev", SHIFT+Key_F5, this,
	                                   SLOT(slotBookmarksPrev()), actionCollection(), "bookmark_prev" );
	m_pActBookmarksNext = new KAction( i18n("&Next Bookmark"), "bookmark_next", Key_F5, this,
	                                   SLOT(slotBookmarksNext()), actionCollection(), "bookmark_next" );

	// settings actions
	new KAction( i18n("&Configure KXMLEditor..."), "configure", 0, this,
	             SLOT (slotConfigure()), actionCollection(), "configure" );

	// path toolbar
	m_pActPathCombo = new KXmlEditorComboAction( i18n("Path Bar"), 0, this,
	                                             SLOT(slotPathSelected(const QString &)), actionCollection(), "path_combo" );
	new KAction( i18n("Clear Path bar"), "locationbar_erase", 0, this,
	             SLOT(slotPathClear()), actionCollection(), "path_clear" );
	new KXmlEditorLabelAction( i18n("&Path "), actionCollection(), "path_label");

	setXMLFile( "kxmleditorpart.rc" );

	//////////////////////////////
	// CREATE WIDGETS
	//////////////////////////////

	QSplitter * pSplitter = new QSplitter( pParent, "Splitter" );
	setWidget( pSplitter );

	// create the tree view -------------------
	m_pViewTree = new KXE_TreeView( this, pSplitter, "Tree view" );

	connect( m_pViewTree, SIGNAL(sigSelectionChanged(XmlElement*)), this, SLOT(slotTreeSelectionChanged(XmlElement*)) );
	connect( m_pViewTree, SIGNAL(sigSelectionChanged(XmlContentsItem*)), this, SLOT(slotTreeSelectionChanged(XmlContentsItem*)) );
	connect( m_pViewTree, SIGNAL(sigSelectionChanged(XmlProcessingInstruction*)), this, SLOT(slotTreeSelectionChanged(XmlProcessingInstruction*)) );
	connect( m_pViewTree, SIGNAL(sigNewBookmarkStatus(bool)), this, SLOT(slotNewBookmarkStatus(bool)) );

	// create tab widget ----------------------
	m_pTabWidget = new QTabWidget( pSplitter, "Tab");

	// create element view
	m_pViewElement = new KXE_ViewElement( m_pTabWidget, "Element View" );
	m_pTabWidget->addTab( m_pViewElement,
	                      QIconSet( UserIcon("xml_element",KXMLEditorFactory::instance()) ),
	                      i18n("Element") );

	// create edit widget, that display XML contents
	m_pViewContents = new QMultiLineEdit(m_pTabWidget, "Edit");
	m_pTabWidget->addTab( m_pViewContents,
	                      QIconSet( UserIcon("xml_contents",KXMLEditorFactory::instance()) ),
	                      i18n("Contents") );
	m_pViewContents->setReadOnly(true);

	// create proc.instr. view
	m_pViewProcInstr = new KXE_ViewProcInstr( m_pTabWidget, "Proc.Instr. View" );
	m_pTabWidget->addTab( m_pViewProcInstr,
	                      QIconSet(SmallIcon("exec")),
	                      i18n("Proc.Instruction") );

connect( this, SIGNAL(started(KIO::Job*)), this, SLOT(started()) );
connect( this, SIGNAL(completed()), this, SLOT(completed()) );
connect( this, SIGNAL(canceled(const QString &)), this, SLOT(canceled()) );

	// create pixmaps ---------------------------------------------------
	XmlTreeItem::m_pPixmapElement = new QPixmap(UserIcon("xml_element",KXMLEditorFactory::instance()));
	XmlTreeItem::m_pPixmapText = new QPixmap(UserIcon("xml_text",KXMLEditorFactory::instance()));
	XmlTreeItem::m_pPixmapCDATA = new QPixmap(UserIcon("xml_cdata",KXMLEditorFactory::instance()));
	XmlTreeItem::m_pPixmapComment = new QPixmap(UserIcon("xml_comment",KXMLEditorFactory::instance()));
	XmlTreeItem::m_pPixmapBookmark = new QPixmap(SmallIcon("bookmark"));
	XmlTreeItem::m_pPixmapProcInstr = new QPixmap(SmallIcon("exec"));

	//////////////////////////////
	// INIT BEGIN STATE
	//////////////////////////////

	// Disable actions
	m_pActEditDeselect->setEnabled(false);
	m_pActViewNodeUp->setEnabled(false);
	m_pActViewExpNode->setEnabled(false);
	m_pActViewColNode->setEnabled(false);
	m_pActBookmarksToggle->setEnabled(false);
	m_pActBookmarksPrev->setEnabled(false);
	m_pActBookmarksNext->setEnabled(false);

	m_pTabWidget->setTabEnabled( m_pViewElement, false );
	m_pTabWidget->setTabEnabled( m_pViewContents, false );
	m_pTabWidget->setTabEnabled( m_pViewProcInstr, false );

	// use configuration
	m_pViewTree->slotConfigRootDecorated( OptionsDialog::getTreeViewRootDecorated() );
	m_pViewTree->slotConfigElemDisplayMode( OptionsDialog::getTreeViewElemDisplayMode() );
	m_pViewTree->slotConfigDragDrop( OptionsDialog::getTreeViewEnableDragDrop() );
}

KXMLEditorPart::~KXMLEditorPart()
{
	if(XmlTreeItem::m_pPixmapElement)
		delete XmlTreeItem::m_pPixmapElement;

	if(XmlTreeItem::m_pPixmapText)
		delete XmlTreeItem::m_pPixmapText;

	if(XmlTreeItem::m_pPixmapCDATA)
		delete XmlTreeItem::m_pPixmapCDATA;

	if(XmlTreeItem::m_pPixmapComment)
		delete XmlTreeItem::m_pPixmapComment;

	if(XmlTreeItem::m_pPixmapProcInstr)
		delete XmlTreeItem::m_pPixmapProcInstr;
}

/////////////////////////////////////////////////////////////////////
//                     ACTION SLOTS
/////////////////////////////////////////////////////////////////////

void KXMLEditorPart::slotEditDeselect()
{
	// Enable/Disable actions
	m_pActEditDeselect->setEnabled(false);
	m_pActViewNodeUp->setEnabled(false); // disable if it's a root item
	m_pActViewExpNode->setEnabled(false);
	m_pActViewColNode->setEnabled(false);
	m_pActBookmarksToggle->setEnabled(false);

	m_pActPathCombo->slotClearEdit();

	// change views
	m_pViewTree->slotEditDeselect();

	m_pViewContents->clear();

	m_pTabWidget->setTabEnabled( m_pViewElement, false );
	m_pTabWidget->setTabEnabled( m_pViewContents, false );
	m_pTabWidget->setTabEnabled( m_pViewProcInstr, false );

	m_pTabWidget->showPage( m_pViewContents );

	// change path combo
	m_pActPathCombo->slotClearEdit();
}

void KXMLEditorPart::slotConfigure()
{
	OptionsDialog * pDlg = new OptionsDialog( widget(), "optionsdialog");
	connect( pDlg, SIGNAL(configurationChanged()), this, SLOT(slotConfigurationChanged()) );

	pDlg->exec();

	delete pDlg;
}

void KXMLEditorPart::slotPathSelected( const QString & szPath )
{
	if ( ! m_pViewTree->selectItem(szPath) )
		m_pActPathCombo->slotClearEdit();
}

void KXMLEditorPart::slotPathClear()
{
	slotEditDeselect();
	m_pActPathCombo->slotFocusEdit();
}



bool KXMLEditorPart::openFile()
{
	QFile file(m_file);

	QXmlSimpleReader xmlReader;
	KXMLEditorDoc tmpDoc(m_pViewTree); // TODO remove this line later
	XmlStructureParser handlerSAX2( m_pViewTree, &tmpDoc );

	xmlReader.setContentHandler(&handlerSAX2);
	xmlReader.setLexicalHandler(&handlerSAX2);
	xmlReader.setErrorHandler(&handlerSAX2);

	xmlReader.setFeature( "http://xml.org/sax/features/namespaces", true );
	xmlReader.setFeature( "http://xml.org/sax/features/namespace-prefixes", true );
kdDebug() << "___________" << endl;
	if( xmlReader.parse(QXmlInputSource(file)) == false )
	{
kdDebug() << "__________Error" << endl;
		kdDebug() << "KXMLEditorPart::openFile Parsing Error [" << handlerSAX2.GetErrorMsg() << " in line " << handlerSAX2.GetLineNumber() << ", column " << handlerSAX2.GetColumnNumber() << "]" << endl;
		return false;
	}
kdDebug() << "___________" << endl;
	return true;
}

void KXMLEditorPart::setReadWrite( bool fReadWrite )
{
	m_pViewTree->setReadWrite(fReadWrite);
//	m_pViewElement-> TODO
	m_pViewContents->setReadOnly( ! fReadWrite );
}

void KXMLEditorPart::started()
{
kdDebug() << "--started" << endl;
}
void KXMLEditorPart::completed()
{
kdDebug() << "---completed" << endl;
}
void KXMLEditorPart::canceled()
{
kdDebug() << "---canceled" << endl;
}

void KXMLEditorPart::slotTreeSelectionChanged( XmlElement * pItem )
{
	// Enable/Disable actions
	m_pActEditDeselect->setEnabled(true);
	m_pActViewNodeUp->setEnabled( pItem->parent() ); // disable if it's a root item
	m_pActViewExpNode->setEnabled( pItem->firstChild() ); // no childs -> disable
	m_pActViewColNode->setEnabled( pItem->firstChild() ); // no childs -> disable
	m_pActBookmarksToggle->setEnabled(true);

	// change views
	m_pViewElement->slotChange(pItem);

	m_pTabWidget->setTabEnabled( m_pViewElement, true );
	m_pTabWidget->setTabEnabled( m_pViewContents, false );
	m_pTabWidget->setTabEnabled( m_pViewProcInstr, false );

	m_pTabWidget->showPage(m_pViewElement);

	// change path combo
	m_pActPathCombo->insertItem( pItem->pixmap(0) ? QPixmap(*pItem->pixmap(0)) : QPixmap(), pItem->path(0) );
}

void KXMLEditorPart::slotTreeSelectionChanged( XmlContentsItem * pItem )
{
	// Enable/Disable actions
	m_pActEditDeselect->setEnabled(true);
	m_pActViewNodeUp->setEnabled( pItem->parent() ); // disable if it's a root item
	m_pActViewExpNode->setEnabled(false);
	m_pActViewColNode->setEnabled(false);
	m_pActBookmarksToggle->setEnabled(true);

	// change views
	m_pViewContents->setText( pItem->contents() );

	m_pTabWidget->setTabEnabled( m_pViewElement, false );
	m_pTabWidget->setTabEnabled( m_pViewContents, true );
	m_pTabWidget->setTabEnabled( m_pViewProcInstr, false );

	m_pTabWidget->showPage( m_pViewContents );

	// change path combo
	m_pActPathCombo->insertItem( pItem->pixmap(0) ? QPixmap(*pItem->pixmap(0)) : QPixmap(), pItem->path(0) );
}

void KXMLEditorPart::slotTreeSelectionChanged( XmlProcessingInstruction * pItem )
{
	// Enable/Disable actions
	m_pActEditDeselect->setEnabled(true);
	m_pActViewNodeUp->setEnabled( pItem->parent() ); // disable if it's a root item
	m_pActViewExpNode->setEnabled(false);
	m_pActViewColNode->setEnabled(false);
	m_pActBookmarksToggle->setEnabled(true);

	// change views
	m_pViewContents->clear();

	m_pTabWidget->setTabEnabled( m_pViewElement, false );
	m_pTabWidget->setTabEnabled( m_pViewContents, false );
	m_pTabWidget->setTabEnabled( m_pViewProcInstr, true );

	m_pTabWidget->showPage( m_pViewProcInstr );

	// change path combo
	m_pActPathCombo->slotClearEdit();
}

void KXMLEditorPart::slotNewBookmarkStatus( bool fStatus )
{
	m_pActBookmarksPrev->setEnabled(fStatus);
	m_pActBookmarksNext->setEnabled(fStatus);
}

void KXMLEditorPart::slotConfigurationChanged()
{
	// use new configuration
	m_pViewTree->slotConfigRootDecorated( OptionsDialog::getTreeViewRootDecorated() );
	m_pViewTree->slotConfigElemDisplayMode( OptionsDialog::getTreeViewElemDisplayMode() );
	m_pViewTree->slotConfigDragDrop( OptionsDialog::getTreeViewEnableDragDrop() );

	// save the new configuration to our config file
	OptionsDialog::saveConfiguration( instance()->config() );
}
