/***************************************************************************
                          xmltreeview.h  -  description
                             -------------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001 by Lumir Vanek, Olaf Hartig
    email                : lvanek@eanet.cz, olaf@punkbands.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef XMLTREEVIEW_H
#define XMLTREEVIEW_H

#include <qwidget.h>
#include <qstrlist.h>
#include <klistview.h>


class QTimer;
class KXMLEditorDoc;
class XmlTreeItem;
class QTextDrag;
class XmlElement;

/**Display XML tree structure. Implement drag&drop.
  *@author Lumir Vanek
  */

class XmlTreeView : public KListView
{
   Q_OBJECT
public:
	XmlTreeView(QWidget *parent, const char *name, KXMLEditorDoc *);
	~XmlTreeView();

  /** Drop or paste text into item */
  bool drop(QListViewItem *, QDropEvent *);

  /** Copy tree item into clipboard */
  QTextDrag * copyItem(XmlTreeItem *);

  /** Paste clipboard contents into tree item */
	bool pasteItem(XmlTreeItem*, QMimeSource *);
	
	/** Return pointer to root XML element */
  XmlElement* rootXmlElement();
	
protected:

	/** Overrides KListView::contentsMouseReleaseEvent */
  void contentsMouseReleaseEvent(QMouseEvent *);

  /** Overrides KListView::contentsMouseMoveEvent */
  void contentsMouseMoveEvent(QMouseEvent *);

  /** Overrides KListView::contentsMousePressEvent */
  void contentsMousePressEvent(QMouseEvent *);

  /** Overrides QScrollView::contentsDragEnterEvent */
  void contentsDragEnterEvent(QDragEnterEvent *);

  /** Overrides QScrollView::contentsDragMoveEvent */
  void contentsDragMoveEvent(QDragMoveEvent *);

  /** Overrides QScrollView::contentsDragLeaveEvent */
  void contentsDragLeaveEvent(QDragLeaveEvent *);

  /** Overrides QScrollView::contentsDropEvent */
  void contentsDropEvent(QDropEvent *);

protected: // Protected attributes

  /** True if drag&drop operation started, otherwise is false */
  bool m_bDrag;

  /** Contain mouse position of drag operation */
  QPoint m_dragPos;

  /** The item that was current before the drag-enter event happened */
  QListViewItem *m_pCurrentBeforeDropItem;

  /** The item we are moving the mouse over (during a drag) */
  QListViewItem *m_pDropItem;

  /** List of avalilable drop formats */
  QStrList m_lstDropFormats;

  /** Timer for counting time to auto open fselected folder while drag */
  QTimer *m_autoOpenTimer;

  /** Pointer to application document */
  KXMLEditorDoc* m_pDoc;

private slots: // Private slots

  /** Called, when m_autoOpenTimer timeout occured */
  void slotAutoOpenFolder();

// --- added by Olaf Hartig (29.Jun.2001)
public slots:
  /**
   * Rename column @p c of @p item, if it's a XmlTreeItem::itemElement.
   */
  virtual void rename(QListViewItem *item, int c);

signals: // Signals
  /** Emited, when tree is changed using drag&drop or inplace editing */
  void contentsChanged();
};

#endif
