/***************************************************************************
                          xmlstructureparser.cpp  -  description
                             -------------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001 by Lumir Vanek
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "xmlstructureparser.h"
#include "kxmleditordoc.h"
#include "xmltreeview.h"

#include <qmessagebox.h>

#include "optionsdialog.h"

XmlStructureParser::XmlStructureParser(XmlTreeView* pListWiew, KXMLEditorDoc *pDocument)
	 : QXmlDefaultHandler()
{
	m_pListWiew = pListWiew;
	m_pDocument = pDocument;
	m_bStartCDATA = false;
}

bool XmlStructureParser::startDocument()
{
    return true;
}

bool XmlStructureParser::startElement(const QString& namespaceURI,
																	 				 const QString& /*localName*/,
                                   		 const QString& qName,
                                   		 const QXmlAttributes& attributes)
{
	XmlElement* pXmlElement;

	if(!m_stackOfXmlElements.isEmpty())
    	{ XmlElement* pParentXmlElement = m_stackOfXmlElements.top();
   			if(!pParentXmlElement)
					{ ASSERT(false);
					  return false;
					}
				
				// get last child element
				QListViewItem *pChild = pParentXmlElement->firstChild();
				QListViewItem *pLastChild = 0;
				while(pChild)
  				{ pLastChild = pChild;
  	  			pChild = pChild->nextSibling();
  				}
				
  		  // create new element
				pXmlElement = new XmlElement(pParentXmlElement, qName, namespaceURI);
				
				// sort properly new element after last child
				if(pLastChild)
					pXmlElement->moveItem(pLastChild);
					
				if(m_stackOfXmlElements.count() < OptionsDialog::m_AppOptionsMisc.iExpandToLevel)
					pXmlElement->setOpen(true);
			}
  else
    	{ // get last child element
				QListViewItem *pChild = m_pListWiew->firstChild();
				QListViewItem *pLastChild = 0;
				while(pChild)
  			{ pLastChild = pChild;
  	  		pChild = pChild->nextSibling();
  			}
  			
  			pXmlElement = new XmlElement(m_pListWiew, qName, namespaceURI); // root element
				pXmlElement->setOpen(true);
				
				// sort properly new item after last child
				if(pLastChild)
					pXmlElement->moveItem(pLastChild);
			}

	m_stackOfXmlElements.push(pXmlElement);

	if(attributes.length() > 0)
    	{ for(int i = 0; i < attributes.length(); i++)
        	{ pXmlElement->appendAttribute(new XmlAttribute(attributes.qName(i), attributes.value(i)));
        	}
        	
     		// update column with attributes list
        pXmlElement->updateStringAttrList();
			}

    return true;
}

bool XmlStructureParser::endElement(const QString&, const QString&, const QString&)
{
    m_stackOfXmlElements.pop();
    return true;
}

bool XmlStructureParser::characters(const QString& ch)
{
	if(containUsefulCharacter(ch))
		{ XmlElement* pParentXmlElement = m_stackOfXmlElements.top();
			if(!pParentXmlElement)
				{ ASSERT(false);
				  return false;
				}
				
			// get last child element
			QListViewItem *pChild = pParentXmlElement->firstChild();
			QListViewItem *pLastChild = 0;
			while(pChild)
  			{ pLastChild = pChild;
  	  		pChild = pChild->nextSibling();
  			}
				
  		// create new text or CDATA
			XmlContentsItem *pXmlContentsItem = new XmlContentsItem(pParentXmlElement, ch, m_bStartCDATA ? XmlTreeItem::itemCDATA : XmlTreeItem::itemText);
				
			// sort properly new element after last child
			if(pLastChild)
				pXmlContentsItem->moveItem(pLastChild);
		}
	
	return true;
}

bool XmlStructureParser::startCDATA()
{
	m_bStartCDATA = true;
	return QXmlDefaultHandler::startCDATA();
}

bool XmlStructureParser::endCDATA()
{
	m_bStartCDATA = false;
	return QXmlDefaultHandler::endCDATA();
}

bool XmlStructureParser::startDTD(const QString &name,
																 			const QString &publicId,
																 			const QString &systemId)
{
	return QXmlDefaultHandler::startDTD(name, publicId, systemId);
}

bool XmlStructureParser::endDTD()
{
	return QXmlDefaultHandler::endDTD();
}


bool XmlStructureParser::comment(const QString& ch)
{
	if(!m_stackOfXmlElements.isEmpty())
    	{ XmlElement* pParentXmlElement = m_stackOfXmlElements.top();
   			if(!pParentXmlElement)
					{ ASSERT(false);
					  return false;
					}
			
		   // get last child element
			QListViewItem *pChild = pParentXmlElement->firstChild();
			QListViewItem *pLastChild = 0;
			while(pChild)
  			{ pLastChild = pChild;
   				pChild = pChild->nextSibling();
  			}
				
  		// create new comment
			XmlContentsItem *pXmlContentsItem = new XmlContentsItem(pParentXmlElement, ch, XmlTreeItem::itemComment);
				
			// sort properly new element after last child
			if(pLastChild)
				pXmlContentsItem->moveItem(pLastChild);
		
		}
  else
		{	// get last child element
			QListViewItem *pChild = m_pListWiew->firstChild();
			QListViewItem *pLastChild = 0;
			while(pChild)
  			{ pLastChild = pChild;
  	  		pChild = pChild->nextSibling();
  			}	
  				
  		XmlContentsItem *pXmlContentsItem = new XmlContentsItem(m_pListWiew, ch, XmlTreeItem::itemComment);
  		
  		// sort properly new item after last child
			if(pLastChild)
				pXmlContentsItem->moveItem(pLastChild);
		}
				
	return true;
}

bool XmlStructureParser::processingInstruction(const QString &target, const QString& data)
{
	if(!m_stackOfXmlElements.isEmpty())
    	{ XmlElement* pParentXmlElement = m_stackOfXmlElements.top();
   			if(!pParentXmlElement)
					{ ASSERT(false);
					  return false;
					}
					
	 		 	// get last child element
				QListViewItem *pChild = pParentXmlElement->firstChild();
				QListViewItem *pLastChild = 0;
				while(pChild)
  				{ pLastChild = pChild;
  	  			pChild = pChild->nextSibling();
  				}	
			
		   	XmlProcessingInstruction *pXmlProcInstr = new XmlProcessingInstruction(pParentXmlElement, target, data);
		
		  	// sort properly new item after last child
				if(pLastChild)
					pXmlProcInstr->moveItem(pLastChild);
			}
  else
    	{ // get last child element
				QListViewItem *pChild = m_pListWiew->firstChild();
				QListViewItem *pLastChild = 0;
				while(pChild)
  				{ pLastChild = pChild;
  	  			pChild = pChild->nextSibling();
  				}	
  				
  			XmlProcessingInstruction *pXmlProcInstr = new XmlProcessingInstruction(m_pListWiew, target, data); // root PI
  			
  			// sort properly new item after last child
				if(pLastChild)
					pXmlProcInstr->moveItem(pLastChild);
			}

	// if proc. instruction contain info about document encoding, read it
	if(target == "xml")
		{ int iPos = data.find("encoding");
			if(iPos >= 0)
				{ QString strEncoding;
				
					int iPosStart = data.find("'", iPos + 9);
					if(iPos >= 0)
						{ int iPosEnd = data.find("'", iPosStart + 1);
							if(iPosEnd >= 0)
								{ strEncoding = data.mid(iPosStart, iPosEnd - iPosStart);
								  m_pDocument->setEncoding(strEncoding);
								}
						}
				
				}
		}
	
	return QXmlDefaultHandler::processingInstruction(target, data);
}

bool XmlStructureParser::warning(const QXmlParseException& exception)
{
	m_strErrorMsg = exception.message();
	m_iColumnNumber = exception.columnNumber();
	m_iLineNumber = exception.lineNumber();
	return false;
}

bool XmlStructureParser::error(const QXmlParseException& exception)
{
	m_strErrorMsg = exception.message();
	m_iColumnNumber = exception.columnNumber();
	m_iLineNumber = exception.lineNumber();
	return false;
}

bool XmlStructureParser::fatalError(const QXmlParseException& exception)
{
	m_strErrorMsg = exception.message();
	m_iColumnNumber = exception.columnNumber();
	m_iLineNumber = exception.lineNumber();
	return false;
}

QString XmlStructureParser::errorString()
{
	return m_strErrorMsg;
}
