/***************************************************************************
                          optionsdialog.h  -  description
                             -------------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001 by Lumir Vanek
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OPTIONSDIALOG_H
#define OPTIONSDIALOG_H

#include <qwidget.h>
#include <kdialogbase.h>

#include <qstrlist.h>

class QCheckBox;
class QLineEdit;
class QListView;
class QListViewItem;
class QButtonGroup;
class QRadioButton;

/**Application options dialog
  *@author Lumir Vanek
  */

class OptionsDialog : public KDialogBase
{
   Q_OBJECT

enum enPage
{
	pageMisc = 0, pageTarGzExt, pageSpecChars
};

public:
	OptionsDialog(QWidget *parent=0, const char *name=0, bool = true);
	~OptionsDialog();
	
	
protected: // Protected methods

  /** Setup page with misc. options  */
  void setupMiscPage();

  /** Setup page for list of files extensions that is TarGz */
  void setupTarGzExtPage();

  /** Setup page for defining special characters list */
  void setupSpecCharactersPage();

public:

struct SAppOptionsMisc
{
	bool bRootDecorated;
	unsigned int  iExpandToLevel;
	bool	bAppendCRLF;
	bool	bEnableDragDrop;
	int		iElemDisplayMode;
};

struct SAppOptionsTarGzExt
{
	QStrList strListOfTarGzExtensions;
};

struct SAppOptionsSpecChars
{
	QStrList strListOfSpecCharacters;
};

static	SAppOptionsMisc				m_AppOptionsMisc;
static	SAppOptionsTarGzExt		m_AppOptionsTarGzExt;
static	SAppOptionsSpecChars	m_AppOptionsSpecChars;

private:

struct SWidgetsMisc
{
	QCheckBox 		*pCheckBoxRootDecorated;
	QLineEdit			*pLineEditExpandToLevel;
	QCheckBox 		*pCheckBoxAppendCRLF;
	QCheckBox 		*pCheckBoxEnableDragDrop;
	
	QButtonGroup	*pButtonGroupElemDisplayMode;
	QRadioButton	*pRadioBtnDisplOnlyElements;
	QRadioButton	*pRadioBtnDisplAttrNames;
	QRadioButton	*pRadioBtnDisplAttrValues;
};

struct SWidgetsTarGzExt
{
	QListView			*pListView;
	QListViewItem *pItemCurrent;
	QLabel				*pLabelExtension;
	QLineEdit			*pEditExtension;
};

struct SWidgetsSpecChars
{
	QListView			*pListView;
	QListViewItem *pItemCurrent;
	QLabel				*pLabelSpecCharacter;
	QLineEdit			*pEditSpecCharacter;
};

	SWidgetsMisc		 		m_WidgetsMisc;
	SWidgetsTarGzExt		m_WidgetsTarGzExt;
	SWidgetsSpecChars		m_WidgetsSpecChars;

protected slots: // Protected slots

  /** Called when user press Apply button */
  void slotApply();

  /** Called when user press OK button */
  void slotOk();

  /** Called, when Delete button clicked */
  void slotDeleteExtension();

  /** Called, when New button clicked */
  void slotNewExtension();

  /** Called, when text in edit line changed  */
  void slotExtensionChanged(const QString&);

  /** Called, when user select item in list of extensions */
  void slotListTarGzExtSelChanged();

  /** Called, when text in edit line changed  */
	void slotSpecCharacterChanged(const QString &);
	
	/** Called, when New button clicked */
	void slotNewSpecCharacter();
	
	/** Called, when Delete button clicked */
	void slotDeleteSpecCharacter();

	/** Called, when user select item in list of extensions */
	void slotListSpecCharsSelChanged();

signals: // Signals

  /** Emited, when user press Apply or Ok buttons */
  void configurationChanged();
};

#endif
