/***************************************************************************
                          optionsdialog.cpp  -  description
                             -------------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001 by Lumir Vanek
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "optionsdialog.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qvalidator.h>
#include <qlistview.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>

#include <klocale.h>
#include <kiconloader.h>

OptionsDialog::SAppOptionsMisc			OptionsDialog::m_AppOptionsMisc;
OptionsDialog::SAppOptionsTarGzExt 	OptionsDialog::m_AppOptionsTarGzExt;
OptionsDialog::SAppOptionsSpecChars	OptionsDialog::m_AppOptionsSpecChars;

OptionsDialog::OptionsDialog(QWidget *parent, const char *name, bool bModal)
 : KDialogBase(IconList,
               i18n("Configure"),
               Apply | Ok | Cancel | Help,
               Ok,
               parent,
               name,
               bModal,
               true
              )
{
	setupMiscPage();
	setupTarGzExtPage();
	setupSpecCharactersPage();
}

OptionsDialog::~OptionsDialog()
{
}

/** Setup page with misc. options  */
void OptionsDialog::setupMiscPage()
{
	QFrame *pPage = addPage(i18n("Miscellaneous"),
													i18n("Various properties"),
													KGlobal::instance()->iconLoader()->loadIcon("misc", KIcon::NoGroup, KIcon::SizeMedium)
												 );
	QVBoxLayout *pTopLayout = new QVBoxLayout(pPage, 0, spacingHint());
	if(pTopLayout == 0)
		return;
		
	QGridLayout *pGbox = new QGridLayout(5, 2);
	pTopLayout->addLayout(pGbox);
	
	m_WidgetsMisc.pCheckBoxRootDecorated = new QCheckBox(i18n("Set root element &decorated"), pPage, "setrootdecorated");
	m_WidgetsMisc.pCheckBoxRootDecorated->setChecked(m_AppOptionsMisc.bRootDecorated);
	pGbox->addWidget(m_WidgetsMisc.pCheckBoxRootDecorated, 0, 0);

	pGbox->addWidget(new QLabel(i18n("After open file, expand to level:"), pPage, "expandtolabel"), 1, 0);
	m_WidgetsMisc.pLineEditExpandToLevel = new QLineEdit(pPage, "expandtolevel");
	m_WidgetsMisc.pLineEditExpandToLevel->setMaxLength(2);
	QIntValidator *pIntValidator = new QIntValidator(m_WidgetsMisc.pLineEditExpandToLevel);
	pIntValidator->setRange(0, 99);
	m_WidgetsMisc.pLineEditExpandToLevel->setValidator(pIntValidator);
	m_WidgetsMisc.pLineEditExpandToLevel->setText(QString().setNum(m_AppOptionsMisc.iExpandToLevel));
	pGbox->addWidget(m_WidgetsMisc.pLineEditExpandToLevel, 1, 1);
	
	m_WidgetsMisc.pCheckBoxAppendCRLF = new QCheckBox(i18n("&Append CR LF at end of line"), pPage, "appendcrlf");
	m_WidgetsMisc.pCheckBoxAppendCRLF->setChecked(m_AppOptionsMisc.bAppendCRLF);
	pGbox->addWidget(m_WidgetsMisc.pCheckBoxAppendCRLF, 2, 0);
	
	m_WidgetsMisc.pCheckBoxEnableDragDrop = new QCheckBox(i18n("Enable &Drag and Drop"), pPage, "enablednd");
	m_WidgetsMisc.pCheckBoxEnableDragDrop->setChecked(m_AppOptionsMisc.bEnableDragDrop);
	pGbox->addWidget(m_WidgetsMisc.pCheckBoxEnableDragDrop, 3, 0);
	
	m_WidgetsMisc.pButtonGroupElemDisplayMode = new QButtonGroup(i18n("XML Elements - what display in tree"), pPage);
	pGbox->addWidget(m_WidgetsMisc.pButtonGroupElemDisplayMode, 4, 0);
	pTopLayout->addStretch(1);
	QGridLayout *pGridLayoutRadio = new QGridLayout(m_WidgetsMisc.pButtonGroupElemDisplayMode, 3, 1, 20);	
	
	m_WidgetsMisc.pRadioBtnDisplOnlyElements = new QRadioButton(i18n("Only element name"), m_WidgetsMisc.pButtonGroupElemDisplayMode);
	pGridLayoutRadio->addWidget(m_WidgetsMisc.pRadioBtnDisplOnlyElements, 1, 0, AlignTop);
	m_WidgetsMisc.pRadioBtnDisplAttrNames = new QRadioButton(i18n("Element, attribute names"), m_WidgetsMisc.pButtonGroupElemDisplayMode);
	pGridLayoutRadio->addWidget(m_WidgetsMisc.pRadioBtnDisplAttrNames, 2, 0, AlignTop);
	m_WidgetsMisc.pRadioBtnDisplAttrValues = new QRadioButton(i18n("Element, attributes names and its values"), m_WidgetsMisc.pButtonGroupElemDisplayMode);
	pGridLayoutRadio->addWidget(m_WidgetsMisc.pRadioBtnDisplAttrValues, 3, 0, AlignTop);
	switch(m_AppOptionsMisc.iElemDisplayMode)
		{ case 0:	m_WidgetsMisc.pRadioBtnDisplOnlyElements->setChecked(true);
							break;
							
			case 1:	m_WidgetsMisc.pRadioBtnDisplAttrNames->setChecked(true);
							break;
							
			case 2:	m_WidgetsMisc.pRadioBtnDisplAttrValues->setChecked(true);
							break;
							
			default: ASSERT(false);
		}
}

/** Setup page for list of files extensions that is TarGz */
void OptionsDialog::setupTarGzExtPage()
{
	QFrame *pPage = addPage(i18n("TarGz Extensions"),
													i18n("Define TarGz file extensions"),
													KGlobal::instance()->iconLoader()->loadIcon("filetypes", KIcon::NoGroup, KIcon::SizeMedium)
    										 );
  QVBoxLayout *pTopLayout = new QVBoxLayout(pPage, 0, spacingHint());

	pTopLayout->addWidget(new QLabel(i18n("Archive files extensions:"), pPage));
	
	m_WidgetsTarGzExt.pListView = new QListView(pPage);
	pTopLayout->addWidget(m_WidgetsTarGzExt.pListView);
	m_WidgetsTarGzExt.pListView->addColumn( i18n("Extension"));
  m_WidgetsTarGzExt.pListView->setAllColumnsShowFocus(true);
  m_WidgetsTarGzExt.pListView->setFrameStyle(QFrame::WinPanel + QFrame::Sunken);
  m_WidgetsTarGzExt.pListView->setSorting(-1);
	connect(m_WidgetsTarGzExt.pListView, SIGNAL(selectionChanged()), this, SLOT(slotListTarGzExtSelChanged()));

	QString strExtension;
  for(strExtension = m_AppOptionsTarGzExt.strListOfTarGzExtensions.first();
  		strExtension != 0;
  		strExtension = m_AppOptionsTarGzExt.strListOfTarGzExtensions.next())
  		 	{ new QListViewItem(m_WidgetsTarGzExt.pListView, strExtension);
  		 	}
	
	QGridLayout *pGbox = new QGridLayout(pTopLayout, 2, 2);
  pGbox->setColStretch(1, 10);

  m_WidgetsTarGzExt.pLabelExtension = new QLabel(i18n("Extension:"), pPage );
  m_WidgetsTarGzExt.pLabelExtension->setEnabled(false);
  pGbox->addWidget(m_WidgetsTarGzExt.pLabelExtension, 0, 0);
  m_WidgetsTarGzExt.pEditExtension = new QLineEdit(pPage);
  m_WidgetsTarGzExt.pEditExtension->setEnabled(false);
  connect(m_WidgetsTarGzExt.pEditExtension, SIGNAL(textChanged(const QString&)), this, SLOT(slotExtensionChanged(const QString&)));
  pGbox->addWidget(m_WidgetsTarGzExt.pEditExtension, 0, 1);


  QWidget *pWidgetHelper = new QWidget(pPage);
  pGbox->addWidget(pWidgetHelper, 2, 1 );
  QHBoxLayout *pHLayout = new QHBoxLayout(pWidgetHelper, 0, spacingHint());
  QPushButton *pPushButton = new QPushButton(i18n("&New"), pWidgetHelper);
  connect(pPushButton, SIGNAL(clicked()), this, SLOT(slotNewExtension()) );
  pPushButton->setAutoDefault( false );
  pHLayout->addWidget(pPushButton);
  pPushButton = new QPushButton(i18n("Dele&te"), pWidgetHelper);
  connect(pPushButton, SIGNAL(clicked()), this, SLOT(slotDeleteExtension()));
  pPushButton->setAutoDefault( false );
  pHLayout->addWidget(pPushButton);
  pHLayout->addStretch(10);

  pTopLayout->addSpacing(spacingHint() * 2);
}

/** Called, when text in edit line changed  */
void OptionsDialog::slotExtensionChanged(const QString &text)
{
	if(m_WidgetsTarGzExt.pItemCurrent != 0)
  	{ m_WidgetsTarGzExt.pItemCurrent->setText(0, text);
  	}
}

/** Called, when New button clicked */
void OptionsDialog::slotNewExtension()
{
	QListViewItem *listItem = new QListViewItem(m_WidgetsTarGzExt.pListView, "");
  m_WidgetsTarGzExt.pListView->setCurrentItem(listItem);
  m_WidgetsTarGzExt.pListView->setSelected(listItem, true);

  m_WidgetsTarGzExt.pItemCurrent = m_WidgetsTarGzExt.pListView->selectedItem();
  if( m_WidgetsTarGzExt.pItemCurrent != 0)
  	{ m_WidgetsTarGzExt.pEditExtension->setEnabled(true);
    	m_WidgetsTarGzExt.pLabelExtension->setEnabled(true);
    	m_WidgetsTarGzExt.pEditExtension->setFocus();
  	}
}

/** Called, when Delete button clicked */
void OptionsDialog::slotDeleteExtension()
{
	if( m_WidgetsTarGzExt.pItemCurrent != 0 )
  {
    QListViewItem *pItemNext = m_WidgetsTarGzExt.pItemCurrent->itemAbove();
    if( pItemNext == 0 )
    	{ pItemNext = m_WidgetsTarGzExt.pItemCurrent->itemBelow();
    	}

    m_WidgetsTarGzExt.pEditExtension->clear();
    m_WidgetsTarGzExt.pEditExtension->setEnabled(false);
    m_WidgetsTarGzExt.pLabelExtension->setEnabled(false);

    m_WidgetsTarGzExt.pListView->takeItem(m_WidgetsTarGzExt.pItemCurrent );
    m_WidgetsTarGzExt.pItemCurrent = 0;

    if(pItemNext != 0)
    	{ m_WidgetsTarGzExt.pListView->setSelected(pItemNext, true );
    	}
  }
}

/** Called, when user select item in list of extensions */
void OptionsDialog::slotListTarGzExtSelChanged()
{
	m_WidgetsTarGzExt.pItemCurrent = m_WidgetsTarGzExt.pListView->selectedItem();
  if(m_WidgetsTarGzExt.pItemCurrent != 0 )
  	{ m_WidgetsTarGzExt.pEditExtension->setText(m_WidgetsTarGzExt.pItemCurrent->text(0));
    	m_WidgetsTarGzExt.pListView->setEnabled(true);
    	m_WidgetsTarGzExt.pLabelExtension->setEnabled(true);
    	m_WidgetsTarGzExt.pEditExtension->setEnabled(true);
  	}
}

/** Setup page for defining special characters list */
void OptionsDialog::setupSpecCharactersPage()
{
QFrame *pPage = addPage(i18n("Spec. Characters"),
													i18n("Define Special Characters List"),
													KGlobal::instance()->iconLoader()->loadIcon("charset", KIcon::NoGroup, KIcon::SizeMedium)
    										 );
  QVBoxLayout *pTopLayout = new QVBoxLayout(pPage, 0, spacingHint());

	pTopLayout->addWidget(new QLabel(i18n("Special Characters:"), pPage));
	
	m_WidgetsSpecChars.pListView = new QListView(pPage, "SpecCharslist");
	pTopLayout->addWidget(m_WidgetsSpecChars.pListView);
	m_WidgetsSpecChars.pListView->addColumn( i18n("Special Character"));
  m_WidgetsSpecChars.pListView->setAllColumnsShowFocus(true);
  m_WidgetsSpecChars.pListView->setFrameStyle(QFrame::WinPanel + QFrame::Sunken);
  m_WidgetsSpecChars.pListView->setSorting(-1);
	connect(m_WidgetsSpecChars.pListView, SIGNAL(selectionChanged()), this, SLOT(slotListSpecCharsSelChanged()));

	QString strSpecCharacter;
  for(strSpecCharacter = m_AppOptionsSpecChars.strListOfSpecCharacters.first();
  		strSpecCharacter != 0;
  		strSpecCharacter = m_AppOptionsSpecChars.strListOfSpecCharacters.next())
  		 	{ new QListViewItem(m_WidgetsSpecChars.pListView, strSpecCharacter);
  		 	}

	QGridLayout *pGbox = new QGridLayout(pTopLayout, 2, 2);
  pGbox->setColStretch(1, 10);

  m_WidgetsSpecChars.pLabelSpecCharacter = new QLabel(i18n("Special Character:"), pPage );
  m_WidgetsSpecChars.pLabelSpecCharacter->setEnabled(false);
  pGbox->addWidget(m_WidgetsSpecChars.pLabelSpecCharacter, 0, 0);
  m_WidgetsSpecChars.pEditSpecCharacter = new QLineEdit(pPage);
  m_WidgetsSpecChars.pEditSpecCharacter->setEnabled(false);
  connect(m_WidgetsSpecChars.pEditSpecCharacter, SIGNAL(textChanged(const QString&)), this, SLOT(slotSpecCharacterChanged(const QString&)));
  pGbox->addWidget(m_WidgetsSpecChars.pEditSpecCharacter, 0, 1);


  QWidget *pWidgetHelper = new QWidget(pPage);
  pGbox->addWidget(pWidgetHelper, 2, 1 );
  QHBoxLayout *pHLayout = new QHBoxLayout(pWidgetHelper, 0, spacingHint());
  QPushButton *pPushButton = new QPushButton(i18n("&New"), pWidgetHelper);
  connect(pPushButton, SIGNAL(clicked()), this, SLOT(slotNewSpecCharacter()) );
  pPushButton->setAutoDefault( false );
  pHLayout->addWidget(pPushButton);
  pPushButton = new QPushButton(i18n("Dele&te"), pWidgetHelper);
  connect(pPushButton, SIGNAL(clicked()), this, SLOT(slotDeleteSpecCharacter()));
  pPushButton->setAutoDefault(false);
  pHLayout->addWidget(pPushButton);
  pHLayout->addStretch(10);

  pTopLayout->addSpacing(spacingHint() * 2);	
}

/** Called, when text in edit line changed  */
void OptionsDialog::slotSpecCharacterChanged(const QString &text)
{
	if(m_WidgetsSpecChars.pItemCurrent != 0)
  	{ m_WidgetsSpecChars.pItemCurrent->setText(0, text);
  	}
}

/** Called, when New button clicked */
void OptionsDialog::slotNewSpecCharacter()
{
	QListViewItem *listItem = new QListViewItem(m_WidgetsSpecChars.pListView, "");
  m_WidgetsSpecChars.pListView->setCurrentItem(listItem);
  m_WidgetsSpecChars.pListView->setSelected(listItem, true);

  m_WidgetsSpecChars.pItemCurrent = m_WidgetsSpecChars.pListView->selectedItem();
  if(m_WidgetsSpecChars.pItemCurrent != 0)
  	{ m_WidgetsSpecChars.pEditSpecCharacter->setEnabled(true);
    	m_WidgetsSpecChars.pLabelSpecCharacter->setEnabled(true);
    	m_WidgetsSpecChars.pEditSpecCharacter->setFocus();
  	}
}

/** Called, when Delete button clicked */
void OptionsDialog::slotDeleteSpecCharacter()
{
	if(m_WidgetsSpecChars.pItemCurrent != 0 )
  {
    QListViewItem *pItemNext = m_WidgetsSpecChars.pItemCurrent->itemAbove();
    if( pItemNext == 0 )
    	{ pItemNext = m_WidgetsSpecChars.pItemCurrent->itemBelow();
    	}

    m_WidgetsSpecChars.pEditSpecCharacter->clear();
    m_WidgetsSpecChars.pEditSpecCharacter->setEnabled(false);
    m_WidgetsSpecChars.pEditSpecCharacter->setEnabled(false);

    m_WidgetsSpecChars.pListView->takeItem(m_WidgetsSpecChars.pItemCurrent );
    m_WidgetsSpecChars.pItemCurrent = 0;

    if(pItemNext != 0)
    	{ m_WidgetsSpecChars.pListView->setSelected(pItemNext, true );
    	}
  }
}
/** Called, when user select item in list of extensions */
void OptionsDialog::slotListSpecCharsSelChanged()
{
	m_WidgetsSpecChars.pItemCurrent = m_WidgetsSpecChars.pListView->selectedItem();
  if(m_WidgetsSpecChars.pItemCurrent != 0 )
  	{ m_WidgetsSpecChars.pEditSpecCharacter->setText(m_WidgetsSpecChars.pItemCurrent->text(0));
    	m_WidgetsSpecChars.pListView->setEnabled(true);
    	m_WidgetsSpecChars.pLabelSpecCharacter->setEnabled(true);
    	m_WidgetsSpecChars.pEditSpecCharacter->setEnabled(true);
  	}
}

/** Called when user press OK button */
void OptionsDialog::slotOk()
{
	slotApply();
	accept();
}

/** Called when user press Apply button */
void OptionsDialog::slotApply()
{
	switch(activePageIndex())
		{ case pageMisc:		m_AppOptionsMisc.bRootDecorated = m_WidgetsMisc.pCheckBoxRootDecorated->isChecked();
												m_AppOptionsMisc.iExpandToLevel = m_WidgetsMisc.pLineEditExpandToLevel->text().toInt();
												m_AppOptionsMisc.bAppendCRLF = m_WidgetsMisc.pCheckBoxAppendCRLF->isChecked();
												m_AppOptionsMisc.bEnableDragDrop = m_WidgetsMisc.pCheckBoxEnableDragDrop->isChecked();
												
												if(m_WidgetsMisc.pRadioBtnDisplOnlyElements->isChecked())
													m_AppOptionsMisc.iElemDisplayMode = 0;
												else
													{ if(m_WidgetsMisc.pRadioBtnDisplAttrNames->isChecked())
															m_AppOptionsMisc.iElemDisplayMode = 1;
														else
															m_AppOptionsMisc.iElemDisplayMode = 2;
													}
													
												break;
												
			case pageTarGzExt:
										    { m_AppOptionsTarGzExt.strListOfTarGzExtensions.clear();
										
										      QListViewItem *pItem = m_WidgetsTarGzExt.pListView->firstChild();
													while(pItem)
														{ m_AppOptionsTarGzExt.strListOfTarGzExtensions.append(pItem->text(0));
														  pItem = pItem->nextSibling();
														}			
										    }
										    break;
			
		  case pageSpecChars:
										    { m_AppOptionsSpecChars.strListOfSpecCharacters.clear();
										
										      QListViewItem *pItem = m_WidgetsSpecChars.pListView->firstChild();
													while(pItem)
														{ m_AppOptionsSpecChars.strListOfSpecCharacters.append(pItem->text(0));
														  pItem = pItem->nextSibling();
														}			
										    }
										    break;
		
		}
	emit configurationChanged();
}


