/***************************************************************************
                          kxmleditorview.h  -  description
                             -------------------
    begin                : t ec 10 12:39:26 CEST 2001
    copyright            : (C) 2001 by Lumir Vanek
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXMLEDITORVIEW_H
#define KXMLEDITORVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for KDE
#include <klistview.h>

// include files for Qt
#include <qsplitter.h>

class KXMLEditorDoc;	// forward references
class XmlElement;
class	KPopupMenu;
class TableWidget;
class QTabWidget;
class XmlTreeItem;
class XmlTreeView;
class QMultiLineEdit;

/** The KXMLEditorView class provides the view widget for the KXMLEditorApp instance.	
 * The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As KXMLEditorView is part of the
 * docuement-view model, it needs a reference to the document object connected with it by the KXMLEditorApp class to manipulate and display
 * the document structure provided by the KXMLEditorDoc class.
 * 	
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */
class KXMLEditorView : public QSplitter
{
  Q_OBJECT
public:
  /** Constructor for the main view */
  KXMLEditorView(QWidget *parent = 0, const char *name=0);

  /** Destructor for the main view */
  ~KXMLEditorView();

  /** returns a pointer to the document connected to the view instance. Mind that this method requires a KXMLEditorApp instance as a parent
  * widget to get to the window document pointer by calling the KXMLEditorApp::getDocument() method.
  *
  * @see KXMLEditorApp#getDocument
  */
  KXMLEditorDoc *getDocument() const;

  /** contains the implementation for printing functionality */
  void print(QPrinter *pPrinter);
	
// Return pointer to list view
  XmlTreeView* getElementsTreeView() const { return m_pTreeViewElements; }

	/** Clear all views views */
  void clearView();

  /** Search string in XML document */
  void searchString(const QString &, bool, bool, bool, bool, bool);

  /** Insert XML element into document */
  void xmlInsertElement();

	/** Edit XML element properties */
  void xmlEditElement();

	/** Delete XML element from document */
  void xmlDeleteElement();

	/** Insert XML Attribute into element list */
  void xmlInsertAttribute();

	/** Edit XML attribute properties */
  void xmlEditAttribute();

	/** Delete XML attribute from element */
  void xmlDeleteAttribute();

	/** Insert XML element contents */
  void xmlInsertContents();

	/** Delete XML element contents */
  void xmlEditContents();

  /** Edit XML element contents */
  void xmlDeleteContents();

  /** Move item in tree Down */
  void xmlMoveItemDown();

  /** Move item in tree Up */
  void xmlMoveItemUp();

  /** Paste item from clipboard */
  void editPaste();

  /** Copy selected item to clipboard */
  void editCopy();

  /** Cut selected item to clipboard */
  void editCut();

  /** Expand selected node and entire child subtree  */
  void expandNode(int);

  /** Collapse selected item subtree */
  void collapseNode(int);

  /** Move selection to next bookmark */
  void bookmarkNext();

  /** Move selection to previous bookmark */
  void bookmarkPrev();

  /** Enable/disable bookmark in selected tree item */
  void toggleBookmark();

  /** Move tree selection to parent item */
  void goUp();
  /** Find item with strPath and select it. */
  bool changePath(const QString &);

  /** Delete Processing Instruction */
  void xmlDeleteProcInstruction();

  /** Edit Processing instruction */
  void xmlEditProcInstruction();

  /** Insert new Processing Instruction into document */
  void xmlInsertProcInstruction();
  /** Update column with attributes list for each XML element */
  void updateStringAttrLists();

private:
		// Tree view display XML document tree structure
  	XmlTreeView* m_pTreeViewElements;

		// Horizontal splitter, contain attributes list view and editor for XML contents
		QSplitter* m_pSplitterHorizontal;
		
		// Tab widget, contain m_pTableAttributes and m_pLineEditContents
		QTabWidget* 	m_pTabWidget;

  	// Table widget display XML attributes
  	TableWidget* m_pTableAttributes;
  	
  	// Edit widget for contents
  	QMultiLineEdit *m_pLineEditContents;
	

public: // Public attributes

static	KPopupMenu*	m_pElementsMenu;

static 	KPopupMenu*	m_pNewRootElementMenu;

static	KPopupMenu*	m_pAttributesMenu;

static 	KPopupMenu*	m_pContentsMenu;

static 	KPopupMenu*	m_pProcInstrMenu;

public slots:
  /** Unselect the currently selected element. */
  void slotUnselect();

protected slots: // Protected slots

  /** Called, when user select Tree item. Make all changes for new selected item */
  void slotElemViewSelChanged(QListViewItem *);

  /** Called, when user double click on XML element in tree view */
  void slotElemViewDoubleClicked(QListViewItem *);

  /** Called, when user press right mouse buton on XML elements Tree View */
  void slotElemViewRButtonPr(QListViewItem*, const QPoint&, int);

  /** Called, when user press right mouse button on XML attributes table */
  void slotAttrViewRButtonPr(const QPoint&);

  /** Called, whed user edit cell with XML attribute */
  void slotAttrViewValueChanged(int, int);

  /** Called, when tree is changed using drag & drop or inplace editing */
  void slotElemViewContentsChanged();

protected: // Protected attributes

	/** Pixmap for XML attribute in KListWiew */
  QPixmap* m_pPixmapXmlAttribute;

signals: // Signals

  /** Emited when selected element in treeview is changed */
  void sigSelectedElementChanged( const XmlTreeItem * const pElement );

protected: // Protected methods

};

#endif // KXMLEDITORVIEW_H
