/***************************************************************************
                          kxmleditorview.cpp  -  description
                             -------------------
    begin                : t ec 10 12:39:26 CEST 2001
    copyright            : (C) 2001 by Lumir Vanek
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qprinter.h>
#include <qpainter.h>
#include <qtextstream.h>
#include <qlineedit.h>
#include <qtable.h>
#include <qtabwidget.h>
#include <qclipboard.h>
#include <qdragobject.h>

// include files for KDE
#include <kmessagebox.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <kiconloader.h>
#include <keditcl.h>

// application specific includes
#include "kxmleditorview.h"
#include "kxmleditordoc.h"
#include "kxmleditor.h"
#include "xmlstructureparser.h"
#include "xmlelementdlg.h"
#include "xmlattributedlg.h"
#include "xmlcontentsdlg.h"
#include "xmlprocinstrdlg.h"
#include "tablewidget.h"
#include "xmltreeview.h"

KPopupMenu*	KXMLEditorView::m_pElementsMenu = 0;
KPopupMenu*	KXMLEditorView::m_pAttributesMenu = 0;
KPopupMenu*	KXMLEditorView::m_pNewRootElementMenu = 0;
KPopupMenu*	KXMLEditorView::m_pContentsMenu = 0;
KPopupMenu*	KXMLEditorView::m_pProcInstrMenu = 0;


KXMLEditorView::KXMLEditorView(QWidget *parent, const char *name)
	: QSplitter(parent, name)
{
  setBackgroundMode(PaletteBase);

  // create tree view, that display XML tree structure --------------
	m_pTreeViewElements = new XmlTreeView(this, "Tree view", getDocument());
	
	connect(m_pTreeViewElements, SIGNAL(selectionChanged(QListViewItem *)), this, SLOT(slotElemViewSelChanged(QListViewItem *)));
	connect(m_pTreeViewElements, SIGNAL(rightButtonPressed(QListViewItem*, const QPoint&, int)), this, SLOT(slotElemViewRButtonPr(QListViewItem*, const QPoint&, int)));
	connect(m_pTreeViewElements, SIGNAL(doubleClicked(QListViewItem*)), this, SLOT(slotElemViewDoubleClicked(QListViewItem *)));
	connect(m_pTreeViewElements, SIGNAL(contentsChanged()), this, SLOT(slotElemViewContentsChanged()));
	
	// create horizontal splitter -------------------------------------
	m_pSplitterHorizontal = new QSplitter(this, "Horizontal splitter");
	m_pSplitterHorizontal->setOrientation(Vertical);
	m_pSplitterHorizontal->setOpaqueResize(TRUE);
	
	// create tab widget ----------------------------------------------
	m_pTabWidget = new QTabWidget(m_pSplitterHorizontal, "Tab");

  // create list view, that display XML attributes list -------------
  m_pTableAttributes = new TableWidget(0, 2, m_pTabWidget, "Attribute view");
	m_pTabWidget->addTab(m_pTableAttributes, QIconSet(UserIcon("xml_attribute")), "Attributes");
	QHeader* pHeaderHorizontal = m_pTableAttributes->horizontalHeader();
	pHeaderHorizontal->setLabel(0, i18n("Attribute name"));
	pHeaderHorizontal->setLabel(1, i18n("Attribute value"));
		
	m_pTabWidget->setTabEnabled(m_pTableAttributes, false);

	connect(m_pTableAttributes, SIGNAL(rightButtonPressed(const QPoint&)), this, SLOT(slotAttrViewRButtonPr(const QPoint&)));
	connect(m_pTableAttributes, SIGNAL(valueChanged(int, int)), this, SLOT(slotAttrViewValueChanged(int, int)));

	// create edit widget, that display XML contents
	m_pLineEditContents = new QMultiLineEdit(m_pTabWidget, "Edit");
	m_pTabWidget->addTab(m_pLineEditContents, QIconSet(UserIcon("xml_contents")), "Contents");
	m_pLineEditContents->setReadOnly(true);
	m_pTabWidget->setTabEnabled(m_pLineEditContents, false);
	
	// create pixmaps ---------------------------------------------------
	XmlTreeItem::m_pPixmapElement = new QPixmap(UserIcon("xml_element"));
	XmlTreeItem::m_pPixmapText = new QPixmap(UserIcon("xml_text"));
	XmlTreeItem::m_pPixmapCDATA = new QPixmap(UserIcon("xml_cdata"));
	XmlTreeItem::m_pPixmapComment = new QPixmap(UserIcon("xml_comment"));
	XmlTreeItem::m_pPixmapBookmark = new QPixmap(SmallIcon("bookmark"));
	XmlTreeItem::m_pPixmapProcInstr = new QPixmap(SmallIcon("exec"));
		
	m_pPixmapXmlAttribute = new QPixmap(UserIcon("xml_attribute"));
}

KXMLEditorView::~KXMLEditorView()
{
	if(m_pPixmapXmlAttribute)
		delete m_pPixmapXmlAttribute;

	if(XmlTreeItem::m_pPixmapElement)
		delete XmlTreeItem::m_pPixmapElement;
		
	if(XmlTreeItem::m_pPixmapText)
		delete XmlTreeItem::m_pPixmapText;
		
	if(XmlTreeItem::m_pPixmapCDATA)
		delete XmlTreeItem::m_pPixmapCDATA;
		
	if(XmlTreeItem::m_pPixmapComment)
		delete XmlTreeItem::m_pPixmapComment;
		
	if(XmlTreeItem::m_pPixmapProcInstr)
		delete XmlTreeItem::m_pPixmapProcInstr;
}

KXMLEditorDoc *KXMLEditorView::getDocument() const
{
  KXMLEditorApp *theApp=(KXMLEditorApp *) parentWidget();

  return theApp->getDocument();
}

void KXMLEditorView::print(QPrinter *pPrinter)
{
  QPainter printpainter;
  printpainter.begin(pPrinter);
	
  // TODO: add your printing code here

  printpainter.end();
}

/** Clear all views views */
void KXMLEditorView::clearView()
{
	m_pTreeViewElements->clear();
	m_pTableAttributes->setNumRows(0);
	m_pLineEditContents->clear();
}

/** Called, when user select Tree item.
Make all changes for new selected item.
 */
void KXMLEditorView::slotElemViewSelChanged(QListViewItem* item)
{
	m_pTableAttributes->setNumRows(0);
	m_pLineEditContents->clear();
	
	XmlTreeItem* pSelectedTreeItem = static_cast<XmlTreeItem *> (item);
	
	// choose appropriate object kind
	switch(pSelectedTreeItem->itemType())
		{ case XmlTreeItem::itemElement:
							{
								m_pTabWidget->setTabEnabled(m_pTableAttributes, true);
								m_pTabWidget->setTabEnabled(m_pLineEditContents, false);
								m_pTabWidget->showPage(m_pTableAttributes);
			
								XmlElement* pXmlElement = static_cast<XmlElement*> (item);

		  					// fill attributes from XML element to KListView
								m_pTableAttributes->setNumRows(pXmlElement->GetListOfAttributes()->count());
																													
								int iRow = 0;
								QList<XmlAttribute> *pListOfAttributes = pXmlElement->GetListOfAttributes();
								XmlAttribute* pXmlAttribute;

								for(pXmlAttribute = pListOfAttributes->first();
										pXmlAttribute != 0;
										pXmlAttribute = pListOfAttributes->next())
											{ m_pTableAttributes->setText(iRow, 0, pXmlAttribute->name());
			  								m_pTableAttributes->setText(iRow, 1, pXmlAttribute->value());
			  								m_pTableAttributes->adjustRow(iRow++);
											}
							}
								break;
																						
			case XmlTreeItem::itemText:
			case XmlTreeItem::itemCDATA:
			case XmlTreeItem::itemComment:			
							{
								m_pTabWidget->setTabEnabled(m_pTableAttributes, false);
								m_pTabWidget->setTabEnabled(m_pLineEditContents, true);
								m_pTabWidget->showPage(m_pLineEditContents);
			
								XmlContentsItem* pXmlContentsItem = static_cast<XmlContentsItem*> (item);
			
								m_pLineEditContents->setText(pXmlContentsItem->contents());
							}
								break;
																						
			case XmlTreeItem::itemProcInstr: 	
							{
								m_pTabWidget->setTabEnabled(m_pTableAttributes, false);
								m_pTabWidget->setTabEnabled(m_pLineEditContents, false);
							}
								break;
																						
			default:	ASSERT(false);
		}
			
	// inform main window, that selected item is changed
	emit sigSelectedElementChanged( pSelectedTreeItem );
}

/** Search string in XML document */
void KXMLEditorView::searchString(const QString &strSearchedString,
																	 bool bMatchCase,
																	 bool bElementNames,
																	 bool bAttributeNames,
																	 bool bAttributeValues,
																	 bool bContents)
{
	XmlElement* pRootXmlElement = m_pTreeViewElements->rootXmlElement();
	if(!pRootXmlElement)
		return;

	// get selected item from tree view
	QListViewItem *pSelectedItem = m_pTreeViewElements->selectedItem();

	// if no selected item, start searching from root item
	XmlElement* pStartXmlElement;

	if(!pSelectedItem)
		pStartXmlElement = pRootXmlElement;
	else
		pStartXmlElement = (XmlElement*) pSelectedItem;
		
	if(!pStartXmlElement)
		return;

	// search string in XML tree structure.
	XmlElement::enSearchResult searchResult;
	QListViewItem *pFoundItem = pStartXmlElement;

	// Searching always start from root elelent, due to "Search Next" functionality.
	// *pbReachedSelectedItem indicates, that selected item is reached and search may start from
	// next element.
	bool bReachedSelectedItem = false;

	searchResult = pRootXmlElement->searchString(strSearchedString,
																							 bMatchCase,
																							 bElementNames,
																							 bAttributeNames,
																							 bAttributeValues,
																							 bContents,
																							 &pFoundItem,
																							 &bReachedSelectedItem
																							);

	if(searchResult > XmlElement::searchNotFound)
		{ m_pTreeViewElements->setSelected(pFoundItem, true);
			m_pTreeViewElements->setCurrentItem(pFoundItem);
			m_pTreeViewElements->ensureItemVisible(pFoundItem);
		}
	else
		{ KMessageBox::sorry(this, i18n("String '%1' not found !").arg(strSearchedString));
		}
}
/** Called, when user press right mouse buton
on XML elements Tree View */
void KXMLEditorView::slotElemViewRButtonPr(QListViewItem* item, const QPoint&, int)
{
	if(item)
		{ XmlTreeItem* pSelectedTreeItem = static_cast<XmlTreeItem *> (item);
	
			// choose appropriate object kind
			switch(pSelectedTreeItem->itemType())
				{	case  XmlTreeItem::itemElement:		m_pElementsMenu->popup(QCursor::pos());
																						break;
																						
					case	XmlTreeItem::itemProcInstr:	m_pProcInstrMenu->popup(QCursor::pos());
																						break;
					
					default:													m_pContentsMenu->popup(QCursor::pos());
				}												
		}
	else
		m_pNewRootElementMenu->popup(QCursor::pos());
}

/** Called, when user double click on XML element
in tree view */
void KXMLEditorView::slotElemViewDoubleClicked(QListViewItem *item)
{
	if(item == 0) return;
	
	XmlTreeItem* pSelectedTreeItem = static_cast<XmlTreeItem *> (item);
	
	// choose appropriate object kind
	switch(pSelectedTreeItem->itemType())
		{	case  XmlTreeItem::itemElement:				// xmlEditElement(); inplace editing make this job
			
																						// mark document as modified
																						getDocument()->setModified();
																						emit sigSelectedElementChanged(pSelectedTreeItem);
																						break;
																							
		  case	XmlTreeItem::itemProcInstr:			xmlEditProcInstruction();
		  																			break;
		
		  default:															xmlEditContents();
		  																			break;
		}
}

/** Called, when user press right mouse button
on XML attributes table */
void KXMLEditorView::slotAttrViewRButtonPr(const QPoint&)
{
	m_pAttributesMenu->popup(QCursor::pos());
}

/** Called, whed user edit cell with XML attribute */
void KXMLEditorView::slotAttrViewValueChanged(int row, int col)
{
	QListViewItem *pSelectedItem = m_pTreeViewElements->selectedItem();
	if(!pSelectedItem)
		{ KMessageBox::sorry(this, i18n("Element not selected !"));
			return;
		}

	XmlElement* pSelectedXmlElement = static_cast <XmlElement *> (pSelectedItem);
	QList<XmlAttribute> *pListOfAttributes = pSelectedXmlElement->GetListOfAttributes();
		
	if(col == 0)
		{ // attribute name changed
		  pListOfAttributes->at(row)->setName(m_pTableAttributes->text(row, 0));
		}
	else
		{ // attribute value changed
		  pListOfAttributes->at(row)->setValue(m_pTableAttributes->text(row, 1));
		}
		
		// update column with attributes list
    pSelectedXmlElement->updateStringAttrList();
	
		// mark document as modified
		getDocument()->setModified();
}

/** Insert XML element into document */
void KXMLEditorView::xmlInsertElement()
{
	bool bRootElement = false;

	// get selected item from tree view
	QListViewItem *pSelectedItem = m_pTreeViewElements->selectedItem();
	
	if(!pSelectedItem)
		{ bRootElement = true;
		}
	else
		{ XmlTreeItem* pSelectedTreeItem = static_cast <XmlElement *> (pSelectedItem);
			if(pSelectedTreeItem->itemType() != XmlTreeItem::itemElement)
				bRootElement = true;
		}
			
	// display dialog for edit XML element properties
	XmlElementDlg dlgXmlElement(this, 0, true, false);
	if(bRootElement)
		{ dlgXmlElement.m_pComboBoxWhereToInsert->setCurrentItem(2); // as root
			dlgXmlElement.m_pComboBoxWhereToInsert->setEnabled(false);
		}
			
	if(dlgXmlElement.exec() == XmlElementDlg::Accepted)
		{ bRootElement = false;
		  if(dlgXmlElement.m_iWhereToInsert == 2)
				{ XmlElement* pRootXmlElement = m_pTreeViewElements->rootXmlElement();
						if(pRootXmlElement)
							{ KMessageBox::sorry(this, i18n("Root element already exists !"));
								return;
							}
						bRootElement = true;
				}
		
			// create new XML element
			XmlElement* pNewXmlElement;

			if(!bRootElement)
    			{ pNewXmlElement = new XmlElement(pSelectedItem, dlgXmlElement.m_strElementName, "");
    			
    			  if(dlgXmlElement.m_iWhereToInsert == 1) // move new item at bottom of list ?
		  				{ XmlElement* pSelectedXmlElement = static_cast<XmlElement *> (pSelectedItem);
		  				
		  					// get last child element
								QListViewItem *pChild = pSelectedXmlElement->firstChild();
								QListViewItem *pLastChild = 0;
								while(pChild)
  								{ pLastChild = pChild;
  	  							pChild = pChild->nextSibling();
  								}
  					
  							// sort properly new element after last child
								if(pLastChild)
									pNewXmlElement->moveItem(pLastChild);
		  				}
    			}
  		else
    			pNewXmlElement = new XmlElement(m_pTreeViewElements, dlgXmlElement.m_strElementName, ""); // root element
    			
    	// mark document as modified
			getDocument()->setModified();
			
			// make new item visible and selected
			m_pTreeViewElements->setCurrentItem(pNewXmlElement);
			m_pTreeViewElements->ensureItemVisible(pNewXmlElement);
		}
}
/** Edit XML element properties */
void KXMLEditorView::xmlEditElement()
{
	// get selected item from tree view
	QListViewItem *pSelectedItem = m_pTreeViewElements->selectedItem();
	if(!pSelectedItem)
		{ KMessageBox::sorry(this, i18n("Element not selected !"));
			return;
		}
		
	XmlElement* pSelectedXmlElement = static_cast <XmlElement *> (pSelectedItem);
	if(!pSelectedXmlElement) return;

	// display dialog for edit XML element properties
	XmlElementDlg dlgXmlElement(this, 0, true);
	dlgXmlElement.m_pEditElementName->setText(pSelectedXmlElement->text(0));
	//dlgXmlElement.m_pEditNamespaceURI->setText(pSelectedItem->text(1));

	if(dlgXmlElement.exec() == XmlElementDlg::Accepted)
		{ // store changed properties to XML element
			pSelectedXmlElement->setText(0, dlgXmlElement.m_strElementName);
			//pSelectedItem->setText(1, dlgXmlElement.m_strNamespaceURI);
			
			// mark document as modified
			getDocument()->setModified();
			emit sigSelectedElementChanged(static_cast <XmlTreeItem*> (pSelectedItem));
		}
}

/** Delete XML element from document */
void KXMLEditorView::xmlDeleteElement()
{
	// get selected item from tree view
	QListViewItem *pSelectedItem = m_pTreeViewElements->selectedItem();
	if(!pSelectedItem)
		{ KMessageBox::sorry(0, i18n("Element not selected !"));
			return;
		}
		
	if(KMessageBox::questionYesNo(this, i18n("Really delete subtree ?")) == KMessageBox::Yes)
		{ // before delete get your parent item
			QListViewItem* pParentItem = pSelectedItem->parent();
		  				
			delete pSelectedItem;
		
			m_pTableAttributes->setNumRows(0);
			
			// mark document as modified
			getDocument()->setModified();
			
			// make new item visible and selected
			if(pParentItem)
				{	m_pTreeViewElements->setCurrentItem(pParentItem);
					m_pTreeViewElements->ensureItemVisible(pParentItem);
				}
		}
}

/** Insert XML Attribute into element list */
void KXMLEditorView::xmlInsertAttribute()
{
	// get selected item from tree view
	QListViewItem *pSelectedItem = m_pTreeViewElements->selectedItem();
	if(!pSelectedItem)
		{ KMessageBox::sorry(this, i18n("Element not selected !"));
			return;
		}

	XmlElement* pSelectedXmlElement = static_cast <XmlElement *> (pSelectedItem);

	XmlAttributeDlg dlgXmlAttribute(this, 0, true);
	if(dlgXmlAttribute.exec() == XmlAttributeDlg::Accepted)
		{ // check existing attributes names to avoid duplicity
			bool bDuplicity = false;
			QList<XmlAttribute> *pListOfAttributes = pSelectedXmlElement->GetListOfAttributes();
			unsigned int i;
						
			for(i = 0; i < pListOfAttributes->count(); i++)
					{ if(pListOfAttributes->at(i)->name() == dlgXmlAttribute.m_strAttributeName)
							{ bDuplicity = true;
								break;
							}
					}
					
			if(bDuplicity)
				{ KMessageBox::sorry(this, i18n("Attribute name already exists !"));
					return;
				}

			// create attribute and insert it into element list
			pSelectedXmlElement->appendAttribute(new XmlAttribute(dlgXmlAttribute.m_strAttributeName,
                                       		 dlgXmlAttribute.m_strAttributeValue
                                      		));
			
			// refresh attribute list window
			slotElemViewSelChanged(pSelectedXmlElement);
			
			// update column with attributes list
      pSelectedXmlElement->updateStringAttrList();
			
			// mark document as modified
			getDocument()->setModified();
		}
}
/** Edit XML attribute properties */
void KXMLEditorView::xmlEditAttribute()
{
	// get selected item from tree view
	QListViewItem *pSelectedItem = m_pTreeViewElements->selectedItem();
	if(!pSelectedItem)
		{ KMessageBox::sorry(this, i18n("Tree item not selected !"));
			return;
		}
		
	if(m_pTableAttributes->numRows() == 0)
		{ KMessageBox::sorry(this, i18n("Attributes list is empty !"));
			return;
		}

	XmlElement* pSelectedXmlElement = static_cast<XmlElement *> (pSelectedItem);
	
	// get selected item from table view
	unsigned int currentRow = m_pTableAttributes->currentRow();
	
	// set values to dialog
	XmlAttributeDlg dlgXmlAttribute(this, 0, true);
	
	QList<XmlAttribute> *pListOfAttributes = pSelectedXmlElement->GetListOfAttributes();
	
	ASSERT(m_pTableAttributes->text(currentRow, 0) == pListOfAttributes->at(currentRow)->name());
	ASSERT(m_pTableAttributes->text(currentRow, 1) == pListOfAttributes->at(currentRow)->value());
	
	dlgXmlAttribute.m_pEditAttributeName->setText(pListOfAttributes->at(currentRow)->name());
	dlgXmlAttribute.m_pEditAttributeValue->setText(pListOfAttributes->at(currentRow)->value());
	
	// show dialog for edit XML attribute
	if(dlgXmlAttribute.exec() == XmlAttributeDlg::Accepted)
		{ // check existing attributes names to avoid duplicity
			bool bDuplicity = false;
			unsigned int i;

			for(i = 0; i < pListOfAttributes->count(); i++)
					{ if(i == currentRow)
							continue; // do not compare with yourself
					
					  if(pListOfAttributes->at(i)->name() == dlgXmlAttribute.m_strAttributeName)
							{ bDuplicity = true;
								break;
							}
					}
					
			if(bDuplicity)
				{ KMessageBox::sorry(this, i18n("Attribute name already exists !"));
					return;
				}

			pListOfAttributes->at(currentRow)->setName(dlgXmlAttribute.m_strAttributeName);
			pListOfAttributes->at(currentRow)->setValue(dlgXmlAttribute.m_strAttributeValue);
			
			// refresh attribute list window
			slotElemViewSelChanged(pSelectedXmlElement);
			
			// update column with attributes list
      pSelectedXmlElement->updateStringAttrList();
			
			// mark document as modified
			getDocument()->setModified();
		}
}
/** Delete XML attribute from element */
void KXMLEditorView::xmlDeleteAttribute()
{
	// get selected item from tree view
	QListViewItem *pSelectedItem = m_pTreeViewElements->selectedItem();
	if(!pSelectedItem)
		{ KMessageBox::sorry(this, i18n("Element not selected !"));
			return;
		}
		
	if(m_pTableAttributes->numRows() == 0)
		{ KMessageBox::sorry(this, i18n("Attributes list is empty !"));
			return;
		}

	XmlElement* pSelectedXmlElement = static_cast<XmlElement *> (pSelectedItem);
	
	// get selected item from list view
	unsigned int currentRow = m_pTableAttributes->currentRow();
		
	// remove XML attribute from list and delete it
	pSelectedXmlElement->removeAttribute(currentRow);
	
	// refresh attribute list window
	slotElemViewSelChanged(pSelectedXmlElement);
	
	// update column with attributes list
  pSelectedXmlElement->updateStringAttrList();
	
	// mark document as modified
	getDocument()->setModified();
}

/** Insert XML element contents */
void KXMLEditorView::xmlInsertContents()
{
	// get selected item from tree view
	QListViewItem *pSelectedItem = m_pTreeViewElements->selectedItem();
	if(!pSelectedItem)
		{ KMessageBox::sorry(this, i18n("Element not selected !"));
			return;
		}
		
	XmlElement* pSelectedXmlElement = static_cast<XmlElement *> (pSelectedItem);
	
	// set XML contents to dialog	
	XmlContentsDlg dlgXmlContents(this, 0, true, false);	
	if(dlgXmlContents.exec() == XmlContentsDlg::Accepted)
		{ // create contents and insert it into element list
			XmlContentsItem *pXmlContentsItem = new XmlContentsItem(pSelectedXmlElement,
																																		 dlgXmlContents.m_strElementContents,
																																		 (XmlContentsItem::enItemType) (dlgXmlContents.m_iContentsType + 1)
													  																				);
													
		  if(dlgXmlContents.m_iWhereToInsert == 1) // move new item at bottom of list ?
		  	{ // get last child element
					QListViewItem *pChild = pSelectedXmlElement->firstChild();
					QListViewItem *pLastChild = 0;
					while(pChild)
  					{ pLastChild = pChild;
  	  				pChild = pChild->nextSibling();
  					}
  					
  					// sort properly new element after last child
					if(pLastChild)
						pXmlContentsItem->moveItem(pLastChild);
		  	}

			// mark document as modified
			getDocument()->setModified();
			
			// make new item visible and selected
			m_pTreeViewElements->setCurrentItem(pXmlContentsItem);
			m_pTreeViewElements->ensureItemVisible(pXmlContentsItem);
		}
}

/** Edit XML element contents */
void KXMLEditorView::xmlEditContents()
{
	// get selected item from tree view
	QListViewItem *pSelectedItem = m_pTreeViewElements->selectedItem();
	if(!pSelectedItem)
		{ KMessageBox::sorry(this, i18n("Contents not selected !"));
			return;
		}
		
		
	XmlContentsItem* pXmlContentsItem = static_cast<XmlContentsItem *> (pSelectedItem);
	
	// set XML contents to dialog	
	XmlContentsDlg dlgXmlContents(this, 0, true);
	
	dlgXmlContents.m_pMultiLineEditElementContents->setText(pXmlContentsItem->contents());
	dlgXmlContents.m_pComboBoxContentsType->setCurrentItem(pXmlContentsItem->itemType() - 1);
		
	// show dialog for editing XML contents
	if(dlgXmlContents.exec() == XmlContentsDlg::Accepted)
		{ // store changed values to list of XML contents
		  pXmlContentsItem->setContents(dlgXmlContents.m_strElementContents);
		  XmlTreeItem::enItemType eItemType = (XmlTreeItem::enItemType) (dlgXmlContents.m_iContentsType + 1);
			pXmlContentsItem->setItemType(eItemType);
			
			// mark document as modified
			getDocument()->setModified();
		}
}

/** Delete XML element contents */
void KXMLEditorView::xmlDeleteContents()
{
	// get selected item from tree view
	QListViewItem *pSelectedItem = m_pTreeViewElements->selectedItem();
	if(!pSelectedItem)
		{ KMessageBox::sorry(0, i18n("Element not selected !"));
			return;
		}

	if(KMessageBox::questionYesNo(this, i18n("Really delete item ?")) == KMessageBox::Yes)
		{ // before delete get your parent item
			QListViewItem* pParentItem = pSelectedItem->parent();
		
		  delete pSelectedItem;
		
			m_pLineEditContents->clear();
			
			// mark document as modified
			getDocument()->setModified();
			
			// make new item visible and selected
			if(pParentItem)
				{	m_pTreeViewElements->setCurrentItem(pParentItem);
					m_pTreeViewElements->ensureItemVisible(pParentItem);
				}
		}
}

/** Insert new Processing Instruction into document */
void KXMLEditorView::xmlInsertProcInstruction()
{
	bool bRootElement = false;

	// get selected item from tree view
	QListViewItem *pSelectedItem = m_pTreeViewElements->selectedItem();
	
	if(!pSelectedItem)
		{ bRootElement = true;
		}
	else
		{ XmlTreeItem* pSelectedTreeItem = static_cast <XmlElement *> (pSelectedItem);
			if(pSelectedTreeItem->itemType() != XmlTreeItem::itemElement)
				bRootElement = true;
		}	

	// display dialog for edit XML Processing Instruction properties
	XmlProcInstrDlg dlgXmlProcInstr(this, 0, true, false);
	if(bRootElement)
		{ dlgXmlProcInstr.m_pComboBoxWhereToInsert->setCurrentItem(2); // as root
			dlgXmlProcInstr.m_pComboBoxWhereToInsert->setEnabled(false);
		}
		
	if(dlgXmlProcInstr.exec() == XmlProcInstrDlg::Accepted)
		{ if(dlgXmlProcInstr.m_iWhereToInsert == 2)
				bRootElement = true;
			else
				bRootElement = false;
				
			// create new XML proc. instr.
			XmlProcessingInstruction* pXmlProcessingInstruction;
			
			if(!bRootElement)
    			{ pXmlProcessingInstruction = new XmlProcessingInstruction(pSelectedItem, dlgXmlProcInstr.m_strProcInstrTarget, dlgXmlProcInstr.m_strProcInstrData);
    			
    			  if(dlgXmlProcInstr.m_iWhereToInsert == 1) // move new item at bottom of list ?
		  				{ XmlElement* pSelectedXmlElement = static_cast<XmlElement *> (pSelectedItem);
		  				
		  					// get last child element
								QListViewItem *pChild = pSelectedXmlElement->firstChild();
								QListViewItem *pLastChild = 0;
								while(pChild)
  								{ pLastChild = pChild;
  	  							pChild = pChild->nextSibling();
  								}
  					
  								// sort properly new element after last child
								if(pLastChild)
									pXmlProcessingInstruction->moveItem(pLastChild);
		  				}
    			}
  		else
    			pXmlProcessingInstruction = new XmlProcessingInstruction(m_pTreeViewElements, dlgXmlProcInstr.m_strProcInstrTarget, dlgXmlProcInstr.m_strProcInstrData); // root proc. instr.
    			
    	// mark document as modified
			getDocument()->setModified();
			
			// make new item visible and selected
			m_pTreeViewElements->setCurrentItem(pXmlProcessingInstruction);
			m_pTreeViewElements->ensureItemVisible(pXmlProcessingInstruction);
		}
}

/** Edit XML Processing instruction */
void KXMLEditorView::xmlEditProcInstruction()
{
	// get selected item from tree view
	QListViewItem *pSelectedItem = m_pTreeViewElements->selectedItem();
	if(!pSelectedItem)
		{ KMessageBox::sorry(this, i18n("Item not selected !"));
			return;
		}
		
		
	XmlProcessingInstruction* pXmlProcessingInstruction = static_cast<XmlProcessingInstruction *> (pSelectedItem);
	
	// set XML contents to dialog	
	XmlProcInstrDlg dlgXmlProcInstr(this, 0, true, true);
	
	dlgXmlProcInstr.m_pEditProcInstrTarget->setText(pXmlProcessingInstruction->target());
	dlgXmlProcInstr.m_pEditProcInstrData->setText(pXmlProcessingInstruction->data());
		
	// show dialog for editing XML Processing Instruction
	if(dlgXmlProcInstr.exec() == XmlProcInstrDlg::Accepted)
		{ // store changed values to XML Processing Instruction
		  pXmlProcessingInstruction->setTargetData(dlgXmlProcInstr.m_strProcInstrTarget, dlgXmlProcInstr.m_strProcInstrData);
		
			// if proc. instruction contain info about document encoding, read it
			if(dlgXmlProcInstr.m_strProcInstrTarget == "xml")
				{ int iPos = dlgXmlProcInstr.m_strProcInstrData.find("encoding");
					if(iPos >= 0)
						{ QString strEncoding;
				
							int iPosStart = dlgXmlProcInstr.m_strProcInstrData.find("'", iPos + 9);
							if(iPos >= 0)
								{ int iPosEnd = dlgXmlProcInstr.m_strProcInstrData.find("'", iPosStart + 1);
									if(iPosEnd >= 0)
										{ strEncoding = dlgXmlProcInstr.m_strProcInstrData.mid(iPosStart, iPosEnd - iPosStart);
								  		getDocument()->setEncoding(strEncoding);
										}
								}
				
					}
			}
		
			// mark document as modified
			getDocument()->setModified();
		}
}

/** Delete Processing Instruction */
void KXMLEditorView::xmlDeleteProcInstruction()
{
		// get selected item from tree view
	QListViewItem *pSelectedItem = m_pTreeViewElements->selectedItem();
	if(!pSelectedItem)
		{ KMessageBox::sorry(0, i18n("Element not selected !"));
			return;
		}

	if(KMessageBox::questionYesNo(this, i18n("Really delete processing instruction ?")) == KMessageBox::Yes)
		{ // before delete get your parent item
			QListViewItem* pParentItem = pSelectedItem->parent();
		  				
			delete pSelectedItem;
		
			// mark document as modified
			getDocument()->setModified();
			
			// make new item visible and selected
			if(pParentItem)
				{	m_pTreeViewElements->setCurrentItem(pParentItem);
					m_pTreeViewElements->ensureItemVisible(pParentItem);
				}
		}
}

/** Move item in tree Up */
void KXMLEditorView::xmlMoveItemUp()
{
	// get selected item from tree view
	QListViewItem *pSelectedItem = m_pTreeViewElements->selectedItem();
	if(!pSelectedItem)
		{ KMessageBox::sorry(this, i18n("Item not selected !"));
			return;
		}

	// get parent tree item
	QListViewItem *pParentItem = pSelectedItem->parent();
	
	// traverse list
 	QListViewItem *pChild = 0;
 	
 	if(pParentItem)
 		pChild = pParentItem->firstChild();
 	else
		pChild = m_pTreeViewElements->firstChild();
		
	QListViewItem *pPreviousChild = 0;
	while(pChild)
 		{ if((pChild == pSelectedItem) && pPreviousChild)
 		  	{ pPreviousChild->moveItem(pChild);
 		  	 		  	
 		  	  // mark document as modified
					getDocument()->setModified();
					emit sigSelectedElementChanged(static_cast <XmlTreeItem*> (pSelectedItem));
 		  	
 		  		return;
 		  	}
 		  pPreviousChild = 	pChild;
 			pChild = pChild->nextSibling();
 		}
}

/** Move item in tree Down */
void KXMLEditorView::xmlMoveItemDown()
{
	// get selected item from tree view
	QListViewItem *pSelectedItem = m_pTreeViewElements->selectedItem();
	if(!pSelectedItem)
		{ KMessageBox::sorry(this, i18n("Item not selected !"));
			return;
		}
		
	QListViewItem *pNextSibling = pSelectedItem->nextSibling();
	if(pNextSibling)
		{ pSelectedItem->moveItem(pNextSibling);
					
		  // mark document as modified
			getDocument()->setModified();
			emit sigSelectedElementChanged(static_cast <XmlTreeItem*> (pSelectedItem));
		}
}

/** Cut selected item to clipboard */
void KXMLEditorView::editCut()
{
	QListViewItem *pSelectedItem = m_pTreeViewElements->selectedItem();
	if(!pSelectedItem)
		{ KMessageBox::sorry(this, i18n("Element not selected !"));
			return;
		}
		
	editCopy();
	
	delete pSelectedItem;
	
	// mark document as modified
	getDocument()->setModified();
}

/** Copy selected item to clipboard */
void KXMLEditorView::editCopy()
{
	QListViewItem *pSelectedItem = m_pTreeViewElements->selectedItem();
	if(!pSelectedItem)
		{ KMessageBox::sorry(this, i18n("Element not selected !"));
			return;
		}

	XmlTreeItem* pSelectedTreeItem = static_cast <XmlTreeItem *> (pSelectedItem);
	QTextDrag *pDrag = m_pTreeViewElements->copyItem(pSelectedTreeItem);
	
	QApplication::clipboard()->setData(pDrag);
}

/** Paste item from clipboard */
void KXMLEditorView::editPaste()
{
	QListViewItem *pSelectedItem = m_pTreeViewElements->selectedItem();
	XmlTreeItem* pSelectedTreeItem = 0;
  if(pSelectedItem)
  	pSelectedTreeItem = static_cast <XmlTreeItem *> (pSelectedItem);
  			
	m_pTreeViewElements->pasteItem(pSelectedTreeItem, QApplication::clipboard()->data());
	
	emit sigSelectedElementChanged(static_cast <XmlTreeItem*> (pSelectedItem));
}

/** Move tree selection to parent item */
void KXMLEditorView::goUp()
{
	// get selected item from tree view
	QListViewItem *pSelectedItem = m_pTreeViewElements->selectedItem();
	if(!pSelectedItem)
		{ KMessageBox::sorry(this, i18n("Tree item not selected !"));
			return;
		}
		
	// get parent item
	QListViewItem *pParentItem = pSelectedItem->parent();
	
	// select parent item in tree view
	if(pParentItem)
		{ m_pTreeViewElements->setCurrentItem(pParentItem);
			m_pTreeViewElements->ensureItemVisible(pParentItem);
		}
}

/** Enable/disable bookmark in selected tree item */
void KXMLEditorView::toggleBookmark()
{
	// get selected item from tree view
	QListViewItem *pSelectedItem = m_pTreeViewElements->selectedItem();
	if(!pSelectedItem)
		{ KMessageBox::sorry(this, i18n("Tree item not selected !"));
			return;
		}
		
	// toggle bookmark on selected item
	XmlTreeItem* pSelectedTreeItem = static_cast<XmlTreeItem *> (pSelectedItem);
	pSelectedTreeItem->toggleBookmark();
}

/** Move selection to previous bookmark */
void KXMLEditorView::bookmarkPrev()
{
	// get selected item from tree view
	QListViewItem *pSelectedItem = m_pTreeViewElements->selectedItem();
	if(!pSelectedItem)
		{ KMessageBox::sorry(this, i18n("Tree item not selected !"));
			return;
		}
	
	// Search above item with bookmark
	QListViewItem *pAboveItem;
	while((pAboveItem = pSelectedItem->itemAbove()) != 0)
		{ XmlTreeItem* pAboveTreeItem = static_cast <XmlTreeItem *> (pAboveItem);
		  if(pAboveTreeItem->hasBookmark())
				{ m_pTreeViewElements->setCurrentItem(pAboveItem);
					m_pTreeViewElements->ensureItemVisible(pAboveItem);
					return;
				}
		  pSelectedItem = pAboveItem;
		}
	KMessageBox::sorry(this, i18n("Item not found !"));
}

/** Move selection to next bookmark */
void KXMLEditorView::bookmarkNext()
{
	// get selected item from tree view
	QListViewItem *pSelectedItem = m_pTreeViewElements->selectedItem();
	if(!pSelectedItem)
		{ KMessageBox::sorry(this, i18n("Tree item not selected !"));
			return;
		}
		
	// Search below item with bookmark
	QListViewItem *pBelowItem;
	while((pBelowItem = pSelectedItem->itemBelow()) != 0)
		{ XmlTreeItem* pBelowTreeItem = static_cast <XmlTreeItem *> (pBelowItem);
		  if(pBelowTreeItem->hasBookmark())
				{ m_pTreeViewElements->setCurrentItem(pBelowItem);
					m_pTreeViewElements->ensureItemVisible(pBelowItem);
					return;
				}
		  pSelectedItem = pBelowTreeItem;
		}
	KMessageBox::sorry(this, i18n("Item not found !"));
}

/** Expand selected node and entire child subtree  */
void KXMLEditorView::expandNode(int iLevel)
{
	// get selected item from tree view
	QListViewItem *pSelectedItem = m_pTreeViewElements->selectedItem();
	if(!pSelectedItem)
		{ KMessageBox::sorry(this, i18n("Tree item not selected !"));
			return;
		}
		
	// expand node
	XmlTreeItem* pSelectedTreeItem = static_cast <XmlTreeItem *> (pSelectedItem);
	pSelectedTreeItem->expandNode(iLevel);
}

/** Collapse selected item subtree */
void KXMLEditorView::collapseNode(int iLevel)
{
	// get selected item from tree view
	QListViewItem *pSelectedItem = m_pTreeViewElements->selectedItem();
	if(!pSelectedItem)
		{ KMessageBox::sorry(this, i18n("Tree item not selected !"));
			return;
		}
	
	// collapse node
	XmlTreeItem* pSelectedTreeItem = static_cast <XmlTreeItem *> (pSelectedItem);
	pSelectedTreeItem->collapseNode(iLevel);
}

/** Find item with strPath and select it. */
bool KXMLEditorView::changePath(const QString &strPath)
{
	XmlElement* pRootXmlElement = m_pTreeViewElements->rootXmlElement();
	if(!pRootXmlElement)
		return false;
	
	XmlTreeItem *pFoundItem = pRootXmlElement->searchPath(strPath);
	if(pFoundItem)
		{ // make new item visible and selected
			m_pTreeViewElements->setCurrentItem(pFoundItem);
			m_pTreeViewElements->ensureItemVisible(pFoundItem);
			return true;
		}
	return false;
}

/** Unselect the currently selected element. */
void KXMLEditorView::slotUnselect()
{
	m_pTreeViewElements->selectAll(false);
	m_pTableAttributes->setEnabled(false);
	m_pTableAttributes->setNumRows(0);
	m_pLineEditContents->setEnabled(false);
	m_pLineEditContents->clear();
}

/** Called, when tree is changed using drag & drop or inplace editing */
void KXMLEditorView::slotElemViewContentsChanged()
{
	// mark document as modified
	getDocument()->setModified();
}

/** Update column with attributes list for each XML element */
void KXMLEditorView::updateStringAttrLists()
{
	QListViewItem* pChildItem = m_pTreeViewElements->firstChild();
	if(!pChildItem)
		return;
	
	do
		{ XmlTreeItem* pTreeItem = static_cast <XmlTreeItem *> (pChildItem);
			
			if(pTreeItem->itemType() == XmlTreeItem::itemElement)
				{ XmlElement* pXmlElement = static_cast <XmlElement *> (pTreeItem);				
				  pXmlElement->updateStringAttrList();
				}
		} while((pChildItem = pChildItem->nextSibling()) != 0);
}
