/***************************************************************************
                          kxmleditorcombo.cpp  -  description
                             -------------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001 by Lumir Vanek
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kxmleditorcombo.h"

KXmlEditorCombo::KXmlEditorCombo(QWidget *parent, const char *name )
	: KHistoryCombo(parent, name),
	m_permanent(false)
{
	setInsertionPolicy(NoInsertion);
  setSizePolicy(QSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed));
  setDuplicatesEnabled(false);

  //connect( this, SIGNAL(returnPressed()), SLOT(slotReturnPressed()));
}

KXmlEditorCombo::~KXmlEditorCombo()
{
}

void KXmlEditorCombo::setPath(const QString& strPath, const QPixmap& pix)
{
  if(count() == 0) // insert a temporary item when we don't have one yet
		insertItem(pix, strPath, temporary);
  else
  	{ if(strPath != temporaryItem())
	    	applyPermanent();
			
			updateItem(pix, strPath, temporary);
    }

	setCurrentItem(temporary);
}

void KXmlEditorCombo::setTemporary(const QString& strPath, const QPixmap& pix)
{
  if(count() == 0) // insert a temporary item when we don't have one yet
		insertItem(pix, strPath, temporary);
  else
		{ updateItem(pix, strPath, temporary);
		}

	setCurrentItem(temporary);
}

void KXmlEditorCombo::clearTemporary(bool makeCurrent)
{
	applyPermanent();
  changeItem(QString::null, temporary); // ### default pixmap?
  if(makeCurrent)
		setCurrentItem(temporary);
}

// Insert permanet item into combo
void KXmlEditorCombo::insertPermanent(const QString& strPath, const QPixmap& pix)
{
  // kdDebug << "### insertPermanent!" << endl;

  //saveState();
  setTemporary(strPath, pix);
  m_permanent = true;
  //restoreState();
}

// Remove permanet item from combo
void KXmlEditorCombo::removePermanent(const QString& strPath)
{
	int i;
	
	for(i = 2; i < count(); i++) // 1 is temporary, 2 is first permanent
		{ if(text(i) ==  strPath)
				{	removeItem(i--);
				}
		}
}

// called right before a new (different!) temporary item will be set. So we
// insert an item that was marked permanent properly at position 1.
void KXmlEditorCombo::applyPermanent()
{
  if(m_permanent && !temporaryItem().isEmpty() )
  	{ // remove as many items as needed to honour maxCount()
			int i = count();
			while(count() >= maxCount())
	    	removeItem(--i);
	    	
	    QString strPath = temporaryItem();
			m_currentIndex = currentItem();
    	QPixmap pixTemporary = *pixmap(temporary);
			insertItem(pixTemporary, strPath,  1);

			// remove all dupes, if available
			for(i = 2; i < count(); i++ )
				{ if(text(i) == strPath )
						removeItem(i--);
				}

			m_permanent = false;
    }
}

// ### use QComboBox::changeItem(), once that finally works
void KXmlEditorCombo::updateItem(const QPixmap& pix, const QString& t, int index)
{
 	// QComboBox::changeItem() doesn't honour the pixmap when
 	// using an editable combobox, so we just remove and insert

  // no need to flicker
  if(text(index) == t && (pixmap(index) && pixmap(index)->serialNumber() == pix.serialNumber()))
		return;

  setUpdatesEnabled(false);
  lineEdit()->setUpdatesEnabled(false);

  removeItem(index);
  insertItem(pix, t, index);

  setUpdatesEnabled(true);
  lineEdit()->setUpdatesEnabled(true);
  repaint();
}

void KXmlEditorCombo::saveState()
{
    m_cursorPos = cursorPosition();
    m_currentText = currentText();
    m_currentIndex = currentItem();
    m_currentPixmap = *pixmap(m_currentIndex);
}

void KXmlEditorCombo::restoreState()
{
    setTemporary(m_currentText, m_currentPixmap);
    lineEdit()->setCursorPosition(m_cursorPos);
}

