#include "kxstartupwizardimpl.h"
#include <qpushbutton.h>
#include <knuminput.h>
#include <qlineedit.h>
#include <kconfig.h>
#include <kglobal.h>

kxStartupWizardImpl::kxStartupWizardImpl( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : kxStartupWizard( parent, name, modal, fl )
{
  passwordOk=FALSE;
  UINOk=FALSE;
  helpButton()->hide();
  QObject::connect(finishButton(), SIGNAL(clicked()), this, SLOT(SlotFinish()));
  QObject::connect(passwordInput, SIGNAL(textChanged(const QString &)), this, SLOT(SlotTextChanged(const QString &)));  
  QObject::connect(passwordAgainInput, SIGNAL(textChanged(const QString &)), this, SLOT(SlotTextChanged(const QString &)));  
}

kxStartupWizardImpl::~kxStartupWizardImpl()
{
    // no need to delete child widgets, Qt does it all for us
}


void kxStartupWizardImpl::SlotTextChanged(const QString &)
{
  passwordOk=FALSE;
  if (passwordInput->text().length()>0 && passwordAgainInput->text().length()>0)
        if (passwordInput->text() == passwordAgainInput->text() ) passwordOk=TRUE;
  
  if (uinInput->text().toUInt()>0) UINOk=TRUE;
  else UINOk=FALSE;
  
  if (UINOk && passwordOk) finishButton()->setEnabled(TRUE);
  else finishButton()->setEnabled(FALSE);

}
void kxStartupWizardImpl::SlotValueChanged(int _uin)
{
  uin=_uin;
  if (_uin>0) UINOk=TRUE;
  else UINOk=FALSE;
  if (UINOk && passwordOk) finishButton()->setEnabled(TRUE);
  else finishButton()->setEnabled(FALSE);
}
void kxStartupWizardImpl::SlotFinish()
{
  KConfig *config=KGlobal::config();
  config->reparseConfiguration();
  config->setGroup("Personal Settings");

  config->writeEntry("Password",passwordInput->text());
  config->writeEntry("UIN",uinInput->text().toUInt());
  config->writeEntry("Nick",nickInput->text());  
  config->writeEntry("First Name",firstNameInput->text());
  config->writeEntry("Last Name",lastNameInput->text());  
  config->writeEntry("Email",emailInput->text());
  
  config->sync();
}
  