#include <kxinfodialogimpl.h>
#include <kwin.h>
#include <qtextbrowser.h>
#include "kxsendmessagesimpl.h"
#include "kxcontact.h"
#include "kxengine.h"
#include <qlabel.h>
#include <qobject.h>
#include <qmultilineedit.h>
#include <kxudp.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qdialog.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <kaccel.h>
#include <klocale.h>
#include <kxmainwindow.h>
#include <kxmessage.h>
#include <v2_codes.h>
/* 
 *  Constructs a kxSendMessagesImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
kxSendMessagesImpl::kxSendMessagesImpl( UIN _uin, bool _first,QWidget* parent,  const char* name, bool modal, WFlags fl )
    : kxSendMessages( parent, name, modal, fl )
{
  uin=_uin;
  showFirst=_first;
  init();
}
kxSendMessagesImpl::kxSendMessagesImpl( UIN _uin, QWidget* parent,  const char* name, bool modal, WFlags fl )
    : kxSendMessages( parent, name, modal, fl )
{
  uin=_uin;
  showFirst=FALSE;
  init();
}
void kxSendMessagesImpl::init()
{
  alert=FALSE;
  showAlert=FALSE;
  QObject::connect(&alertTimer, SIGNAL(timeout()), this, SLOT(SlotAlertTimeout()));
  ENGINE->CONTACT->setSendWidget(uin,this);
  historyView=NULL;

  QStringList list;
  QString tmp;
  for (int t=1; t<=50; t++)
  {
    tmp.sprintf("kde/%04d",t);
    list.append(tmp);
  }

  sendAnim=new KAnimWidget(list, 22, animLabel, "anim");
  sendAnim->resize(25,25);

  doSend=FALSE;
  sendSeq=0;
  send=NULL;
  clean=TRUE;
  QString tmpStr;
  tmpStr.sprintf("%d",uin);  
  uinLabel->setText(tmpStr.latin1());
  nickLabel->setText(ENGINE->CONTACT->getContact(uin).nick); 
  nick=ENGINE->CONTACT->getContact(uin).nick;
  makeCaption(ENGINE->CONTACT->getContact(uin).status);  

  QObject::connect(infoButton, SIGNAL(clicked()), this, SLOT(SlotInfoButton()));  
  QObject::connect(stayOnTop, SIGNAL(toggled(bool)), this, SLOT(SlotStayOnTop(bool)));  
  QObject::connect((QObject *)cancelButton, SIGNAL(clicked()), this, SLOT(SlotCancelButton()));
  QObject::connect((QObject *)sendButton, SIGNAL(clicked()), this, SLOT(SlotSendButton()));
  QObject::connect(messageInput,SIGNAL(textChanged()), this, SLOT(SlotTextChanged()));
  QObject::connect(ENGINE, SIGNAL(SignalContactStatusChange(UIN , Q_UINT16, Q_UINT16 )), this,SLOT(SlotContactStatusChange(UIN , Q_UINT16, Q_UINT16 )));
                                                                                                     
  QObject::connect(MAINWINDOW, SIGNAL(SignalNewMessage(UIN, kxMessageStruct)), this, SLOT(SlotNewMessage(UIN, kxMessageStruct)));
  QObject::connect(ENGINE->MESSAGE, SIGNAL(SignalMessagePosSend(UIN, int)), this, SLOT(SlotMessagePos(UIN, int)));
  QObject::connect((QObject *)historyButton, SIGNAL(clicked()), this, SLOT(SlotHistoryButton()));  
  
  throughServer->setChecked(ENGINE->CONTACT->getContact(uin).alwaysServer);  
                   
  KAccel *a = new KAccel(this);
  a->insertItem(i18n("Send"), "Send",Key_S + ALT);
  a->connectItem("Send",this,SLOT(SlotSendButton()));
  a->insertItem(i18n("Send2"), "Send2",Key_Enter + CTRL);
  a->connectItem("Send2",this,SLOT(SlotSendButton()));
  a->insertItem(i18n("Send3"), "Send3",Key_Return + CTRL);
  a->connectItem("Send3",this,SLOT(SlotSendButton()));
 
  if (showFirst)
  {
    int pos=0;
    
    pos=ENGINE->MESSAGE->giveFirstUnreadMessage(uin);
    while(pos>0)
    {
      kxMessageStruct message;
      message=ENGINE->MESSAGE->getMessage(pos);
      SlotNewMessage(uin,message);
      ENGINE->MESSAGE->setRead(pos,TRUE);
      pos=ENGINE->MESSAGE->giveFirstUnreadMessage(uin);
    }
  }
  
  sendButton->setEnabled(FALSE);   
  messageInput->setFocus();
}

void kxSendMessagesImpl::hide()
{
  debug("Close/Hide !!");
  QDialog::hide();
  ENGINE->CONTACT->setSendWidget(uin);
  if (send) delete send;
  delete this;
}  

void kxSendMessagesImpl::SlotCancelButton()
{
  if (doSend)
  {
    sendAnim->stop();
    doSend=FALSE;
    sendButton->setEnabled(TRUE);
    messageInput->setEnabled(TRUE);  
    messageInput->setFocus();  
    if (send) { delete send; send=NULL; }
  }
  else
    close();
}
void kxSendMessagesImpl::SlotSendButton()
{
  if (messageInput->text().length()>0)
  {
    QString sendMsg=messageInput->text();
    sendMsg.replace(QRegExp("\n"),"\r\n");

    send=ENGINE->sendMessage(uin,sendMsg ,throughServer->isChecked());  
    doSend=TRUE;
    sendSeq=send->sendSeq;
    sendButton->setEnabled(FALSE);
    messageInput->setEnabled(FALSE);
    sendAnim->start();
    
    QObject::connect(send, SIGNAL(SignalSendToClientOk(int)), this, SLOT(SlotSendToClientOk(int)));
    QObject::connect(send, SIGNAL(SignalSendToClientError(int)), this, SLOT(SlotSendToClientError(int)));  
    QObject::connect(send, SIGNAL(SignalSendToServerOk(int)), this, SLOT(SlotSendToServerOk(int)));
    QObject::connect(send, SIGNAL(SignalSendToServerError(int)), this, SLOT(SlotSendToServerError(int)));  

    QString _tmp;
    messageToSend=messageInput->text();
    messageToSend.replace(QRegExp("\n"),"<br>");
    messageToSend.replace(QRegExp("\r"),"");    
    
  }
}
void kxSendMessagesImpl::SlotNewMessage(UIN _uin, kxMessageStruct _message)
{
  if (uin==_uin)
  {
    QString _tmp;
    _message.message.replace(QRegExp("\n"),"<br>");
    _message.message.replace(QRegExp("\r"),"");    
  
    _tmp=QString(ENGINE->CONTACT->getContact(_uin).nick)+": "+_message.message;
    //messageInput->clear();
    if (clean) 
      textOutput->setText(_tmp);
    else
      textOutput->append(_tmp);
    clean=FALSE;
    if (autoRaise->isChecked())
    {
      QDialog::raise();
      show();
      setFocus();
    }    
    if (!hasFocus())
    {
      alert=TRUE;
      showAlert=TRUE;
      alertTimer.start(1000);
    }    
    // scroll to the new text
    textOutput->ensureVisible(0, textOutput->contentsHeight());
    // This should not be a hard coded value like this!!!
    textOutput->repaintContents(0,0, 10000, 20000, true);
  }
}
void kxSendMessagesImpl::SlotMessagePos(UIN _uin,int _pos)
{
  if (uin==_uin)
    ENGINE->MESSAGE->setRead(_pos,TRUE);
}
void kxSendMessagesImpl::SlotTextChanged()
{
  stopAlert();
  if (messageInput->text().length()>0)
    sendButton->setEnabled(TRUE);
  else
    sendButton->setEnabled(FALSE);
}
void kxSendMessagesImpl::SlotSendToClientError(int _s)
{
  throughServer->setChecked(TRUE);  
  ENGINE->CONTACT->setAlwaysServer(uin,TRUE,FALSE);
  send->sendToServer();
}
void kxSendMessagesImpl::SlotSendToClientOk(int _s)
{
  if (_s==sendSeq)
  {
    QString _tmp;
    _tmp="<I>"+MAINWINDOW->kxConfig.nick+": "+messageToSend+"</I>";
    messageInput->clear();
    if (clean) 
      textOutput->setText(_tmp);
    else
      textOutput->append(_tmp);
    clean=FALSE;
  
    sendAnim->stop();
    doSend=FALSE;
    sendButton->setEnabled(FALSE);
    messageInput->setEnabled(TRUE);
    messageInput->setFocus();
      
    // scroll to the new text
    textOutput->ensureVisible(0, textOutput->contentsHeight());
    // This should not be a hard coded value like this!!!
    textOutput->repaintContents(0,0, 10000, 20000, true);

    if (send) { delete send; send=NULL; }
  }
}
void kxSendMessagesImpl::SlotSendToServerError(int _s)
{
  if (send) { delete send; send=NULL; }
}
void kxSendMessagesImpl::SlotSendToServerOk(int _s)
{
  if (_s==sendSeq)
  {
    QString _tmp;
    _tmp="<I>"+MAINWINDOW->kxConfig.nick+": "+messageToSend+"</I>";
    messageInput->clear();
    if (clean) 
      textOutput->setText(_tmp);
    else
      textOutput->append(_tmp);
    clean=FALSE;

    sendAnim->stop();
    doSend=FALSE;
    sendButton->setEnabled(FALSE);
    messageInput->setEnabled(TRUE);    
    messageInput->setFocus();
    // scroll to the new text
    textOutput->ensureVisible(0, textOutput->contentsHeight());
    // This should not be a hard coded value like this!!!
    textOutput->repaintContents(0,0, 10000, 20000, true);

    if (send) { delete send; send=NULL; }
  }
}
void kxSendMessagesImpl::makeCaption(int _st)
{
  if (showAlert)
    setCaption("   "+nick+"  "+ENGINE->CONTACT->status2str(_st)+"   ");
  else
    setCaption("[[ "+nick+" ("+ENGINE->CONTACT->status2str(_st)+")]]");
}
void kxSendMessagesImpl::SlotContactStatusChange(UIN _u, Q_UINT16 _s, Q_UINT16 )
{
  if (_u==uin)
  {
    makeCaption(_s);
  }
}
void kxSendMessagesImpl::SlotHistoryButton()
{
  if (historyView!=NULL)
  {
    delete vbox_2;
    delete historyView;
    historyWidget->setMinimumSize(0,0);
    //vbox->activate();
    resize(width(),height()-100);    
    updateGeometry();    
    historyView=NULL;
    historyButton->setDown(FALSE);    
  }
  else
  {
    debug("show hist! ");
    vbox_2 = new QVBoxLayout( historyWidget );
    vbox_2->setSpacing( 0 );
    vbox_2->setMargin( 0 );   
    historyView = new kxHistoryWidget(uin, historyWidget, "historyView" );
//    historyView->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)4, historyView->sizePolicy().hasHeightForWidth() ) );
    historyView->setFocusPolicy( QListView::NoFocus );
    historyView->show();    
    vbox_2->addWidget( historyView,1 );        
    vbox_2->activate();
    historyWidget->setMinimumSize(0,10);
    historyWidget->setMaximumHeight(100);    
    historyWidget->resize(10,100);    
    
    //vbox->activate();
    resize(width(),height()+100);
    updateGeometry();
    historyButton->setDown(TRUE);
  }
}
void kxSendMessagesImpl::SlotStayOnTop(bool)
{
  if (stayOnTop->isChecked())
  {
    KWin::setState(this->winId(),NET::StaysOnTop);
  }
  else
  {
    KWin::clearState(this->winId(),NET::StaysOnTop);    
  }
}
void kxSendMessagesImpl::SlotInfoButton()
{
  kxInfoDialogImpl *dialog=new kxInfoDialogImpl(uin,0L,"info");
  dialog->show();
}
void kxSendMessagesImpl::SlotAlertTimeout()
{
  showAlert=!showAlert;
  makeCaption(ENGINE->CONTACT->getContact(uin).status);  
  alertTimer.start(1000);
}
void kxSendMessagesImpl::enterEvent(QEvent *e)
{
  stopAlert();
  QWidget::enterEvent(e);
}
void kxSendMessagesImpl::focusInEvent(QFocusEvent *e)     
{
  stopAlert();
  QWidget::focusInEvent(e);
}
void kxSendMessagesImpl::mousePressEvent(QMouseEvent *e)
{
  stopAlert();
  QWidget::mousePressEvent(e);
}
void kxSendMessagesImpl::keyPressEvent(QKeyEvent *e)
{
  stopAlert();
  QWidget::keyPressEvent(e);
}
void kxSendMessagesImpl::stopAlert()
{
  if (alert)
  {
    alert=FALSE;
    showAlert=FALSE;
    alertTimer.stop();
    makeCaption(ENGINE->CONTACT->getContact(uin).status);  
  }
}
