
#include "kxinfodialogimpl.h"
#include "kxfiledialogimpl.h"
#include <kxtcp.h>
#include "kxmainwindow.h"
#include <qcheckbox.h>
#include "kxreceivedmessage.h"
#include "kxreceivedmessageimpl.h"
#include "kxSendMessageImpl.h"
#include <qpushbutton.h>
#include <qlabel.h>
#include <kxengine.h>
#include <kxmessage.h>
#include <klocale.h>
#include <qmultilineedit.h>
#include <kxcontact.h>
#include <qlayout.h>
#include <qbuttongroup.h>
#include <qstring.h>

                
kxReceivedMessageImpl::kxReceivedMessageImpl(UIN _uin,int _seq, QString _msg, QString _fn, int _size, QWidget* parent , const char* name  ) 
    : kxReceivedMessage( parent, name)
{
  debug("Show This Message");
  uin=_uin;
  seq=_seq;
  fileMessage=_msg;
  fileName=_fn;
  size=_size;
  type=FILE_TYPE;
  showPos=-1;
  init();
}

kxReceivedMessageImpl::kxReceivedMessageImpl( UIN _uin,QWidget* parent,  const char* name )
    : kxReceivedMessage( parent, name)
{
  debug("Show a New Message from a UIN");
  type=0;
  uin=_uin;
  showPos=-1;
  init();
}
kxReceivedMessageImpl::kxReceivedMessageImpl( bool, int _pos,QWidget* parent,  const char* name )
    : kxReceivedMessage( parent, name)
{
  debug("Show 1 message on _pos");
  type=0;
  showPos=_pos;
  uin=0;
  uin=ENGINE->MESSAGE->getMessage(_pos).uin;
  init();
}
kxReceivedMessageImpl::kxReceivedMessageImpl( QWidget* parent,  const char* name )
    : kxReceivedMessage( parent, name)
{
  debug("Show a New Message");
  uin=0;
  type=1;
  showPos=-1;
  init();  
}
  
void kxReceivedMessageImpl::init()
{
  oldUin=0;
  messageString=NULL;
  urlString=NULL; 
  urlLabel=NULL;
  urlLayout=NULL;
  boxLayout=NULL;
  historyView=NULL;

  prevFrame=0;
  QObject::connect(readNextButton, SIGNAL(clicked()), this, SLOT(SlotNextButton()));
  QObject::connect(closeButton, SIGNAL(clicked()), this, SLOT(SlotCancelButton()));
  QObject::connect(replyButton, SIGNAL(clicked()), this, SLOT(SlotReplyButton()));
  QObject::connect(forwardButton, SIGNAL(clicked()), this, SLOT(SlotForwardButton()));
  QObject::connect(addUserButton, SIGNAL(clicked()), this, SLOT(SlotAddButton()));
  QObject::connect(historyButton, SIGNAL(clicked()), this, SLOT(SlotHistoryButton()));
  QObject::connect(infoButton, SIGNAL(clicked()), this, SLOT(SlotInfoButton()));  
  QObject::connect(ENGINE->CONTACT, SIGNAL(recountMessages(UIN)), this, SLOT(SlotRecountMessages(UIN)));
  readNextButton->setEnabled(FALSE);
  showEvent();
}

kxReceivedMessageImpl::~kxReceivedMessageImpl()
{
}
void kxReceivedMessageImpl::showEvent()
{
  if (type==FILE_TYPE)
  {
    setupMessageFrame(type);    
//    historyView->setEnabled(FALSE);
    readNextButton->setEnabled(FALSE);
    historyButton->setEnabled(FALSE);
    addUserButton->setEnabled(FALSE);
    replyButton->setText(i18n("Accept"));
    forwardButton->setText(i18n("Reject"));
    messageString->setText(fileMessage);    
    urlString->setText(fileName+i18n(" Size: ")+QString().setNum(size));
    if (ENGINE->CONTACT->getContact(uin).uin>0)
    {
      addUserButton->setEnabled(FALSE);
      nickLabel->setText(ENGINE->CONTACT->getContact(uin).nick);
    }
    else
    {
      addUserButton->setEnabled(TRUE);
      if (nick.length()>0) nickLabel->setText(nick);
      else nickLabel->setText(i18n("<Unknown: ")+QString().setNum(uin)+">");
    }        
  }
  else
  {
    int pos=0;
    if (showPos>=0)
    {
      pos=showPos;
      showPos=0;
    }
    else
    {
      if (type==0) pos=ENGINE->MESSAGE->giveFirstUnread(uin);
      else pos=ENGINE->MESSAGE->giveFirstAllUnread();
    }
    debug("Pos = %d",pos);
    kxMessageStruct message;
    message=ENGINE->MESSAGE->getMessage(pos);
    setupMessageFrame(message.type);
    ruin=message.uin;
    msgType=message.type;
    if (message.type==MESSAGE_TYPE || message.type==URL_TYPE)
    {
      message.message.replace(QRegExp("\n"),"\n");
      message.message.replace(QRegExp("\r"),"");    
      messageString->setText(message.message);  
    }
    if (message.type==REQUEST_TYPE) 
    {
      message.message.replace(QRegExp("\\n"),"\n");
      message.message.replace(QRegExp("\\r"),"");
      messageString->setText(i18n("A Contact has asked for Authorization:\n\nNick: ")+message.nick+
                             i18n("\nName: ")+message.firstName+" "+message.lastName+"\n"+i18n("E-Mail: ")+
                             message.email+i18n("\n\nHe/She has the following request:\n")+message.message     
       );
    }
    if (message.type==ADDED_TYPE)
      messageString->setText(message.nick+i18n(" has added you:\n\n")+
                             i18n("\nName: ")+message.firstName+" "+message.lastName+"\n"+i18n("E-Mail: ")+
                             message.email
       );
      
    if (message.type==URL_TYPE) 
      urlString->setText(message.url);
  
    nick=message.nick;
    needAuth=message.auth_request;  
      
    if (ENGINE->CONTACT->getContact(message.uin).uin>0)
    {
      addUserButton->setEnabled(FALSE);
      nickLabel->setText(ENGINE->CONTACT->getContact(message.uin).nick);
    }
    else
    {
      addUserButton->setEnabled(TRUE);
      if (nick.length()>0) nickLabel->setText(nick);
      else nickLabel->setText(i18n("<Unknown: ")+QString().setNum(message.uin)+">");
    }    
       
    QString dateTime;
    dateTime.sprintf("%02d-%02d-%04d %02d:%02d",message.dateTime.date().day()
                                               ,message.dateTime.date().month()
                                               ,message.dateTime.date().year()
                                               ,message.dateTime.time().hour()
                                               ,message.dateTime.time().minute() );
    dateLabel->setText(dateTime); 
    debug("Pos is here %d",pos);
    ENGINE->MESSAGE->setRead(pos,TRUE);
    if (historyView!=NULL)
    {
      if (oldUin!=0)
      {
        if (oldUin!=message.uin)
        {
          historyView->changeUin(message.uin);
        }
      }
    }
    oldUin=message.uin;
  }    
}     

void kxReceivedMessageImpl::setupMessageFrame(int _type)
{
  if (messageString!=NULL) { delete messageString;  messageString=NULL; }
  if (urlString!=NULL)     { delete urlString;      urlString=NULL;     }
  if (urlLabel!=NULL)      { delete urlLabel;       urlLabel=NULL;      }
  if (urlLayout!=NULL)     { delete urlLayout;      urlLayout=NULL;     }
  if (boxLayout!=NULL)     { delete boxLayout;      boxLayout=NULL;     }  
  
  messageGroup->setColumnLayout(0, Qt::Vertical );
  messageGroup->layout()->setSpacing( 0 );
  messageGroup->layout()->setMargin( 0 );    

  boxLayout = new QVBoxLayout( messageGroup->layout() );
  boxLayout->setAlignment( Qt::AlignTop );
  boxLayout->setSpacing( 3 );
  boxLayout->setMargin( 5 ); 

  insertCheck->setEnabled(TRUE);  
  replyButton->setText(i18n("Reply"));
  forwardButton->setText(i18n("Forward"));
  if (_type==REQUEST_TYPE) 
  {
    replyButton->setText(i18n("Authorize"));
    forwardButton->setText(i18n("Reject"));  
    insertCheck->setEnabled(FALSE);
  }
    
  if (_type==MESSAGE_TYPE || _type==REQUEST_TYPE || _type==ADDED_TYPE)
  {   
    messageString = new QMultiLineEdit( (QWidget *)messageGroup, "messageString" );
    messageString->setReadOnly( TRUE );
    messageString->setFocusPolicy( QMultiLineEdit::NoFocus );
    messageString->setWordWrap( QMultiLineEdit::WidgetWidth );
    boxLayout->addWidget( messageString ); 
    prevFrame=_type;
    messageString->show();
    
  }
  if (_type==URL_TYPE)
  {
    urlLayout = new QHBoxLayout;
    urlLayout->setSpacing( 0 );
    urlLayout->setMargin( 0 );
 
    urlLabel = new QLabel( (QWidget *)messageGroup, "TextLabel1" );
    urlLabel->setText( i18n( "URL:"  ) );
    urlLayout->addWidget( (QWidget *) urlLabel );
 
    urlString = new QMultiLineEdit( (QWidget *)messageGroup, "MultiLineEdit3" );
    urlString->setMinimumSize( QSize( 0, 22 ) );
    urlString->setMaximumSize( QSize( 32767, 22 ) );
    urlLayout->addWidget( (QWidget *)urlString );
    boxLayout->addLayout( urlLayout );
 
    messageString = new QMultiLineEdit( (QWidget *)messageGroup, "MultiLineEdit2" );
    messageString->setReadOnly( TRUE );
    messageString->setFocusPolicy( QMultiLineEdit::NoFocus );
    messageString->setWordWrap( QMultiLineEdit::WidgetWidth );

    boxLayout->addWidget( (QWidget *)messageString );   
    messageString->show();
    urlLabel->show();
    urlString->show();
    urlLayout->activate();
    prevFrame=_type;
  }  
  if (_type==FILE_TYPE)
  {
    urlLayout = new QHBoxLayout;
    urlLayout->setSpacing( 0 );
    urlLayout->setMargin( 0 );
 
    urlLabel = new QLabel( (QWidget *)messageGroup, "TextLabel1" );
    urlLabel->setText( i18n( "File:"  ) );
    urlLayout->addWidget( (QWidget *) urlLabel );
 
    urlString = new QMultiLineEdit( (QWidget *)messageGroup, "MultiLineEdit3" );
    urlString->setMinimumSize( QSize( 0, 22 ) );
    urlString->setMaximumSize( QSize( 32767, 22 ) );
    urlLayout->addWidget( (QWidget *)urlString );
    boxLayout->addLayout( urlLayout );
 
    messageString = new QMultiLineEdit( (QWidget *)messageGroup, "MultiLineEdit2" );
    messageString->setReadOnly( TRUE );
    messageString->setFocusPolicy( QMultiLineEdit::NoFocus );
    messageString->setWordWrap( QMultiLineEdit::WidgetWidth );

    boxLayout->addWidget( (QWidget *)messageString );   
    messageString->show();
    urlLabel->show();
    urlString->show();
    urlLayout->activate();
    prevFrame=_type;
  }  
  
  boxLayout->activate();
}
void kxReceivedMessageImpl::SlotHistoryButton()
{
  if (historyView!=NULL)
  {
    delete vbox_2;
    delete historyView;
    historyFrame->setMinimumSize(0,0);
    //vbox->activate();
    resize(width(),height()-75);    
    updateGeometry();    
    historyView=NULL;
    historyButton->setDown(FALSE);
  }
  else
  {
    debug("show hist! ");
    vbox_2 = new QVBoxLayout( historyFrame );
    vbox_2->setSpacing( 0 );
    vbox_2->setMargin( 0 );   
    historyView = new kxHistoryWidget(ruin, historyFrame, "historyView" );
    historyView->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)4, historyView->sizePolicy().hasHeightForWidth() ) );
    historyView->setFocusPolicy( QListView::NoFocus );
    historyView->show();    
    vbox_2->addWidget( historyView );        
    vbox_2->activate();
    historyFrame->setMinimumSize(0,75);
    historyFrame->resize(10,75);    
    //vbox->activate();
    resize(width(),height()+75);
    updateGeometry();
    historyButton->setDown(TRUE);
  }
}

void kxReceivedMessageImpl::SlotNextButton()
{
  showEvent();
}
void kxReceivedMessageImpl::SlotForwardButton()
{
  if (msgType==REQUEST_TYPE)
  {
    kxSendMessageImpl *dialog=new kxSendMessageImpl(ruin,REJECT_TYPE,0L,"SendMessage");
    dialog->resize(200,300);
    dialog->show();
    ENGINE->CONTACT->setSendWidget(uin,dialog);
    delete this;
  }  
}
void kxReceivedMessageImpl::SlotAddButton()
{
  ENGINE->CONTACT->add(nick,ruin, needAuth);
  ENGINE->addContact2List(ruin);
  if (MAINWINDOW->kxConfig.notifyContactOnAdding && !msgType==REQUEST_TYPE)
    ENGINE->notifyContact(ruin, MAINWINDOW->kxConfig.nick,
                                                 MAINWINDOW->kxConfig.lastName,
                                                 MAINWINDOW->kxConfig.firstName,
                                                 MAINWINDOW->kxConfig.email);
  addUserButton->setEnabled(FALSE);                                              
}

void kxReceivedMessageImpl::SlotCancelButton()
{
  close();
}
void kxReceivedMessageImpl::hide()
{
  delete this;
}
void kxReceivedMessageImpl::SlotInfoButton()
{
  kxInfoDialogImpl *dialog=new kxInfoDialogImpl(ruin,0L,"info");
  dialog->show();
}

void kxReceivedMessageImpl::SlotReplyButton()
{
  if (type==FILE_TYPE)
  {                 
    kxServerSocket *sock=ENGINE->TCP->getNextFreePort();
    if (sock)
    {
     kxFileDialogImpl *dialog=new kxFileDialogImpl(uin, sock, fileName, size,0,0L, "file", seq);    
     dialog->show();
    }
    else
    {
      debug("No Free Port !!!");
    }
    hide();   
  } 
  else 
  if (msgType==REQUEST_TYPE)
  {
    ENGINE->sendAuthorization(ruin);
    SlotAddButton();
    delete this;
  }
  else
  {
    kxSendMessageImpl *dialog=new kxSendMessageImpl(ruin,1,0L,"SendMessage");
    dialog->resize(200,300);
    dialog->show();
    delete this;
  }
}
void kxReceivedMessageImpl::SlotRecountMessages(UIN _uin)
{
  if (type==FILE_TYPE) return;
  bool show=FALSE;
  if (type==0 && _uin==uin) show=TRUE;
  if (type==1) show=TRUE;
  debug("Recount: %d",show);
  if (show)
  {
    QString txt;
    int toGo=0;
    if (type==0) toGo=ENGINE->MESSAGE->countUnreadMessages (uin);
    else toGo=ENGINE->MESSAGE->countAllUnread();
    if (toGo<1)
    {
      readNextButton->setText(i18n("Read Next"));
      readNextButton->setEnabled(FALSE);
    }
    else
    {
      readNextButton->setEnabled(TRUE);
      if (toGo==1)
      {
        readNextButton->setText(i18n("Read Next"));
      }
      else
      {
        txt.sprintf("Read Next (%d)",toGo);
        readNextButton->setText(txt);
      }
    }  
  }
}
