#include "kxlabel.h"
#include <qpixmap.h>
#include <qpainter.h>
#include <qcolor.h>
#include <qpalette.h>
#include <qfontmetrics.h>
#include <kxengine.h>
#include "kxcontact.h"
#include "kxmessage.h"
#include <kxmainwindow.h>

kxLabel::kxLabel(QWidget *_parent, const char *_name)
  : QLabel(_parent, _name)
{
  QObject::connect(ENGINE, SIGNAL(SignalUpdateDock()), this, SLOT(SlotUpdatePixmap()));
  QObject::connect(ENGINE->CONTACT, SIGNAL(recountMessages(UIN)), this, SLOT(SlotRecount(UIN)));  
}

void kxLabel::mouseReleaseEvent(QMouseEvent *e)
{
  QLabel::mouseReleaseEvent(e);
  emit clicked();
}
void kxLabel::setText(const QString &_txt)
{
  text=_txt;
  repaint();
}  
void kxLabel::SlotUpdatePixmap()
{
  repaint();
}
void kxLabel::SlotRecount(UIN)
{
  repaint();
}
void kxLabel::paintEvent(QPaintEvent *_p)
{
  QPainter paint(this);
  paint.setBrush(colorGroup().base());
  paint.setPen(colorGroup().text());  
  paint.drawRect(0,0,width()-1, height());

  int x=0;
  QPixmap pixmap;
  
  if (ENGINE->MESSAGE->countUnreadMessages(0)>0)
  {    
    pixmap=MAINWINDOW->kxIcons.message;    
    paint.drawPixmap((height()/2)-(pixmap.height()/2),2,pixmap);
    x=pixmap.width();
  }
  paint.drawText(x+3+2,(height()/2)-(fontMetrics().height()/2), width()-4, height()-2, AlignLeft, text.latin1());
}