#include "kxhistorydialogimpl.h"
#include <kxhistorywidget.h>
#include <qlayout.h>

/* 
 *  Constructs a kxHistoryDialogImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
kxHistoryDialogImpl::kxHistoryDialogImpl( UIN _uin, QWidget* parent,  const char* name, bool modal, WFlags fl )
    : kxHistoryDialog( parent, name, modal, fl )
{
    QVBoxLayout *vbox_2 = new QVBoxLayout( sendReceivedWidget );
    vbox_2->setSpacing( 0 );
    vbox_2->setMargin( 0 );
    kxHistoryWidget *historyView = new kxHistoryWidget(_uin, sendReceivedWidget, "historyView" );
    historyView->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)5, historyView->sizePolicy().hasHeightForWidth() ) );
    historyView->setFocusPolicy( QListView::NoFocus );
    historyView->show();
    vbox_2->addWidget( historyView );
    vbox_2->activate();
     
    vbox_2 = new QVBoxLayout( sendWidget );
    vbox_2->setSpacing( 0 );
    vbox_2->setMargin( 0 );
    historyView = new kxHistoryWidget(_uin, VIEW_SEND, sendWidget, "historyView" );
    historyView->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)5, historyView->sizePolicy().hasHeightForWidth() ) );
    historyView->setFocusPolicy( QListView::NoFocus );
    historyView->show();
    vbox_2->addWidget( historyView );
    vbox_2->activate();      
    
    vbox_2 = new QVBoxLayout( receivedWidget );
    vbox_2->setSpacing( 0 );
    vbox_2->setMargin( 0 );
    historyView = new kxHistoryWidget(_uin, VIEW_RECEIVE, receivedWidget, "historyView" );
    historyView->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)5, historyView->sizePolicy().hasHeightForWidth() ) );
    historyView->setFocusPolicy( QListView::NoFocus );
    historyView->show();
    vbox_2->addWidget( historyView );
    vbox_2->activate();      

}

/*  
 *  Destroys the object and frees any allocated resources
 */
kxHistoryDialogImpl::~kxHistoryDialogImpl()
{
    // no need to delete child widgets, Qt does it all for us
}
void kxHistoryDialogImpl::hide()
{
  debug("kill ;-)");
  delete this;
}
