#include <qcheckbox.h>
#include <klocale.h>
#include "kxcontacttransferdialogimpl.h"
#include <kxengine.h>
#include <kxcontact.h>
#include <kxmainwindow.h>
#include <kxudp.h>
#include <kxsend.h>

kxContactTransferDialogImpl::kxContactTransferDialogImpl(UIN _uin,QWidget *parent, const char *name)
  : kxContactTransferDialog(parent, name)
{
  ENGINE->CONTACT->setSendWidget(_uin,this);
  uin=_uin;
  type=0;

  init();
  addContacts();
}  
  
void kxContactTransferDialogImpl::init()
{  
  QStringList _list;
  QString tmp;
  for (int t=1; t<=50; t++)
  {
    tmp.sprintf("kde/%04d",t);
    _list.append(tmp);
  }

  sendAnim=new KAnimWidget(_list, 22, animLabel, "anim");
  sendAnim->resize(25,25);
  
  throughServer->setChecked(ENGINE->CONTACT->getContact(uin).alwaysServer);  
  QString tmpStr;
  tmpStr.sprintf("%d",uin);  
  uinLabel->setText(tmpStr.latin1());
  if (strlen(ENGINE->CONTACT->getContact(uin).nick)>0)
    nickLabel->setText(ENGINE->CONTACT->getContact(uin).nick); 
  else
    nickLabel->setText(i18n("<Unknown> ")+QString().setNum(uin));


  listLayout = new QVBoxLayout( listFrame );
  listLayout->setSpacing( 0 );
  listLayout->setMargin( 0 );   
  list=new CheckListBox(listFrame,"List");
  listLayout->addWidget( list );
  list->showHeader(FALSE);  
  
  QObject::connect(sendButton, SIGNAL(clicked()), SLOT(SlotSend()));
  QObject::connect(cancelButton, SIGNAL(clicked()), SLOT(SlotCancel()));  
}
void kxContactTransferDialogImpl::addContacts()
{
  CheckListBoxItem *li;
  li=list->insertItem(MAINWINDOW->kxConfig.nick,FALSE,0);
  li->allowAction(FALSE);
  li->allowEdit(FALSE);  
  for (int t=0; t<ENGINE->CONTACT->count(); t++)
  {
    if (ENGINE->CONTACT->getContact(t).show)
    {
      li=list->insertItem(ENGINE->CONTACT->getContact(t).nick,FALSE,t+1);
      li->allowAction(FALSE);
      li->allowEdit(FALSE);
    }    
  }     
}
void kxContactTransferDialogImpl::hide()
{
  debug("Close/Hide !!");
  QDialog::hide();
  ENGINE->CONTACT->setSendWidget(uin);
  delete this;
}  
void kxContactTransferDialogImpl::SlotSend()
{
  QList<kxAddContactStruct> contactList;
  contactList.clear();
  contactList.setAutoDelete(TRUE);
  
  CheckListBoxItem *li;
  int c=0;
  bool add;
  int addNum=0;
  for (int t=0; t<(int)list->count(); t++)
  {
    li=list->item(t);
    add=FALSE;
    if (li->isChecked())
    {
      c++;
      if (t==0)
        add=TRUE; // 0 are we ;_)
      else
      {
        for (int y=0; y<ENGINE->CONTACT->count(); y++)
        {
          if (QString(ENGINE->CONTACT->getContact(y).nick) == QString(li->text()))
          {
            add=TRUE;
            addNum=y;
            y=ENGINE->CONTACT->count()+1;
            debug("Do add!!");
            continue;
          }
        }                  
      }     
      if (add)
      {
        kxAddContactStruct *c=new kxAddContactStruct;
        if (t==0) // we, remeber ;-)
        {
          c->uin=MAINWINDOW->kxConfig.uin;
          c->nick=MAINWINDOW->kxConfig.nick;
        }
        else
        {
          c->uin=ENGINE->CONTACT->getContact(addNum).uin;
          c->nick=ENGINE->CONTACT->getContact(addNum).nick;
          debug("Add: %s",c->nick.latin1());
        }        
        contactList.append(c);
      }
    }
  }
  if (c>0)
  {
    send=ENGINE->sendContacts(uin, &contactList,throughServer->isChecked());  
    doSend=TRUE;
    sendSeq=send->sendSeq;
    sendButton->setEnabled(FALSE);
    list->setEnabled(FALSE);
    sendAnim->start();
        
    QObject::connect(send, SIGNAL(SignalSendToClientOk(int)), this, SLOT(SlotSendToClientOk(int)));
    QObject::connect(send, SIGNAL(SignalSendToClientError(int)), this, SLOT(SlotSendToClientError(int)));  
    QObject::connect(send, SIGNAL(SignalSendToServerOk(int)), this, SLOT(SlotSendToServerOk(int)));
    QObject::connect(send, SIGNAL(SignalSendToServerError(int)), this, SLOT(SlotSendToServerError(int)));  
  }
}
void kxContactTransferDialogImpl::SlotCancel()
{
  if (doSend)
  {
    sendAnim->stop();
    doSend=FALSE;
    sendButton->setEnabled(TRUE);
    list->setEnabled(TRUE);    
    list->setFocus();
  }
  else
    close();
}
void kxContactTransferDialogImpl::SlotSendToClientError(int)
{
  throughServer->setChecked(TRUE);
  ENGINE->CONTACT->setAlwaysServer(uin,TRUE,FALSE);
  send->sendToServer();
}
void kxContactTransferDialogImpl::SlotSendToClientOk(int _s)
{
  if (_s==sendSeq)
    close();
}
void kxContactTransferDialogImpl::SlotSendToServerError(int)
{
}
void kxContactTransferDialogImpl::SlotSendToServerOk(int _s)
{
  if (_s==sendSeq)
    close();
}
