#ifndef KXCONTACTLIST_H
#define KXCONTACTLIST_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kpopupmenu.h>
#include <qwidget.h>
#include <qscrollview.h>
#include <qlabel.h>
#include <qlist.h>
#include <qvbox.h>
#include <qlayout.h>
#include <v2_codes.h>

// empty class as virtual class
class kxContactListItem : public QFrame
{
  Q_OBJECT
public:
  kxContactListItem(QWidget *_parent) : QFrame(_parent) { };

  virtual void init() {};
  virtual void drawContent() {};
  virtual void updateContent() {};
  virtual int  getType() { return 0; }; // no type    
  virtual int  getHeight() { return 10; };
  virtual int  getStatus() { return -1; };  
};

class kxContactListContactItem : public kxContactListItem
{
  Q_OBJECT
public:
  kxContactListContactItem(Q_UINT32, int, QWidget *);

 int getType() { return 3; }; // Contact
 int getStatus() { return status; };
 void updateContent();
 int getHeight();
  
  int status;
  int type;
  Q_UINT32 uin;
  bool focus;
  int itemHeight;
  KPopupMenu *popup;
  KPopupMenu *options;
  
  int InvisibleItem, OnlineItem, VisibleItem, ServerItem, IgnoreItem, IntIPItem;
  
  
protected:
  void enterEvent(QEvent *);
  void leaveEvent(QEvent *);
  void dragLeaveEvent(QDragLeaveEvent *);
  void dragEnterEvent(QDragEnterEvent *);
  void dropEvent(QDropEvent *);
  void mousePressEvent(QMouseEvent *_e);
  void paintEvent(QPaintEvent *);
  
public slots:
  void repaintItem(UIN);
  void SlotSendMessage();  
  void SlotSendMessages();
  void SlotSendUrl();
  void SlotInfo();
  void SlotRemove();
  void SlotUpdateNick();
  void SlotRenameNick();
  void SlotHistory(); 
  void SlotAskStatusMessage();
  void SlotSendFile();
  void SlotSendContacts();
  void SlotShowOptionsMenu();
  void SlotSetInvisible();
  void SlotSetOnlineNotify();
  void SlotSetVisible();
  void SlotSetAlwaysServer();
  void SlotSetIgnore();
  void SlotSetIntIP();
  
};

class kxContactListSeparatorItem : public kxContactListItem
{
  Q_OBJECT
public:
  kxContactListSeparatorItem(int, QWidget *);

  int type;
  
  int getType() { return type; }; // Separator
  int getHeight() { return 15; };
  
protected:  
  void paintEvent(QPaintEvent *);
};

class kxContactList : public QScrollView
{
  Q_OBJECT
public:
  kxContactList(QWidget *);
  
  // add user
  void addContact(Q_UINT32 _uin, int _status, bool _resize=TRUE);
  // change contact
  void changeContact(Q_UINT32, int);
  void repaintContact(Q_UINT32);
  void removeContact(UIN _uin);
  
  QList<kxContactListItem> itemList;
  
  int calcHeight(int); // 0 = all

public slots:
  void SlotContactAdded(UIN, QString);
    
protected:
  void resizeEvent(QResizeEvent *);
  
};
  

#endif
