#ifndef KXSENDMESSAGEIMPL_H
#define KXSENDMESSAGEIMPL_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qmultilineedit.h>
#include <qlayout.h>
#include <kxhistorywidget.h>
#include <kanimwidget.h>
#include <kxsend.h>
#include "kxSendMessage.h"
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qtimer.h>

class kxSendMessageImpl : public kxSendMessage
{
  Q_OBJECT
public:

  kxSendMessageImpl( Q_UINT32,int, QWidget *, const char *);
  kxSendMessageImpl( Q_UINT32,int, QString,QWidget *, const char *);
  void init();
  ~kxSendMessageImpl();
  
  Q_UINT32 uin;
  int type;
  QTimer fileTimer;  
  bool doSend;
  int sendSeq;
  kxSend *send;
  QString file;
  KAnimWidget *sendAnim;
  QPushButton *fileButton;
  kxHistoryWidget *historyView;
  QVBoxLayout* vbox_2;
  QMultiLineEdit *messageString;
 
  QLineEdit *urlString;
  
public slots:
  virtual void hide();
  void SlotCancelButton();  
  void SlotSendButton();
  void SlotHistoryButton();
  void SlotTextChanged();
  
  void SlotSendToClientError(int);
  void SlotSendToClientOk(int);
  void SlotSendToServerError(int);
  void SlotSendToServerOk(int);
  void SlotSelect();
  void SlotFileTimeout();
  
  void SlotChatAck(int,int,UIN,Q_UINT16, char*);

  
};

#endif

