#include <kmessagebox.h>
#include <kxfiledialogimpl.h>
#include <kxtcp.h>
#include <kfiledialog.h>
#include <qtooltip.h>
#include <stdlib.h>
#include "kxSendMessageImpl.h"
#include "kxcontact.h"
#include "kxengine.h"
#include <qlabel.h>
#include <qobject.h>
#include <qmultilineedit.h>
#include <kxudp.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qdialog.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <kaccel.h>
#include <klocale.h>
#include <kanimwidget.h>
#include <qstringlist.h>

kxSendMessageImpl::kxSendMessageImpl(Q_UINT32 _uin,int _type,QString _file,QWidget *_parent, const char *_name): kxSendMessage( _parent,_name)
{
  file=_file;
  uin=_uin;
  type=_type;
  init();
}
kxSendMessageImpl::kxSendMessageImpl(Q_UINT32 _uin,int _type,QWidget *_parent, const char *_name) : kxSendMessage( _parent,_name)
{
  uin=_uin;
  type=_type;
  init();
}
void kxSendMessageImpl::init()
{
  QObject::connect(&fileTimer, SIGNAL(timeout()), SLOT(SlotFileTimeout()));

  ENGINE->CONTACT->setSendWidget(uin,this);
  historyView=NULL;
  doSend=FALSE;
  sendSeq=0;
  send=NULL;

  QStringList list;
  QString tmp;
  for (int t=1; t<=50; t++)
  {
    tmp.sprintf("kde/%04d",t);
    list.append(tmp);
  }

  sendAnim=new KAnimWidget(list, 22, animLabel, "anim");
  sendAnim->resize(25,25);
  
  QString tmpStr;
  messageBox->setColumnLayout(0, Qt::Vertical );
  messageBox->layout()->setSpacing( 0 );
  messageBox->layout()->setMargin( 0 );   

  if (type==URL_TYPE)
  {
    historyWidget->setGeometry(0,0,0,0);

    QHBoxLayout *hbox = new QHBoxLayout;
    hbox->setSpacing( 6 );
    hbox->setMargin( 0 );
   
    QLabel *TextLabel2 = new QLabel( messageBox, "TextLabel2" );
    TextLabel2->setText( tr( "URL:"  ) );
    hbox->insertWidget( 0,TextLabel2 );
   
    urlString = new QLineEdit( messageBox, "urlString" );
    hbox->addWidget( urlString );
       
    QVBoxLayout *vbox_2 = new QVBoxLayout(messageBox->layout()); 
    vbox_2->setAlignment( Qt::AlignTop );
    vbox_2->setSpacing( 6 );
    vbox_2->setMargin( 11 );
    
    messageString = new QMultiLineEdit( messageBox, "messageString" );
    messageString->setWordWrap( QMultiLineEdit::WidgetWidth );
    QToolTip::add(  messageString, tr( "Enter Message" ) );

    vbox_2->addLayout(hbox);
    vbox_2->addWidget(messageString);    
    
    setTabOrder( urlString, messageString);  
    setTabOrder( messageString, sendButton );
    setTabOrder( sendButton, throughServer );
    setTabOrder( throughServer, cancelButton );
    setTabOrder( cancelButton, showHistory );
    setTabOrder( showHistory, sendToMore );  
 
    urlString->setFocus();    
  }
  else
  {
    if (type==MESSAGE_TYPE)
    {
      historyWidget->setGeometry(0,0,0,0);
      QVBoxLayout *vbox_2 = new QVBoxLayout( messageBox->layout() );
      vbox_2->setAlignment( Qt::AlignTop );
      vbox_2->setSpacing( 6 );
      vbox_2->setMargin( 11 );
      messageString = new QMultiLineEdit( messageBox, "messageString" );
      messageString->setWordWrap( QMultiLineEdit::WidgetWidth );
      QToolTip::add(  messageString, tr( "Eneter Message" ) );
      
      vbox_2->addWidget( messageString );
      vbox_2->activate();
  
      setTabOrder( messageString, sendButton );
      setTabOrder( sendButton, throughServer );
      setTabOrder( throughServer, cancelButton );
      setTabOrder( cancelButton, showHistory );
      setTabOrder( showHistory, sendToMore );  
      messageString->setFocus();
    }
    else
    {
      if (type==FILE_TYPE)
      {
        historyWidget->setGeometry(0,0,0,0);
    
        QHBoxLayout *hbox = new QHBoxLayout;
        hbox->setSpacing( 6 );
        hbox->setMargin( 0 );
       
        QLabel *TextLabel2 = new QLabel( messageBox, "TextLabel2" );
        TextLabel2->setText( tr( "File:"  ) );
        hbox->insertWidget( 0,TextLabel2 );
       
        urlString = new QLineEdit( messageBox, "urlString" );
        hbox->addWidget( urlString );
        
        fileButton = new QPushButton(messageBox, "fileButton");
        QObject::connect(fileButton,SIGNAL(clicked()),this, SLOT(SlotSelect()));
        fileButton->setText(i18n("Select"));
        hbox->addWidget(fileButton);
           
        QVBoxLayout *vbox_2 = new QVBoxLayout(messageBox->layout()); 
        vbox_2->setAlignment( Qt::AlignTop );
        vbox_2->setSpacing( 6 );
        vbox_2->setMargin( 11 );
        
        messageString = new QMultiLineEdit( messageBox, "messageString" );
        messageString->setWordWrap( QMultiLineEdit::WidgetWidth );
        QToolTip::add(  messageString, tr( "Enter Message" ) );
    
        vbox_2->addLayout(hbox);
        vbox_2->addWidget(messageString);            
        
        setTabOrder( messageString, fileButton);
        setTabOrder( fileButton,sendButton );
        setTabOrder( sendButton, throughServer );
        setTabOrder( throughServer, cancelButton );
        setTabOrder( cancelButton, showHistory );
        setTabOrder( showHistory, sendToMore );  
     
        messageString->setFocus();    
        setCaption("Send File");
        showHistory->setEnabled(FALSE);
        sendToMore->setEnabled(FALSE);
        throughServer->setEnabled(FALSE);
        if (file.length()<=0) SlotSelect();
        else  urlString->setText(file);
//        show();
      }
    }
  }
    
  if (type==REJECT_TYPE)
  {
    setCaption(i18n("Reject Message"));
    throughServer->setEnabled(FALSE);
  }
  else
    throughServer->setChecked(ENGINE->CONTACT->getContact(uin).alwaysServer);  
  
  tmpStr.sprintf("%d",uin);  
  uinLabel->setText(tmpStr.latin1());
  if (strlen(ENGINE->CONTACT->getContact(uin).nick)>0)
    nickLabel->setText(ENGINE->CONTACT->getContact(uin).nick); 
  else
    nickLabel->setText(i18n("<Unknown> ")+QString().setNum(uin));

  QObject::connect((QObject *)cancelButton, SIGNAL(clicked()), this, SLOT(SlotCancelButton()));
  QObject::connect((QObject *)sendButton, SIGNAL(clicked()), this, SLOT(SlotSendButton()));
  QObject::connect(messageString,SIGNAL(textChanged()), this, SLOT(SlotTextChanged()));  
  QObject::connect((QObject *)showHistory, SIGNAL(clicked()), this, SLOT(SlotHistoryButton()));  
  
  sendButton->setEnabled(FALSE);
  
  KAccel *a = new KAccel(this);
  a->insertItem(i18n("Send"), "Send",Key_S + ALT);
  a->connectItem("Send",this,SLOT(SlotSendButton()));
  a->insertItem(i18n("Send2"), "Send2",Key_Enter + CTRL);
  a->connectItem("Send2",this,SLOT(SlotSendButton()));
  a->insertItem(i18n("Send3"), "Send3",Key_Return + CTRL);
  a->connectItem("Send3",this,SLOT(SlotSendButton()));

}
kxSendMessageImpl::~kxSendMessageImpl()
{
  debug("~close");
}

void kxSendMessageImpl::SlotCancelButton()
{
  if (doSend)
  {
    sendAnim->stop();
    doSend=FALSE;
    sendButton->setEnabled(TRUE);
    messageString->setEnabled(TRUE);    
    messageString->setFocus();
  }
  else
    close();
}
void kxSendMessageImpl::SlotHistoryButton()
{
  if (historyView!=NULL)
  {
    delete vbox_2;
    delete historyView;
    historyWidget->setMinimumSize(0,0);
//    vbox->activate();
    resize(width(),height()-75);    
    updateGeometry();    
    historyView=NULL;
    showHistory->setDown(FALSE);    
  }
  else
  {
    debug("show hist! ");
    vbox_2 = new QVBoxLayout( historyWidget );
    vbox_2->setSpacing( 0 );
    vbox_2->setMargin( 0 );   
    historyView = new kxHistoryWidget(uin, historyWidget, "historyView" );
    historyView->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)4, historyView->sizePolicy().hasHeightForWidth() ) );
    historyView->setFocusPolicy( QListView::NoFocus );
    historyView->show();    
    vbox_2->addWidget( historyView );        
    vbox_2->activate();
    historyWidget->setMinimumSize(0,75);
    historyWidget->resize(10,75);    
//    vbox->activate();
    resize(width(),height()+75);
    updateGeometry();
    showHistory->setDown(TRUE);
  }
}
void kxSendMessageImpl::SlotSendButton()
{
  if (messageString->text().length()>0)
  {
    if (type==FILE_TYPE)
    {
      int sock;
      sock=ENGINE->TCP->connect(uin);
      if (sock>0)
      {
        QFile f(file);
        Q_UINT32 size=f.size();
        debug("File size is now: (%s) %d, %d",file.latin1(),size, f.exists());
        int c=0;
        QString newFile;
        for (Q_UINT16 t=0; t<file.length(); t++)
        {
          if (file[t]=='/' || file[t]=='\\')
            c=t;
        }
        for (Q_UINT16 t=c+1; t<file.length(); t++)
        {
          newFile+=file[t];
        }
        sendAnim->start();
        sendButton->setEnabled(FALSE);
        messageString->setEnabled(FALSE);
        fileButton->setEnabled(FALSE);
        QObject::connect(ENGINE->TCP, SIGNAL(receivedChatAck(int,int,UIN,Q_UINT16, char*)), this, 
          SLOT(SlotChatAck(int,int,UIN,Q_UINT16, char*)));
        sendSeq=ENGINE->TCP->sendFileRequest(uin,messageString->text().latin1(),newFile.latin1(),size);
        fileTimer.start(30000);
      }     
      else
      {
        KMessageBox::sorry(this, i18n("Cannot connect to the contact..."),i18n("File transfer connection error"));
        hide();
      }     

      return;
    }
    if (type==MESSAGE_TYPE || type==URL_TYPE)
    {
      QString sendMsg=messageString->text();
      sendMsg.replace(QRegExp("\n"),"\r\n");

      if (type==MESSAGE_TYPE)
        send=ENGINE->sendMessage(uin, sendMsg,throughServer->isChecked());  
      else  
        send=ENGINE->sendUrl(uin, sendMsg,urlString->text(),throughServer->isChecked());  
      doSend=TRUE;
      sendSeq=send->sendSeq;
      sendButton->setEnabled(FALSE);
      messageString->setEnabled(FALSE);
      sendAnim->start();
      
      QObject::connect(send, SIGNAL(SignalSendToClientOk(int)), this, SLOT(SlotSendToClientOk(int)));
      QObject::connect(send, SIGNAL(SignalSendToClientError(int)), this, SLOT(SlotSendToClientError(int)));  
      QObject::connect(send, SIGNAL(SignalSendToServerOk(int)), this, SLOT(SlotSendToServerOk(int)));
      QObject::connect(send, SIGNAL(SignalSendToServerError(int)), this, SLOT(SlotSendToServerError(int)));  
    }
    else
    {
      ENGINE->rejectContact(uin, messageString->text());
      close();
    }
  }
}

void kxSendMessageImpl::hide()
{
  debug("Close/Hide !!");
  QDialog::hide();
  ENGINE->CONTACT->setSendWidget(uin);
  if (send) delete send;
  delete this;
}  
void kxSendMessageImpl::SlotTextChanged()
{
  if (messageString->text().length()>0)
    sendButton->setEnabled(TRUE);
  else
    sendButton->setEnabled(FALSE);
}
void kxSendMessageImpl::SlotSendToClientError(int _s)
{
  throughServer->setChecked(TRUE);
  ENGINE->CONTACT->setAlwaysServer(uin,TRUE,FALSE);
  send->sendToServer();
}
void kxSendMessageImpl::SlotSendToClientOk(int _s)
{
  if (_s==sendSeq)
    close();
}
void kxSendMessageImpl::SlotSendToServerError(int _s)
{

}
void kxSendMessageImpl::SlotSendToServerOk(int _s)
{
  if (_s==sendSeq)
    close();
}
void kxSendMessageImpl::SlotSelect()
{
        QString f(KFileDialog::getOpenFileName(QString::null,"All files (*.*)",this));
        if (!f.isEmpty())
        {
          file=f;
          urlString->setText(f);
        }      
}
void kxSendMessageImpl::SlotChatAck(int _seq,int _status,UIN _uin,Q_UINT16 _port, char*_msg)
{
  if (_seq==sendSeq && _uin==uin && !_status && _port!=0)
  {
    QFile f(file);
    int size=f.size();
    kxFileDialogImpl *dialog=new kxFileDialogImpl(uin, 0L, file, size,_port,0L, "file");
    dialog->show();
    hide();
  }
  else
  {
    debug("rejected !!!!");
  }
}
void kxSendMessageImpl::SlotFileTimeout()
{
  KMessageBox::sorry(this, i18n("Cannot connect to the contact..."),i18n("File transfer connection error"));
  hide();
}
