#include <kglobalaccel.h>
#include "kxpaneldock.h"
#include <kxengine.h>
#include <kxmessage.h>
#include <qpainter.h>
#include <kxreceivedmessageimpl.h>
#include <qcolor.h>
#include <kxcontact.h>
#include <kxmainwindow.h>
#include <kwin.h>
#include <klocale.h>

kxPanelDock::kxPanelDock() : QLabel(0L,"dock")
{
  showIcon=TRUE;
  
  QObject::connect(&blinkTimer, SIGNAL(timeout()), this, SLOT(SlotTimeout()));
  QObject::connect(ENGINE, SIGNAL(SignalUpdateDock()), this, SLOT(SlotUpdatePixmap()));
  QObject::connect(ENGINE->CONTACT, SIGNAL(recountMessages(UIN)), this, SLOT(SlotRecount(UIN)));
  
  KGlobalAccel *ga = new KGlobalAccel(); 
  ga->insertItem( i18n("Read Message"), "Read Message", "CTRL+ALT+R" ); 
  ga->connectItem( "Read Message", this, SLOT( SlotShowMessage() ) );

  ga->readSettings();
  SlotUpdatePixmap();  
}

void kxPanelDock::paintEvent(QPaintEvent *)
{
  QPixmap pm(size());
  QPainter paint;
  pm.fill(backgroundColor());
  if (showIcon)
  {
    paint.begin(&pm);  
    paint.drawPixmap(0,0,pixmap);
    paint.end();
  }
  bitBlt(this, 0, 0, &pm);
}
void kxPanelDock::SlotShowMessage()
{
  showMessage();
}
int kxPanelDock::showMessage()
{
  if (ENGINE->MESSAGE->countAllUnread()>0)
  {
    kxReceivedMessageImpl *dialog;
    dialog=new kxReceivedMessageImpl(0L,"view all");
    dialog->resize(200,300);
    dialog->show();
    return 1;    
  }
  else return 0;
}

void kxPanelDock::mousePressEvent(QMouseEvent *_e)
{
  if (_e->button()==QMouseEvent::LeftButton)
  {  
    if (!showMessage())
    {
      if (MAINWINDOW->isVisible())
      {
        Mpos=MAINWINDOW->pos();
        Msize=MAINWINDOW->size();
        MAINWINDOW->hide();
      }
      else
      {
        MAINWINDOW->resize(Msize);
        MAINWINDOW->move(Mpos);        
        MAINWINDOW->show();
        
        KWin::setActiveWindow(MAINWINDOW->winId());
      }
    }      
  }
  else
  {
    if (_e->button()==QMouseEvent::RightButton)
    {
        KWin::Info i = KWin::info( winId() );
        QRect g = i.geometry;
 
        if ( g.x() > QApplication::desktop()->width()/2 &&
             g.y() + MAINWINDOW->popup->height() > QApplication::desktop()->height() )
            MAINWINDOW->popup->popup(QPoint( g.x(), g.y() - MAINWINDOW->popup->height()));
        else
            MAINWINDOW->popup->popup(QPoint( g.x() + width(), g.y() + height()));
    }
  }
}
void kxPanelDock::SlotRecount(UIN)
{
  SlotUpdatePixmap();  
}
void kxPanelDock::SlotTimeout()
{
  showIcon=!showIcon;
  if (showIcon) blinkTimer.start(1200);
  else blinkTimer.start(750);  
  update();
}
void kxPanelDock::SlotUpdatePixmap()
{
  if (ENGINE->MESSAGE->countAllUnread()>0)
  {
    showIcon=TRUE;
    pixmap=MAINWINDOW->kxIcons.message;
    blinkTimer.start(1000);
  }
  else    
  {
    if (ENGINE->loggedOn()) 
    {
      switch(ENGINE->getStatus())
      {
        case STATUS_AWAY:
          pixmap=MAINWINDOW->kxIcons.away;
          break;
        case STATUS_NA:
          pixmap=MAINWINDOW->kxIcons.na;
          break;
        case STATUS_OCCUPIED:
          pixmap=MAINWINDOW->kxIcons.occupied;
          break;
        case STATUS_FFC:
          pixmap=MAINWINDOW->kxIcons.ffc;
          break;
        case STATUS_INVISIBLE:
          pixmap=MAINWINDOW->kxIcons.invisible;
          break;
        case STATUS_DND:
          pixmap=MAINWINDOW->kxIcons.dnd;
          break;                    
        case STATUS_ONLINE:
        default:
          pixmap=MAINWINDOW->kxIcons.online;
          break; 
      }                  
    }
    else pixmap=MAINWINDOW->kxIcons.offline;
    showIcon=TRUE;
    blinkTimer.stop();
  }
  update();
}
