#ifndef KXMAINWINDOW_H
#define KXMAINWINDOW_H

class kxLabel;
#include <qtimer.h>
#include <kxmessage.h>
#include <kapp.h>
#include <ktmainwindow.h>
#include "kxcontactlist.h"
#include "v2_codes.h"
#include <qpushbutton.h>
#include <qlabel.h>
#include <kpopupmenu.h>

struct kxIconStruct
{
  QPixmap available;
  QPixmap na;
  QPixmap dnd;
  QPixmap ffc;
  QPixmap occupied;
  QPixmap away;  
  QPixmap online;
  QPixmap offline; 
  QPixmap message;
  QPixmap history; 
  QPixmap invisible;
}  ;

struct kxConfigStruct
{
  // connection
  bool reconnect;
  int retry;

  // contact list
  bool popupMessageChatOnPress;
  bool popupMessageChatOnReceive;  
  bool notifyContactOnAdding;
  bool ignoreContactAuth;
  bool saveGeometry;
  bool saveStatus;
  
  // startup
  bool autoConnect;
  bool stayOnTop;
  bool sticky;
  bool showDebug;

  // auto away
  bool autoAway;
  bool autoUnAway;
  int awayTime;
  int naTime;  
  
  bool askAwayMessage;
  QString awayMessage;
  QString naMessage;  
  QString dndMessage;  

  int lastStatus;
  bool hideIP;
  bool webStatus;
  bool byPassAuth;
  int minPort;
  int maxPort;

  QString lastName;
  QString firstName;
  QString email;
  QStringList servers;
  QStringList serverPorts;
  
  QString password;
  QString nick;
  UIN uin;

};

class kxMainWindow;

#define MAINWINDOW kxMainWindow::getPointer()

class kxMainWindow : public KTMainWindow
{Q_OBJECT

public:
	kxMainWindow(const char *name = 0L);
	~kxMainWindow();
	
	
  static kxMainWindow *ptr;
  static kxMainWindow *getPointer() { return ptr; };

  QTimer autoAwayTimer;
  QTimer waitForAutoAwayTimer;
  bool waitForAutoAway;  

  void readConfig(); // read config
  void rereadConfig();
  void init();
  void loadIcons();
  QPixmap loadIcon( const QString&);
	
	kxContactList *list;
	int retryCounter;
	
	bool manualStatusChange;
	kxLabel *statusLabel;
	QPushButton *menuButton;
	KPopupMenu *popup;
  KPopupMenu *statusPopup;	

  struct kxConfigStruct kxConfig;
  struct kxIconStruct kxIcons;
	
  void makeSound(int);
  void updateStatusMessage(int, QString);
  	
public slots:
  void SlotConnect();
  void SlotMenuConnect();
  void SlotDisconnect();  
  void SlotConnected();
  void SlotConnecting();
  void SlotErrorString(QString);
  void SlotDisconnected(int);  
  void SlotContactStatusChange(UIN, Q_UINT16, Q_UINT16);	
  void SlotContactChange(UIN);	
  void SlotChangeStatus(int);
  void SlotChangeStatusByMenu(int);
  void SlotStatusUpdate(int);
  void SlotStatusMessage(UIN, char *);
  void SlotLabelButton();
  void SlotAboutDialog();
  void SlotReportBug();
  void SlotReadMessage();  
  void SlotSettings();
  
  void SlotNewMessage(UIN, kxMessageStruct);
  void SlotNewFile(UIN,int,QString,QString, int);
  
  void SlotExit();
  void SlotSearch();
  void SlotCheckAutoAway();
  void SlotWaitForAutoAway();

signals:
  void SignalNewMessage(UIN, kxMessageStruct);    
  void SignalExit();
  
protected:
  void closeEvent(QCloseEvent *);

private:

};
#endif

