/**************************************************************************
* codes Originally for libXicq - Originally written by tnc (xtrophy@it.dk)*
*'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''*
* v2_codes.h                                                              *
* Command codes for the ICQ protocol v2, v5 and the TCP codes             *
*                                                                         *
* Updated for KXicq by Herwin Jan Steehouwer                              *
* TCP added also for KXicq                                                *
**************************************************************************/


#ifndef _V2_CODES_H
#define _V2_CODES_H

#define VIEW_OFFLINE 1
#define VIEW_ONLINE 2
#define TYPE_SERVER 0

#define UIN Q_UINT32
//#define CONTACT contect

#define STATUS_OFFLINE 			0xFFFF
#define STATUS_ONLINE  			0x0000
#define STATUS_AWAY    			0x0001
#define STATUS_DND    			0x0002
#define STATUS_NA_99      	0x0005
#define STATUS_NA      			0x0004
#define STATUS_OCCUPIED 		0x0010
#define STATUS_OCCUPIED_MAC 0x0011
#define STATUS_DND_KXICQ 		0x0013
#define STATUS_FFC 					0x0020
#define STATUS_DND_99    		0x0022
#define STATUS_INVISIBLE 		0x0100
#define STATUS_UNKNOWN 			0xFFFE

#define TYPE_MSG 1
#define TYPE_URL 2
#define TYPE_ADDED 3
#define TYPE_SEARCH 4
#define TYPE_CHAT 5
#define TYPE_AUTH_REQ 6
#define TYPE_FILE 7

#define TYPE_FULL 100
#define TYPE_WIZARD 101
#define TYPE_REST 102


/* ICQ client commands */
#define C_ACK               0x000A      /* acknowledgement */
#define C_ACK_MSG           0x0442	/* Ack message (delete from server) */
#define C_SEND_MESSAGE      0x010E      /* send message to offline user */
#define C_LOGIN             0x03E8      /* login on server */
#define C_CONTACT_LIST      0x0406      /* Inform the server of cont. list */
#define C_SEARCH_UIN        0x041A      /* search for user by UIN */
#define C_SEARCH_USER       0x0424      /* search for user by name/email */
#define C_KEEP_ALIVE        0x042E      /* keep alive */
#define C_KEEP_ALIVE_2      0x051e      /* keep alive 2 */

#define C_SEND_TEXT_CODE    0x0438      /* send special message to server */
#define C_LOGIN_1           0x044C      /* request system messages */
#define C_INFO_REQ          0x0460      /* Request basic information */
#define C_EXT_INFO_REQ      0x046A      /* Request extended information */
#define C_CHANGE_PASSWORD   0x049C      /* Change the user's password */
#define C_STATUS_CHANGE     0x04D8      /* Change status of user (Away etc.) */
#define C_LOGIN_2           0x0528      /* Sent during Login */

#define C_UPDATE_INFO       0x050A      /* Update my basic information */
//#define C_UPDATE_INFO       0x04A6      /* Update my basic information */
#define C_UPDATE_EXT_INFO   0x04B0      /* Update my extended information */
#define C_ADD_TO_LIST       0x053C      /* Add user to contact list (clist)*/
#define C_REQ_ADD_TO_LIST   0x0456      /* Request auth to add to clist */
#define C_QUERY_STATUS      0x04BA      /* Query about other servers */
#define C_QUERY_ADDONS      0x04C4      /* Query about global add-ons */
#define C_NEW_USER_1        0x04EC      /* Ask for permission to add new usr */
#define C_NEW_USER_REG      0x03Fc      /* Register a new user */
#define C_CMD_X1            0x0442      /* Uknown */
#define C_MSG_TO_NEW_USER   0x0456      /* Send a message to not in clist */
#define C_META_USER         0x064A
#define C_WEB_FINISCH       0x04D8
#define C_VISIBLE_LIST			0x06AE			/* send visible list */
#define C_INVISIBLE_LIST		0x06A4			/* send invisible list */
#define C_SYSMESSAGE_ACK		0x0442
#define C_RAND_SEARCH       0x056E                                                                                                                                 
#define C_RAND_SET          0x0564 

//#define C_UPDATE_SECURITY		0x064A	  	/* update some security updates ! */
#define C_INVISIBLE_STATUS	0x06b8			/* send 1 persons (In)visible status ( 0 = off, 1 = on ) */

#define C_META 0x064a
#define META_C_SEARCH_UIN          0x051F
#define META_C_SEARCH_NICK         0x0515
#define META_C_SEARCH_EMAIL        0x0529
#define META_SRV_USER_FOUND        0x019A
#define META_SRV_USER_MORE_FOUND   0x0190

#define META_INFO_SET         0x03E9                                                                                                                                      
#define META_EXTRA_SET        0x03FD
#define META_WORK_SET         0x03F3
#define META_INFO_REQ         0x04B0                                                                                                                                      
#define META_INFO_SECURE      0x0424                                                                                                                                      
#define META_INFO_PASS        0x042E                                                                                                                                      
#define META_SRV_GEN          0x00C8                                                                                                                                       
#define META_SRV_MORE         0x00DC                                                                                                                                       
#define META_SRV_WORK         0x00D2                                                                                                                                       
#define META_SRV_ABOUT        0x00E6                                                                                                                                      
#define META_SRV_PASS         0x00AA   
#define META_SRV_SEC_ACK      0x00A0                                                                                                                                    
#define META_SRV_GEN_UPDATE   0x0064
#define META_SRv_EXTRA_UPDATE 0x0078                                                                                                                                   
#define META_SRV_ABOUT_UPDATE 0x0082                                                                                                                                  
#define META_INFO_ABOUT       0x0406      


/* ICQ server commands */
#define S_ACK               0x000A      /* Ack */
#define S_LOGIN_REPLY       0x005A      /* Login reply */
#define S_USER_ONLINE       0x006E      /* user in clist changed status */
#define S_USER_OFFLINE      0x0078      /* user in clist has gone offline */
#define S_USER_FOUND        0x008C      /* user record found matching query */
#define S_RECEIVE_MESSAGE   0x00DC      /* message sent while offline */
#define S_GET_MESSAGE       0x0104	/* message from user (sent throu server) */
#define S_END_OF_SEARCH     0x00A0      /* No more USER_FOUND will be sent */
#define S_INFO_REPLY        0x0118      /* Return basic information */
#define S_EXT_INFO_REPLY    0x0122      /* Return extended information */
#define S_STATUS_UPDATE     0x01A4      /* User on contact list changed stat */
#define S_GO_AWAY           0x0028	/* Been idle, logging you out */
#define S_DISCONNECTED      0x00F0      /* We got disconnected? */
/**/
#define S_REPLY_X1          0x021C      /* Unknown (returned during login) */
#define S_REPLY_X2          0x00E6      /* Unknown (confirm my UIN?) */
#define S_UPDATE_REPLY      0x01E0      /* Confirmation of basic update */
#define S_UPDATE_REPLY_FAIL 0x01EA      /* Confirmation of basic update fail*/

#define S_UPDATE_EXT_REPLY  0x00C8      /* Confirmation of extended update */
#define S_NEW_USER_UIN      0x0046      /* Confirmation of new user with UIN */
#define S_NEW_USER_REPLY    0x00B4      /* Confirmation of new user info */
#define S_QUERY_REPLY       0x0082      /* Response to QUERY_SERVERS or QUERY_A*/
#define S_SYSTEM_MESSAGE    0x01C2      /* System message with URL button */
#define S_TRY_AGAIN	    	0x00FA	/* try again */
#define S_WEB_ACK           0x03DE
#define S_INVALID_UIN	    	0x012C
#define S_WRONG_PASSWORD    0x0064
#define S_WRONG_PASSWORD_2    0x8300
#define S_RAND_USER      0x024E

#define S_SYSMESSAGE_DONE		0x00E6			/* system message are done */
#define S_MULTI_PACKET			0x0212	
#define S_SEARCH_ERROR			0x001E			/* search error, server error ?? */
#define S_META_USER         0x03De

#define MESSAGE_TYPE_CONTACT 0x30

#define LOCALHOST	0x0100007f	/* localhost IP ( 127.0.0.1 ) ;) */

#define FONT_PLAIN	0x00000000
#define FONT_BOLD	0x00000001
#define FONT_ITALIC	0x00000002
#define FONT_UNDERLINE	0x00000004

/* TCP Message Commands */

#define TCP_CANCEL           0x07D0
#define TCP_ACK              0x07DA
#define TCP_MESSAGE          0x07EE

/* TCP Message Types */

#define TCP_START       0x07EE
#define TCP_CANCEL      0x07D0
#define TCP_ACK         0x07DA
#define TCP_MSG         0x0001
#define TCP_FILE        0x0003
#define TCP_CHAT        0x0002
#define TCP_URL         0x0004


#define TCP_MSG_MSG          0x0001
#define TCP_MSG_CHAT         0x0002
#define TCP_MSG_FILE         0x0003
#define TCP_MSG_URL          0x0004
#define TCP_MSG_READAWAY     0x03E8
#define TCP_MSG_READOCCUPIED 0x03E9
#define TCP_MSG_READNA       0x03EA
#define TCP_MSG_READDND      0x03EB
#define TCP_MSG_READFFC      0x03EC
#define TCP_MSG_CONTACT			 0x0013
#define TCP_MSG_WAV          0x001A

/* TCP Message Command Types */

#define TCP_MSG_AUTO         0x0000
#define TCP_MSG_REAL         0x0010
#define TCP_MSG_LIST         0x0020
#define TCP_MSG_URGENT       0x0040
#define TCP_MSG_INVISIBLE    0x0090
#define TCP_MSG_UNK_1        0x00A0
#define TCP_MSG_AWAY         0x0110
#define TCP_MSG_OCCUPIED     0x0210
#define TCP_MSG_UNK_2        0x0802
#define TCP_MSG_NA           0x0810
#define TCP_MSG_NA_2         0x0820
#define TCP_MSG_DND          0x1010

/* TCP Message Status' */

#define TCP_STAT_ONLINE      0x0000
#define TCP_STAT_REFUSE      0x0001
#define TCP_STAT_AWAY        0x0004
#define TCP_STAT_OCCUPIED    0x0009
#define TCP_STAT_DND         0x000A
#define TCP_STAT_NA          0x000E
#define TCP_STAT_FREE_CHAT   TCP_STAT_ONLINE
#define TCP_STAT_INVISIBLE   TCP_STAT_ONLINE

#endif
