/***************************************************************************
                          kxtcp.cpp  -  description                              
                             -------------------                                         
    begin                : Sun Aug 15 1999                                           
    copyright            : (C) 1999 by Herwin Jan Steehouwer                         
    email                : steehouwer@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qstring.h>
#include "kxtcp.h"
#include <sys/time.h>
#include <unistd.h>
#include <sys/stat.h>
#include "kxengine.h"
#include <stdlib.h>

kxTCP::kxTCP(Q_UINT32 _minPort=0, Q_UINT32 _maxPort=0)
{
	sequence=1;
  chatSessions.setAutoDelete(TRUE);
	freePort=_minPort;
	minPort=_minPort;
	maxPort=_maxPort;
	myServerSocket=getNextFreePort();
	if (!myServerSocket) 
	{
	  debug("error get port ;-( ");
	  return;
	}
	debug("Got port: %d:%d",getAddr(), getPort());
	QObject::connect(myServerSocket, SIGNAL(accepted(kxSocket *)), this, SLOT(SlotAccepted(kxSocket *)));
	initPacket();
}

kxTCP::~kxTCP(){
	delete myServerSocket;
}

/** Get out addres */
Q_UINT32 kxTCP::getIntAddr(){
	return ENGINE->ourIntIP;
}
/** Get out addres */
Q_UINT32 kxTCP::getAddr(){
  return ENGINE->ourExtIP;	
}

/** Get our port */
Q_UINT16 kxTCP::getPort(){
	return myServerSocket->getPort();	
}

/** Accept  a incomming connection... */
void kxTCP::SlotAccepted(kxSocket *_ks){
	debug("=-=-=-=-=-= Incomming !!!=-=-=-=-=-=-=-=");
	debug("-> %d, %ld", _ks->socket(), _ks->getAddr());
//	_ks->enableWrite(TRUE);
	_ks->enableRead(TRUE);		
	QObject::connect(_ks,SIGNAL(readEvent(kxSocket *)), this, SLOT(SlotReadEvent(kxSocket *)));
	QObject::connect(_ks,SIGNAL(closeEvent(kxSocket *)), this, SLOT(SlotCloseEvent(kxSocket *)));
	QObject::connect(_ks,SIGNAL(writeEvent(kxSocket *)), this, SLOT(SlotWriteEvent(kxSocket *)));
}


/**  */
void kxTCP::SlotReadEvent(kxSocket *_ks){

	kxIncommingPacket *p;
	int len;
	Q_UINT16 packetLen;
	Q_UINT32 sock=_ks->socket();
	for (Q_UINT16 t=0; t<packetList.count(); t++)
	{
		p=packetList.at(t);
		if (p->mySocket==_ks)
		{
			if (p->length==0)
			{
				char *buf2=new char[3];		
				len=recv(sock, buf2, 2,0 );
			 	QByteArray  a; //=new QByteArray(2049);
				a.setRawData( buf2, len );
				QDataStream s( a, IO_ReadOnly );            // open on a's data
				s.setByteOrder(QDataStream::LittleEndian);	
				s >> (Q_UINT16 &)packetLen;		
				p->length=packetLen;
				p->totalRead=0;
				delete buf2;

				return;
			}
			QDataStream s(p->packet, IO_ReadWrite);
			s.setByteOrder(QDataStream::LittleEndian);
			
			char *buf=new char[p->length-p->totalRead+1];	
			len=recv(sock, buf, p->length-p->totalRead,0 );
			if (len>0)
			{	
				s.device()->at(p->totalRead);
				s.writeRawBytes(buf,len);	
				p->totalRead+=len;
				debug("packet: len: %d, %d",len, p->totalRead);
			}
			delete buf;
			if (p->totalRead>=p->length)
			{
				parseData(&p->packet, _ks, p->totalRead);
				packetList.remove(t);
			}
			return;
		}
	}
  p=new kxIncommingPacket;
  p->length=0;
  p->totalRead=0;
  p->mySocket=_ks;
  packetList.append(p);

 	char *buf2=new char[3];		
 	len=recv(sock, buf2, 2,0 );
 	QByteArray  a; //=new QByteArray(2049);
 	a.setRawData( buf2, len );
 	QDataStream s( a, IO_ReadOnly );            // open on a's data
 	s.setByteOrder(QDataStream::LittleEndian);	
 	s >> (Q_UINT16 &)packetLen;		
 	p->length=packetLen;
 	p->totalRead=0;
 	a.resetRawData(buf2, len);
 	delete buf2;
}

/**  */
void kxTCP::SlotCloseEvent(kxSocket *_ks){
	packetDef *p;
	int t;
	for (t=0; t<count(); t++)
	{
		p=getPacket(t);
		if (p->mySocket==_ks)
		{
			p->mySocket=NULL;
			t=count();
			continue;
		}
	}
	debug("delete _ks ?");
	kxContactStruct cs;
	for (t=0; t<ENGINE->CONTACT->count(); t++)
	{
		cs=ENGINE->CONTACT->getContact(t);
		if (cs.mySocket==_ks)
		{
					ENGINE->CONTACT->updateSocket(cs.uin, NULL);
					debug("sock bound to user !! delete");
		}
	}
	delete _ks;
}

/** parse the packet */
void kxTCP::parseData(QByteArray *a, kxSocket *_ks, int len,bool _sendAck = 1){
	QDataStream s( *a, IO_ReadOnly );            // open on a's data
	s.setByteOrder(QDataStream::LittleEndian);	
	
	Q_UINT32 uin, uin2, ip, ip2, port, seq, hversion, rport;
	Q_UINT16 version , command, unknown_1, type, length;
	Q_UINT16 status, commandType;
	Q_UINT32 chatPort;
	char *message=0;
	char *filename=0;
	Q_UINT8 tmp;

	debug("[TCP]=========================[receive]=======================");	
	debug("packet: len: %d",len);
	QString str,tmps;
	Q_UINT8 ttmp;
	for (int t=0; t<len; t++)
	{	
		s >> (Q_UINT8 &)ttmp;		
		tmps.sprintf("[%02X] ", (Q_UINT8)ttmp);
		str.append(tmps);		
    if (str.length()>200) { debug(str.latin1()); str.remove(0,str.length()); }				
	}
	debug("%s", str.latin1());
	debug("[TCP]=========================[end receive]=======================");

	
	Q_UINT8 handshake;
	s.device()->at(0);
	s >> (Q_UINT8 &)handshake;
	if (handshake==0xff)
	{
		debug("HandShake");

		s >> (Q_UINT32 &)hversion;
		s >> (Q_UINT32 &)port;
		s >> (Q_UINT32 &)uin;
		s >> (Q_UINT32 &)ip;
		s >> (Q_UINT32 &)ip2;
		s >> (Q_UINT8  &)tmp;
		s >> (Q_UINT32 &)rport;		
//		send(TCP_MSG_MSG, _ks, uin, 0);
//		sendHandshake(uin, _ks);
		debug("verion :%d, uin:%d, port: %d",hversion, uin, port);
    Q_UINT8 p1, p2, p3, p4;
  	p1=ip;
  	ip>>= 8;
  	p2=ip;
  	ip>>=8;
  	p3=ip;
  	ip>>=8;
  	p4=ip;
  	debug("IP1: [%d] %02d.%02d.%02d.%02d",ip, p1, p2, p3, p4);		
//    Q_UINT8 p1, p2, p3, p4;
  	p1=ip2;
  	ip2>>= 8;
  	p2=ip2;
  	ip2>>=8;
  	p3=ip2;
  	ip2>>=8;
  	p4=ip2;
  	debug("IP2: [%d] %02d.%02d.%02d.%02d",ip2, p1, p2, p3, p4);		
		
		kxContactStruct cs;
		for (int t=0; t<ENGINE->CONTACT->count(); t++)
		{
			cs=ENGINE->CONTACT->getContact(t);
			if (cs.uin==uin)
			{
				debug("found already sock !");
				if (cs.mySocket)
				{
					delete cs.mySocket;
					ENGINE->CONTACT->updateSocket(cs.uin, NULL);
					debug("Deleted sock");
				}
				ENGINE->CONTACT->updateSocket(uin,_ks);
			}
		}
	}
	else
	{
		chatPort=0;
		s.device()->at(0);
		s >> (Q_UINT32 &)uin;
		s >> (Q_UINT16 &)version;
		s >> (Q_UINT16 &)command;
		s >> (Q_UINT16 &)unknown_1;
		s >> (Q_UINT32 &)uin2;
		s >> (Q_UINT16 &)type;
		s >> (Q_UINT16 &)length;
    message=new char[length+1];
    s.readRawBytes(message, length);
		s >> (Q_UINT32 &)ip;
		s >> (Q_UINT32 &)ip2;
		s >> (Q_UINT32 &)port;
		s >> (Q_UINT8  &)tmp;		
		s >> (Q_UINT16 &)status;
		s >> (Q_UINT16 &)commandType;
		
  debug("verion :%d, uin:%d, port: %d", version, uin, port);
    Q_UINT8 p1, p2, p3, p4;
  	p1=ip;
  	ip>>= 8;
  	p2=ip;
  	ip>>=8;
  	p3=ip;
  	ip>>=8;
  	p4=ip;
  	debug("IP1: [%d] %02d.%02d.%02d.%02d",ip, p1, p2, p3, p4);		
//    Q_UINT8 p1, p2, p3, p4;
  	p1=ip2;
  	ip2>>= 8;
  	p2=ip2;
  	ip2>>=8;
  	p3=ip2;
  	ip2>>=8;
  	p4=ip2;
  	debug("IP2: [%d] %02d.%02d.%02d.%02d",ip2, p1, p2, p3, p4);		
    QString sessionContact;
		
		if(type==TCP_MSG_CHAT && status==0)
		{
			Q_UINT16 len, ioport, none;
//			Q_UINT8 c;
//			Q_UINT32 zero;
			s >> (Q_UINT16 &)len;			
      char *session=new char[len+1];
      s.readRawBytes(session, len);
      debug("Chat session with: %d, %s",len, session);
      sessionContact=session;
      delete session;
			s >> ( Q_UINT16 &)ioport;
			s >> (Q_UINT16 &)none;
			s >> (Q_UINT32 &)chatPort;					
			//s >> ( Q_UINT32 &) zero;
			if (chatPort==0) chatPort=(ioport>>8) | ((ioport&255)<<8);
						
			debug("Got ports: %d, %d",chatPort, ioport);
		}
		Q_UINT32 flen;
		if (type==TCP_MSG_FILE && command==TCP_START)
		{
		  Q_UINT16 len;
		  Q_UINT32 junk;
 		                           
		  s >> (Q_UINT32 &)junk;
 		  s >> (Q_UINT16 &)len;
      filename=new char[len+1];
      s.readRawBytes(filename, len);
      s >> (Q_UINT32 &)flen;      
		  s >> (Q_UINT32 &)junk;
		  
		  debug("Got file: [%s] size: %d",filename, flen);
		}
    if (type==TCP_MSG_FILE && command==TCP_ACK)
    {
        Q_UINT32 rp1,zero, p1;
        Q_UINT16 len;
        Q_UINT8 c; 
       	s >> ( Q_UINT32 &) rp1;    //port
 				s >> (Q_UINT16 &)len;			
  			for (int t=0; t<len; t++)
  				s>> (Q_UINT8 &)c;
       	s >> ( Q_UINT32 &) zero;		// file size =0 in ACK
       	s >> ( Q_UINT32 &) p1;	    // port normal
       	chatPort=p1;
    } 
		s >> (Q_UINT32 &)seq;

		debug( "[TCP] UIN: %d, Seq: %d, command, %d(%x), lenmsg: %d, Type: %X version: %d, status: %d, commandType: %d(%x)",uin, seq, command, command, strlen(message), type, version, status, commandType, commandType);
//		debug( "[TCP] %X, %X, %X, %X, %X",command,  type, type|0x8000, type^0x8000, type&0x8000);

//debug("type: %X",type);					
		if (type>0x8000)
		{
			debug("Mass message !");
			type^=0x8000;
		}
		debug("type: %X",type);					
		
		switch(command)
		{
			case TCP_ACK:
				debug("got ack, %d", chatPort);
				emit receivedAck(seq);
				if (type==TCP_MSG_CHAT || type==TCP_MSG_FILE)
					emit receivedChatAck(seq, status, uin, chatPort, message);
				if (strlen(message)>0 && !( ( type==TCP_MSG_CHAT || type==TCP_MSG_FILE || type==0x3EE) ))
				{
				  debug("this");
					emit receivedStatusMessage(uin, message);
				}
				if (type==0x3EE)
				{
				  debug("or this");
				  emit receivedRandomAck(uin, message);
				}
				return;
				break;
			case TCP_START:
     		switch(type)
     		{
     			case TCP_MSG_MSG:
     				debug("got message");
     				parseMessage(message, type, uin);
     				send(type, _ks, uin, seq);
     				break;
     			case TCP_MSG_URL:
     				debug("got URL");
     				parseMessage(message, type, uin);
     				send(type, _ks, uin, seq);
     				break;
     			case TCP_MSG_FILE:
    			  {
     			  bool haveUser=FALSE;
//     				debug("got file %d - %d",ENGINE->CONTACT->getContact(uin).uin, ENGINE->kxConfig.rejectChat);
     				debug("File: message: %s",message);
     				
     				kxContactStruct cs;
           	for (int t=0; t<ENGINE->CONTACT->count(); t++)
           	{
           		cs=ENGINE->CONTACT->getContact(t);
           		if (cs.uin==uin)
           		{
           			haveUser=TRUE; 			
           		}
           	}
           	if (!haveUser)
           	{
           	  break;
//todo           		ENGINE->SlotAddUser(uin,"","","","",0);
           		ENGINE->CONTACT->updateSocket(uin, _ks);
           	}
           	emit SignalNewFile(uin,seq,QString(message), QString(filename),flen);
            //kxFile *fileXfer;
            //fileXfer=new kxFile(uin,GOT_FILE_REQUEST,seq,"", message);
            //fileXfer->show(); 
     				break;
     				}
     			case TCP_MSG_CHAT:
/*todo     				{
   					bool haveUser=FALSE;
   					
   					debug("chat: %d - %d",ENGINE->CONTACT->getContact(uin).uin, ENGINE->kxConfig.rejectChat);
                        if ((ENGINE->CONTACT->getContact(uin).uin==0 && ENGINE->kxConfig.rejectChat) || (ENGINE->currentStatus!=STATUS_FFC && ENGINE->currentStatus!=STATUS_ONLINE) ) 
                      	{
                      	  debug("reject chat !");
                         	  
                      	  QString tmp;
                      	  if (!(ENGINE->currentStatus!=STATUS_FFC && ENGINE->currentStatus!=STATUS_ONLINE))
                      	    tmp=i18n("User not accept chat from user that are not in his contact list!");
                      	  else
                      	    tmp.sprintf("User is %s:\n\r%s",ENGINE->CONTACT->status2str(ENGINE->currentStatus),
                      	      ENGINE->getAwayMessage(ENGINE->currentStatus).latin1());
                          sendChatReject(uin,seq,tmp.latin1(), _ks );	  
                      	  return;
                      	}	  		
                      	kxContactStruct cs;
                       	for (int t=0; t<ENGINE->CONTACT->count(); t++)
                       	{
                       		cs=ENGINE->CONTACT->getContact(t);
                       		if (cs.uin==uin)
                       		{
                       			haveUser=TRUE; 			
                       		}
                       	}
                       	if (!haveUser)
                       	{
                       		ENGINE->SlotAddUser(uin,"","","","",0);
                       		ENGINE->CONTACT->updateSocket(uin, _ks);
                       	}
                     kxChat2 *c=new kxChat2(uin, CHAT_GOT_REQUEST, seq, message);
//     				kxChatRequest *c=new kxChatRequest(uin, CHAT_GOT_REQUEST, message, sessionContact, seq, chatPort);
     				debug("show request");
     				if (c) c->show();
     				} */
     				break;
     			case TCP_MSG_READAWAY:
     				debug("got read Away");
     				send(type, _ks, uin);
     				break;
     			case TCP_MSG_READOCCUPIED:
     				debug("got read Occupied");
     				send(type, _ks, uin);
     				break;
     			case TCP_MSG_READNA:
     				debug("got read NA");
     				send(type, _ks, uin);
     				break;
     			case TCP_MSG_READDND:
     				debug("got read DND");
     				send(type, _ks, uin);
     				break;
     			case TCP_MSG_READFFC:
     				debug("got read FFC");
     				send(type, _ks, uin);
     				break;
     			case 0x03EE:
     				debug("got ??? TCP 3ee");
     				send(type, _ks, uin);
     				break;     			
     			case TCP_MSG_WAV: //must do !
            break;
     			case TCP_MSG_CONTACT:
     				debug("got contact exchange");
     				parseContacts(message, uin);
     				send(type, _ks, uin, seq);
     				break;
     			default:
     			  emit receivedUnknownStartPacket(a, uin, type);
     		}			
     		break;
   		case TCP_CANCEL:
   			debug("TCP cancel");
   			switch(type)
   			{
   				case TCP_MSG_CHAT:
   					status=1; // BAD !!
   					emit receivedChatAck(seq, status, uin, chatPort, message);
   					break;
   				default:
   				  emit receivedUnknownCancelPacket(a, uin, type);
   			}
   			break;
   	}
	}
}

/** parse this message */
void kxTCP::parseMessage(char *_message, int type,Q_UINT32 _uin ){
	if (type==TCP_MSG_MSG)
	{
    kxMessageStruct message;
    message.uin = _uin;                   
    message.type=MESSAGE_TYPE;
    message.send=FALSE;
  
    message.message=_message;    

    time_t t = time( NULL );
    tm *t2 = localtime( &t );

    message.online = 1;
    QDate tmpDate(t2->tm_year + 1900, t2->tm_mon + 1, t2->tm_mday);
    QTime tmpTime(t2->tm_hour,t2->tm_min);

    message.dateTime.setDate(tmpDate);
    message.dateTime.setTime(tmpTime);      
    
    debug("yupe: %d, sender: %d",message.online, message.uin);
    debug("message: [%s]",message.message.latin1());
    emit receivedMessage((UIN)_uin, message);
	}
	else
	{
	  kxMessageStruct message;
	  
    message.uin = _uin;                   
    message.type=MESSAGE_TYPE;
    message.send=FALSE;
  
    time_t t = time( NULL );
    tm *t2 = localtime( &t );

    message.online = 1;
    QDate tmpDate(t2->tm_year + 1900, t2->tm_mon + 1, t2->tm_mday);
    QTime tmpTime(t2->tm_hour,t2->tm_min);

    message.dateTime.setDate(tmpDate);
    message.dateTime.setTime(tmpTime);      
    
//  	char *tmp1=_message;
  	int tlen=strlen(_message);
    char tmpdelim[ 2 ];
    tmpdelim[ 0 ] = 0xFE;
    tmpdelim[ 1 ] = '\0';
    char *desc = kxicqStrSep( &_message, tmpdelim );
    char *_url = kxicqStrSep( &_message, "" );
    bool del=FALSE;
    if (tlen-1<=(int)strlen(desc)) 
    {
      _url=new char[2];
      _url[0]=0;
      del=TRUE;
    }      
    message.message=desc;
  	message.url=_url;
  	if (del) delete _url;
        
    emit receivedUrl((UIN)_uin, message);
	}
}

/** Send this packet */
int kxTCP::send(Q_UINT16 _type, kxSocket *_ks, Q_UINT32 _ruin, int _seq=0, int _command=0, const char *_message=NULL, int _port=0){
	debug("Send packet %d", _seq);	
	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);

	Q_UINT32 uin=ENGINE->ourUin, ip=ipToIcq(getAddr()),lip=ipToIcq(getIntAddr()), port=myServerSocket->getPort(), seq;
	if (_seq==0) seq=sequence++; else seq=_seq;
	if (_command==0) _command=TCP_ACK;
	Q_UINT16 version=0x03, command=_command, unknown=0x0, type=_type, len=1, status=0, commandType=0x0;
	Q_UINT8 tmp=0x04;
	debug("send IP: %d:%d",ip,port);
	QString msg="";
  if (_message==NULL)
  {
  	switch(_type)
  	{
  		case TCP_MSG_READAWAY:
   		case TCP_MSG_READOCCUPIED:
   		case TCP_MSG_READNA:
   		case TCP_MSG_READDND:
   		case TCP_MSG_READFFC:
   		case 0x3EE:
  	 		msg=ENGINE->getStatusMessages(_type);	
   			break;		
  		default:
  			msg=ENGINE->getStatusMessages(ENGINE->currentStatus);
  			break;
  	}
  }
  else
  {
  	msg=_message;
  }
	len=msg.length()+1;

	if (status==0)
	{
  	switch(ENGINE->currentStatus)
  	{
  		case STATUS_ONLINE:
  		case STATUS_INVISIBLE:
  		case STATUS_FFC:
  			status=TCP_STAT_ONLINE;
  			break;
  		case STATUS_AWAY:
  			status=TCP_STAT_AWAY;
  			break;
  		case STATUS_NA:
  			status=TCP_STAT_NA;
  			break;
  		case STATUS_DND:
  			status=TCP_STAT_DND;
  			break;
  		case STATUS_OCCUPIED:
  			status=TCP_STAT_OCCUPIED;
  			break;
  	}		
	}
//todo	ENGINE->SlotConvertOutGoingMessage(&msg);
	s << ( Q_UINT32 ) uin;
	s << ( Q_UINT16 ) version;	
	s << ( Q_UINT16 ) command;
	s << ( Q_UINT16 ) unknown;
	s << ( Q_UINT32 ) uin;	
	s << ( Q_UINT16 ) type;		
	s << ( Q_UINT16 ) len;
	debug("-=-=-=-MESSAGE: [%s]%d] =-=-=-=-=-",msg.latin1(),len);
	s.writeRawBytes(msg.latin1(),len);		
	s << ( Q_UINT32 ) ip;		
	s << ( Q_UINT32 ) lip;	
	s << ( Q_UINT32 ) port;	
	s << ( Q_UINT8 ) tmp;
	s << ( Q_UINT16 ) status;				
	int clen=0;
	s << ( Q_UINT16 ) commandType;
	if (_port>0)
	{
		debug(" send chat/file accept commands");
		Q_UINT16 len=0x1,  rp1=((_port & 0xFF) << 8) + ((_port >> 8) & 0xFF);
		Q_UINT16 zero=0x0;
		Q_UINT32 p1=(Q_UINT32)_port;
//		Q_UINT32 dx=0x0;
		
		s << ( Q_UINT16 ) len;	
		s << ( Q_UINT8  ) zero;
		s << ( Q_UINT16 ) rp1;
		s << ( Q_UINT16 ) zero;
		s << ( Q_UINT32 ) p1;	
		
		clen=11;
				
	}
	s << ( Q_UINT32 ) seq;		
	
	debug("send %d, %d",status, commandType);
	debug("ack Packet to send: command: %d, %Xd (%d)",seq, command,command);

	length=39+len+clen;
	addPacket2List(_ks, _ruin);
	_ks->enableWrite(TRUE);   	
	return sequence-1;
}

/**  */
void kxTCP::SlotWriteEvent(kxSocket *_ks)
{
	packetDef *p, *pc;
	for (int t=0; t<count(); t++)
	{
		p=getPacket(t);
		if (p->mySocket==_ks)
		{
			
			QByteArray *b=p->packet;
			QByteArray a;
			QDataStream s(a, IO_ReadWrite);
			s.setByteOrder(QDataStream::LittleEndian);
			s << (Q_UINT16) p->length;
			
			int ret=::send(_ks->socket(), a.data(), 2, 0);
			if (ret > 0)
			{
	QDataStream s1(*p->packet, IO_ReadWrite);
	s1.setByteOrder(QDataStream::LittleEndian);
	s1.device()->at(0);
	Q_UINT16 len=p->length;
	debug("[TCP]=========================[SEND]=======================");	
	debug("packet: len: %d",len);
	QString str,tmps;
	Q_UINT8 ttmp;
	for (int t1=0; t1<len; t1++)
	{	
		s1 >> (Q_UINT8 &)ttmp;		
		tmps.sprintf("[%02X] ", (Q_UINT8)ttmp);
		str.append(tmps.latin1());		
		if (str.length()>200) { debug(str.latin1()); str.remove(0,str.length()); }		
	}
	debug("%s", str.latin1());
	debug("[TCP]=========================[SEND]=======================");
  s1.device()->at(2);
				ret=::send(_ks->socket(), b->data(), p->length, 0);
				if (ret > 0 )
				{
					_ks->enableWrite(FALSE);
					debug("Send TCP ok !(%d, %d)", ret, p->length );
					deletePacket(t);
					bool found=FALSE;
					kxContactStruct cs;
					for (int t=0; t<ENGINE->CONTACT->count(); t++)
					{
						cs=ENGINE->CONTACT->getContact(t);
						if (cs.mySocket==_ks)
						{
							found=TRUE;
							debug("sock bound to user ! !");
						}
					}					
					if (found==FALSE)
					{
						debug("sock not bound, delete !");
						delete _ks;
					}
					else
					{
  					for (int t1=0; t1<count(); t1++)
  					{
  						pc=getPacket(t1);
  						
  						if (pc->mySocket==_ks)
  						{
  							_ks->enableWrite(TRUE);
  							t1=count();
  							continue;
  						}
  					}
  			  }
					return;
				}
			}
		}
	}
}

/** connect to this IP */
int kxTCP::connect(UIN uin)
{
	kxContactStruct p=ENGINE->CONTACT->getContact(uin);
  
	if (p.mySocket) return p.mySocket->socket();
	if (p.port==0 || p.ip==0) return -1;
	Q_UINT32 ip;	
	if (p.intIp) debug("Use Internal IP %d",p.realIp);
	if (p.intIp) ip=p.realIp; else ip=p.ip;
//  ip=p.realIp;
	Q_UINT32 l=icqToIp(ip);
/*	Q_UINT8 p1, p2, p3, p4;
	p1=l;
	l>>= 8;
	p2=l;
	l>>=8;
	p3=l;
	l>>=8;
	p4=l;
//	debug("IP: [%d] %02d.%02d.%02d.%02d:%d",p.ip, p1, p2, p3, p4, p.port);
	QString sip;
	sip.sprintf("%02d.%02d.%02d.%02d",p1, p2, p3, p4);*/
	kxSocket *_ks;
//	debug ("IP: %s:%d",ip.latin1(), p.port);
	_ks=new kxSocket(l, p.port);
	debug("new kxSocket");
	if (_ks->socket()!=-1)
	{
		_ks->enableRead(TRUE);
		QObject::connect(_ks,SIGNAL(readEvent(kxSocket *)), this, SLOT(SlotReadEvent(kxSocket *)));
		QObject::connect(_ks,SIGNAL(closeEvent(kxSocket *)), this, SLOT(SlotCloseEvent(kxSocket *)));
		QObject::connect(_ks,SIGNAL(writeEvent(kxSocket *)), this, SLOT(SlotWriteEvent(kxSocket *)));
		ENGINE->CONTACT->updateSocket(uin, _ks);
		sendHandshake(uin, _ks);
		return _ks->socket();
	}
	else
	{
		delete _ks;
	}
	return -1;
}

/** send the handshake */
void kxTCP::sendHandshake(UIN _ruin, kxSocket *_ks)
{
	debug("Send HandShake");	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);

	Q_UINT32  ip=ipToIcq(getAddr()), lip=ipToIcq(getIntAddr()),port=getPort(), uin=ENGINE->ourUin;
  Q_UINT16 version=0x02,zero=0;
  
	Q_UINT32 chatPort=0x0;
	Q_UINT8 hs=0xff, tcpc=0x04;	

	s << ( Q_UINT8  ) hs;
	s << ( Q_UINT16 ) version;	
 	s << ( Q_UINT16 ) zero;
	s << ( Q_UINT32 ) port;
	s << ( Q_UINT32 ) uin;
	s << ( Q_UINT32 ) ip;	
	s << ( Q_UINT32 ) lip;		
	s << ( Q_UINT8  ) tcpc;
	s << ( Q_UINT32 ) chatPort;	
	
//	debug("ack Packet to send: command: %Xd (%d)",command,command);

	length=1+2+2+4+4+4+4+1+4;
	addPacket2List(_ks, _ruin);

	_ks->enableWrite(TRUE);   	

}

/** Send a TCP message */
int kxTCP::sendMessage(UIN _uin, char *_message)
{
  if (strlen(_message)>3000) _message[30001]=0; // max len ! UDP=450, TCP=30000
  char *txt=new char[strlen(_message)+2];
  sprintf(txt,"%s",_message);
	return sendPacket(_uin, TCP_MSG_MSG, txt);		

}

/** Send a TCP URL */
int kxTCP::sendUrl(UIN _uin, char *_url, char *_message)
{
  if (strlen(_message)>30000) _message[300001]=0; // max len ! UDP=450, TCP=30000
	char *txt=new char[strlen(_url)+strlen(_message)+2];
	sprintf(txt, "%s%c%s",_message, 0xFE, _url);
	return sendPacket(_uin, TCP_MSG_URL, txt);		
}

/** Send a packet, URL or MSG */
int kxTCP::sendPacket(UIN _ruin, int _type,char *_message)
{
	debug("Send packet %d",_type);	
	kxContactStruct p=ENGINE->CONTACT->getContact(_ruin);

	if (p.mySocket==NULL) return -1;
	kxSocket *_ks=p.mySocket;
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);

	Q_UINT32 uin=ENGINE->ourUin, ip=ipToIcq(getAddr()), port=myServerSocket->getPort(), seq, lip=ipToIcq(getIntAddr());
	seq=sequence++;
	Q_UINT16 version=0x03, command=TCP_MESSAGE, unknown=0x0, type=_type, len=1, status=0x0, commandType=0x0;
	Q_UINT8 tmp=0x04;

	len=strlen(_message)+1;
	_message[len]=0;
  debug("send IP: %d:%d",ip,port);
	switch(ENGINE->currentStatus)
	{
		case STATUS_ONLINE:
		case STATUS_INVISIBLE:
		case STATUS_FFC:
			status=TCP_STAT_ONLINE;
			break;
		case STATUS_AWAY:
			status=TCP_STAT_AWAY;
			break;
		case STATUS_NA:
			status=TCP_STAT_NA;
			break;
		case STATUS_DND:
			status=TCP_STAT_DND;
			break;
		case STATUS_OCCUPIED:
			status=TCP_STAT_OCCUPIED;
			break;
	}		

	s << ( Q_UINT32 ) uin;
	s << ( Q_UINT16 ) version;	
	s << ( Q_UINT16 ) command;
	s << ( Q_UINT16 ) unknown;
	s << ( Q_UINT32 ) uin;	
	s << ( Q_UINT16 ) type;		
	s << ( Q_UINT16 ) len;
	s.writeRawBytes(_message,len);		
	s << ( Q_UINT32 ) ip;		
	s << ( Q_UINT32 ) lip;	
	s << ( Q_UINT32 ) port;	
	s << ( Q_UINT8 ) tmp;
	s << ( Q_UINT16 ) status;			
	
	if (_type==TCP_CHAT) commandType=0x0010;
	
	s << ( Q_UINT16 ) commandType;
	int clen=0;	
	if (_type==TCP_CHAT && status==0)
	{
		debug(" send chat commands");
		Q_UINT16 len=0x1, z=0x0;
		Q_UINT8 zero=0x0;
		Q_UINT32 dx=0x0;
		s << ( Q_UINT16 ) len;	
		s << ( Q_UINT8 ) zero;	
		s << ( Q_UINT16 ) z;	
		s << ( Q_UINT16 ) z;	
		s << ( Q_UINT32 ) dx;
		clen=11;
	}
	s << ( Q_UINT32 ) seq;		
	
	debug("send %d, %d",status, commandType);
	
	
	debug("Packet to send: command: %d, %X (%d)",seq,command,command);

	length=39+len+clen;
	debug("len: %d, %d, %d",length, len, clen);
	
	s.device()->at(0);
	debug("[TCP]=========================[tmp send]=======================");	
	debug("packet: len: %d",length);
	QString str,tmps;
	Q_UINT8 ttmp;
	for (Q_UINT16 t=0; t<length; t++)
	{	
		s >> (Q_UINT8 &)ttmp;		
		tmps.sprintf("[%02X] ", (Q_UINT8)ttmp);
		str.append(tmps.latin1());
		if (str.length()>200) { debug(str.latin1()); str.remove(0,str.length()); }				
	}
	debug("%s", str.latin1());
	debug("[TCP]=========================[end tmp send]=======================");
	
	
	addPacket2List(_ks, _ruin);

	_ks->enableWrite(TRUE);   	
	return sequence-1;

}

/**  */
void kxTCP::parseContacts(char *_msg, UIN _uin)
{
  char tmpdelim[ 2 ];
  tmpdelim[ 0 ] = 0xFE;
  tmpdelim[ 1 ] = '\0';

  char *p1,*p, *n = kxicqStrSep( &_msg, tmpdelim );
  debug("Contacts: %s", n);
  QList<kxAddContactStruct> list;
  kxAddContactStruct *c;

//  delete p;
  do
  {
  	p  = kxicqStrSep( &_msg, tmpdelim );
  	p1 = kxicqStrSep( &_msg, tmpdelim );
//        QString tmp=p1;
//todo        ENGINE->SlotConvertIncommingMessage(&tmp);
//        p1=tmp.latin1();
        //ENGINE->SlotConvertIncommingMessage((QString *)p1);
  	if (p)
  	{
  		debug("Ask to add: %s (%s)",p, p1);
   		c=new kxAddContactStruct;
  		c->nick=p1;
  		c->uin=atoi(p);
  		list.append(c);  		
  	}      
  }
  while(p);
  emit receivedAskAddContact(_uin,&list);
}

/** read the status message */
int kxTCP::sendReadStatus(UIN uin, Q_UINT16 status){
	char *message=new char[2];
	message[0]=0;
	Q_UINT16 type=0;
	switch(status)
 	{
 		case STATUS_ONLINE:
 		case STATUS_OFFLINE:
 			break;
 		case STATUS_AWAY:								
			type=TCP_MSG_READAWAY; 			
 			break;
 		case STATUS_NA:
			type=TCP_MSG_READNA; 			 		
 			break;					
 		case STATUS_DND:								
			type=TCP_MSG_READDND; 			 		
 			break;								
 		case STATUS_OCCUPIED:
			type=TCP_MSG_READOCCUPIED; 			
 			break;
 		case STATUS_FFC:								
			type=TCP_MSG_READFFC; 			 		
 			break;
 	}
 	if (type>0) sendPacket(uin, type, message);
 	return 0;
}


/** Accept chat */
int kxTCP::sendChatAccept(UIN _uin, Q_UINT32 _seq, int _port)
{
	kxContactStruct p=ENGINE->CONTACT->getContact(_uin);

	if (p.mySocket==NULL) return -1;
	kxSocket *_ks=p.mySocket;
	return send((Q_UINT16)TCP_CHAT, _ks, _uin, _seq, TCP_ACK, "", _port);
}

/** Accept chat */
int kxTCP::sendFileAccept(UIN _uin, Q_UINT32 _seq, int _port)
{
	kxContactStruct p=ENGINE->CONTACT->getContact(_uin);

	if (p.mySocket==NULL) return -1;
	kxSocket *_ks=p.mySocket;
	return sendFileAcceptAck( _ks, _uin, _seq, _port);
}


/** reject chat */
int kxTCP::sendChatReject(UIN _ruin, Q_UINT32 _seq, const char *_message, kxSocket *_k)
{
// send ack back...
  kxSocket *_ks;
  if (_k==NULL)
  {
	  kxContactStruct p=ENGINE->CONTACT->getContact(_ruin);
	  if (p.mySocket==NULL) return -1;
	  _ks=p.mySocket;
	}
	else
	{
	  debug("send to unknown");
	  _ks=_k;
	}
	
	debug("Send Chat reject %d, %d, %s",_ruin, _seq, _message);
	char *msg=new char[strlen(_message)];
	strcpy(msg,_message);	
		debug("Send file accept packet %d", _seq);	
	
	return send((Q_UINT16) TCP_CHAT, _ks, _ruin, _seq, TCP_CANCEL, msg);

}
/** reject chat */
int kxTCP::sendFileReject(UIN _uin, Q_UINT32 _seq, const char *_message, kxSocket *_k)
{
// send ack back...
  kxSocket *_ks=NULL;
  if (_k==NULL)
  {
	  kxContactStruct p=ENGINE->CONTACT->getContact(_uin);
	  if (p.mySocket==NULL) return -1;
	  _ks=p.mySocket;
	}
	else
	{
	  debug("send to unknown");
	  _ks=_k;
	}
	
	debug("Send Chat reject %d, %d, %s",_uin, _seq, _message);
	char *msg=new char[strlen(_message)+1];
	strcpy(msg,_message);	
	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);

	Q_UINT32 uin=ENGINE->ourUin;
	Q_UINT32 ip=ipToIcq(getAddr()), lip=ipToIcq(getIntAddr());
	Q_UINT32 port=myServerSocket->getPort();
	Q_UINT32 seq=_seq;
	Q_UINT16 version=0x03;
	Q_UINT16 command=TCP_ACK;
	Q_UINT16 unknown=0x0;
	Q_UINT16 type=TCP_FILE;
	Q_UINT16 len=strlen(_message)+1;
	Q_UINT16 status=TCP_STAT_REFUSE;
	Q_UINT16 commandType=0x00;
	Q_UINT8 tmp=0x04;
	debug("send IP: %d:%d",ip,port);
	

	s << ( Q_UINT32 ) uin;            //4
	s << ( Q_UINT16 ) version;	      //2
	s << ( Q_UINT16 ) command;        //2
	s << ( Q_UINT16 ) unknown;        //2
	s << ( Q_UINT32 ) uin;	          //4
	s << ( Q_UINT16 ) type;		        //2
	s << ( Q_UINT16 ) len;            //2   = 18
	s.writeRawBytes(msg,len);	//len	
	s << ( Q_UINT32 ) ip;		          //4
	s << ( Q_UINT32 ) lip;	            //4
	s << ( Q_UINT32 ) port;	          //4
	s << ( Q_UINT8 ) tmp;             //1
	s << ( Q_UINT16 ) status;				  //2   = 15
	int clen=0;
	s << ( Q_UINT16 ) commandType;    //2   = 2
 	debug(" send file reject commands");
 	Q_UINT16 p1=0, rp1=0 ; //((_port & 0xFF) << 8) + ((_port >> 8) & 0xFF);;
 	Q_UINT16 zero=0x0, zero1=0x1;
//		Q_UINT32 dx=0x0;
	
// 	s << ( Q_UINT16 ) len;	
// 	s << ( Q_UINT8  ) zero;
 	s << ( Q_UINT32 ) rp1;    //port
 	s << ( Q_UINT16 ) zero1;  //file length
 	s << ( Q_UINT8  ) zero;   // empty string
 	s << ( Q_UINT32 ) zero;		// file size =0 in ACK
 	s << ( Q_UINT32 ) p1;	    // port normal
		
 	clen=15;
 	
	s << ( Q_UINT32 ) seq;		
	
	debug("send %d, %d",status, commandType);
	debug("ack refuse Packet to send: command: %d, %Xd (%d)",seq, command,command);

	length=20+19+len+clen;
	addPacket2List(_ks, _uin);
	_ks->enableWrite(TRUE);   	
	return sequence-1;
	
}

/** chat request */
int kxTCP::sendChatRequest(UIN _uin, const char *_message)
{
	char *msg=new char[strlen(_message)+10];
	strcpy(msg, _message);
	msg[strlen(_message)]=0;
	debug("send Chat Request");
	return sendPacket(_uin, TCP_CHAT, msg);
}

/** delete this socket */
void kxTCP::deleteSocket(UIN uin){
	kxContactStruct p=ENGINE->CONTACT->getContact(uin);
	if (p.mySocket)
	{
		debug("delete socket");
		delete p.mySocket;
		ENGINE->CONTACT->updateSocket(uin, NULL);
	}
}

/** Send this packet */
int kxTCP::sendFileAcceptAck(kxSocket *_ks, Q_UINT32 _ruin, Q_UINT32 _seq=0, int _port=0){
	debug("Send file accept packet %d", _seq);	
	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);

	Q_UINT32 uin=ENGINE->ourUin;
	Q_UINT32 ip=ipToIcq(getAddr()), lip=ipToIcq(getIntAddr());
	Q_UINT32 port=myServerSocket->getPort();
	Q_UINT32 seq=_seq;
	Q_UINT16 version=0x02;
	Q_UINT16 command=TCP_ACK;
	Q_UINT16 unknown=0x0;
	Q_UINT16 type=TCP_FILE;
	Q_UINT16 len=1;
	Q_UINT16 status=TCP_STAT_ONLINE;
	Q_UINT16 commandType=0x0;
	Q_UINT8 tmp=0x04;
	debug("send IP: %d:%d",ip,port);
	
	char msg[2];
	msg[0]=0;
	len=1;

	s << ( Q_UINT32 ) uin;            //4
	s << ( Q_UINT16 ) version;	      //2
	s << ( Q_UINT16 ) command;        //2
	s << ( Q_UINT16 ) unknown;        //2
	s << ( Q_UINT32 ) uin;	          //4
	s << ( Q_UINT16 ) type;		        //2
	s << ( Q_UINT16 ) len;            //2   = 18
	s.writeRawBytes(msg,len);	//len	
	s << ( Q_UINT32 ) ip;		          //4
	s << ( Q_UINT32 ) lip;	            //4
	s << ( Q_UINT32 ) port;	          //4
	s << ( Q_UINT8  ) tmp;             //1
	s << ( Q_UINT16 ) status;				  //2   = 15

	s << ( Q_UINT16 ) commandType;    //2   = 2
 	debug(" send file accept commands");
 	Q_UINT16 p1=_port, rp1=((_port & 0xFF) << 8) + ((_port >> 8) & 0xFF);;
 	Q_UINT16 zero=0x0, zero1=0x01;
//		Q_UINT32 dx=0x0;
		
 	s << ( Q_UINT16 ) rp1;    //port
  s << ( Q_UINT16 ) zero; 	
 	s << ( Q_UINT16 ) zero1;  //file length
 	s << ( Q_UINT8  ) zero;   // empty string
 	s << ( Q_UINT32 ) zero;		// file size =0 in ACK
 	s << ( Q_UINT32 ) p1;	    // port normal
		
 	
	s << ( Q_UINT32 ) seq;		
	
	debug("send %d, %d",status, commandType);
	debug("ack Packet to send: command: %d, %Xd (%d)",seq, command,command);
         
	length=4+2+2+2+4+2+2+4+4+4+1+2+2+ 2+2+2+1+4+4+4+len;
	addPacket2List(_ks, _ruin);
	_ks->enableWrite(TRUE);   	
	return sequence-1;
}
/** chat request */
int kxTCP::sendFileRequest(UIN _uin, const char *_message, const char *_file, Q_UINT32 _size)
{
	debug("Send file request packet");	
	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);

	Q_UINT32 uin=ENGINE->ourUin;
	Q_UINT32 ip=ipToIcq(getAddr()), lip=ipToIcq(getIntAddr());
	Q_UINT32 port=myServerSocket->getPort();	
  Q_UINT32 seq=sequence++;
	Q_UINT16 version=0x02;
	Q_UINT16 command=TCP_MESSAGE;
	Q_UINT16 unknown=0x0;
	Q_UINT16 type=TCP_FILE;
	Q_UINT16 len=1;
	Q_UINT16 status=TCP_STAT_ONLINE;
	Q_UINT16 commandType=0x0010;
	Q_UINT8 tmp=0x04;
	debug("send IP: %d:%d",ip,port);
	
	char *msg;
  msg=new char[strlen(_message)+2];
	msg[len+1]=0;
	len=strlen(_message)+1;
  strcpy(msg,_message);

	s << ( Q_UINT32 ) uin;            //4
	s << ( Q_UINT16 ) version;	      //2
	s << ( Q_UINT16 ) command;        //2
	s << ( Q_UINT16 ) unknown;        //2
	s << ( Q_UINT32 ) uin;	          //4
	s << ( Q_UINT16 ) type;		        //2
	s << ( Q_UINT16 ) len;            //2   = 18
	s.writeRawBytes(msg,len);	//len	
	s << ( Q_UINT32 ) ip;		          //4
	s << ( Q_UINT32 ) lip;	            //4
	s << ( Q_UINT32 ) port;	          //4
	s << ( Q_UINT8 ) tmp;             //1
	s << ( Q_UINT16 ) status;				  //2   = 15
	s << ( Q_UINT16 ) commandType;    //2   = 2

  Q_UINT16 fnl=0;
  Q_UINT32 flen=_size;
  fnl=strlen(_file)+1;
  msg=new char[strlen(_file)+2];
	msg[fnl]=0;

  strcpy(msg,_file);
 	Q_UINT16 p1=0x0; //_port, rp1=((_port & 0xFF) << 8) + ((_port >> 8) & 0xFF);;
  debug("File size: %d, Filename: %s",flen, msg); 			
  s << (Q_UINT16 )p1;
  s << (Q_UINT16 )p1;  
  s << (Q_UINT16 )fnl;
  s.writeRawBytes(msg, fnl);
  s << (Q_UINT32 )flen;      
  s << (Q_UINT32 )p1;
		
	s << ( Q_UINT32 ) seq;		

	length=4+2+2+2+4+2+2+4+4+4+1+2+2+2+2+2+fnl+4+4+4+len;

	kxContactStruct p=ENGINE->CONTACT->getContact(_uin);
	if (p.mySocket==NULL) return -1;
	kxSocket *_ks=p.mySocket;

	addPacket2List(_ks, _uin);
	_ks->enableWrite(TRUE);   	
	return sequence-1;

}

kxServerSocket* kxTCP::getNextFreePort()
{
  kxServerSocket *tmp;
  bool done=FALSE;
  tmp=new kxServerSocket(freePort);
	while (tmp->socket()==-1)
	{
	  debug("error: %d, try next",freePort);
		delete tmp;
		freePort++;
		if (freePort>maxPort)
		{
		  freePort=minPort;
		  if (done) return NULL;
		  done=TRUE;
		}		  
		tmp=new kxServerSocket(freePort);		
	}
	return tmp;
}
/** chat request */
int kxTCP::sendRandomInfoRequest(UIN _uin)
{
	debug("Send random request packet");	
	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::LittleEndian);

	Q_UINT32 uin=ENGINE->ourUin;
	Q_UINT32 ip=ipToIcq(getAddr()), lip=ipToIcq(getIntAddr());
	Q_UINT32 port=myServerSocket->getPort();
	Q_UINT32 seq=sequence++;
	Q_UINT16 version=0x03;
	Q_UINT16 command=TCP_MESSAGE;
	Q_UINT16 unknown=0x0;
	Q_UINT16 type=0x3EE;
	Q_UINT16 len=1;
	Q_UINT16 status=TCP_STAT_ONLINE;
	Q_UINT16 commandType=0x0010;
	Q_UINT8 tmp=0x04;
	debug("send IP: %d:%d",ip,port);
	
	char *msg;
  msg=new char[2];
	msg[0]=0;
	len=1;
  
	s << ( Q_UINT32 ) uin;            //4
	s << ( Q_UINT16 ) version;	      //2
	s << ( Q_UINT16 ) command;        //2
	s << ( Q_UINT16 ) unknown;        //2
	s << ( Q_UINT32 ) uin;	          //4
	s << ( Q_UINT16 ) type;		        //2
	s << ( Q_UINT16 ) len;            //2   = 18
	s.writeRawBytes(msg,len);	//len	
	s << ( Q_UINT32 ) ip;		          //4
	s << ( Q_UINT32 ) lip;	            //4
	s << ( Q_UINT32 ) port;	          //4
	s << ( Q_UINT8 ) tmp;             //1
	s << ( Q_UINT16 ) status;				  //2   = 15
	s << ( Q_UINT16 ) commandType;    //2   = 2
 	
	s << ( Q_UINT32 ) seq;		

	length=18+21+len;

	kxContactStruct p=ENGINE->CONTACT->getContact(_uin);
	if (p.mySocket==NULL) return -1;
	kxSocket *_ks=p.mySocket;

	addPacket2List(_ks, _uin);
	_ks->enableWrite(TRUE);   	
	return sequence-1;
}
int kxTCP::sendContacts(UIN _uin,QList<kxAddContactStruct> *lst)
{
	debug("Send CONTATCS");	

  QString t;
	QCString msg;
	
	QByteArray data;
	QDataStream d(data, IO_ReadWrite);	

	msg.sprintf("%d",lst->count());
  d.writeRawBytes(msg.data(), msg.length());
	kxAddContactStruct *li;
	for (int t1=0; t1<(int)lst->count(); t1++)
	{
	  li=lst->at(t1);
	  d << (Q_UINT8) 0xFE;
	  d.writeRawBytes(QString().setNum(li->uin),(QString().setNum(li->uin)).length());
	  d << (Q_UINT8) 0xFE;
	  d.writeRawBytes(li->nick.latin1(),li->nick.length());
	}
	d << (Q_UINT8) 0xFE;
	d << (Q_UINT8) 0x00;	
	
  char *txt=new char[data.size()+2];
  sprintf(txt,"%s",data.data());
	return sendPacket(_uin, TCP_MSG_CONTACT, txt);		
	
}
