#ifndef KXSEND_H
#define KXSEND_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qstring.h>
#include <kxmessage.h>
#include <v2_codes.h>
#include <qtimer.h>
#include <qlist.h>
class kxAddContactStruct;


class kxSend : public QObject
{
  Q_OBJECT
public:
  kxSend(int, int, UIN, QString, QString, bool);
  kxSend(int, UIN, QList<kxAddContactStruct> *, bool);
  
  QTimer sendTimer;
  kxMessageStruct message;
  int sendAck;
  int sendSeq;
  QList<kxAddContactStruct> *contactList;
  
  int type; // 1 = UDP, 0 = TCP;
  
  UIN uin;
  void init();    
  void sendToServer();
  void sendToClient();
  void cancelSend();  
  
public slots:
  void SlotTimeout();
  void SlotReceivedAck(int); 
  
signals:
  void SignalSendToClientError(int);
  void SignalSendToClientOk(int);
  void SignalSendToServerError(int);
  void SignalSendToServerOk(int);

};

#endif

