#include <sys/time.h>
#include "kxsend.h"
#include <kxengine.h>
#include <kxudp.h>
#include <kxtcp.h>

kxSend::kxSend(int _type, int _sendSeq, UIN _uin, QString _msg, QString _url, bool _server) : QObject()
{
  message.type=_type;
  message.send=TRUE;
  message.uin=_uin;
  message.message=_msg;
  message.url=_url;
  sendSeq=_sendSeq;
  uin=_uin;
  type=_server ? 1 : 0;
  init();

}
kxSend::kxSend(int _sendSeq,UIN _uin, QList<kxAddContactStruct> *_cl, bool _server)
{
  message.type=CONTACTS_TYPE;
  message.send=TRUE;
  message.uin=_uin;
  uin=_uin;  
  type=_server ? 1 : 0;  
  sendSeq=_sendSeq;  
  contactList=_cl;
  init();
}
void kxSend::init()
{  
  time_t t = time( NULL );
  tm *t2 = localtime( &t );

  QDate tmpDate(t2->tm_year + 1900, t2->tm_mon + 1, t2->tm_mday);
  QTime tmpTime(t2->tm_hour,t2->tm_min);

  message.dateTime.setDate(tmpDate);
  message.dateTime.setTime(tmpTime);      
  message.online=TRUE;

  QObject::connect(&sendTimer, SIGNAL(timeout()), this, SLOT(SlotTimeout()));  
  QObject::connect(ENGINE->UDP, SIGNAL(receivedAck(int)), this, SLOT(SlotReceivedAck(int)));
  QObject::connect(ENGINE->TCP, SIGNAL(receivedAck(int)), this, SLOT(SlotReceivedAck(int)));  
  
  if (type)
  {
    sendToServer();
  }
  else
  {
    sendToClient();
  }
}
   
void kxSend::sendToServer()
{
  if (message.type==MESSAGE_TYPE)
  {
    sendAck=ENGINE->UDP->sendMessage(uin, (char*)message.message.latin1());
  }
  else
  {
    if (message.type==URL_TYPE)
    {
      sendAck=ENGINE->UDP->sendUrl(uin, (char*)message.url.latin1(), (char*)message.message.latin1());
    }
    else
    {
      if (message.type==CONTACTS_TYPE)
      {
        sendAck=ENGINE->UDP->sendContacts(uin, contactList);        
      }
    }
  }
  type=1;
  sendTimer.start(30000);
}
void kxSend::sendToClient()
{
  int sock;
  sock=ENGINE->TCP->connect(uin);
  if (sock>0)
  {
    if (message.type==MESSAGE_TYPE)
    {
      sendAck=ENGINE->TCP->sendMessage(uin, (char*)message.message.latin1());
    }
    else
    {
      if (message.type==URL_TYPE)
      {
        sendAck=ENGINE->TCP->sendUrl(uin, (char*)message.url.latin1(), (char*)message.message.latin1());
      }
      else
      {
        if (message.type==CONTACTS_TYPE)
        {
          sendAck=ENGINE->TCP->sendContacts(uin, contactList);
        }
      }
    }
    type=0;
    sendTimer.start(30000);
  }
  else
  {
    sendToServer();
  }
}
void kxSend::SlotTimeout()
{
  sendTimer.stop();
  if (type)
    emit SignalSendToServerError(sendSeq);
  else
    emit SignalSendToClientError(sendSeq);
}
void kxSend::cancelSend()
{                  
  delete this;
}
void kxSend::SlotReceivedAck(int _ack)
{
  if (_ack==sendAck)
  {
    if (message.type==MESSAGE_TYPE)
      ENGINE->MESSAGE->newMessage(uin, message);
    else
      if (message.type==URL_TYPE) 
        ENGINE->MESSAGE->newUrl(uin, message);
    if (type) 
      emit SignalSendToServerOk(sendSeq);
    else  
      emit SignalSendToClientOk(sendSeq);      
  }
}
