#include "kxmessage.h"
#include <qstring.h>
#include <qtextstream.h>
#include <qregexp.h>
#include "kxengine.h"
#include <kxcontact.h>
#include <kstddirs.h>

kxMessage::kxMessage()
{
  QString fileName=locateLocal("appdata","messages.kxicq2");
  file.setName(fileName);
  file.open(IO_ReadWrite);
  readMessages();  
}

void kxMessage::readMessages()
{
  if (file.size()<1)
  {
    QString size;
    size=makeMessageCount(0);
    QTextStream t ( &file );
    t << size;
    file.at(0);
  }
  QTextStream t ( &file );
  QString size;
  size = t.readLine();
  QString key, val;
  split(size, &key, &val);
  int cnt=1,pos;
  QString buf,tmpStr;
  while(!t.eof())
  {
    pos=file.at();
    buf=t.readLine();
    tmpStr.sprintf("[Message %d]",cnt);
    if (buf==tmpStr)
    {
      cnt++;
      buf=t.readLine();
      split(buf, &key, &val);
      if (key=="Options")
      {
        kxMessageInfoStruct *info;
        info=new kxMessageInfoStruct;        
        info->read=val.mid(0,1).toInt();
        info->type=val.mid(2,2).toInt();
        info->send=val.mid(5,2).toInt();
        info->pos=pos;
        buf=t.readLine();
        split(buf,&key, &val);
        if (key=="Uin")
        {
          info->uin=val.toUInt();
          messageList.append(info);
          if (!info->send && !info->read) ENGINE->CONTACT->addMessage(val.toUInt());
        }
        else
        {
          debug("Error in message, UIN not found on right place !!");
          delete info;
        }        
      }
      else
      {
        debug("Error in message !!");
      }
    }
  }
}

QString kxMessage::makeMessageCount(int _num)
{
  QString msg;
  msg.sprintf("Messages=%d",_num);
  for (int t=msg.length(); t<19; t++)
  {
    msg+=' ';
  }
  msg+='\n';
  return msg;  
}

void kxMessage::split(QString str, QString *key, QString *val)
{
  int pos=str.find('=');
  *key=str.mid(0,pos);
  *val=str.mid(pos+1,str.length());
}
  
void kxMessage::newMessage(UIN _uin,  kxMessageStruct _msg)
{
  file.at(0);
  QString size;
  int num=messageList.count()+1;
  size=makeMessageCount(num);
  QTextStream tw ( &file );
  tw << size;  
  file.at(file.size());
  QTextStream t ( &file );
  kxMessageInfoStruct *info;
  info=new kxMessageInfoStruct;
  info->uin=_uin;
  info->pos=file.at();
  info->read=_msg.send==TRUE ? TRUE : FALSE;
  info->type=MESSAGE_TYPE;
  info->send=_msg.send;
  
  messageList.append(info);
  int p=messageList.at();
  
  QString buf;
  
  buf.sprintf("[Message %d]\n",num);
  t << buf;
  buf.sprintf("Options=%01d %02d %01d %01d\n",info->read, MESSAGE_TYPE, info->send, _msg.online );
  t << buf;
  buf.sprintf("Uin=%d\n",_uin);
  t << buf;
  buf.sprintf("DateTime=%02d-%02d-%04d %02d:%02d\n",_msg.dateTime.date().day()
                                                   ,_msg.dateTime.date().month()
                                                   ,_msg.dateTime.date().year()
                                                   ,_msg.dateTime.time().hour()
                                                   ,_msg.dateTime.time().minute() );
  t << buf;

  _msg.message.replace(QRegExp("\n"),"\\n");
  _msg.message.replace(QRegExp("\r"),"\\r");      

  t << "Message="+_msg.message+"\n";

  file.flush();  
  if (!_msg.send)
  {
    ENGINE->CONTACT->addMessage(_uin);
    emit SignalMessagePosSend(info->uin,p);    
  }
  emit SignalMessagePos(info->uin,p);
  
}
void kxMessage::newUrl(UIN _uin,  kxMessageStruct _msg)
{
  debug("New Message: %d, [%s]",_uin, _msg.message.latin1());
  file.at(0);
  QString size;
  int num=messageList.count()+1;
  size=makeMessageCount(num);
  QTextStream tw ( &file );
  tw << size;  
  file.at(file.size());
  QTextStream t ( &file );
  kxMessageInfoStruct *info;
  info=new kxMessageInfoStruct;
  info->uin=_uin;
  info->pos=file.at();
  info->read=_msg.send==TRUE ? TRUE : FALSE;
  info->type=URL_TYPE;
  info->send=_msg.send;
  
  messageList.append(info);
  if (!_msg.send) ENGINE->CONTACT->addMessage(_uin);
  
  QString buf;
  
  buf.sprintf("[Message %d]\n",num);
  t << buf;
  buf.sprintf("Options=%01d %02d %01d %01d\n",info->read, URL_TYPE, info->send, _msg.online );
  t << buf;
  buf.sprintf("Uin=%d\n",_uin);
  t << buf;
  buf.sprintf("DateTime=%02d-%02d-%04d %02d:%02d\n",_msg.dateTime.date().day()
                                                   ,_msg.dateTime.date().month()
                                                   ,_msg.dateTime.date().year()
                                                   ,_msg.dateTime.time().hour()
                                                   ,_msg.dateTime.time().minute() );
  t << buf;
 
  _msg.message.replace(QRegExp("\n"),"\\n");
  _msg.message.replace(QRegExp("\r"),"\\r");      
  t << "Message="+_msg.message+"\n";
    
  _msg.url.replace(QRegExp("\n"),"\\n");
  _msg.url.replace(QRegExp("\r"),"\\r");      
  t << "Url="+_msg.url+"\n";
  
  file.flush();  
}
void kxMessage::newAuthReq(UIN _uin,  kxMessageStruct _msg)
{
  file.at(0);
  QString size;
  int num=messageList.count()+1;
  size=makeMessageCount(num);
  QTextStream tw ( &file );
  tw << size;  
  file.at(file.size());
  QTextStream t ( &file );
  kxMessageInfoStruct *info;
  info=new kxMessageInfoStruct;
  info->uin=_uin;
  info->pos=file.at();
  info->read=_msg.send==TRUE ? TRUE : FALSE;
  info->type=REQUEST_TYPE;
  info->send=_msg.send;
  
  messageList.append(info);
  int p=messageList.at();
  
  QString buf;
  
  buf.sprintf("[Message %d]\n",num);
  t << buf;
  buf.sprintf("Options=%01d %02d %01d %01d %01d 0\n",info->read, REQUEST_TYPE, info->send, _msg.online, _msg.auth_request );
  t << buf;
  buf.sprintf("Uin=%d\n",_uin);
  t << buf;
  buf.sprintf("DateTime=%02d-%02d-%04d %02d:%02d\n",_msg.dateTime.date().day()
                                                   ,_msg.dateTime.date().month()
                                                   ,_msg.dateTime.date().year()
                                                   ,_msg.dateTime.time().hour()
                                                   ,_msg.dateTime.time().minute() );
  t << buf;

  _msg.message.replace(QRegExp("\n"),"\\n");
  _msg.message.replace(QRegExp("\r"),"\\r");      

  t << "Message="+_msg.message+"\n";
  t << "Nick="+_msg.nick+"\n";
  t << "FirstName="+_msg.firstName+"\n";
  t << "LastName="+_msg.lastName+"\n";
  t << "EMail="+_msg.email+"\n";  

  file.flush();  
  if (!_msg.send)
  {
    ENGINE->CONTACT->addMessage(_uin);
    emit SignalMessagePosSend(info->uin,p);     
  }
  emit SignalMessagePos(info->uin,p);
  
}
void kxMessage::newAdded(UIN _uin,  kxMessageStruct _msg)
{
  file.at(0);
  QString size;
  int num=messageList.count()+1;
  size=makeMessageCount(num);
  QTextStream tw ( &file );
  tw << size;  
  file.at(file.size());
  QTextStream t ( &file );
  kxMessageInfoStruct *info;
  info=new kxMessageInfoStruct;
  info->uin=_uin;
  info->pos=file.at();
  info->read=_msg.send==TRUE ? TRUE : FALSE;
  info->type=ADDED_TYPE;
  info->send=_msg.send;
  
  messageList.append(info);
  int p=messageList.at();
  
  QString buf;
  
  buf.sprintf("[Message %d]\n",num);
  t << buf;
  buf.sprintf("Options=%01d %02d %01d %01d\n",info->read, ADDED_TYPE, info->send, _msg.online );
  t << buf;
  buf.sprintf("Uin=%d\n",_uin);
  t << buf;
  buf.sprintf("DateTime=%02d-%02d-%04d %02d:%02d\n",_msg.dateTime.date().day()
                                                   ,_msg.dateTime.date().month()
                                                   ,_msg.dateTime.date().year()
                                                   ,_msg.dateTime.time().hour()
                                                   ,_msg.dateTime.time().minute() );
  t << buf;

  
  t << "Nick="+_msg.nick+"\n";
  t << "FirstName="+_msg.firstName+"\n";
  t << "LastName="+_msg.lastName+"\n";
  t << "EMail="+_msg.email+"\n";  

  file.flush();  
  if (!_msg.send)
  {
    ENGINE->CONTACT->addMessage(_uin);
    emit SignalMessagePosSend(info->uin,p);        
  }
  emit SignalMessagePos(info->uin,p);

}


kxMessageStruct kxMessage::getMessage(int _pos)
{
  int pos=messageList.at(_pos)->pos;
  file.at(pos);
  QTextStream t ( &file );
  QString buf,tmpStr;
  QString key,val;
  kxMessageStruct message;
  message.uin=0;

  buf=t.readLine();
  buf=t.readLine();
  split(buf, &key, &val);
  if (key=="Options")
  {
    kxMessageInfoStruct *info;
    info=new kxMessageInfoStruct;        
    message.type=val.mid(2,2).toInt();
    message.send=val.mid(5,2).toInt();
    message.online=val.mid(8,1).toInt();
    if (message.type==REQUEST_TYPE)
    {
      message.auth_request=val.mid(10,1).toInt();
      message.didAuthorize=val.mid(12,1).toInt();
    }
      
    buf=t.readLine();
    split(buf,&key, &val);
    message.uin=val.toUInt();
    buf=t.readLine();
    split(buf,&key, &val);
    int mo,d,y;
    int m,h;

    d = val.mid(0,2).toInt();
    mo= val.mid(3,2).toInt();
    y = val.mid(6,4).toInt();
    m = val.mid(14,2).toInt();
    h = val.mid(11,2).toInt();    

    QDate date(y,mo,d);
    QTime time(h,m);

    message.dateTime.setDate(date);
    message.dateTime.setTime(time);

    if (message.type==MESSAGE_TYPE || message.type==URL_TYPE || message.type==REQUEST_TYPE)
    {
      buf=t.readLine();
      split(buf,&key, &val);      
      message.message=parseEnters(val);
//      debug("Message: %s",message.message.latin1());
    }
    if (message.type==URL_TYPE)
    {
      buf=t.readLine();
      split(buf,&key, &val);
      message.url=val;
//      debug("Url: %s",message.url.latin1());      
    }
    if (message.type==REQUEST_TYPE || message.type==ADDED_TYPE)
    {
      buf=t.readLine();
      split(buf,&key, &val);
      message.nick=val;
      buf=t.readLine();
      split(buf,&key, &val);
      message.firstName=val;
      buf=t.readLine();
      split(buf,&key, &val);
      message.lastName=val;
      buf=t.readLine();
      split(buf,&key, &val);
      message.email=val;    
    }      
  }
  return message;
}
void kxMessage::setRead(int _pos,bool _read)
{
  int pos=messageList.at(_pos)->pos;
  file.at(pos);
  QTextStream t ( &file );
  QString buf,tmpStr;
  QString key,val;
  
  buf=t.readLine();
  int pp=file.at();
  buf=t.readLine();
  split(buf,&key,&val);
  val[0]=_read==TRUE ? '1' : '0';
  file.at(pp);
  QString buf1;
  buf1.sprintf("Options=%s\n",val.latin1());
  t << buf1;

  file.flush();
  messageList.at(_pos)->read=_read;
  if (_read) ENGINE->CONTACT->removeMessage(  messageList.at(_pos)->uin);
  else ENGINE->CONTACT->addMessage(  messageList.at(_pos)->uin);
}
int kxMessage::giveFirstUnreadMessage(UIN _uin)
{
  kxMessageInfoStruct *tmp;
  for (tmp = messageList.first(); tmp!=0; tmp = messageList.next() )
  {
    if (tmp->uin == _uin && tmp->type==MESSAGE_TYPE)
    {
      if (tmp->read == 0)
      {
        return messageList.at();
      }
    }
  }
  return -1;
}
int kxMessage::giveFirstUnread(UIN _uin)
{
  kxMessageInfoStruct *tmp;
  if (_uin==0)
  {
    for (tmp = messageList.first(); tmp!=0; tmp = messageList.next() )
    {
      if (!ENGINE->CONTACT->isUinInList(tmp->uin) )
      {
        if (tmp->read == 0)
        {
          return messageList.at();
        }
      }
    }
  }
  else
  {
    for (tmp = messageList.first(); tmp!=0; tmp = messageList.next() )
    {
      if (tmp->uin == _uin )
      {
        if (tmp->read == 0)
        {
          return messageList.at();
        }
      }
    }
  }  
  return -1;
}
int kxMessage::giveLastUnread(UIN _uin)
{
  kxMessageInfoStruct *tmp;
  if (_uin==0)
  {
    for (tmp = messageList.last(); tmp!=messageList.first(); tmp = messageList.prev() )
    {
      if (!ENGINE->CONTACT->isUinInList(tmp->uin) )
      {
        if (tmp->read == 0)
        {
          return messageList.at();
        }
      }
    }
  }
  else
  {
    for (tmp = messageList.last(); tmp!=messageList.first(); tmp = messageList.prev() )
    {
      if (tmp->uin == _uin )
      {
        if (tmp->read == 0)
        {
          return messageList.at();
        }
      }
    }
  }  
  return -1;
}

int kxMessage::giveFirstAllUnread()
{
  kxMessageInfoStruct *tmp;
  for (tmp = messageList.first(); tmp!=0; tmp = messageList.next() )
  {
    if (tmp->read == 0)
    {
      return messageList.at();
    }
  }
  return -1;
}

int kxMessage::countAllUnread()
{
  kxMessageInfoStruct *tmp;
  int count=0;
  for (tmp = messageList.first(); tmp!=0; tmp = messageList.next() )
  {
    if (tmp->read == 0)
      count++;
  }
  return count;
}
int kxMessage::countUnreadMessages(UIN _uin)
{
  int count =0;
  kxMessageInfoStruct *tmp;
  if (_uin==0)
  {
    for (tmp = messageList.first(); tmp!=0; tmp = messageList.next() )
    {
      if (!ENGINE->CONTACT->isUinInList(tmp->uin) )
      {
        if (tmp->read == 0)
        {
          count++;
        }
      }
    }
  }
  else
  {
    for (tmp = messageList.first(); tmp!=0; tmp = messageList.next() )
    {
      if (tmp->uin == _uin )
      {
        if (tmp->read == 0)
        {
          count++;
        }
      }
    }
  }  
  return count;
}
bool kxMessage::isAnyMessage(UIN _uin)
{
  kxMessageInfoStruct *tmp;
  if (_uin==0)
  {
    for (tmp = messageList.first(); tmp!=0; tmp = messageList.next() )
    {
      if (!ENGINE->CONTACT->isUinInList(tmp->uin) )
      {
          return TRUE;
      }
    }
  }
  else
  {
    for (tmp = messageList.first(); tmp!=0; tmp = messageList.next() )
    {
      if (tmp->uin == _uin )
      {
          return TRUE;
      }
    }
  }  
  return FALSE;
}
bool kxMessage::isUnreadMessage(UIN _uin)
{
  kxMessageInfoStruct *tmp;
  if (_uin==0)
  {
    for (tmp = messageList.first(); tmp!=0; tmp = messageList.next() )
    {
      if (!ENGINE->CONTACT->isUinInList(tmp->uin) )
      {
        if (tmp->read == 0)
        {
          return TRUE;
        }
      }
    }
  }
  else
  {
    for (tmp = messageList.first(); tmp!=0; tmp = messageList.next() )
    {
      if (tmp->uin == _uin )
      {
        if (tmp->read == 0)
        {
          return TRUE;
        }
      }
    }
  }  
  return FALSE;
}

QString kxMessage::parseEnters(QString _str)
{
  QString tmp;
  
  for (Q_UINT16 t=0; t<_str.length(); t++)
  {
    if (_str[t]=='\\')
    {
      if (_str[t+1]=='n')
      {
        tmp+='\n';
        t++;
      }
      else if ( _str[t+1]=='r')
      {
        tmp+='\r';
        t++;
      }
      else
        tmp+=_str[t];
    }
    else
    {
      tmp+=_str[t];
    }
  }
  return tmp;
}
int kxMessage::getType(int _p)
{
  kxMessageInfoStruct *s=NULL;
  s=messageList.at(_p);
  if (s) return s->type;
  return -1;
}
