/***************************************************************************
                          kxcontact.h  -  description                              
                             -------------------                                         
    begin                : Sun Jun 6 1999                                           
    copyright            : (C) 1999 by Herwin Jan Steehouwer                         
    email                : steehouwer@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KXCONTACT_H
#define KXCONTACT_H

#include <kxsock.h>
#include <qlist.h>
//#include "v2_codes.h"
#include "ksimpleconfig.h"
#include "qstring.h"
#include "qobject.h"
#include <qtimer.h>

#define UIN Q_UINT32

#define contacts kxContact::getContactPointer()

/**
	holds a contact
*/

struct kxContactStruct
{
		bool alwaysServer;
    char nick[ 60 ];
    unsigned int uin;
    unsigned int status;
    bool invisible;
    bool visible;
		Q_UINT32 ip;
		Q_UINT32 realIp;
    Q_UINT16 port;
    char *awaymsg;
		kxSocket *mySocket;
		QByteArray incomming;
		Q_UINT16 length;
		bool waitAuth;
		bool authorized;
		bool ignore;
		int unreadMessages;
		bool onlineNotify;
		bool show;
		bool ignoreAway;
		bool intIp;
		
		Q_UINT8 mode;
		Q_UINT32 tcpVersion;
		QWidget *sendWidget;
};


class kxUpdateContactNick : public QObject
{
  Q_OBJECT
public:

  kxUpdateContactNick(UIN);

  UIN uin;  
  QTimer waitTimer;
  int seq;
    
public slots:

  void SlotTimeout();
  void SlotInfoReply(Q_UINT16 seq, UIN uin, char *nick, char *first, char *last, char *email, Q_UINT8 auth);  
  
signals:
  void SignalChangeNick(UIN, QString);
};
    

/**Handles the contact file
  *@author Herwin Jan Steehouwer
  */

class kxContact : public QObject {
  Q_OBJECT
public: 
	kxContact();
	~kxContact();

  /** set Visible */
  void setVisible(UIN _uin, int _stat);
  /** set Online Notifycation*/
  void setOnlineNotify(UIN _uin, bool _stat);

  /** set Invisible */
  void setInvisible(UIN _uin, int _stat);
  /** Update a Contact */
  void updateContact(UIN uin, unsigned int status, Q_UINT32 ip=0, Q_UINT16 port=0, Q_UINT8 mode=0, Q_UINT32 realIp=0,Q_UINT32 tcpVersion=0x0);
  /** This Updates the statusof a Contact in memory */
  void updateStatus(UIN uin, unsigned int status, Q_UINT32 ip=0, Q_UINT16 port=0);
  /** This Updates the status of a Contact in memory */
  void updateStatus(int _t, unsigned int status);

/**
	Must run the first time to load the Contact file
*/	
	void init();
/**
	return the amount of Contact in memory and File
*/
	int count();
	int countShow();
// count the ifnore list	
	int countIgnore();
  QString getCountry(int t);
/**
	Add a contact
*/
	bool add(const char *, UIN , bool, bool show=TRUE);
	
	bool ignoreAdd(UIN, char *);
/**
	remove the Contact UIN
*/
	void remove(UIN);
	void ignoreRemove(UIN);
/**
	rename the Contact UIN
*/
	void rename(UIN, const char *);
/**
	return the Contact with a UIN
*/
	kxContactStruct getContact(UIN);
	kxContactStruct getIgnoreContact(UIN);
/**
	return the Contact with the index i
*/

  bool isIgnore(UIN);

	kxContactStruct getContact(int i);
	kxContactStruct getIgnoreContact(int i);
	

/** is UIN in the list of known contacts ? */	
	bool isUinInList(UIN uin);
	
	static kxContact *myC;
	static kxContact *getContactPointer() { return myC; };

	KSimpleConfig *contactsFile;

/** return the status as Text */
  char * status2str(unsigned int status);
/** return the status as a INT */
  int status2int(unsigned int status);
  /** update the socket pointer */
  /** set Always via Server */
  void setAlwaysServer(UIN, bool, bool save=TRUE);
  void updateSocket(UIN, kxSocket *);
	/** set Wait for Authorization */
	void setWaitAuth(UIN _uin, bool _stat);
	/** set Authorization */
	void setAuthorized(UIN _uin, bool _stat);
  /** count the unknown messages() */
  int countMessages(UIN);
 	/** set Ignore */
  /** remove a message from the stack */
  void removeMessage(UIN);
  /** add a message to the stack */
  void addMessage(UIN);
	void setIgnore(UIN _uin, bool _stat);
	void setSendWidget(UIN, QWidget *w=NULL);
	QWidget *getSendWidget(UIN);

	void setIgnoreAway(UIN, bool);
  bool getIgnoreAway(UIN);	
	void setIntIp(UIN, bool);
  bool getIntIp(UIN);	
	
signals:
  void removeContact(UIN);
  void repaintContact(UIN);
  void recountMessages(UIN);
  void contactAdded(UIN, QString);
  void SignalUserOnline(UIN);
	
private:
	void loadContacts();
	
	int unknownMessage;	
		
protected:
/**
	The list with Contacts
*/
	QList<kxContactStruct> contactList;
	QList<kxContactStruct> ignoreList;
};

#endif
