/***************************************************************************
                          kxcontact.cpp  -  description                              
                             -------------------                                         
    begin                : Sun Jun 6 1999                                           
    copyright            : (C) 1999 by Herwin Jan Steehouwer                         
    email                : steehouwer@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/
#include <kglobal.h>
#include <kxudp.h>
#include "kxcontact.h"
#include <kxengine.h>
#include "v2_codes.h"
#include <kapp.h>
#include <stdlib.h>
#include <kstddirs.h>
kxContact *kxContact::myC=0L;

kxContact::kxContact(){
	myC=this;
	unknownMessage=0;
	QString path;
	path = locateLocal("appdata","contacts.kxicq");
	contactsFile=new KSimpleConfig(path);

  contactList.setAutoDelete(TRUE);
  ignoreList.setAutoDelete(TRUE);
}

kxContact::~kxContact(){
}

void kxContact::init()
{
	unknownMessage=0;
	loadContacts();
}

int kxContact::countShow()
{
  int c=0;
  for (Q_UINT16 t=0; t<contactList.count(); t++)
  {
    if (contactList.at(t)->show) c++;
  }
	return c;
}
int kxContact::count()
{
	return contactList.count();
}

int kxContact::countIgnore()
{
	return ignoreList.count();
}


bool kxContact::add(const char *nick, UIN uin, bool auth, bool show)
{
  bool oldShow=FALSE;
  kxContactStruct *c=NULL;
	if (count()>0)
	{
  	for (int t=0; t<count(); t++)
  	{
  		if (contactList.at(t)->uin==uin)
  		{
  		  if (show==TRUE && contactList.at(t)->show==FALSE)
  		  {
  		    c=contactList.at(t);
  		    oldShow=TRUE;
  		  }
  		  else  
  		  {
  			  return FALSE;
  		  }
  		}
  	}
	}
	QString _nick=nick;
	if (_nick.length()==0 && show) 
	{
	  _nick.sprintf("%d",uin);
	  (void)new kxUpdateContactNick(uin);
	}
	if (!oldShow) c=new kxContactStruct;
	unsigned int cnt=0;
	QStrList tmp;
	if (show)
	{
   	contactsFile->setGroup("Default");

   	contactsFile->readListEntry("Contacts",tmp);
   	QString tmpUin;
   	tmpUin.sprintf("%d",uin);
   	tmp.append(tmpUin);
   	cnt=contactsFile->readNumEntry("Count",0);
   	cnt++;
   	QString str;
   	str.sprintf("Contact %d",uin);
   	contactsFile->setGroup(str);
   	contactsFile->writeEntry("Nick",_nick);	
   	contactsFile->writeEntry("UIN",uin);	
   	
   	if (auth)
   	{
  		contactsFile->writeEntry("Awaiting Auth",auth);	 	
  		contactsFile->writeEntry("Authorized",FALSE);	 		
  		c->authorized=FALSE;
  	}
  	else
  	{
  		c->authorized=TRUE;		
  		contactsFile->writeEntry("Authorized",TRUE);	 			
  	}
  }

 	strcpy(c->nick, _nick.latin1());
 	c->uin=uin;
 	c->mySocket=NULL;
 	c->status=STATUS_OFFLINE;
 	c->alwaysServer=FALSE;
 	c->invisible=0;
 	c->visible=0;
 	c->waitAuth=auth;
 	c->unreadMessages=0;
 	c->ignore=FALSE;
 	c->onlineNotify=FALSE;
 	c->show=show;
 	c->sendWidget=NULL;
 	c->ignoreAway=FALSE;
 	if (!oldShow) contactList.append(c);
  if (show)
  {		
   	contactsFile->setGroup("Default");	
   	contactsFile->writeEntry("Count",cnt);
  	contactsFile->writeEntry("Contacts",tmp); 	
   	contactsFile->sync();
   	emit contactAdded(uin, QString(_nick));
  }
 	return TRUE;
}

bool kxContact::ignoreAdd(UIN uin, char *nick)
{
  bool add=TRUE;
	if (countIgnore()>0)
	{
  	for (int t=0; t<countIgnore(); t++)
  	{
  		if (ignoreList.at(t)->uin==uin)
  			return FALSE;
  	}
 }
 if (count()>0)
 {
  	for (int t=0; t<count(); t++)
  	{
  		if (contactList.at(t)->uin==uin)
  	  {
  	    setIgnore(uin,TRUE);
  	    return TRUE;
//  	    continue;  	    
  	  }
  	}
	}
	QString _nick;
	_nick=nick;
	if (_nick.length()==0) 
	{
	  _nick.sprintf("%d",uin);
	  (void)new kxUpdateContactNick(uin);
	}

 	contactsFile->setGroup("Default");
 	QStrList tmp;
 	contactsFile->readListEntry("Contacts",tmp);
 	QString tmpUin;
 	tmpUin.sprintf("%d",uin);
 	tmp.append(tmpUin);
 	unsigned int count=contactsFile->readNumEntry("Count",0);
 	if (add) count++;
 	QString str;
 	str.sprintf("Contact %d",uin);
 	contactsFile->setGroup(str);
 	if (add) contactsFile->writeEntry("UIN",uin);	
  if (add) contactsFile->writeEntry("Nick",_nick);	 	
 	if (add) contactsFile->writeEntry("Ignore List",TRUE);	
  contactsFile->writeEntry("Ignore",TRUE);	 	
 	
 	kxContactStruct *c=new kxContactStruct;

 	c->uin=uin;
 	c->ignore=TRUE;
 	c->onlineNotify=FALSE;
 	
 	ignoreList.append(c);
  		
 	contactsFile->setGroup("Default");	
 	contactsFile->writeEntry("Count",count);
	contactsFile->writeEntry("Contacts",tmp); 	
 	contactsFile->sync();
 	return TRUE;
}

void kxContact::remove(UIN uin)
{
	for (int t=0; t<count(); t++)
	{
		if (contactList.at(t)->uin==uin)
		{
		  bool show=contactList.at(t)->show;
			contactList.remove();			
			if (show)
			{
      	contactsFile->setGroup("Default");
      	QStrList tmp;
      	contactsFile->readListEntry("Contacts",tmp);
      	QString str;
  		 	str.sprintf("Contact %d",uin);
  
      	unsigned int count=contactsFile->readNumEntry("Count",0);
  			for (unsigned int y=0; y<tmp.count(); y++)
  			{	
  				 if ((UIN)atoi(tmp.at(y))==uin)
  				 	tmp.remove(y);
  			}
  			count--;
  			contactsFile->deleteGroup(str);
  		 	contactsFile->setGroup("Default");	
  		 	contactsFile->writeEntry("Count",count);
  			contactsFile->writeEntry("Contacts",tmp); 	
   			contactsFile->sync();
   			emit removeContact(uin);
   		}
		}
	}
}
void kxContact::ignoreRemove(UIN uin)
{
	for (int t=0; t<countIgnore(); t++)
	{
		if (ignoreList.at(t)->uin==uin)
		{
			ignoreList.remove();			
    	contactsFile->setGroup("Default");
    	QStrList tmp;
    	contactsFile->readListEntry("Contacts",tmp);
    	QString str;
		 	str.sprintf("Contact %d",uin);

    	unsigned int count=contactsFile->readNumEntry("Count",0);
			for (unsigned int y=0; y<tmp.count(); y++)
			{	
				 if ((UIN)atoi(tmp.at(y))==uin)
				 	tmp.remove(y);
			}
			count--;
			contactsFile->deleteGroup(str);
		 	contactsFile->setGroup("Default");	
		 	contactsFile->writeEntry("Count",count);
			contactsFile->writeEntry("Contacts",tmp); 	
 			contactsFile->sync();
		}
	}
}

void kxContact::rename(UIN uin, const char *_nick)
{
	for (int t=0; t<count(); t++)
	{
		if (contactList.at(t)->uin==uin)
		{
			strcpy(contactList.at(t)->nick, _nick);
			if (contactList.at(t)->show)
			{
      	contactsFile->setGroup("Default");
      	QStrList tmp;
      	contactsFile->readListEntry("Contacts",tmp);
      	QString tmpUin;
      	tmpUin.sprintf("%d",uin);
      	tmp.append(tmpUin);
      	unsigned int count=contactsFile->readNumEntry("Count",0);
      	count++;
      	QString str;
      	str.sprintf("Contact %d",uin);
      	contactsFile->setGroup(str);
      	contactsFile->writeEntry("Nick",_nick);	
        contactsFile->sync();
      }
		}
	}
	for (int t=0; t<countIgnore(); t++)
	{
		if (ignoreList.at(t)->uin==uin)
		{
			strcpy(ignoreList.at(t)->nick, _nick);
    	contactsFile->setGroup("Default");
    	QStrList tmp;
    	contactsFile->readListEntry("Contacts",tmp);
    	QString tmpUin;
    	tmpUin.sprintf("%d",uin);
    	tmp.append(tmpUin);
    	unsigned int count=contactsFile->readNumEntry("Count",0);
    	count++;
    	QString str;
    	str.sprintf("Contact %d",uin);
    	contactsFile->setGroup(str);
    	contactsFile->writeEntry("Nick",_nick);	
      contactsFile->sync();
			// must be written to file !
		}
	}

}

kxContactStruct kxContact::getContact(UIN uin)
{
	for (int t=0; t<count(); t++)
	{
		if (contactList.at(t)->uin==uin)
		{
			return *contactList.at(t);
		}
	}
	kxContactStruct c;
	c.uin=0;
	c.status=0;
	return c;
}
       
kxContactStruct kxContact::getContact(int i)
{
	return *contactList.at(i);
}
kxContactStruct kxContact::getIgnoreContact(UIN uin)
{
	for (int t=0; t<countIgnore(); t++)
	{
		if (ignoreList.at(t)->uin==uin)
		{
			return *ignoreList.at(t);
		}
	}
	kxContactStruct c;
	c.uin=0;
	c.status=0;
	return c;
}
       
kxContactStruct kxContact::getIgnoreContact(int i)
{
	return *ignoreList.at(i);
}

void kxContact::loadContacts()
{
	contactsFile->setGroup("Default");
	unsigned int count=contactsFile->readNumEntry("Count",0);
 	QStrList tmp;
 	contactsFile->readListEntry("Contacts",tmp);
  bool ignoreOnly;
	if (count>0)
	{
		for (unsigned int t=1; t<=count; t++)
		{
    	QString str;
    	str.sprintf("Contact %s",tmp.at(t-1));
    	contactsFile->setGroup(str);
    	ignoreOnly=contactsFile->readBoolEntry("Ignore List", FALSE);
    	if (!ignoreOnly) // normal contact
    	{
      	kxContactStruct *c=new kxContactStruct;
      	strcpy(c->nick,contactsFile->readEntry("Nick").data());
  			c->uin=contactsFile->readUnsignedNumEntry("UIN");
  			c->invisible=contactsFile->readUnsignedNumEntry("Invisible", 0);
  			c->visible=contactsFile->readUnsignedNumEntry("Visible", 0);
  			c->alwaysServer=contactsFile->readBoolEntry("Always via Server", FALSE);
  			c->waitAuth=contactsFile->readBoolEntry("Awaiting Auth", FALSE);
  			c->ignore=contactsFile->readBoolEntry("Ignore", FALSE);
  			c->authorized=contactsFile->readBoolEntry("Authorized", TRUE);
  			c->onlineNotify=contactsFile->readBoolEntry("Online Notify",FALSE);
  			c->show=contactsFile->readBoolEntry("Show",TRUE);
  			if (c->invisible>1) c->invisible=0;
  			if (c->visible>1) c->visible=0;
  			c->status=STATUS_OFFLINE;
  			c->mySocket=NULL;
  			c->unreadMessages=0;
  			c->sendWidget=NULL;
 			 	c->ignoreAway=FALSE;
  			contactList.append(c);
      }
      else // ignore list
      {
        kxContactStruct *c=new kxContactStruct;
      	strcpy(c->nick,contactsFile->readEntry("Nick").data());
  			c->uin=contactsFile->readUnsignedNumEntry("UIN");
  			c->ignore=contactsFile->readBoolEntry("Ignore", TRUE);
  			ignoreList.append(c);
      }
  	}
	}
	contactsFile->setGroup("Default");	
	contactsFile->writeEntry("Count",count);
	contactsFile->sync();
}

/** This Updates the statusof a Contact in memory */
void kxContact::updateStatus(UIN uin, unsigned int status, Q_UINT32 ip, Q_UINT16 port)
{
	for (int t=0; t<count(); t++)
	{
		if (contactList.at(t)->uin==uin)
		{
			contactList.at(t)->status=status;
			if (ip!=0)
			{
				if (contactList.at(t)->mySocket)
				{
					delete contactList.at(t)->mySocket;
					contactList.at(t)->mySocket=NULL;
				}
				contactList.at(t)->ip=ip;			
				contactList.at(t)->port=port;
				emit repaintContact(uin);
			}
		}
	}	
}
/** This Updates the status of a contact in memory */
void kxContact::updateStatus(int _t, unsigned int status)
{
			contactList.at(_t)->status=status;
}

/** Update a Contact */
void kxContact::updateContact(UIN uin, unsigned int status, Q_UINT32 ip=0, Q_UINT16 port=0, Q_UINT8 mode=0, Q_UINT32 realIp=0, Q_UINT32 tcpVersion=0x0)
{
	for (int t=0; t<count(); t++)
	{
		if (contactList.at(t)->uin==uin)
		{
			contactList.at(t)->status=status;	
			if (ip!=0 || status==STATUS_OFFLINE)
			{
				if (contactList.at(t)->mySocket)
				{
					delete contactList.at(t)->mySocket;
					contactList.at(t)->mySocket=NULL;
				}
				contactList.at(t)->ip=ip;			
				contactList.at(t)->realIp=realIp;			
				contactList.at(t)->tcpVersion=tcpVersion;
				debug("Show IP: %d, mode: %d, version: %02X",ip, mode, tcpVersion);
				contactList.at(t)->port=port;
				contactList.at(t)->mode=mode;				
				if (contactList.at(t)->onlineNotify && status!=STATUS_OFFLINE)
				{
				  emit SignalUserOnline(uin);
				}
				emit repaintContact(uin);
			}
		}
	}
	Q_UINT32 l=ip;
	Q_UINT8 p1, p2, p3, p4;
	p1=l;
	l>>= 8;
	p2=l;
	l>>=8;
	p3=l;
	l>>=8;
	p4=l;
	debug("IP: %02d.%02d.%02d.%02d",p1, p2, p3, p4);
	
}

/** is UIN in the list of known contacts ? */
bool kxContact::isUinInList(UIN uin)
{
	for (int t=0; t<count(); t++)
	{
		if (contactList.at(t)->uin==uin)
		{	
			return TRUE;
		}
	}
	return FALSE;
}

/** set Invisible */
void kxContact::setInvisible(UIN _uin, int _stat)
{
	for (int t=0; t<count(); t++)
	{
		if (contactList.at(t)->uin==_uin)
		{	
			contactList.at(t)->invisible=_stat;
	   	QString str;
    	str.sprintf("Contact %d",_uin);
    	contactsFile->setGroup(str);
    	contactsFile->writeEntry("Invisible", _stat);
			contactsFile->sync();    	
  		emit repaintContact(_uin);
			return;
		}
	}				
}
/** set Visible */
void kxContact::setVisible(UIN _uin, int _stat)
{
	for (int t=0; t<count(); t++)
	{
		if (contactList.at(t)->uin==_uin)
		{	
			contactList.at(t)->visible=_stat;
	   	QString str;
    	str.sprintf("Contact %d",_uin);
    	contactsFile->setGroup(str);
    	contactsFile->writeEntry("Visible", _stat);
			contactsFile->sync();    	
      emit repaintContact(_uin);
			return;
		}
	}				
}
/** set Ignore */
void kxContact::setIgnore(UIN _uin, bool _stat)
{
	for (int t=0; t<count(); t++)
	{
		if (contactList.at(t)->uin==_uin)
		{	
			contactList.at(t)->ignore=_stat;
	   	QString str;
    	str.sprintf("Contact %d",_uin);
    	contactsFile->setGroup(str);
    	contactsFile->writeEntry("Ignore", _stat);
			contactsFile->sync();    	
      emit repaintContact(_uin);
			return;
		}
	}				
}
/** set Ignore */
void kxContact::setOnlineNotify(UIN _uin, bool _stat)
{
	for (int t=0; t<count(); t++)
	{
		if (contactList.at(t)->uin==_uin)
		{	
			contactList.at(t)->onlineNotify=_stat;
	   	QString str;
    	str.sprintf("Contact %d",_uin);
    	contactsFile->setGroup(str);
    	contactsFile->writeEntry("Online Notify", _stat);
			contactsFile->sync();    	
			return;
		}
	}				
}

/** return the status as Text */
char * kxContact::status2str(unsigned int status)
{
	switch(status)
	{
		case -1:
     case 65535:
         return "Offline";
         break;
  }
   switch ( status&0x1ff )
   {
     case 0x0:
             // This MIGHT be DND..
     case 0x10013:
     case 0x10000:
             // This MIGHT be N/A..
     case 0x10005:
     case 0x20000:
     case 0x30000:
             {
                     return "Available";
                     break;
             }
     case 0x1:
     case 0x10001:
     case 0x20001:
     case 0x30001:
     case 131585:
     case 131584:
     case 131588:
     case 2294272:
     case 66048:
     case 512:
     case 2293761:
     case 2293765:
     case 2293760:
     case 2293762:
     case 2293763:
     case 2293764:
             return "Away";
             break;
     case 0x5:
     case 0x20005:
     case 0x30005:
     case STATUS_NA:
             return "N/A";
             break;
     case 0x11:
     case 0x20011:
     case 0x30011:
     case STATUS_OCCUPIED:
             return "Occupied";
             break;
     case 0x13:
     case 0x20013:
     case 0x30013:
     case STATUS_DND:
             return "DND";
             break;
     case 0x20:
     case 0x20020:
     case 0x30020:
             return "Free for chat";
             break;
     case 0x100:
             return "Invisible";
             break;
     case -1:
     case 65535:
         return "Offline";
         break;
     default:
                     //char string[BUFSIZE];
                     //char *string;
                     //string = new char(25);
                     //sprintf( string, "Unknown", status );
         return "Unknown";
         break;
   }
   return '\0';
}

/** return the status as a INT */
int kxContact::status2int(unsigned int status)
{
  if (status==STATUS_OFFLINE) 				return STATUS_OFFLINE;
  switch(status & 0x1ff)
  {
	  case STATUS_DND: 			
 	  case STATUS_DND_KXICQ: 	
	  	return STATUS_DND;
	  	break;
	  case STATUS_OCCUPIED_MAC: 	
	  case STATUS_OCCUPIED: 	
	  	return STATUS_OCCUPIED;
	  	break;
	  case STATUS_NA_99:
	  case STATUS_NA: 				
	  	return STATUS_NA;
	  	break;
	  case STATUS_AWAY: 			
	  	return STATUS_AWAY;
	  	break;
	  case STATUS_FFC: 			
	  	return STATUS_FFC;
	  	break;
	  case STATUS_ONLINE: 			
	  	return STATUS_ONLINE;
	  	break;
	 	default:
			return (STATUS_UNKNOWN);
	  	break;
	}  
  return 0;
}

/** update the socket pointer */
void kxContact::updateSocket(UIN _uin, kxSocket *_ks){
	for (int t=0; t<count(); t++)
	{
		if (contactList.at(t)->uin==_uin)
		{	
			contactList.at(t)->mySocket=_ks;
		}
	}
}      

/** set Always via Server */
void kxContact::setAlwaysServer(UIN _uin, bool _stat, bool _save)
{
	for (int t=0; t<count(); t++)
	{
		if (contactList.at(t)->uin==_uin)
		{	
			contactList.at(t)->alwaysServer=_stat;
			if (_save)
			{
  	   	QString str;
      	str.sprintf("Contact %d",_uin);
      	contactsFile->setGroup(str);
      	contactsFile->writeEntry("Always via Server", _stat);
  			contactsFile->sync();    	
      }		
			return;
		}
	}		
}
/** set Wait for Authorization */
void kxContact::setWaitAuth(UIN _uin, bool _stat)
{
	for (int t=0; t<count(); t++)
	{
		if (contactList.at(t)->uin==_uin)
		{	
			contactList.at(t)->waitAuth=_stat;
	   	QString str;
    	str.sprintf("Contact %d",_uin);
    	contactsFile->setGroup(str);
    	contactsFile->writeEntry("Awaiting Auth", _stat);
			contactsFile->sync();    	
  		emit repaintContact(_uin);
			return;
		}
	}		
}
/** set Authorization */
void kxContact::setAuthorized(UIN _uin, bool _stat)
{
	for (int t=0; t<count(); t++)
	{
		if (contactList.at(t)->uin==_uin)
		{	
			contactList.at(t)->authorized=_stat;
	   	QString str;
    	str.sprintf("Contact %d",_uin);
    	contactsFile->setGroup(str);
    	contactsFile->writeEntry("Authorized", _stat);
			contactsFile->sync();    	
  		
			return;
		}
	}		
}

/** add a message to the stack */
void kxContact::addMessage(UIN _uin){
	kxContactStruct *kc;
	for (int t=0; t<count(); t++)
	{
		if (contactList.at(t)->uin==_uin)
		{	
			kc=contactList.at(t);
			kc->unreadMessages++;
			emit repaintContact(_uin);
			emit recountMessages(_uin);
			return;
		}
	}
	unknownMessage++;
	emit repaintContact(0);
	emit recountMessages(0);
}

/** remove a message from the stack */
void kxContact::removeMessage(UIN _uin){
	kxContactStruct *kc;
	for (int t=0; t<count(); t++)
	{
		if (contactList.at(t)->uin==_uin)
		{	
			kc=contactList.at(t);
			kc->unreadMessages--;
			if (contactList.at(t)->unreadMessages<0)
			{
				kc->unreadMessages=0;
				debug("Unread Messages(%d) < 0 ???",_uin);
			}
			emit repaintContact(_uin);
			emit recountMessages(_uin);
			return;
		}
	}
	unknownMessage--;
	if (unknownMessage<0)
	{
			debug("Unread Unknown Messages < 0 ???");
			unknownMessage=0;
	}
	debug("Unknown Message: %d",unknownMessage);
	emit repaintContact(0);
	emit recountMessages(0);
}

/** count the unknown messages() */
int kxContact::countMessages(UIN _uin)
{
	for (int t=0; t<count(); t++)
	{
		if (contactList.at(t)->uin==_uin)
		{	
			return contactList.at(t)->unreadMessages;
		}
	}
	return unknownMessage;
}

bool kxContact::isIgnore(UIN _uin)
{
	for (int t=0; t<count(); t++)
	{
		if (contactList.at(t)->uin==_uin)
		{	
			return contactList.at(t)->ignore;
		}
	}
	for (int t=0; t<countIgnore(); t++)
	{
		if (ignoreList.at(t)->uin==_uin)
		{	
			return TRUE;
		}
	}
  return FALSE;
}
QString kxContact::getCountry(int t)
{
  return QString("");
}

void kxContact::setSendWidget(UIN _uin, QWidget *w=NULL)
{
	for (int t=0; t<count(); t++)
	{
		if (contactList.at(t)->uin==_uin)
		{	
      contactList.at(t)->sendWidget=w;
    }
  }     
}
QWidget *kxContact::getSendWidget(UIN _uin)
{
	for (int t=0; t<count(); t++)
	{
		if (contactList.at(t)->uin==_uin)
		{	
      return contactList.at(t)->sendWidget;
    }
  }     
  return NULL;
}
void kxContact::setIgnoreAway(UIN _uin, bool _w)
{
	for (int t=0; t<count(); t++)
	{
		if (contactList.at(t)->uin==_uin)
		{	
      contactList.at(t)->ignoreAway=_w;
    }
  }     
}
bool kxContact::getIgnoreAway(UIN _uin)
{
	for (int t=0; t<count(); t++)
	{
		if (contactList.at(t)->uin==_uin)
		{	
      if (contactList.at(t)->ignoreAway) return TRUE;
      else  return FALSE;
    }
  }     
  return FALSE;
}
void kxContact::setIntIp(UIN _uin, bool _w)
{
	for (int t=0; t<count(); t++)
	{
		if (contactList.at(t)->uin==_uin)
		{	
      contactList.at(t)->intIp=_w;
    }
  }     
}
bool kxContact::getIntIp(UIN _uin)
{
	for (int t=0; t<count(); t++)
	{
		if (contactList.at(t)->uin==_uin)
		{	
      if (contactList.at(t)->intIp) return TRUE;
      else  return FALSE;
    }
  }     
  return FALSE;
}

kxUpdateContactNick::kxUpdateContactNick(UIN _uin)
{
  if (ENGINE->loggedOn())
  {
    uin=_uin;
    QObject::connect(ENGINE->UDP,SIGNAL(receivedInfoReply(Q_UINT16, UIN, char *, char *, char *, char *, Q_UINT8)),
                      this, SLOT(SlotInfoReply(Q_UINT16, UIN, char *, char *, char *, char *, Q_UINT8)));
    QObject::connect(&waitTimer, SIGNAL(timeout()), this, SLOT(SlotTimeout()));
    seq=ENGINE->UDP->sendInfoReply(uin);
    waitTimer.start(3600);
  }
  else
    delete this;
}
void kxUpdateContactNick::SlotTimeout()
{
  delete this;
}
void kxUpdateContactNick::SlotInfoReply(Q_UINT16 _seq, UIN _uin, char *nick, char *first, char *last, char *email, Q_UINT8 auth)
{
  if (_seq==seq)
  {
    emit SignalChangeNick(uin,nick);
    ENGINE->CONTACT->rename(uin,nick);
    delete this;
  }
}
