/**
 * $Id: filefinder.cpp,v 1.1.1.1 2001/04/15 02:08:03 gis Exp $
 *
 * Copyright 1998, 1999 by Carsten Pfeiffer
 */

#include <qkeycode.h>

#include <kurlcompletion.h>

#include "filefinder.h"

FileFinder::FileFinder( QWidget *parent, const char *name )
    : KLineEdit( parent, name )
{
    // make this widget just as large, as the font is + 8 Pixels
    int height = fontMetrics().height() + 8;
    setFixedSize( 150, height );
    setFrame( true );

    KURLCompletion *comp = new KURLCompletion();
    comp->setReplaceHome( true );
    comp->setReplaceEnv( true );
    setCompletionObject( comp, false );
    setAutoDeleteCompletionObject( true );
    setFocusPolicy( ClickFocus );
}

FileFinder::~FileFinder()
{
}

void FileFinder::focusOutEvent( QFocusEvent * )
{
    hide();
}

void FileFinder::keyPressEvent( QKeyEvent *e )
{
    // somewhat broken in {Q,K}LineEdit... we get returnPressed() twice
    // but this keyEvent is called only once. So we simply use an own signal.
    int key = e->key();
    if ( key == Key_Escape || key == Key_Return || key == Key_Enter ) {
 	emit enterDir( text() );
	hide();
	e->accept();
    }
    else {
	KLineEdit::keyPressEvent( e );
    }
}

#include "filefinder.moc"
