/***************************************************************************
                          mytext.cpp  -  description
                             -------------------
    begin                : Sat Sep 4 1999
    copyright            : (C) 1999 by Rolf Jakob
    email                : rjakob@duffy1.franken.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <iostream.h>
#include <qstring.h>
#include <qregexp.h>
#include <kapp.h>
#include "mytext.h"

void mybox :: setChild(QWidget *child)
{
	mychild=child;
}

void mybox :: removeChild()
{
	mychild=0;
}

void mybox :: resizeEvent( QResizeEvent *e)
{
	QWidget::resizeEvent(e);

	if (mychild) {
		mychild->resize(width(),height());
		mychild->show();
		}
}

void mybox :: mousePressEvent(QMouseEvent *e)
{
//cerr << "mouse event in mybox\n";
#ifdef ALLOW_DECOR_CHANGE
	if (e->button()==RightButton && e->state()==ControlButton)
		emit altrightclicked();
	else
#endif
	if (e->button()==RightButton) {
		emit rightclicked();
//		cerr << "right mouse button\n";
	} else if (e->button()==MidButton)
		emit middleclicked();
	else QWidget::mousePressEvent(e);
}

mytext::mytext(QWidget *parent, const char *name)
	: QTextEdit(parent,name)
{
	maxLines=MAX_LINES;
	lastLineComplete=true;
	re=0;
	excludePattern=false;
	intActionCode=0;
	setReadOnly(true);
	setWordWrap(NoWrap);
}

void mytext :: mousePressEvent(QMouseEvent *e)
{
#ifdef ALLOW_DECOR_CHANGE
	if (e->button()==RightButton && e->state()==ControlButton)
		emit altrightclicked();
	else
#endif
	if (e->button()==RightButton)
		emit rightclicked();
	else if (e->button()==MidButton)
		emit middleclicked();
	else QTextEdit::mousePressEvent(e);
}

void mytext::setMaxLines(int n)
{
	maxLines=n;
}

void mytext::setActionCode(int n)
{
	intActionCode=n;
}


void mytext::setFilter(const char *r,bool excl)
{
	if (r && *r) {
		re=new QRegExp(r);
		excludePattern=excl;
		}
	else if (re) { delete re; re=0; }
}

void mytext::editFilter()
{
	filterw=new myfilterdlg(this,"Filter",true);
	if (re) filterw->setText(re->pattern());
	filterw->setExclude(excludePattern);
	filterw->exec();
	setFilter(filterw->text(),filterw->isExcludeSelected());
	delete filterw;
}

const char *mytext::getFilter()
{
	if (re) return(re->pattern());
	else return("");
}

// add a line to the QMultiLineEdit, parameter may have trailing EOL

void mytext::insertLineAtEnd(const char *t)
{
char *p,*q;
int l;
bool flag;

	if (re) {
	
	// only do this if there is a filter
	char *buffer=new char[strlen(t)+1];
	strcpy(buffer,t);
	q=buffer;
	while(*q) {
		p=strchr(q,'\n');
		if (p) {
			*p=0;
			insertSingleLineAtEnd(q,true);
			q=p+1;
			} else {
			insertSingleLineAtEnd(q,false);
			break;
			}
		}
	delete buffer;

	} else {
	
	// else do not split the line for better performance
	if ((l=strlen(t))) {
		flag=(*(t+l-1)=='\n');
		} else flag=false;
	insertSingleLineAtEnd(t,flag);
	}
}

void mytext::insertSingleLineAtEnd(const char *t, bool complete)
{
// bool complete;
QString help;
bool matches;

	if (!t || !*t) return;
	
	help=t;
//	complete=(help.right(1)=="\n");

	/* delete only one EOL */
	if (help.right(1)=="\n") help.truncate(help.length()-1);
	if (help.right(1)=="\r") help.truncate(help.length()-1);
	
	int lastline=paragraphs()-1;
	if (!lastLineComplete) {
//		help=textLine(lastline)+help;
//		removeLine(lastline);
// better update performance with insertAt
		QTextEdit::insertAt(help.data(),
			lastline,
			paragraphLength(lastline));
		}
	else {
		QTextEdit::append(help.data());
		}

	// filter only complete lines
	lastline=paragraphs()-1;
	help=text(lastline);
	if (complete) {
		if (re) {
			matches=(re->match(help.data())>=0);
			if ((matches && excludePattern) ||
			(!matches && !excludePattern))
				removeParagraph(lastline);
			}
		}
	lastLineComplete=complete;

	while(paragraphs()>maxLines) {
		removeParagraph(0);
		kapp->processEvents();
		}
	setCursorPosition(paragraphs()-1,0);
}







