/*
 * puz_app.h -- Copyright (C) 1998 by M. G"otze
 */

#include <kmainwindow.h>
#include <kaction.h>
#include <kstatusbar.h>
#include "cpreferences.h"

class KSlidePuzzle;

class KSlideApp : public KMainWindow
{
  Q_OBJECT

  public:
    KSlideApp();
    ~KSlideApp();

  public slots:
    void setModeCl3();
    void setModeCl4();
    void setModeCl5();
    void setModeCl6();
    void setModeCo();
    void setModeCr();
    void setModeDi();
    void setModeIs();
    void setModeTr();
    void setModeNo();
    void scramblingStarted();
    void scramblingStopped();
    void orderingStarted();
    void orderingStopped();
    void toggleMissingTile();
    void toggleSound();
    void help();
    void loadImage();
    void defaultImage();
  /** Display the configuration window */
  void slotPreferences();

  protected:
		void initActions();

  private:
    struct {
      QPopupMenu *mGame, *mPrefs;
      int scramble, order;
      int loadImg, defImg;
      int mode1, mode2;
      int modes[9];
      int mTile;
      int sound;
    } mIDs;  // ID's of modifyable menu options
    int curMode;

    KSlidePuzzle *puzzle;
    KToggleAction **menu;
    KToggleAction **menushape;
    CPreferences *prefs;
    KStatusBar *statusbar;

    void setMode(unsigned char mode);
    void enableModeChange(bool enable);
};
