/***************************************************************************
                          cpreferences.h  -  description
                             -------------------
    begin                : Sat Jul 1 2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CPREFERENCES_H
#define CPREFERENCES_H

#include <qwidget.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qspinbox.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qlistbox.h>
#include <qdialog.h>
#include <qbuttongroup.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qfont.h>
#include <qvbox.h>

#include <kfontdialog.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kapp.h>
#include <kconfig.h>
#include <kstddirs.h>
#include <kdialogbase.h>

/** This class will provide a pretty dialog box in whioch
	* the user can set all the options of kslide
  *@author Eric Coquelle
  */

class CPreferences : public KDialogBase  {
   Q_OBJECT
public: 
	CPreferences(QWidget *parent=0, const char *name=0);
	~CPreferences();
  /** Get the name of the puzzle's image to be loaded */
  QString getLoadImageName();
  /** return the max moves number */
  bool getMaxMovesNumber( int* moves );
	/** return the max game time */
	bool getMaxSolveTime( int* mins );
	/** return the max game time */
	bool getMaxHintNumber( int* hint );
  /** Return the game difficulty option */
  int getGameLevel();
	
protected: 
	void initDialog();
  /*Read the config file and set the propper values for all widgets*/
	void litOptions();
	/*Save those options*/
	void Sauver();
  /*General options*/
  void setGeneralOptions();
  /*Image options*/
  void setImageOptions();
  /*Game options*/
  void setGameOptions();
	
protected slots: // Protected slots
  /** close the dialog box, and forget the changes */
  void slotAnnuler();
  /** Save the changes */
  void slotSauver();
  /** close the dialog box and use the changes */
  void slotOk();
  /** set all widgets to default settings */
  void slotDefault();


private:
	QComboBox *cmbBackgroundColor, * cmbMissingSquareColor, *cmbMissingSquareHilightColor, *cmbGameLevel;
	QPushButton * bLoadImage, *bDefaultImage, *bRandomImage;
	QCheckBox *cbMaxTipNumber, *cbMaxMoveNumber, *cbMaxSolveTime;
	QSpinBox *leMaxTipNumber, *leMaxMoveNumber, *leMaxSolveTime;
	/*Name of the .png image used as a puzzle*/
	QString puzzleImageName;
	/*Path where images are stored*/
	QString imagepath;
	
public slots: // Public slots
  /** Load a specified puzzle */
  void slotLoadImage();
  /** Load a random puzzle */
  void slotLoadRandomImage();
  /** Load a default puzzle */
  void slotLoadDefaultImage();
  /** The skin feature is not achieved */
  void slotWarningMessage(int);
};

#endif
