/*
 * puz_app.cpp -- Copyright (C) 1998 by M. G"otze
								Copyright (c) 2001 by Eric Coquelle
 */

#include <iostream.h>

#include <qfiledlg.h>
#include <qkeycode.h>
#include <qpopmenu.h>
#include <qstring.h>

#include <kapp.h>
#include <klocale.h>
#include <kmenubar.h>
#include <kmessagebox.h>
#include <kstddirs.h>
#include <kdebug.h>
#include <kiconloader.h>

#include "icons.h"
#include "puzzle.moc.cpp"
#include "puz_app.moc.cpp"

KSlideApp::KSlideApp()
  : puzzle(0)
{
/*  QPixmap *icons[9];
  for (int i = 0; i < 9; i++)
    icons[i] = new QPixmap(xpmIcons[i]);
*/
	KIconLoader icone;
  setCaption("KSlide");
	setIcon(icone.loadIcon("kslide",KIcon::Small));
  puzzle = new KSlidePuzzle(this, 0 );
  prefs=new CPreferences(this);
	statusbar=new KStatusBar(this);
	statusbar->insertItem(i18n("Ready"),2);
	statusbar->setItemAlignment(2,KStatusBar::AlignRight);
	puzzle->setStatusBar(statusbar);

//  setView(puzzle, FALSE);

/*  QPopupMenu *game = new QPopupMenu();
  mIDs.scramble = game->insertItem(locale->translate("&Scramble"), puzzle,
    SLOT(scramble()), Key_F2);
  mIDs.order = game->insertItem(locale->translate("&Order"), puzzle,
    SLOT(order()));
  game->insertSeparator();
  game->insertItem(locale->translate("&Exit"), qApp, SLOT(quit()), CTRL+Key_X);
  // game modes sorted by supposed difficulty
  QPopupMenu *mode1 = new QPopupMenu();
  mIDs.modes[0] = mode1->insertItem(*icons[0], locale->translate("&Tiny"),
    this, SLOT(setModeCl3()));
  mIDs.modes[1] = mode1->insertItem(*icons[1], locale->translate("&Normal"),
    this, SLOT(setModeCl4()));
  mIDs.modes[2] = mode1->insertItem(*icons[2], locale->translate("&Large"),
    this, SLOT(setModeCl5()));
  mIDs.modes[3] = mode1->insertItem(*icons[3], locale->translate("&Giant"),
    this, SLOT(setModeCl6()));
  mode1->setCheckable(TRUE);
  QPopupMenu *mode2 = new QPopupMenu();
  mIDs.modes[5] = mode2->insertItem(*icons[6], locale->translate("&Cross"),
    this, SLOT(setModeCr()));
  mIDs.modes[4] = mode2->insertItem(*icons[5], locale->translate("C&orners"),
    this, SLOT(setModeCo()));
  mIDs.modes[6] = mode2->insertItem(*icons[4], locale->translate("&Diamond"),
    this, SLOT(setModeDi()));
  mIDs.modes[8] = mode2->insertItem(*icons[8], locale->translate("&Triangle"),
    this, SLOT(setModeTr()));
  mIDs.modes[7] = mode2->insertItem(*icons[7], locale->translate("&Isles"),
    this, SLOT(setModeIs()));
  mode2->setCheckable(TRUE);
  for (int i = 0; i < 9; i++)
    delete icons[i];
  QPopupMenu *prefs = new QPopupMenu();
  mIDs.mode1 = prefs->insertItem(locale->translate("&Classical Game"), mode1);
  mIDs.mode2 = prefs->insertItem(locale->translate("&Tricky Game"), mode2);
  mIDs.loadImg = prefs->insertItem(locale->translate("&Load image..."), this,
    SLOT(loadImage()));
  mIDs.defImg = prefs->insertItem(locale->translate("&Default image"), this,
    SLOT(defaultImage()));
  prefs->insertSeparator();
  mIDs.mTile = prefs->insertItem(locale->translate("&Random missing tile"),
    this, SLOT(toggleMissingTile()));
  mIDs.sound = prefs->insertItem(locale->translate("&Sound"), this,
    SLOT(toggleSound()));
  prefs->setCheckable(TRUE);
  prefs->setItemChecked(mIDs.mTile, puzzle->randomMissingTile());
  prefs->setItemChecked(mIDs.sound, puzzle->soundOn());
  if (!puzzle->soundOn())            // find out whether sound can be turned on
    if (!puzzle->toggleSound()) {
      prefs->setItemEnabled(mIDs.sound, FALSE);         // disable sound option
      cerr << locale->translate("Sound initialization failed, sound disabled.")
        << endl;
    } else
      puzzle->toggleSound();
  QPopupMenu *help = new QPopupMenu();
  help->insertItem(locale->translate("&Help..."), this, SLOT(help()), Key_F1);
  help->insertSeparator();
  help->insertItem(locale->translate("&About..."), this, SLOT(about()), 0);
  mBar = new KMenuBar(this, "mBar");
  mBar->insertItem(locale->translate("&Game"), game);
  mBar->insertItem(locale->translate("&Settings"), prefs);
  mBar->insertItem(locale->translate("&Help"), help);
  */

  initActions();

//  mIDs.mGame = game;
//  mIDs.mPrefs = prefs;
//  mBar->show();
  connect(puzzle, SIGNAL(sigStartedScrambling()), this,
    SLOT(scramblingStarted()));
  connect(puzzle, SIGNAL(sigStoppedScrambling()), this,
    SLOT(scramblingStopped()));
  connect(puzzle, SIGNAL(sigStartedOrdering()), this,
    SLOT(orderingStarted()));
  connect(puzzle, SIGNAL(sigStoppedOrdering()), this,
    SLOT(orderingStopped()));
  connect(puzzle, SIGNAL(sigPuzzleSolved()), this, SLOT(orderingStopped()));
//  setMenu(mBar);
  setModeCl4();
  puzzle->show();
  resize(565,565+statusbar->height());
}

KSlideApp::~KSlideApp()
{
  delete puzzle;
  delete prefs;
//  delete mBar;
}

void KSlideApp::setMode(unsigned char mode)
{
	int i;
	kdDebug()<<QString("Set mode to:%1\n").arg(mode);
	if(mode==9)
	{
		if (!puzzle->loadImage(tOpt(1)))
    		return;
    }
   else if (!puzzle->loadImage(tOpt(mode)))
    return;
   if(mode<4)
   {
   		for(i=0;i<4;i++)
   			menu[i]->setChecked(false);
		menu[mode]->setChecked(true);
   }
   	else
   	{
   		for(i=0;i<6;i++)
   			menushape[i]->setChecked(false);
		menushape[mode-4]->setChecked(true);
	}
}

void KSlideApp::setModeCl3() { setMode(0); };
void KSlideApp::setModeCl4() { setMode(1); };
void KSlideApp::setModeCl5() { setMode(2); };
void KSlideApp::setModeCl6() { setMode(3); };
void KSlideApp::setModeCo()  { setMode(4); };
void KSlideApp::setModeCr()  { setMode(5); };
void KSlideApp::setModeDi()  { setMode(6); };
void KSlideApp::setModeIs()  { setMode(7); };
void KSlideApp::setModeTr()  { setMode(8); };
void KSlideApp::setModeNo()  { setMode(9); };

void KSlideApp::scramblingStarted()
{
//  mBar->setItemEnabled(mIDs.order, FALSE);
  enableModeChange(FALSE);
//  mIDs.mGame->changeItem(i18n("&Stop scrambling"), mIDs.scramble);
}

void KSlideApp::scramblingStopped()
{
//  mBar->setItemEnabled(mIDs.order, TRUE);
  enableModeChange(TRUE);
//  mIDs.mGame->changeItem(i18n("&Scramble"), mIDs.scramble);
}

void KSlideApp::orderingStarted()
{
//  mBar->setItemEnabled(mIDs.scramble, FALSE);
//  mBar->setItemEnabled(mIDs.order, FALSE);
  enableModeChange(FALSE);
}

void KSlideApp::orderingStopped()
{
//  mBar->setItemEnabled(mIDs.scramble, TRUE);
//  mBar->setItemEnabled(mIDs.order, FALSE);
  enableModeChange(TRUE);
}

void KSlideApp::toggleSound()
{
//  mBar->setItemChecked(mIDs.sound, puzzle->toggleSound());
}

void KSlideApp::toggleMissingTile()
{
//  mBar->setItemChecked(mIDs.mTile, puzzle->toggleRandomMissingTile());
}

void KSlideApp::help()
{
  kapp->invokeHTMLHelp("", "");
}

void KSlideApp::enableModeChange(const bool enable)
{
//  for (int i = 0; i < 9; i++)
//    mBar->setItemEnabled(mIDs.modes[i], enable);
//  mIDs.mPrefs->setItemEnabled(mIDs.mode1, enable);
//  mIDs.mPrefs->setItemEnabled(mIDs.mode2, enable);
//  mBar->setItemEnabled(mIDs.loadImg, enable);
//  mBar->setItemEnabled(mIDs.defImg, enable);
}

void KSlideApp::defaultImage()
{
  if (!puzzle->isIdle())
    return;
  puzzle->loadImage(moKeepMode | moLoadDefImage);
}

void KSlideApp::loadImage()
{
  if (!puzzle->isIdle())
    return;
  QString s = QFileDialog::getOpenFileName(0, "*.jpg | jpg images\n*.png | png images", this,
    i18n("Load Image..."));
  if (!s.length())
    return;
  if (!puzzle->loadImage(moKeepMode, s.data()))
    KMessageBox::information(this,  i18n(
      "An error occurred while trying to load the image.\n"
      "Please check whether the image is of a valid type\n"
      "and has a suitable size. See the help for more\n"
      "information on this."), i18n("Oops...") );
}

void KSlideApp::initActions() {
  menu=new KToggleAction* [4];
  menushape=new KToggleAction* [6];

        new KAction( i18n("Scramble puzzle"), "run", 0, puzzle, SLOT(scramble()), actionCollection(),"game_scramble");
        new KAction( i18n("Solve puzzle"), "solve", 0, puzzle, SLOT(order()), actionCollection(),"game_solve");
		new KAction( i18n("Load game"),"fileopen", 0, puzzle, SLOT(slotLoadGame()), actionCollection(),"puzzle_load");
		new KAction( i18n("Save game"), "filesave",0, puzzle, SLOT(slotSaveGame()), actionCollection(),"puzzle_save");
        new KAction( i18n("Quit"), "exit",0, this, SLOT(close()), actionCollection(),"game_quit");
        menu[0]=new KToggleAction( i18n("Tiny"), 0, this, SLOT(setModeCl3()), actionCollection(),"size_tiny");
        menu[1]=new KToggleAction( i18n("Normal"), 0, this, SLOT(setModeCl4()), actionCollection(),"size_normal");
        menu[2]=new KToggleAction( i18n("Large"), 0, this, SLOT(setModeCl5()), actionCollection(),"size_large");
        menu[3]=new KToggleAction( i18n("Giant"), 0, this, SLOT(setModeCl6()), actionCollection(),"size_giant");
        menushape[5]=new KToggleAction( i18n("Normal"), 0, this, SLOT(setModeNo()), actionCollection(),"block_normal");
        menushape[0]=new KToggleAction( i18n("Cross"), 0, this, SLOT(setModeCr()), actionCollection(),"block_cross");
        menushape[1]=new KToggleAction( i18n("Corners"), 0, this, SLOT(setModeCo()), actionCollection(),"block_corners");
        menushape[2]=new KToggleAction( i18n("Diamond"), 0, this, SLOT(setModeDi()), actionCollection(),"block_diamond");
        menushape[3]=new KToggleAction( i18n("Triangle"), 0, this, SLOT(setModeTr()), actionCollection(),"block_triangle");
        menushape[4]=new KToggleAction( i18n("Isles"), 0, this, SLOT(setModeIs()), actionCollection(),"block_isles");
/*        new KAction( i18n("Load image"), 0, this, SLOT(loadImage()), actionCollection(),"load_image");
        new KAction( i18n("Default image"), 0, this, SLOT(defaultImage()), actionCollection(),"default_image");
        new KAction( i18n("Random image"), 0, this, SLOT(toggleMissingTile()), actionCollection(),"random_file");*/
        new KAction( i18n("Use sound"), 0, this, SLOT(toggleSound()), actionCollection(),"sound");
        new KAction( i18n("Give hint"), 0, puzzle, SLOT(slotGiveHint()), actionCollection(),"hint");
        new KAction( i18n("Stop hint"), 0, puzzle, SLOT(slotStopHint()), actionCollection(),"stop_hint");
        new KAction( i18n("Preferences"),"configure", 0, this, SLOT(slotPreferences()), actionCollection(),"preferences");

        createGUI();
}


/** Display the configuration window */
void KSlideApp::slotPreferences(){
//	CPreferences prefs;
	QString s;
	int moves;
	int gametime;
	int hintnumber;

	if(prefs->exec())
	{
		if(prefs->getMaxMovesNumber( &moves))
			puzzle->setMaxMoves( moves );
		else
			puzzle->setMaxMoves( -1 );

		if(prefs->getMaxSolveTime( &gametime))
			puzzle->setMaxGameTime( gametime );
		else
			puzzle->setMaxGameTime( -1 );
			
		if(prefs->getMaxHintNumber( &hintnumber))
			puzzle->setMaxHints( hintnumber );
		else
			puzzle->setMaxHints( -1 );
			
		puzzle->setGameLevel(prefs->getGameLevel());
		
		s=prefs->getLoadImageName();
		
//   			 puzzle->setMask(0);
		
		if((s.length() != 0) && (!puzzle->loadImage(moKeepMode, s.data())))
		{
		    KMessageBox::information(this,  i18n(
   		   	"An error occurred while trying to load the image.\n"
	      "Please check whether the image is of a valid type\n"
   	   		"and has a suitable size. See the help for more\n"
	   	   "information on this."), i18n("Oops...") );
   			 puzzle->setMask(1);
   		}
	}
}
