<?php
/*
 * $Horde: kronolith/prefs.php,v 1.13.2.3 2002/04/23 17:59:49 chuck Exp $
 *
 * Copyright 2001 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

/**
 * Call PrefsUI::groupIsEditable() here because we can rely on it being present
 * in Horde 2.1 but the prefs template still calls groupIsEditable().
 */
function groupIsEditable($group)
{
    return PrefsUI::groupIsEditable($group);
}


define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/PrefsUI.php';
require KRONOLITH_BASE . '/config/prefs.php';

/* See if we have a preferences group set. */
$group = Horde::getFormData('group');
$js_onLoad = null;

if (PrefsUI::handleForm($group)) {
    $group = null;
    include KRONOLITH_BASE . '/config/prefs.php';
}

$title = _("User Options");
require KRONOLITH_TEMPLATES . '/common-header.inc';
require KRONOLITH_BASE . '/menu.php';
$notification->notify();

/* Assign variables for select lists. */
if (!$prefs->isLocked('timezone')) {
    $timezone_options = &$tz;
}
if (!$prefs->isLocked('day_hour_start') || !$prefs->isLocked('day_hour_end')) {
    $day_hour_start_options = array();
    for ($i = 0; $i <= 48; $i++) {
        $day_hour_start_options[$i] = date(($prefs->getValue('twentyFour')) ? 'G:i' : 'g:ia', mktime(0, $i * 30, 0));
    }
    $day_hour_end_options = $day_hour_start_options;
}

/* Show the UI. */
PrefsUI::generateUI($group);

$registry->shutdown();
require KRONOLITH_TEMPLATES . '/common-footer.inc';

?>
