<?php
/*
 * $Horde: kronolith/deleventaction.php,v 1.1.2.1 2002/04/23 17:59:48 chuck Exp $
 *
 * Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';

if ($eventID = Horde::getFormData('eventID')) {
    $event = $calendar->getEventObject($eventID);
    if ($event->hasRecurType(KRONOLITH_RECUR_NONE) || Horde::getFormData('all')) {
        $calendar->deleteEvent($event->getID());
    } elseif (Horde::getFormData('future')) {
        $event->setRecurEndTimestamp(mktime(1, 1, 1,
                                            Horde::getFormData('month', date('n')),
                                            Horde::getFormData('mday', date('j')) - 1,
                                            Horde::getFormData('year', date('Y'))));
        $event->save();
    } elseif (Horde::getFormData('current')) {
        $event->addException(Horde::getFormData('year'),
                             Horde::getFormData('month'),
                             Horde::getFormData('mday'));
        $event->save();
    }
}

if ($timestamp = Horde::getFormData('timestamp')) {
    $month = date('n', $timestamp);
    $day = date('j', $timestamp);
    $year = date('Y', $timestamp);
} else {
    $month = Horde::getFormData('month', date('n'));
    $day = Horde::getFormData('mday', date('j'));
    $year = Horde::getFormData('year', date('Y'));
}

if ($url = Horde::getFormData('url')) {
    $location = Horde::applicationUrl(urldecode($url), true);
} else {
    $location = Horde::applicationUrl($prefs->getValue('defaultview') . ".php?month=$month&year=$year&mday=$day", true);
}

// make url unique
if (strpos($location, '?') !== false) {
    $location .= '&';
} else {
    $location .= '?';
}
$location .= 'unique=' . md5(microtime());
  
header('Location: ' . $location);

?>
