/***************************************************************************
                          setupdlg.cpp  -  The KountDown setup dialog
                             -------------------
    begin                : Mon Apr 15 2002
    copyright            : (C) 2002 by Erik Johansson
    email                : erre@telia.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qcheckbox.h>
#include <qbuttongroup.h>
#include <qtabwidget.h>
#include <qfont.h>
#include <qdatetime.h>
#include <qmultilineedit.h>
#include <qslider.h>
#include <qspinbox.h>
#include <qstring.h>
#include <qvbox.h>

// KDE includes
#include <kcolorbutton.h>
#include <kconfig.h>
#include <kglobal.h>
#include <klocale.h>
#include <klineedit.h>
#include <kfontdialog.h>
#include <kmessagebox.h>
#include <kiconloader.h>
#include <kaboutapplication.h>
#include <kaboutdata.h>

// Local includes
#include "setupdlg.h"
#include "setupstart.h"
#include "setuphalf.h"
#include "setupfinish.h"
#include "timewidget.h"

SetupDlg::SetupDlg() :
	KDialogBase( IconList, i18n("Setup the KountDown screensaver"), Ok|Apply|Cancel|Default, Ok, 0,
	"setupdlg", true, false )
{
	setButtonText( Default, i18n( "About" ) );
	QVBox *startLayout = addVBoxPage( i18n("Start"), i18n("Start settings"), BarIcon("cookie", KIcon::SizeMedium) );
	start = new SetupStart( startLayout );
	connect( start->startFont, SIGNAL(clicked()), this, SLOT(slotFont()) );
	
	QVBox *halfLayout = addVBoxPage( i18n("HalfWay"), i18n("HalfWay settings"), BarIcon("misc", KIcon::SizeMedium) );
	half = new SetupHalf( halfLayout );
	connect( half->halfFont, SIGNAL(clicked()), this, SLOT(slotFont()) );
	
	QVBox *finishLayout = addVBoxPage( i18n("Finish"), i18n("Finish settings"), BarIcon("exit", KIcon::SizeMedium) );
	finish = new SetupFinish( finishLayout );		
	connect( finish->finFont, SIGNAL(clicked()), this, SLOT(slotFont()) );
	
	readSettings();
}

SetupDlg::~SetupDlg()
{
	delete start;
	delete half;
	delete finish;
}

void SetupDlg::readSettings()
{
	int format;
	KConfig *config = KGlobal::config();

	// Setup Start tab
	config->setGroup( "Start settings" );
		font[0] = config->readFontEntry("Font");
		start->startText->setText( config->readEntry( "Text", i18n( "Days left: %D" ) ) );
		start->startBackCol->setColor( config->readColorEntry( "BackCol", &black ) );
		start->startFontCol->setColor( config->readColorEntry( "FontCol", &red ) );
      start->rndBackCol->setChecked( config->readBoolEntry( "RandomBackCol", false ) );
      start->rndFontCol->setChecked( config->readBoolEntry( "RandomFontCol", false ) );
      start->rndFont->setChecked( config->readBoolEntry( "RandomFont", false ) );
		format = config->readNumEntry( "Display", 8 );
		start->startYears->setChecked( calcFormat( format, YEARS ) );
		start->startMonths->setChecked( calcFormat( format, MONTHS ) );
		start->startWeeks->setChecked( calcFormat( format, WEEKS ) );
		start->startDays->setChecked( calcFormat( format, DAYS ) );
		start->startHours->setChecked( calcFormat( format, HOURS ) );
		start->startMin->setChecked( calcFormat( format, MINS ) );
		start->startSec->setChecked( calcFormat( format, SECS ) );
		start->startRoundOff->setButton( config->readNumEntry( "Round Off", 1 ) );
  		start->effects->setButton( config->readNumEntry( "Text effect", 0 ) );
		start->startSpeed->setValue( config->readNumEntry( "Speed", 50 ) );

	// Setup Half way tab
	config->setGroup( "HalfWay settings" );
		font[1] = config->readFontEntry("Font");
		half->halfText->setText( config->readEntry( "Text", i18n( "Hours left: %H" ) ) );
		half->halfBackCol->setColor( config->readColorEntry( "BackCol", &red ) );
		half->halfFontCol->setColor( config->readColorEntry( "FontCol", &black ) );
      half->rndBackCol->setChecked( config->readBoolEntry( "RandomBackCol", false ) );
      half->rndFontCol->setChecked( config->readBoolEntry( "RandomFontCol", false ) );
      half->rndFont->setChecked( config->readBoolEntry( "RandomFont", false ) );
		format = config->readNumEntry( "Display", 4 );
		half->halfYears->setChecked( calcFormat( format, YEARS ) );
		half->halfMonths->setChecked( calcFormat( format, MONTHS ) );
		half->halfWeeks->setChecked( calcFormat( format, WEEKS ) );		
		half->halfDays->setChecked( calcFormat( format, DAYS ) );
		half->halfHours->setChecked( calcFormat( format, HOURS ) );
		half->halfMin->setChecked( calcFormat( format, MINS ) );
		half->halfSec->setChecked( calcFormat( format, SECS ) );
		half->halfRoundOff->setButton( config->readNumEntry( "Round Off", 1 ) );
  		half->effects->setButton( config->readNumEntry( "Text effect", 0 ) );
		half->halfSpeed->setValue( config->readNumEntry( "Speed", 50 ) );
		
	// Setup Finish tab
	config->setGroup("Finish settings");
		font[2] = config->readFontEntry("Font");
		finish->finText->setText (config->readEntry ("Text", i18n ("The end")));
		finish->finBackCol->setColor( config->readColorEntry( "BackCol", &black ) );
		finish->finFontCol->setColor( config->readColorEntry( "FontCol", &red ) );
      finish->rndBackCol->setChecked( config->readBoolEntry( "RandomBackCol", false ) );
      finish->rndFontCol->setChecked( config->readBoolEntry( "RandomFontCol", false ) );
      finish->rndFont->setChecked( config->readBoolEntry( "RandomFont", false ) );
  		finish->effects->setButton( config->readNumEntry( "Text effect", 0 ) );
		finish->finSpeed->setValue( config->readNumEntry( "Speed", 60 ) );		

	// Setup Global settings
	config->setGroup( "Global settings" );
		if ( config->readBoolEntry( "UseHalfWay", true ) )
			half->halfOn->setChecked( true );
		else
			half->halfTabs->setEnabled( false );
		QDateTime temp = QDateTime::currentDateTime().addDays(10);
		QDateTime fin = config->readDateTimeEntry( "FinishDateTime", &temp );
		temp = QDateTime::currentDateTime().addDays(5);
		QDateTime halfw = config->readDateTimeEntry( "HalfDateTime", &temp );
		
		ULONG y, o, w, d, h, m, s;		
		calcHalfTime	( halfw, fin, y, o, w, d, h, m, s );

		finish->finDate->setDateTime( fin );
		half->switchYears->setValue( y );
		half->switchMonths->setValue( o );
		half->switchWeeks->setValue( w );
		half->switchDays->setValue( d );
		half->switchHours->setValue( h );
		half->switchMin->setValue( m );
		half->switchSec->setValue( s );
}

void SetupDlg::slotOk()
{
	closeDialog = true;
	slotApply();
	if ( closeDialog )
		accept();
}

void SetupDlg::slotApply()
{
	// Make sure the QSpinBox loses focus, or theire value won't be updated
	if ( focusWidget() )
		focusWidget()->clearFocus();
	if ( finish->finDate->getDateTime() < QDateTime::currentDateTime() )
	{
		int ans = KMessageBox::warningYesNoCancel( this, i18n( "The finish date you has entered is in the past.\n"
			"Do you want me to set it to %1" ).arg(
			QDateTime( QDate::currentDate().addDays( 1 ), finish->finDate->getDateTime().time() ).toString() ),
			i18n( "Not in the future..." ) );
		if ( ans == KMessageBox::Yes )
				finish->finDate->setDateTime( QDateTime( QDate::currentDate().addDays( 1 ), finish->finDate->getDateTime().time() ) );			
		if ( ans == KMessageBox::Cancel )
			closeDialog = false;
	}
	KConfig *config = KGlobal::config();

	// Save Start tab
	config->setGroup("Start settings");
		config->writeEntry("Text", start->startText->text());
		config->writeEntry("Font", font[0]);
		config->writeEntry( "BackCol", start->startBackCol->color() );
		config->writeEntry( "FontCol", start->startFontCol->color());
      config->writeEntry( "RandomBackCol", start->rndBackCol->isChecked() );
      config->writeEntry( "RandomFontCol", start->rndFontCol->isChecked() );
      config->writeEntry( "RandomFont", start->rndFont->isChecked() );
		config->writeEntry( "Display", calcFormat(
			start->startYears->isChecked(), start->startMonths->isChecked(), start->startWeeks->isChecked(),
			start->startDays->isChecked(), start->startHours->isChecked(), start->startMin->isChecked(),
			start->startSec->isChecked() ) );
		config->writeEntry("Round Off", start->startRoundOff->id( start->startRoundOff->selected() ) );
  		config->writeEntry("Text effect", start->effects->id( start->effects->selected() ) );
		config->writeEntry( "Speed", start->startSpeed->value() );

	// Save half way tab
	config->setGroup("HalfWay settings");
		config->writeEntry("Text", half->halfText->text());
		config->writeEntry("Font", font[1]);
		config->writeEntry("BackCol", half->halfBackCol->color());
		config->writeEntry("FontCol", half->halfFontCol->color());
      config->writeEntry( "RandomBackCol", half->rndBackCol->isChecked() );
      config->writeEntry( "RandomFontCol", half->rndFontCol->isChecked() );
      config->writeEntry( "RandomFont", half->rndFont->isChecked() );
		config->writeEntry("Display", calcFormat(
			half->halfYears->isChecked(), half->halfMonths->isChecked(), half->halfWeeks->isChecked(),
			half->halfDays->isChecked(), half->halfHours->isChecked(), half->halfMin->isChecked(),
			half->halfSec->isChecked() ) );
		config->writeEntry("Round Off", half->halfRoundOff->id( half->halfRoundOff->selected() ) );
  		config->writeEntry("Text effect", half->effects->id( half->effects->selected() ) );
		config->writeEntry( "Speed", half->halfSpeed->value() );
		
	// Save finish tab
	config->setGroup("Finish settings");
		config->writeEntry("Text", finish->finText->text());
		config->writeEntry("Font", font[2]);
		config->writeEntry("BackCol", finish->finBackCol->color());
		config->writeEntry("FontCol", finish->finFontCol->color());
      config->writeEntry( "RandomBackCol", finish->rndBackCol->isChecked() );
      config->writeEntry( "RandomFontCol", finish->rndFontCol->isChecked() );
      config->writeEntry( "RandomFont", finish->rndFont->isChecked() );
  		config->writeEntry("Text effect", finish->effects->id( finish->effects->selected() ) );
		config->writeEntry( "Speed", finish->finSpeed->value() );		
		
	// Save global settings
	config->setGroup("Global settings");
		config->writeEntry( "FinishDateTime", finish->finDate->getDateTime() );
		config->writeEntry( "HalfDateTime", calcHalfTime(
			finish->finDate->getDateTime(), half->switchYears->value(), half->switchMonths->value(),
			half->switchWeeks->value(), half->switchDays->value(), half->switchHours->value(),
			half->switchMin->value(), half->switchSec->value() ) );
		config->writeEntry( "UseHalfWay", half->halfOn->isChecked() );

	config->sync();	
}

void SetupDlg::slotDefault()
{
  KAboutData aboutData( "kountdown.kss", "KountDown", VERSION,
    I18N_NOOP( "A screensaver that counts down\nto selected date" ), KAboutData::License_GPL_V2,
    "(c) 2002, Erik Johansson", 0, "http://come.to/erre", "erre@telia.com");
  aboutData.addAuthor("Erik Johansson", "Author and maintainer", "erre@telia.com", "http://come.to/erre" );
  aboutData.addCredit( "Florian Hacker", "Suggestions and bugfixes", 0, 0 );
  aboutData.addCredit( "Thomas Kosch", "Found a nasty bug", 0, 0 );
  KAboutApplication about(&aboutData);
  about.exec();
}

void SetupDlg::slotFont()
{
	KFontDialog::getFont( font[activePageIndex()] );
}

QDateTime SetupDlg::calcHalfTime( const QDateTime fin, const ULONG y, const ULONG o,	const ULONG w,	
	const ULONG d,	const ULONG h, const ULONG m, const ULONG s )
{
	ULONG temp;
	temp = (y * 365) + (o * 30) + (w * 7) + d;
	QDateTime half = fin.addDays( -temp );
	temp = (h * 3600) + (m * 60) + s;
	return half.addSecs( -temp );

}

void SetupDlg::calcHalfTime( const QDateTime half, const QDateTime fin, ULONG &y, ULONG &o, ULONG &w,
	ULONG &d, ULONG &h, ULONG &m, ULONG &s )
{
	ULONG temp;
	if ( half.time() <= fin.time() )
		temp = half.daysTo(fin);
	else
		temp = ( half.daysTo(fin) - 1 >= 0 ) ? half.daysTo(fin) - 1 : 0;
	ULONG addDays = temp;
	
	y = (temp - (temp % 365)) / 365;
	temp = temp - (y * 365);
	o = (temp - (temp % 30)) / 30;
	temp = temp - (o * 30);
	w = (temp - (temp % 7)) / 7;
	temp = temp - (w * 7);
	d = temp;
	QDateTime calc = half.addDays( addDays );
	
	temp = calc.secsTo(fin);
	h = (temp - (temp % 3600)) / 3600;
	temp = temp - (h * 3600);
	m = (temp - (temp % 60)) / 60;
	s = temp - (m * 60);
}

int SetupDlg::calcFormat( bool y, bool m, bool w, bool d, bool h, bool min, bool s )
{
	int format = 0;
	if ( y )
		format += 64;
	if ( m )
		format += 32;
	if ( w )
		format += 16;
	if ( d )
		format += 8;
	if ( h )
		format += 4;
	if ( min )
		format += 2;
	if ( s )
		format += 1;
	return format;
}

bool SetupDlg::calcFormat( int &format, NAME name )
{
	switch ( name )
	{
	case YEARS:
		if ( format >= 64 )
		{
			format -= 64;
			return true;
		}
		break;
	case MONTHS:
		if ( format >= 32 )
		{
			format -= 32;
			return true;
		}
		break;
	case WEEKS:
		if ( format >= 16 )
		{
			format -= 16;
			return true;
		}
		break;
	case DAYS:
		if ( format >= 8 )
		{
			format -= 8;
			return true;
		}
		break;
	case HOURS:
		if ( format >= 4 )
		{
			format -= 4;
			return true;
		}
		break;
	case MINS:
		if ( format >= 2 )
		{
			format -= 2;
			return true;
		}
		break;
	case SECS:
		if ( format >= 1 )
		{
			format -= 1;
			return true;
		}
		break;
	}
	return false;
}

