/***************************************************************************
                          kountdownsetup.cpp  -  description
                             -------------------
    begin                : Sun Feb 10 2002
    copyright            : (C) 2002 by Erik Johansson
    email                : erre@telia.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qcheckbox.h>
#include <qbuttongroup.h>
#include <qtabwidget.h>
#include <qfont.h>
#include <qdatetime.h>
#include <qregexp.h>
#include <qmultilineedit.h>
#include <qslider.h>
#include <qspinbox.h>
#include <qstring.h>

#include <kcolorbutton.h>
#include <kconfig.h>
#include <kglobal.h>
#include <klocale.h>
#include <klineedit.h>
#include <kfontdialog.h>
#include <kmessagebox.h>

#include "kountdownsetup.h"
#include "timewidget.h"
#include "global.h"

KountdownSetup::KountdownSetup(QWidget *parent, const char *name ) : KSetupDlg(parent, name, true)
{
	readSettings();
}

KountdownSetup::~KountdownSetup()
{
}

void KountdownSetup::readSettings()
{
	int format;
	KConfig *config = KGlobal::config();

	// Setup Start tab
	config->setGroup( "Start settings" );
		font[0] = config->readFontEntry("Font");
		startText->setText( config->readEntry( "Text", i18n( "Days left: %D" ) ) );
		startBackCol->setColor( config->readColorEntry( "BackCol", &black ) );
		startFontCol->setColor( config->readColorEntry( "FontCol", &red ) );
		format = config->readNumEntry( "Display", 15 );
		startDays->setChecked( calcFormat( format, DAYS ) );
		startHours->setChecked( calcFormat( format, HOURS ) );
		startMin->setChecked( calcFormat( format, MINS ) );
		startSec->setChecked( calcFormat( format, SECS ) );
		startRoundOff->setButton( config->readNumEntry( "Round Off", 0 ) );
		startLoop->setChecked( config->readBoolEntry( "Loop text", true ) );
		startSpeed->setValue( config->readNumEntry( "Speed", 50 ) );

	// Setup Half way tab
	config->setGroup( "HalfWay settings" );
		font[1] = config->readFontEntry("Font");
		halfText->setText( config->readEntry( "Text", i18n( "Hours left: %H" ) ) );
		halfBackCol->setColor( config->readColorEntry( "BackCol", &black ) );
		halfFontCol->setColor( config->readColorEntry( "FontCol", &red ) );
		format = config->readNumEntry( "Display", 15 );
		halfDays->setChecked( calcFormat( format, DAYS ) );
		halfHours->setChecked( calcFormat( format, HOURS ) );
		halfMin->setChecked( calcFormat( format, MINS ) );
		halfSec->setChecked( calcFormat( format, SECS ) );
		halfRoundOff->setButton( config->readNumEntry( "Round Off", 0 ) );
		halfLoop->setChecked( config->readBoolEntry( "Loop text", true ) );		
		halfSpeed->setValue( config->readNumEntry( "Speed", 50 ) );
		
	// Setup Finish tab
	config->setGroup("Finish settings");
		font[2] = config->readFontEntry("Font");
		finText->setText (config->readEntry ("Text", i18n ("The end")));
		finBackCol->setColor( config->readColorEntry( "BackCol", &black ) );
		finFontCol->setColor( config->readColorEntry( "FontCol", &red ) );
		finLoop->setChecked( config->readBoolEntry( "Loop text", true ) );		
		finSpeed->setValue( config->readNumEntry( "Speed", 50 ) );		

	// Setup Global settings
	config->setGroup( "Global settings" );
		halfOn->setChecked( config->readBoolEntry( "UseHalfWay", false ) );
		QDateTime temp = QDateTime::currentDateTime().addDays(10);
		QDateTime fin = config->readDateTimeEntry( "FinishDateTime", &temp );
		temp = QDateTime::currentDateTime().addDays(5);
		QDateTime half = config->readDateTimeEntry( "HalfDateTime", &temp );
		
		ULONG d, h, m, s;		
		calcHalfTime	( half, fin, d, h, m, s );

		finDate->setDateTime( fin );
		switchDays->setValue( d );
		switchHours->setValue( h );
		switchMin->setValue( m );
		switchSec->setValue( s );
}

void KountdownSetup::slotApply()
{
	// Make sure the QSpinBox loses focus, or theire value won't be updated
	if ( focusWidget() )
		focusWidget()->clearFocus();
	if ( finDate->getDateTime() < QDateTime::currentDateTime() )
	{
		finDate->setDateTime( QDateTime( QDate::currentDate().addDays( 1 ), finDate->getDateTime().time() ) );
		KMessageBox::sorry( this, i18n( "The date and time you has entered is in the past. "
			"Setting time to now + one day" ), i18n( "Not in the future..." ) );
	}
	KConfig *config = KGlobal::config();

	// Save Start tab
	config->setGroup("Start settings");
		config->writeEntry("Text", startText->text());
		config->writeEntry("Font", font[0]);
		config->writeEntry("BackCol", startBackCol->color());
		config->writeEntry("FontCol", startFontCol->color());
		config->writeEntry("Display", calcFormat(
			startDays->isChecked(), startHours->isChecked(), startMin->isChecked(), startSec->isChecked() ) );
		config->writeEntry("Round Off", startRoundOff->id( startRoundOff->selected() ) );
		config->writeEntry( "Loop text", startLoop->isChecked() );
		config->writeEntry( "Speed", startSpeed->value() );

	// Save half way tab
	config->setGroup("HalfWay settings");
		config->writeEntry("Text", halfText->text());
		config->writeEntry("Font", font[1]);
		config->writeEntry("BackCol", halfBackCol->color());
		config->writeEntry("FontCol", halfFontCol->color());
		config->writeEntry("Display", calcFormat(
			halfDays->isChecked(), halfHours->isChecked(), halfMin->isChecked(), halfSec->isChecked() ) );
		config->writeEntry("Round Off", halfRoundOff->id( halfRoundOff->selected() ) );
		config->writeEntry( "Loop text", halfLoop->isChecked() );
		config->writeEntry( "Speed", halfSpeed->value() );
		
	// Save finish tab
	config->setGroup("Finish settings");
		config->writeEntry("Text", finText->text());
		config->writeEntry("Font", font[2]);
		config->writeEntry("BackCol", finBackCol->color());
		config->writeEntry("FontCol", finFontCol->color());
		config->writeEntry( "Loop text", finLoop->isChecked() );
		config->writeEntry( "Speed", finSpeed->value() );		
		
	// Save global settings
	config->setGroup("Global settings");
		config->writeEntry( "FinishDateTime", finDate->getDateTime() );
		config->writeEntry( "HalfDateTime", calcHalfTime(
			finDate->getDateTime(), switchDays->value(), switchHours->value(), switchMin->value(), switchSec->value() ) );
		config->writeEntry( "UseHalfWay", halfOn->isChecked() );

	config->sync();
}

void KountdownSetup::slotOk()
{
	slotApply();
	accept();
}

void KountdownSetup::slotAbout()
{
	QString about;
	about.sprintf( i18n( "KountDown version %s\n\nWritten by Erik Johansson 2002\n"
			"e-mail: erre@telia.com\nhomepage: http://come.to/erre" ), VERSION );
	KMessageBox::about( this, about, "About KountDown" );
}

void KountdownSetup::slotFont()
{
	KFontDialog::getFont( font[setupTabs->currentPageIndex()] );
}
	
QDateTime KountdownSetup::calcHalfTime(
		const QDateTime fin, const ULONG d,	const ULONG h, const ULONG m, const ULONG s )
{
	ULONG temp;
	temp = (d * 24 * 3600) + (h * 3600) + (m * 60) + s;
	return fin.addSecs( -temp );

}

void KountdownSetup::calcHalfTime(
		const QDateTime half, const QDateTime fin, ULONG &d, ULONG &h, ULONG &m, ULONG &s )
{
	ULONG temp = half.secsTo(fin);
	d = (temp - (temp % (24 * 3600))) / (24 * 3600);
	temp = temp - (d * 24 * 3600);
	h = (temp - (temp % 3600)) / 3600;
	temp = temp - (h * 3600);
	m = (temp - (temp % 60)) / 60;
	s = temp - (m * 60);
}

int KountdownSetup::calcFormat( bool d, bool h, bool m, bool s )
{
	int format = 0;
	if ( d )
		format += 8;
	if ( h )
		format += 4;
	if ( m )
		format += 2;
	if ( s )
		format += 1;
	return format;
}

bool KountdownSetup::calcFormat( int &format, NAME name )
{
	switch ( name )
	{
	case DAYS:
		if ( format >= 8 )
		{
			format -= 8;
			return true;
		}
		break;
	case HOURS:
		if ( format >= 4 )
		{
			format -= 4;
			return true;
		}
		break;
	case MINS:
		if ( format >= 2 )
		{
			format -= 2;
			return true;
		}
		break;
	case SECS:
		if ( format >= 1 )
		{
			format -= 1;
			return true;
		}
		break;
	}
	return false;
}
