/*  This file is part of the KDE project
    Copyright (C) 2000,2001 Simon Hausmann <hausmann@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

// !! The history code is (c) David Faure <faure@kde.org> !!

#ifndef __mainwindowbase_h__
#define __mainwindowbase_h__

#include <qmainwindow.h>
#include <qaction.h>

#include <kurl.h>
#include <kparts/browserextension.h>

class QComboBox;
class QLineEdit;
class QTimer;
class QWidgetStack;
class View;
class QToolButton;
class BookmarkManager;

#include "bookmarks.h"

namespace KIO
{
    class Job;
};

class MainWindowBase : public QMainWindow
{
    Q_OBJECT
public:
    virtual ~MainWindowBase();

    View *currentView() const { return m_currentView; }

    static KURL homeURL();

    static MainWindowBase *instantiate();

public slots:
    void createNewView( const KURL &url, const KParts::URLArgs &args = KParts::URLArgs() );
    void createNewView( const KURL &url, const KParts::URLArgs &args,
                        const KParts::WindowArgs &windowArgs, KParts::ReadOnlyPart *&part );

    void urlEntered( const QString & );

protected:
    MainWindowBase( QWidget *parent, const char *name, WFlags flags );

    virtual void init();

protected slots:
    void home();

    void find();

    void closeFind();

    void statusMessage( const QString &msg );

    void prepareWindowListMenu();

    void activateWindowFromPopup( int id );

    void viewDestroyed();

    void viewWidgetDestroyed();

    void closeView();

    void openURL( View *view, const KURL &url, const KParts::URLArgs &args );

    virtual void popupMenu( const QString &url, const QPoint & );

    void newView();

    void showPreferences();

    void setLocationBarURL( const QString &url );

    void toggleLocationBar();

//    void setEncoding( const QString &encoding );

protected:
    virtual View *createNewViewInternal( const KURL &url, const KParts::URLArgs &args );

    void setActiveView( View *view );

    void disconnectView( View *view );

    void connectView( View *view );

    View *findChildView( const QString &name, KParts::BrowserHostExtension **hostExtension );

    void initActions();

    virtual void initGUI() = 0;

    virtual QIconSet loadPixmap( const char *xpm[] );

    QAction *m_menu;
    QAction *m_close;
    QAction *m_stop;
    QAction *m_back;
    QAction *m_forward;
    QAction *m_home;
    QAction *m_reload;
    QAction *m_find;
    QAction *m_closeFind;
    QAction *m_windows;
    QAction *m_security;
    QAction *m_newView;
    QAction *m_preferences;

    QToolBar *m_searchBar;
    QLineEdit *m_findInput;

    QComboBox *m_locationCombo;

    QPopupMenu *m_mainMenu;
    QPopupMenu *m_windowList;

//    QPopupMenu *m_encodingMenu;
//    QAction *m_encoding;

    QAction *m_toggleLocationBar;

    BookmarkManager *m_bookmarks;

    QTimer *m_statusBarAutoHideTimer;

    QWidgetStack *m_widgetStack;
    QList<View> m_views;
    QGuardedPtr<View> m_currentView;
    int m_widgetId;

    static KURL *s_homeURL;
};

// destruction and removeFrom code I deliberated left out as it's not needed
// here and just costs size :)
class PopupAction : public QAction
{
    Q_OBJECT
public:
    PopupAction( QPopupMenu *popup, const QString &text, const QIconSet &iconSet,
                 const QString &menuText, int accel, QObject *parent, const char *name = 0,
                 bool toggle = false );

    virtual bool addTo( QWidget *widget );

public slots:
    virtual void setEnabled( bool enable );

protected:
    virtual bool eventFilter( QObject *o, QEvent *e );

private:
    QPopupMenu *m_popup;
    QToolButton *m_toolButton; // ### let's save memory and assume we plug the action only once anyway
};

#endif
