/*  This file is part of the KDE project
    Copyright (C) 2001 Simon Hausmann <hausmann@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    As a special exception this program may be linked with Qt non-commercial 
    edition, the resulting executable be distributed, without including the 
    source code for the Qt non-commercial edition in the source distribution.

*/

// Implementation of the X11 GUI

#include "mainwindow_x11.h"

#if defined(KONQ_GUI_X11)

#include <qpopupmenu.h>
#include <qtoolbar.h>
#include <qaction.h>
#include <qmenubar.h>
#include <qlineedit.h>
#include <qstatusbar.h>
#include <qcombobox.h>

#include <klocale.h>

MainWindowX11::MainWindowX11()
    : MainWindowBase( 0, 0, WType_TopLevel|WDestructiveClose )
{
}

void MainWindowX11::initGUI()
{
    QToolBar *tb = new QToolBar( this );
    tb->setBackgroundColor( backgroundColor() );
//    tb->setHorizontalStretchable( true );
    m_mainToolBar = tb;

    m_newView->addTo( m_mainMenu );

    m_mainMenu->insertSeparator();

//    m_encoding->addTo( m_mainMenu );
//
//    m_mainMenu->insertSeparator();

    m_toggleLocationBar->addTo( m_mainMenu );
    m_autoloadImages->addTo( m_mainMenu );

    m_mainMenu->insertSeparator();

    m_find->addTo( m_mainMenu );

    m_mainMenu->insertSeparator();

    m_preferences->addTo( m_mainMenu );

    m_mainMenu->insertSeparator();

    if ( m_bookmarks->addTo( m_mainMenu ) )
        m_mainMenu->insertSeparator();

    m_close->addTo( m_mainMenu );

    m_menu->addTo( tb );

    m_back->addTo( tb );

    m_forward->addTo( tb );

    m_home->addTo( tb );

    m_reload->addTo( tb );

    m_stop->addTo( tb );

    m_security->addTo( tb );

    m_windows->addTo( tb );

    m_zoom->addTo( tb );

    tb->show();

    tb = new QToolBar( i18n( "Location:" ), this, QMainWindow::Top, true, "locationbar" );
    tb->setHorizontalStretchable( true );

    m_locationCombo = new QComboBox( true, tb, "locationcombo" );

    tb->show();

    statusBar()->setSizeGripEnabled( false );

    m_searchBar = new QToolBar( "searchbar", this, QMainWindow::Top, true );

    m_findInput = new QLineEdit( m_searchBar, "search" );

    m_searchBar->setStretchableWidget( m_findInput );

    m_closeFind->addTo( m_searchBar );

    m_searchBar->hide();
}

void MainWindowX11::showLoadImagesAction( bool show )
{
    if ( show )
        m_loadImages->addTo( m_mainToolBar );
    else
        m_loadImages->removeFrom( m_mainToolBar );
}

#include "mainwindow_x11.moc"

#endif

/*
 * vim:ts=4:et:sw=4
 */
