/***************************************************************************
                          knutrwvar.cpp  -  description
                             -------------------
    begin                : So rj 26 2002
    copyright            : (C) 2002 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knutrwvar.h"
#include "knutprintupsvar.h"

#include <qframe.h>
#include <qlabel.h>
#include <qstring.h>

#include <kcombobox.h>
#include <kmessagebox.h>


KNutRWVar::KNutRWVar(QString uName, QString password, KNutNet* initUpsNet, QWidget* parent, const char* name, bool modal)
: KDialogBase(Plain, i18n("RW variables"),Ok|Cancel|Default,Ok, parent, name, modal, true), myUpsNet(initUpsNet){
  struct upsRVar myStructRVar;

  myUpsNet->getUpsValues(true);

    QFrame *page = plainPage();
    QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );
    QLabel *label1 = new QLabel (i18n("SET RW VARIABLE"),page,"label1");
    label1->setAlignment(Qt::AlignHCenter);
    topLayout->addWidget(label1);


    QLabel *label2 = new QLabel (i18n("Variable:"),page,"label2");
    rWVarBox = new KComboBox(page,"rwvarbox");

    QLabel *label3 = new QLabel (i18n("Value:"),page,"label2");
    valueVarBox = new KComboBox(page,"valuevarbox");
    valueVarLine = new KLineEdit(page,"valuevarLine");
    valueVarLine->hide();
   
    passLayout = new QGridLayout (4,2,5,"passLayout");
    QLabel *labelName = new QLabel (i18n("User name:"),page,"labelName");
    QLabel *labelPassword = new QLabel (i18n("Password:"),page,"labelPassword");
    lineEditName = new KLineEdit( page, "LineEditName" );
    lineEditName->setText(uName);
    lineEditPassword = new KLineEdit( page, "LineEditName" );
    lineEditPassword->setText(password);
    lineEditPassword->setEchoMode(QLineEdit::Password);

    topLayout->addLayout(passLayout);

    passLayout->addWidget(label2,0,0);
    passLayout->addWidget(rWVarBox,0,1);
    passLayout->addWidget(label3,1,0);
    passLayout->addWidget(labelName,2,0);
    passLayout->addWidget(labelPassword,3,0);
    passLayout->addWidget(lineEditName,2,1);
    passLayout->addWidget(lineEditPassword,3,1);

    topLayout->addStretch(10);
   //naplnime ComboBox
    int n;
    if (( n = (myUpsNet->readNumberVars( RW_VARS )+1)) > 1 ) { // zvetsime si pocet o 1
      for (int i =1; i < n ; i++) {
        myUpsNet->readVars(i, myStructRVar,RW_VARS);
        rWVarBox->insertItem(myStructRVar.upsVarName);
        }
      slotChangeVar(0);
      }
    else {
      passLayout->addWidget(valueVarLine,1,1);
      valueVarLine->setMaxLength(myStructRVar.upsVarMax);
      valueVarBox->hide();
      valueVarLine->show();
      upsValueType=true;
      }
    connect (rWVarBox,SIGNAL(activated(int)),this,SLOT(slotChangeVar(int)));
    }


int KNutRWVar::findItem(KComboBox *myBox ,QString text) {
  int n;

  if ((n=myBox->count())) {
    for (int i =0; i < n; i++)
      if (text == myBox->text(i)) return i;
    }
  return myBox->currentItem();  
  }
    
void KNutRWVar::slotDefault () {
  struct upsRVar myStructRVar;

  QString varName = rWVarBox->currentText();
  myUpsNet->readVars((char *)varName.latin1(),myStructRVar);
  if (myStructRVar.upsValueType) {
    valueVarLine->setText(myStructRVar.upsValue);
    }
//**** Tato cast je pro 3.x
//  else valueVarBox->setCurrentItem(myStructRVar.upsValue);
//**** Tato cast je pro 2.3.x nebo vetsi
  else valueVarBox->setCurrentItem(findItem(valueVarBox,myStructRVar.upsValue));
  }  

void KNutRWVar::slotChangeVar(int item) {
  struct upsRVar myStructRVar;

  QString varName = rWVarBox->text(item);
  myUpsNet->readVars((char *)varName.latin1(),myStructRVar);
  upsValueType=myStructRVar.upsValueType;
  if (myStructRVar.upsValueType) {
    // char
    valueVarBox->hide();
    valueVarLine->show();
    passLayout->addWidget(valueVarLine,1,1);
    valueVarLine->setText(myStructRVar.upsValue);
    }
  else {
    //enum
    valueVarLine->hide();
    valueVarBox->show();
    passLayout->addWidget(valueVarBox,1,1);
    valueVarBox->clear();
    if (myStructRVar.upsVarMax) {
      for (int i = 0 ; i < myStructRVar.upsVarMax; i++)
        valueVarBox->insertItem(myUpsNet->readEnumValueVar(myStructRVar.upsVarName,i+1));
      }
//****  Tato cast je pro verzi 3.x
//    valueVarBox->setCurrentItem(myStructRVar.upsValue);
//****   Tato cast je pro verzi 2.3.x
    valueVarBox->setCurrentItem(findItem(valueVarBox,myStructRVar.upsValue));
    }
  }



KNutRWVar::~KNutRWVar(){
}

void KNutRWVar::slotOk() {
  char *value;
  if (upsValueType) value=(char *)valueVarLine->text().latin1();
  else value=(char *)valueVarBox->currentText().latin1();
  if (!myUpsNet->setVariable((char *)rWVarBox->currentText().latin1(), value, (char *)lineEditName->text().latin1(),(char *)lineEditPassword->text().latin1())) {
    myUpsNet->getUpsValues(true);
    emit signalChangeRWVars(rWVarBox->currentText()); //dame prikaz k natazeni promene
                                                      // a pripadne k prekresleni panelu
    accept();
    }
  else {
    //Nahlasime chybu
    KNutPrintUpsVar::showError (myUpsNet->getError());
    }
  }


