/***************************************************************************
                          knutprintupsvar.cpp  -  description
                             -------------------
    begin                : St cec 3 2002
    copyright            : (C) 2002 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knutprintupsvar.h"

#include <kmessagebox.h>
#include <qgroupbox.h>
#include <qscrollview.h>

// od verze 6  nebudeme vytvaret vlastni spojeni

KNutPrintUpsVar::KNutPrintUpsVar(KNutNet* upsNet, QWidget* parent,  const char* name, bool modal )
: KDialogBase(Plain, i18n("Variables"),User1|Cancel,Ok, parent, name, modal, true), myUpsNet(upsNet){

//KNutPrintUpsVar::KNutPrintUpsVar(KNutNet* upsNet, QWidget* parent,  const char* name, bool modal, WFlags fl )
//    : KDialog( parent, name, modal, fl ), myUpsNet(upsNet) {


  upsRVar myStructVar;
  upsRIComm myStructIComm;

  lVars *pointerVar, *endVar ;
  firstVar = pointerVar = endVar = 0L;

  setButtonText(User1,i18n("Reload Vars"));
  setName( "knutprintupsvar" );
  setCaption( i18n("UPS variables") );
  
  if (myUpsNet->getUpsValues(true) !=0) {
    KNutPrintUpsVar::showError (myUpsNet->getError());
    upsConnectOk = false;
    }
  else {
    upsConnectOk = true;

   QFrame *page = plainPage();
//   QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );



    QHBoxLayout* upsVarsMainLayout = new QHBoxLayout(page);

    QScrollView* sv = new QScrollView(page);
    sv->setVScrollBarMode(QScrollView::AlwaysOn);
    sv->setResizePolicy(QScrollView::AutoOneFit);
//    sv->setStaticBackground(true);
//    sv = new QScrollView(page);
    upsVarsMainLayout->addWidget(sv);
    QWidget* mw = new QWidget(page);
//    mw = new QWidget(page);

    sv->addChild(mw);

    QHBoxLayout* upsVarsHLayout = new QHBoxLayout(mw);

    upsVarsLayout = new QVBoxLayout();
    upsVarsHLayout->addLayout(upsVarsLayout);


    upsVarsLayout->setMargin(5);


    // GROUP BOX pro RO promenne
    QGroupBox* myROGroupBox = new QGroupBox (i18n("Read Only Variables"),mw,"myROGroupBox");
    myROGroupBox->setColumnLayout(0, Qt::Vertical );
    myROGroupBox->layout()->setSpacing( 0 );
    myROGroupBox->layout()->setMargin( 3 );
    myROGroupBox->setFrameStyle( QFrame::Box | QFrame::Sunken);

    myGridROVars = new QGridLayout( myROGroupBox->layout() );
    myGridROVars->setAlignment( Qt::AlignTop );

    // GROP BOX pro RW promenne
    QGroupBox* myRWGroupBox = new QGroupBox (i18n("Read/Write Variables"),mw,"myRWGroupBox");
    myRWGroupBox->setColumnLayout(0, Qt::Vertical );
    myRWGroupBox->layout()->setSpacing( 0 );
    myRWGroupBox->layout()->setMargin( 3 );
    myRWGroupBox->setFrameStyle( QFrame::Box | QFrame::Sunken);

    myGridRWVars = new QGridLayout( myRWGroupBox->layout() );
    myGridRWVars->setAlignment( Qt::AlignTop );

    // GROP BOX pro Instant Commands
    QGroupBox* myICGroupBox = new QGroupBox (i18n("Instant Commands"),mw,"myICGroupBox");
    myICGroupBox->setColumnLayout(0, Qt::Vertical );
    myICGroupBox->layout()->setSpacing( 0 );
    myICGroupBox->layout()->setMargin( 3 );
    myICGroupBox->setFrameStyle( QFrame::Box | QFrame::Sunken);

    myGridICVars = new QGridLayout( myICGroupBox->layout() );
    myGridICVars->setAlignment( Qt::AlignTop );


    // Vlozime widgety
    // vlozime GROUP BOX
    upsVarsLayout->addWidget(myROGroupBox);
    upsVarsLayout->addSpacing(5);
    upsVarsLayout->addWidget(myRWGroupBox);
    upsVarsLayout->addSpacing(5);
    upsVarsLayout->addWidget(myICGroupBox);

    // konec vlozeni hlavnich widgetu

   countVars=myUpsNet->readNumberVars(ALL_VARS);
   countIComms=myUpsNet->readNumberComms();

    // naplnime mrizku a RO promenne
    int j=0;
    for (int i=0; i<countVars; i++) {
      myUpsNet->readVars(i+1,myStructVar);

      if (myStructVar.upsVarType) {
        pointerVar = new lVars;
        if (firstVar == 0) endVar = firstVar = pointerVar;
        else {
          endVar->nextVar=pointerVar;
          endVar = pointerVar;
          }
        pointerVar->nextVar=0;

        QLabel* myLabel = new QLabel (myROGroupBox);
        myLabel->setText (myStructVar.upsVarName);
        myGridROVars->addWidget (myLabel,j,1);
        pointerVar->myName=myLabel;

        myLabel = new QLabel (myROGroupBox);
        myLabel->setText (myStructVar.upsValue);
        myGridROVars->addWidget (myLabel,j++,2);
        pointerVar->myVar=myLabel;
        }
      } //endfor


    myGridRWVars->addColSpacing(0,5);
    myGridRWVars->addColSpacing(3,5);

    j=0;
    for (int i=0; i<countVars; i++) {
      myUpsNet->readVars(i+1,myStructVar);

      if (!myStructVar.upsVarType) {
      pointerVar = new lVars;
      if (firstVar == 0) endVar = firstVar = pointerVar;
      else {
        endVar->nextVar=pointerVar;
        endVar = pointerVar;
        }
      pointerVar->nextVar=0;

      QLabel* myLabel = new QLabel (myRWGroupBox);
      myLabel->setText (myStructVar.upsVarName);
      myGridRWVars->addWidget (myLabel,j,1);
      pointerVar->myName=myLabel;

      myLabel = new QLabel (myRWGroupBox);
      myLabel->setText (myStructVar.upsValue);
      myGridRWVars->addWidget (myLabel,j++,2);
      pointerVar->myVar=myLabel;
      }
    }

// naplneme prikazy
    myGridICVars->addColSpacing(0,5);
    myGridICVars->addColSpacing(2,5);

    for (int i=0; i<countIComms; i++) {
      myUpsNet->readIComm(i+1,myStructIComm);

      QLabel* myLabel = new QLabel (myICGroupBox);
      myLabel->setText (myStructIComm.upsCommName);
      myGridICVars->addWidget (myLabel,i,1);
      }
    connect (this,SIGNAL(user1Clicked()),this,SLOT(slotReloadVars()));

    } // end else
  }


KNutPrintUpsVar::~KNutPrintUpsVar(){
  lVars* pointerVar;

  if (firstVar != 0) {
    while (firstVar !=0) {
      pointerVar = firstVar;
      firstVar = firstVar->nextVar;
      delete pointerVar;
      }
    }
  }


void KNutPrintUpsVar::slotReloadVars (void) {
  upsRVar myStructVar;
  lVars* pointerVar;
  
//  int countVars = myUpsNet->readNumberVars();
  if (myUpsNet->getUpsValues(true) !=0)
    showError (myUpsNet->getError());
  else {
    // zobrazime data
    pointerVar = firstVar;
//    for (int i=0; i<countVars; i++) {
    while (pointerVar!=0l) {
      QString varName=pointerVar->myName->text();
      myUpsNet->readVars((char *)varName.latin1(),myStructVar);
      pointerVar->myVar->setText (myStructVar.upsValue);
      pointerVar=pointerVar->nextVar;
      }
    }
  }

bool KNutPrintUpsVar::upsOk (void) { return upsConnectOk; };

void KNutPrintUpsVar::showError (int error) {
  switch (error) {

// knutclient error
    case KUPS_LOW_MEM: KMessageBox::sorry (0,i18n("No memmory."));
      break;
    case KUPS_NULL_ADDRESS: KMessageBox::sorry (0,i18n("No address."));
      break;
    case KUPS_NO_SUCH_HOST: KMessageBox::sorry (0,i18n("Unknown address."));
      break;
    case KUPS_SOCKET_ERR:   // socket
    case KUPS_BIND_ERR:  // bind
    case KUPS_CONNECT_ERR:  // connect
    case KUPS_SELECT_ERR:
      KMessageBox::sorry (0,i18n("No connect with server."));
      break;
    case KUPS_SENDTO_ERR:
    case KUPS_SEND_ERR:
      KMessageBox::sorry (0,i18n("Server doesn't receive data."));
      break;
    case KUPS_RECVFROM_ERR:
    case KUPS_RECV_ERR:
      KMessageBox::sorry (0,i18n("Server doesn't send data."));
      break;
    case KUPS_NO_SERVER_DATA: KMessageBox::sorry (0,i18n("Server doesn't answer."));
      break;
    case KUPS_NO_UPSNET_OK: KMessageBox::sorry (0,i18n("No connect with server."));
      break;

      
// server error      
    case KUPS_ACCESS_DENIED: KMessageBox::sorry (0,i18n("Access denied. Failed password ?"));
      break;
    case KUPS_DATA_STALE: KMessageBox::sorry (0,i18n("Ups doesn't sent data to server."));
      break;
    case KUPS_UNKNOWN_COMMAND: KMessageBox::sorry (0,i18n("Server doesn't know this command."));
      break;

      
// driver error      
    case KUPS_PASSWORD_REQUIRED: KMessageBox::sorry (0,i18n("Server required password."));
      break;
    case KUPS_PASSWORD_INCORRECT: KMessageBox::sorry (0,i18n("Incorrect password."));
      break;
    case KUPS_NO_RESPONSE: KMessageBox::sorry (0,i18n("Ups doesn't response."));
      break;
    case KUPS_COMMAND_FAILED: KMessageBox::sorry (0,i18n("Command failed."));
      break;
    case KUPS_UNKNOWN_INSTCMD: KMessageBox::sorry (0,i18n("Ups doesn't know this instant command."));
      break;
    case KUPS_CMD_NOT_SUPPORTED: KMessageBox::sorry (0,i18n("Ups doesn't support this instant command."));
      break;
    case KUPS_VAR_UNKNOWN: KMessageBox::sorry (0,i18n("Ups doesn't known this variable."));
      break;
    case KUPS_VAR_NOT_SUPPORTED: KMessageBox::sorry (0,i18n("Ups doesn't support this variable."));
      break;

    default:KMessageBox::sorry (0,i18n("Unknown error."));
    }
  }

