/***************************************************************************
                          knutprefdlg.cpp  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knutprefdlg.h"
#include "knutvardata.h"

#include "knutfrontpanel.h"

#include <kiconloader.h>
#include <qlayout.h>

#include <stdio.h>
//#include <iostream>

#define MAIN_PANEL_FONT 0
#define ANALOG_PANEL_FONT 1

void KNutPrefDlg::initSetting () {
  QFrame *page = addPage( i18n("Setting"),i18n("Main Setting"),DesktopIcon("misc"));
  QVBoxLayout *setTopLayout = new QVBoxLayout( page, 10, spacingHint (), "setTopLayout" );

//nahradime boxem
  QGroupBox *dataBox = new QGroupBox (page ,"dataBox");
  QGridLayout *dataLayout = new QGridLayout (dataBox,3,2,spacingHint());
  dataBox->setFrameStyle(QFrame::NoFrame);
  setTopLayout->addWidget(dataBox);

  QButtonGroup *VFGroup = new QButtonGroup(i18n("Voltage/Frequency"),page,"VFGroup");
  QGridLayout *setVoltFreqLayout = new QGridLayout (VFGroup, 4 , 2,spacingHint () );

  xfer = new QCheckBox (i18n("&Use High-Low XFER"),VFGroup,"xfer");

  QLabel *label1 = new QLabel(i18n("Number of columns :"),dataBox,"label1");
  numberOfColumns = new QSpinBox(MIN_COLS,MAX_COLS,1,dataBox);

  QLabel *label2 = new QLabel(i18n("Use custom background color"),dataBox,"label2");
  checkBoxCbc = new QCheckBox ("",dataBox,"checboxcbc");

  
  label3 = new QLabel(i18n("Color of background :"),dataBox,"label3");
  BGButton = new KColorButton (dataBox);
  BGButton->setColor (prefData->mainBackgroundColor);

  QLabel *label4 = new QLabel(i18n("Use dialog \"Are you sure\" :"),dataBox,"label4");

  checkBoxAys = new QCheckBox ("",dataBox,"checboxaus");

  voltageGroup = new QButtonGroup(i18n("Nominal Input Voltage"),VFGroup,"voltageGroup");
  QGridLayout *voltLayout = new QGridLayout (voltageGroup, 4 , 1,spacingHint () );

  vRadioButton1 = new QRadioButton(i18n("&230 V"), voltageGroup, "vRadioButton1" );
  vRadioButton2 = new QRadioButton(i18n("&120 V"), voltageGroup, "vRadioButton2" );

  frequencyGroup = new QButtonGroup(i18n("Nominal Input Frequency"),VFGroup,"frequencyGroup");
  QGridLayout *freqLayout = new QGridLayout (frequencyGroup, 4 , 1,spacingHint () );

  fRadioButton1 = new QRadioButton(i18n("&50 Hz"), frequencyGroup, "fRadioButton1" );
  fRadioButton2 = new QRadioButton(i18n("&60 Hz"), frequencyGroup, "fRadioButton2" );

  dataLayout->addWidget (label1,0,0);
  dataLayout->addWidget (numberOfColumns,0,1);

  dataLayout->addWidget (label2,1,0);
  dataLayout->addWidget (checkBoxCbc,1,1);

  dataLayout->addWidget (label3,2,0);
  dataLayout->addWidget (BGButton,2,1);

  dataLayout->addWidget (label4,3,0);
  dataLayout->addWidget (checkBoxAys,3,1);

  dataLayout->setColStretch(1,5);

  voltLayout->addRowSpacing (0 ,fontMetrics().lineSpacing() );
  voltLayout->addWidget ( vRadioButton1,1,0 );
  voltLayout->addWidget ( vRadioButton2,2,0 );
  voltLayout->addRowSpacing (3 ,fontMetrics().lineSpacing() );

  freqLayout->addRowSpacing (0 ,fontMetrics().lineSpacing() );
  freqLayout->addWidget ( fRadioButton1,1,0 );
  freqLayout->addWidget ( fRadioButton2,2,0 );
  freqLayout->addRowSpacing (3 ,fontMetrics().lineSpacing() );

  setTopLayout->addWidget (VFGroup,10);
  setVoltFreqLayout->addRowSpacing (0 ,fontMetrics().lineSpacing() );
  setVoltFreqLayout->addWidget ( voltageGroup,1,0 );
  setVoltFreqLayout->addWidget ( frequencyGroup,1,1 );
  setVoltFreqLayout->addWidget ( xfer,2,0 );
  setVoltFreqLayout->addRowSpacing (3 ,fontMetrics().lineSpacing() );

  setTopLayout->addStretch( 20 );

  //nastavime hodnotu
  numberOfColumns->setValue(prefData->countCols);
  BGButton->setColor(prefData->mainBackgroundColor);  // nastavime barvu pozadi
  checkBoxAys->setChecked(prefData->areYouSure);

  if (prefData->inputVoltage == 230)
    vRadioButton1->setChecked( TRUE );
  else
    vRadioButton2->setChecked( TRUE );
  if (prefData->inputFrequency == 50)
    fRadioButton1->setChecked( TRUE );
  else
    fRadioButton2->setChecked( TRUE );

  xfer->setChecked(prefData->lowHighXfer);
  voltageGroup->setEnabled(!prefData->lowHighXfer);
  frequencyGroup->setEnabled(!prefData->lowHighXfer);
  connect (xfer,SIGNAL(toggled(bool)),this,SLOT(slotEnableVoltage(bool)));
  connect (xfer,SIGNAL(toggled(bool)),this,SLOT(slotEnableFrequency(bool)));

  
  checkBoxCbc->setChecked(prefData->customBColor); 
  BGButton->setColor(prefData->mainBackgroundColor);
  BGButton->setEnabled(prefData->customBColor);
  label3->setEnabled(prefData->customBColor);
  connect (checkBoxCbc,SIGNAL(toggled(bool)),this,SLOT(slotUseCustomBColor(bool)));
  }

void KNutPrefDlg::initUps () {
  QFrame *page = addPage( i18n("UPS"),i18n("UPS Setting"),DesktopIcon("knutclient"));
  QHBoxLayout *upsTopLayout = new QHBoxLayout( page, 0, spacingHint (),"upsTopLayout" );

  // Vytvorime box pro jmena UPS-ek
  ListBox2 = new KListBox( page, "ListBox2" );
  ListBox2->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)5, ListBox2->sizePolicy().hasHeightForWidth() ) );
  ListBox2->setFrameShape( QListBox::StyledPanel );
  ListBox2->setFrameShadow( QListBox::Sunken );
  ListBox2->setMinimumSize (100,100);

  // naplnime listbox
  for (int i=0; i < myUpsData->getCount (); i++) ListBox2->insertItem (*myUpsData->getName(i));
  // vlozime ListBox do horizontalniho Layoutu na prvni misto
  upsTopLayout->addWidget( ListBox2, 20 );
  // vytvorime vertikalni Layout a vlozime jej na druhe misto do hor. layoutu
  QVBoxLayout *upsLayout = new QVBoxLayout( upsTopLayout, spacingHint (),"upsLayout" );

  // vytvorime tlacitka
  KPushButton *newButton = new KPushButton (i18n("&Add"),page);
  KPushButton *editButton = new KPushButton (i18n("&Edit"),page);
  KPushButton *deleteButton = new KPushButton (i18n("&Delete"),page);

  // vlozime tlacitka do layoutu
  upsLayout->addWidget( newButton );
  upsLayout->addWidget( editButton );
  upsLayout->addWidget( deleteButton );

  upsLayout->addStretch( 10 );

  connect (newButton,SIGNAL(clicked()),this,SLOT(slotNewUps()));
  connect (editButton,SIGNAL(clicked()),this,SLOT(slotEditUps()));
  connect (deleteButton,SIGNAL(clicked()),this,SLOT(slotDeleteUps()));
  }


void KNutPrefDlg::initPanel () {
  QFrame *page = addPage( i18n("Panel"),i18n("Panel Setting"),DesktopIcon("panel_settings"));
  QVBoxLayout *setTopLayout = new QVBoxLayout( page, 10, spacingHint (), "setTopLayout" );


  QGroupBox *infoBox = new QGroupBox (page ,"infoBox");
  QGridLayout *infoLayout = new QGridLayout (infoBox,10,1,spacingHint());
  setTopLayout->addWidget(infoBox);

  QGridLayout *colorLayout = new QGridLayout (10,1,spacingHint(),"colorLayout");
  setTopLayout->addLayout(colorLayout);
  

  // vytvorime widgety - Nazev Zatrhavaci box
  checkBoxOver = new QCheckBox (i18n("UPS &Overload"),infoBox);
  checkBoxOver->setChecked((prefData->panelFlags) & PB_OVER);

  checkBoxBL = new QCheckBox (i18n("UPS &Battery low"),infoBox);
  checkBoxBL->setChecked((prefData->panelFlags) & PB_BATT_LOW);

  checkBoxRB = new QCheckBox (i18n("R&eplace battery"),infoBox);
  checkBoxRB->setChecked((prefData->panelFlags) & PB_REP_BATT);

  checkBoxCal = new QCheckBox (i18n("Ups &calibration"),infoBox);
  checkBoxCal->setChecked((prefData->panelFlags) & PB_CAL);

  checkBoxMFRM = new QCheckBox (i18n("&Manufac. + Model"),infoBox);
  checkBoxMFRM->setChecked((prefData->panelFlags) & PB_MFR_MOD);

  checkBoxMFR = new QCheckBox (i18n("M&anufacturer"),infoBox);
  checkBoxMFR->setChecked((prefData->panelFlags) & PB_MFR);

  checkBoxModel = new QCheckBox (i18n("M&odel"),infoBox);
  checkBoxModel->setChecked((prefData->panelFlags) & PB_MODEL);

  checkBoxSerial = new QCheckBox (i18n("&Serial"),infoBox);
  checkBoxSerial->setChecked((prefData->panelFlags) & PB_SERIAL);

  checkBoxFirm = new QCheckBox (i18n("&Firm. rev."),infoBox);
  checkBoxFirm->setChecked((prefData->panelFlags) & PB_FIRM);

  checkBoxRun = new QCheckBox (i18n("&Runtime"),infoBox);
  checkBoxRun->setChecked((prefData->panelFlags) & PB_RUN);


  QLabel *label1 = new QLabel(i18n("Use custom background color"),page,"label1");
  checkBoxCbpc = new QCheckBox ("",page,"checboxcbpc");

  label4 = new QLabel(i18n("Color of background :"),page,"label2");
  BGPButton = new KColorButton (page);
//  BGPButton->setColor (prefData->mainBackgroundColor);

// Vlozime widgety
  infoLayout->addWidget ( checkBoxOver, 0,0);
  infoLayout->addWidget ( checkBoxBL ,1,0);
  infoLayout->addWidget ( checkBoxRB ,2,0);
  infoLayout->addWidget ( checkBoxCal ,3,0);
  infoLayout->addWidget ( checkBoxMFRM ,4,0);
  infoLayout->addWidget ( checkBoxMFR ,5,0);
  infoLayout->addWidget ( checkBoxModel ,6,0);
  infoLayout->addWidget ( checkBoxSerial ,7,0);
  infoLayout->addWidget ( checkBoxFirm ,8,0);
  infoLayout->addWidget ( checkBoxRun ,9,0);

  colorLayout->addWidget (label1,0,0);
  colorLayout->addWidget (checkBoxCbpc,0,1);
  colorLayout->addWidget (label4,1,0);
  colorLayout->addWidget (BGPButton,1,1);

  setTopLayout->addStretch( 20 );

  checkBoxCbpc->setChecked(prefData->customBPanelColor);
  BGPButton->setColor(prefData->mPanelBackgroundColor);
  BGPButton->setEnabled(prefData->customBPanelColor);
  label3->setEnabled(prefData->customBPanelColor);
  connect (checkBoxCbpc,SIGNAL(toggled(bool)),this,SLOT(slotUseCustomBPanelColor(bool)));

  }


void KNutPrefDlg::initFonts () {
  QFrame *page = addPage( i18n("Fonts"),i18n("Setting Fonts"),DesktopIcon("fonts"));

  QVBoxLayout *setTopLayout = new QVBoxLayout( page, 10, spacingHint (), "setTopLayout" );
  QHBoxLayout *setSysLayout = new QHBoxLayout( setTopLayout, spacingHint (), "setTypeLayout" );
  QHBoxLayout *setTypeLayout = new QHBoxLayout( setTopLayout, spacingHint (), "setTypeLayout" );
  QHBoxLayout *setFontLayout = new QHBoxLayout( setTopLayout, spacingHint (), "setFontLayout" );

  customFont = new QCheckBox (i18n("&Use custom font"),page);
  setSysLayout->addWidget ( customFont ,10);
  setSysLayout->addStretch( 10 );

  panelFonts = new KComboBox(page);
  panelFonts->insertItem (i18n("Main panel"));
  panelFonts->insertItem (i18n("Analog panels"));
  setTypeLayout->addWidget ( panelFonts ,0);



  fontWidget = new KFontChooser(page,"Font",false);
  setFontLayout->addWidget (fontWidget ,0);

  setTopLayout->addStretch( 20 );

//inicializace
  customFont->setChecked(prefData->customFont);
  aPanelFont = prefData->aPanelFont;
  mPanelFont = prefData->mPanelFont;
  settingFont = MAIN_PANEL_FONT; // nastavujeme font pro Main Panel
  fontWidget->setFont(mPanelFont);
  fontWidget->setEnabled(prefData->customFont);
  connect (panelFonts,SIGNAL(activated(int)),this,SLOT(slotChangeSettingFont(int)));
  connect (customFont,SIGNAL(toggled(bool)),fontWidget,SLOT(setEnabled(bool)));
  }

void KNutPrefDlg::initAnalog () {
  QFrame *page = addPage( i18n("Analog"),i18n("Setting Analog panel"),DesktopIcon("ksysguard"));
  QVBoxLayout *setTopLayout = new QVBoxLayout( page, 10, spacingHint (), "setTopLayout" );
  QGridLayout *setColorLayout = new QGridLayout( 8,2, spacingHint(),"setColorLayout");
  setTopLayout->addLayout(setColorLayout);
  setTopLayout->addStretch( 20 );

  QLabel *label1 = new QLabel(i18n("Use custom background color"),page,"label1");
  checkBoxCbac = new QCheckBox ("",page,"checboxcbac");
  label5 = new QLabel(i18n("Color of background :"),page,"label5");
  BGAButton = new KColorButton (page);
  QLabel *label12 = new QLabel(i18n("Use custom other colors"),page,"label12");
  checkBoxCoac = new QCheckBox ("",page,"checboxcoac");
  label6 = new QLabel(i18n("Color of finger :"),page,"label6");
  AFingerButton = new KColorButton (page);
  label7 = new QLabel(i18n("Color of OK range :"),page,"label7");
  AOKButton = new KColorButton (page);
  label8 = new QLabel(i18n("Color of warning range :"),page,"label8");
  AWarnningButton = new KColorButton (page);
  label9 = new QLabel(i18n("Color of error range :"),page,"label9");
  AErrorButton = new KColorButton (page);
  label10 = new QLabel(i18n("Color of scale :"),page,"label10");
  AScaleButton = new KColorButton (page);
  label11 = new QLabel(i18n("Color of font :"),page,"label11");
  AFontButton = new KColorButton (page);


  setColorLayout->addWidget ( label1, 0,0);
  setColorLayout->addWidget ( checkBoxCbac ,0,1);
  setColorLayout->addWidget ( label5, 1,0);
  setColorLayout->addWidget ( BGAButton ,1,1);
  setColorLayout->addWidget ( label12, 2,0);
  setColorLayout->addWidget ( checkBoxCoac ,2,1);
  setColorLayout->addWidget ( label6, 3,0);
  setColorLayout->addWidget ( AFingerButton ,3,1);
  setColorLayout->addWidget ( label7, 4,0);
  setColorLayout->addWidget ( AOKButton ,4,1);
  setColorLayout->addWidget ( label8, 5,0);
  setColorLayout->addWidget ( AWarnningButton ,5,1);
  setColorLayout->addWidget ( label9, 6,0);
  setColorLayout->addWidget ( AErrorButton ,6,1);
  setColorLayout->addWidget ( label10, 7,0);
  setColorLayout->addWidget ( AScaleButton ,7,1);
  setColorLayout->addWidget ( label11, 8,0);
  setColorLayout->addWidget ( AFontButton ,8,1);


  checkBoxCbac->setChecked(prefData->customBAnalogColor);
  checkBoxCoac->setChecked(prefData->customOAnalogColor);
  BGAButton->setColor(prefData->aPanelBackgroundColor);
  BGAButton->setEnabled(prefData->customBAnalogColor);
  AFingerButton->setColor(prefData->analogFingerColor);
  AFingerButton->setEnabled(prefData->customOAnalogColor);
  AOKButton->setColor(prefData->analogOKColor);
  AOKButton->setEnabled(prefData->customOAnalogColor);
  AWarnningButton->setColor(prefData->analogWarnningColor);
  AWarnningButton->setEnabled(prefData->customOAnalogColor);
  AErrorButton->setColor(prefData->analogErrorColor);
  AErrorButton->setEnabled(prefData->customOAnalogColor);
  AScaleButton->setColor(prefData->analogScaleColor);
  AScaleButton->setEnabled(prefData->customOAnalogColor);
  AFontButton->setColor(prefData->analogFontColor);
  AFontButton->setEnabled(prefData->customOAnalogColor);
  label5->setEnabled(prefData->customBAnalogColor);
  label6->setEnabled(prefData->customOAnalogColor);
  label7->setEnabled(prefData->customOAnalogColor);
  label8->setEnabled(prefData->customOAnalogColor);
  label9->setEnabled(prefData->customOAnalogColor);
  label10->setEnabled(prefData->customOAnalogColor);
  label11->setEnabled(prefData->customOAnalogColor);

  connect (checkBoxCbac,SIGNAL(toggled(bool)),this,SLOT(slotUseCustomBAnalogColor(bool)));
  connect (checkBoxCoac,SIGNAL(toggled(bool)),this,SLOT(slotUseCustomOAnalogColor(bool)));
  }


KNutPrefDlg::KNutPrefDlg(KNutUpsData* upsData, KNutVarData* analogData, SettingDataDef* settingData, QString upsName, QWidget* parent,  const char* name, bool modal)
            : KDialogBase(IconList, i18n("Preferences"),Help|Default|Apply|Ok|Cancel,Ok, parent, name, modal, true), activeUpsName (upsName) {
  setName( "UpsMemberDlg" );

  myUpsData = upsData;
  myAnalogData=analogData;
  checked = FALSE; // neni zadna zmena na definici UPS
  checkedActiveUps = FALSE; // neni provedena zmena aktivni UPS
  prefData=settingData;

  initSetting ();
  initUps();
  initPanel();
  initFonts();
  initAnalog(); // az v dalsi verzi
  setMinimumSize (450, 300);
  }


KNutPrefDlg::~KNutPrefDlg(){
  delete ListBox2;
  }

void KNutPrefDlg::slotEnableVoltage(bool enable) { voltageGroup->setEnabled(!enable);}

void KNutPrefDlg::slotEnableFrequency(bool enable) { frequencyGroup->setEnabled(!enable);}

void KNutPrefDlg::slotUseCustomBColor(bool enable) {
  BGButton->setEnabled(enable);
  label3->setEnabled(enable);
  }

void KNutPrefDlg::slotUseCustomBPanelColor(bool enable) {
  BGPButton->setEnabled(enable);
  label4->setEnabled(enable);
  }

void KNutPrefDlg::slotUseCustomBAnalogColor(bool enable) {
  BGAButton->setEnabled(enable);
  label5->setEnabled(enable);
  }

void KNutPrefDlg::slotUseCustomOAnalogColor(bool enable) {
  AFingerButton->setEnabled(enable);
  AOKButton->setEnabled(enable);
  AWarnningButton->setEnabled(enable);
  AErrorButton->setEnabled(enable);
  AScaleButton->setEnabled(enable);
  AFontButton->setEnabled(enable);
  label6->setEnabled(enable);
  label7->setEnabled(enable);
  label8->setEnabled(enable);
  label9->setEnabled(enable);
  label10->setEnabled(enable);
  label11->setEnabled(enable);
  }

  

void KNutPrefDlg::slotChangeSettingFont(int index) {
  if (settingFont != index) {
  // vybirame jiny font
  if (settingFont == MAIN_PANEL_FONT)
    {
     mPanelFont=fontWidget->font();
     fontWidget->setFont(aPanelFont);
    }
  else
    {
    aPanelFont=fontWidget->font();
    fontWidget->setFont(mPanelFont);
    }
   settingFont = index;
  }
}



void KNutPrefDlg::slotDeleteUps() {
  if (ListBox2->currentItem() != -1)	{
    // smazeme policko
    int ukListBox = ListBox2->currentItem();
    if ( activeUpsName == ListBox2->currentText() ) checkedActiveUps = TRUE;
    myUpsData->deleteName(ukListBox);
    ListBox2->removeItem(ukListBox);
    checked = TRUE;
    // pokud smazeme aktivni UPS nsatavime checkedActiveUps
    }
  }


void KNutPrefDlg::slotEditUps() {
  if (ListBox2->currentItem() != -1)	{
    UpsInfo upsPref;
    // Vytvorime dialog
    newUpsDlg = new KNutNewUpsDlg(myUpsData,myAnalogData,FALSE);
    // precteme zaznam
    myUpsData->get(ListBox2->currentItem(),upsPref);
    // nastavime parametry pro edit
    newUpsDlg->putData(upsPref);
    int result = newUpsDlg->exec();
    if (result == Accepted) {
      // pridame do seznamu po stisku OK
      // Precteme data z formulare
      newUpsDlg->getData(upsPref);
      // opravime data v zaznamu
      myUpsData->put(ListBox2->currentItem(),upsPref);
      // opravime data v okenku
      ListBox2->changeItem(upsPref.name,ListBox2->currentItem());
      checked = TRUE;
      // pokud zmenime aktivni UPS nsatavime checkedActiveUps
      if ( activeUpsName == ListBox2->currentText() ) checkedActiveUps = TRUE;
      }
    delete newUpsDlg;
    }
  }


void KNutPrefDlg::slotNewUps () {
  UpsInfo upsPref;
  // Zalozime novy zdroj
  newUpsDlg = new KNutNewUpsDlg(myUpsData,myAnalogData);
  int result = newUpsDlg->exec();
  if (result == Accepted) {
    // pridame do seznamu po stisku OK
    // Precteme data z formulare
    newUpsDlg->getData(upsPref);
    //pridame data do zaznamu
    myUpsData->add( upsPref);
    // pridame data do okenka
    ListBox2->insertItem(upsPref.name);
    // pokud pridame prvni prekreslime hlavni okno
    checked = TRUE;
    if (myUpsData->getCount() ==1 ) checkedActiveUps = TRUE;
    }
  delete newUpsDlg;
  }


void KNutPrefDlg::slotOk() {
  slotApply ();
  accept();
  }

void KNutPrefDlg::slotApply() {
//od verze 6.0 zmena: Apply funguje pro vsechny casti najednou !!!!!
// budeme emitovat signal podle toho co se deje

  unsigned int changeSetting = 0;

 // MainPage
  if (prefData->countCols != numberOfColumns->value()) {
    changeSetting += CHANGE_COUNT_COLS;  // nastavime pocet sloupcu
    prefData->countCols = numberOfColumns->value();  // nastavime pocet sloupcu
    }

  if (prefData->customBColor != checkBoxCbc->isChecked()) {
    prefData->customBColor = checkBoxCbc->isChecked();
    changeSetting += CHANGE_CUSTOM_BCOLOR;
    }
                           
  if (prefData->mainBackgroundColor != BGButton->color()) {
    changeSetting += CHANGE_MBCOLOR;
    prefData->mainBackgroundColor = BGButton->color();  // nastavime barvu pozadi
    }
         
  // ovlivnuje jen ukonceni programu nei duvod pro ChangeSetting
  prefData->areYouSure = checkBoxAys->isChecked();

  int newInputVoltage, newInputFrequency;
  if ( vRadioButton1->isChecked()) newInputVoltage = 230; else newInputVoltage = 120;
  if ( fRadioButton1->isChecked()) newInputFrequency = 50; else newInputFrequency = 60;

  if (prefData->inputVoltage != newInputVoltage) {
    prefData->inputVoltage = newInputVoltage;
    changeSetting += CHANGE_VOLTAGE;
    }

  if (prefData->inputFrequency != newInputFrequency) {
    prefData->inputFrequency = newInputFrequency;
    changeSetting += CHANGE_FREQUENCY;
    }

 if (prefData->lowHighXfer != xfer->isChecked()) changeSetting += CHANGE_XFER;
 prefData->lowHighXfer = xfer->isChecked();

    //Ups page
  if ( checkedActiveUps ) { // zmenea aktivni UPS
    changeSetting += CHANGE_UPS_SETTING;
    }

    // panel Page
    unsigned int prefPanelFlags = 3;
    if (checkBoxOver->isChecked()) prefPanelFlags += PB_OVER;
    if (checkBoxBL->isChecked()) prefPanelFlags += PB_BATT_LOW;
    if (checkBoxRB->isChecked()) prefPanelFlags += PB_REP_BATT;
    if (checkBoxCal->isChecked()) prefPanelFlags += PB_CAL;
    if (checkBoxMFRM->isChecked()) prefPanelFlags += PB_MFR_MOD;
    if (checkBoxMFR->isChecked()) prefPanelFlags += PB_MFR;
    if (checkBoxModel->isChecked()) prefPanelFlags += PB_MODEL;
    if (checkBoxSerial->isChecked()) prefPanelFlags += PB_SERIAL;
    if (checkBoxFirm->isChecked()) prefPanelFlags += PB_FIRM;
    if (checkBoxRun->isChecked()) prefPanelFlags += PB_RUN;

    if (prefData->panelFlags != prefPanelFlags) {
      prefData->panelFlags = prefPanelFlags;
      changeSetting += CHANGE_MAIN_PANEL_SETTING;
      }

  if (prefData->customBPanelColor != checkBoxCbpc->isChecked()) {
    prefData->customBPanelColor = checkBoxCbpc->isChecked();
    changeSetting += CHANGE_CUSTOM_MPANEL_BCOLOR;
    }

  if (prefData->mPanelBackgroundColor != BGPButton->color()) {
    changeSetting += CHANGE_MPBCOLOR;
    prefData->mPanelBackgroundColor = BGPButton->color();  // nastavime barvu pozadi
    }


                          
    // font Page:
    unsigned int changeFonts;
    changeFonts =0;

    if (settingFont == MAIN_PANEL_FONT)
      mPanelFont=fontWidget->font();
    else
      aPanelFont=fontWidget->font();

    if (  customFont->isChecked() != prefData->customFont) {
      // zmena typy fontu systemove <-> uzivatelske
       prefData->customFont = customFont->isChecked();
       if (prefData->customFont) {
         // prejdeme na uzivatelske fonty
         prefData->aPanelFont = aPanelFont;
         prefData->mPanelFont = mPanelFont;
         changeSetting += CHANGE_ANALOG_FONT;
         changeSetting += CHANGE_PANEL_FONT;
         }
       else {
         // pouzijeme systemove fonty
         changeSetting += CHANGE_ANALOG_FONT;
         changeSetting += CHANGE_PANEL_FONT;
         }
      }
    else {
      if ( prefData->customFont ) {
        // otestujeme zda se zmenili nase fonty
        if (aPanelFont != prefData->aPanelFont) {
          prefData->aPanelFont = aPanelFont;
          changeSetting += CHANGE_ANALOG_FONT;
          }
        if (mPanelFont != prefData->mPanelFont) {
          prefData->mPanelFont = mPanelFont;
          changeSetting += CHANGE_PANEL_FONT;
          }
        }
      }
  // analog page

  if (prefData->customBAnalogColor != checkBoxCbac->isChecked()) {
    prefData->customBAnalogColor = checkBoxCbac->isChecked();
    changeSetting += CHANGE_CUSTOM_APANEL_BCOLOR;
    }

  if (prefData->aPanelBackgroundColor != BGAButton->color()) {
    changeSetting += CHANGE_APBCOLOR;
    prefData->aPanelBackgroundColor = BGAButton->color();  // nastavime barvu pozadi
    }

  if (prefData->customOAnalogColor != checkBoxCoac->isChecked()) {
    prefData->customOAnalogColor = checkBoxCoac->isChecked();
    changeSetting += CHANGE_CUSTOM_APANEL_OCOLOR;
    }

  if ((prefData->analogFingerColor != AFingerButton->color()) ||
      (prefData->analogOKColor != AOKButton->color()) ||
      (prefData->analogWarnningColor != AWarnningButton->color()) ||
      (prefData->analogErrorColor != AErrorButton->color()) ||
      (prefData->analogScaleColor != AScaleButton->color()) ||
      (prefData->analogFontColor != AFontButton->color())) {
    changeSetting += CHANGE_APOCOLOR;
    prefData->analogFingerColor = AFingerButton->color();  // nastavime barvu rucicky
    prefData->analogOKColor = AOKButton->color();  // nastavime barvu ok
    prefData->analogWarnningColor = AWarnningButton->color();  // nastavime barvu varovano
    prefData->analogErrorColor = AErrorButton->color();  // nastavime barvu chyby
    prefData->analogScaleColor = AScaleButton->color();  // nastavime barvu stupnice
    prefData->analogFontColor = AFontButton->color();  // nastavime barvu textu
    }
    

    
  if (changeSetting)  emit signalChangeConfig( changeSetting );
  }


void KNutPrefDlg::slotDefault() {
  switch (activePageIndex()) {
    case mainSettingPage:
      numberOfColumns->setValue( DEFAULT_COUNT_COLS );
      BGButton->setColor(DEFAULT_BG_COLOR);
      checkBoxAys->setChecked ( FALSE );
      vRadioButton1->setChecked( TRUE );
      fRadioButton1->setChecked( TRUE );
      xfer->setChecked( FALSE );
      break;
    case panelSettingPage:
      checkBoxOver->setChecked(DEFAULT_PANEL_FLAGS & PB_OVER);
      checkBoxBL->setChecked(DEFAULT_PANEL_FLAGS & PB_BATT_LOW);
      checkBoxRB->setChecked(DEFAULT_PANEL_FLAGS & PB_REP_BATT);
      checkBoxCal->setChecked(DEFAULT_PANEL_FLAGS & PB_CAL);
      checkBoxMFRM->setChecked(DEFAULT_PANEL_FLAGS & PB_MFR_MOD);
      checkBoxMFR->setChecked(DEFAULT_PANEL_FLAGS & PB_MFR);
      checkBoxModel->setChecked(DEFAULT_PANEL_FLAGS & PB_MODEL);
      checkBoxSerial->setChecked(DEFAULT_PANEL_FLAGS & PB_SERIAL);
      checkBoxFirm->setChecked(DEFAULT_PANEL_FLAGS & PB_FIRM);
      checkBoxCbpc->setChecked(false);
      BGAButton->setColor(DEFAULT_BG_COLOR);
      break;
   case fontSettingPage:
      customFont->setChecked(false);
      break;
   case analogSettingPage:
      checkBoxCbac->setChecked(false);
      BGAButton->setColor(DEFAULT_BG_COLOR);
      checkBoxCoac->setChecked(false);
      AFingerButton->setColor(DEFAULT_FINGER_COLOR);
      AOKButton->setColor(DEFAULT_OK_COLOR);
      AWarnningButton->setColor(DEFAULT_WARNNING_COLOR);
      AErrorButton->setColor(DEFAULT_ERROR_COLOR);
      AScaleButton->setColor(DEFAULT_SCALE_COLOR);
      AFontButton->setColor(DEFAULT_FONT_COLOR);
      break;
    }
  }
