/***************************************************************************
                          knutnewupsdlg.h  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTNEWUPSDLG_H
#define KNUTNEWUPSDLG_H

#include <kdialogbase.h>
#include <kcombobox.h>
#include <klineedit.h>
#include <kpushbutton.h>

#include <qlabel.h>
#include <qgroupbox.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>

#include "knutupsdata.h"
#include "knutvardata.h"


/**
 * Tato trida je dialog pro vytvoreni nebo opravu informaci a UPS.
 * Umoznuje nastavit adresu, port, typ protokolu a vybrat promenu jejiz hodnota se bude zjistovat.
 * @author Daniel Prynych
 * @short NUT get data
 * @version 0.2
 */
class KNutNewUpsDlg : public KDialogBase
{
    Q_OBJECT
public:
/**
 * Konstruktor vytvori konfiguracni dialog.
 *
 * @param add Urcuje zda budeme data opravovat nebo pridavat.
 * @param settingData Je odkaz na strukturu ktera obsahuje hodnoty nastavovane v dialogu.
 * @param upsdata Je odkaz na na instanci tridy KNutUpsData.
 * @param upsdata Je odkaz na na instanci tridy KNutVarData.
 *
 * @since  0.4
 **/
	KNutNewUpsDlg (KNutUpsData* upsData, KNutVarData* analogData,  bool add = TRUE, QWidget* parent = 0, const char* name = 0, bool modal = TRUE);

/**
 * @since  0.2
 **/
	~KNutNewUpsDlg();

/**
 * Precte data z polozek formulare.
 *
 * @param upsInfo Struktura tipu UpsInfo - obsahuje vsechny polozky ktere jsou ve formulari.
 *
 * @since  0.1
 **/
 	void getData (UpsInfo& upsInfo );

/**
 * Vlozi data do polozek formulare.
 *
 * @param upsInfo Struktura tipu UpsInfo - obsahuje vsechny polozky ktere jsou ve formulari.
 *
 * @since  0.1
 **/
  void putData (UpsInfo upsInfo );

/********************* PRIVATE **************************/
private:
  KLineEdit* LineEdit1;
  KLineEdit* LineEdit2;
  KLineEdit* LineEdit3;
  KLineEdit* LineEdit4;
  KLineEdit* LineEdit5;
  KLineEdit* LineEdit6;

  KComboBox* ComboBox1;
  KComboBox* ComboBox2;
  KComboBox* ComboBox3;
  KComboBox* ComboBox4;
  KComboBox* ComboBox5;
  KComboBox* ComboBox6;
  KComboBox* ComboBox7;
  KComboBox* ComboBox8;
  KComboBox* ComboBox9;
  KComboBox* ComboBox10;

  QRadioButton* RadioButton1;
  QRadioButton* RadioButton2;

  QCheckBox* savePassword;
  
  KNutUpsData* myUpsData; // Ups data object

  bool add_member;   // true pokud se pridava polozka false edit

  private slots:

/**
 * Provede se pri stisknuti tlacitka ok.
 *
 * @since  0.1
 **/
  virtual void slotOk();

/**
 * Aktivuje/Deaktivuje polozky User name, password atd.
 *
 * @since  0.1
 **/
  void slotProtocol(bool tcp);


};

#endif
