/***************************************************************************
                          knutnet.cpp  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "knutnet.h"

/******************************************************************/
/*                                                                */
/*                       Protected Funkce                         */
/*                                                                */
/******************************************************************/



int KNutNet::closeUpsDate(int soc_addr) {
  if ( soc_addr != 0) { return close (soc_addr); }
  else return 0;
  }

int KNutNet::getUpsData (int soc_addr,char *sbuffer,int sbuffer_len,char *rbuffer,int rbuffer_len, char* endString) {
  //rbuffer_len a sbuffer_len udavaji maximalni velikost bufferu
  int sel_ret; // navratova hodnota selectu
  struct timeval ups_timeout; // struktura pro cas cekani na ukazatel
  //  testnem buffery a jejich velikost
  if ((sbuffer == 0L) || (rbuffer == 0L) || (rbuffer_len <1)  || (sbuffer_len <1)) {
    // nebyly zadny buffery
    upsErr=KUPS_NO_BUFFER;
    return (-1);
    }
  // existenci bufferu
  if ( strlen(sbuffer) > 0) {
    if (upsNetOk) {
      if (upsProtocol) {
        // pro tcp pouzijem send
        if (send(soc_addr, (char *)sbuffer, strlen((char *)sbuffer), 0 )<0) {
          closeUpsDate(soc_addr);
          upsErr=KUPS_SEND_ERR;
          return -1;
          }
        }
      else {
        if (sendto (soc_addr, (char *)sbuffer, strlen((char *)sbuffer), 0, (struct sockaddr *)&upsAddr, sizeof(upsAddr))<0) {
          closeUpsDate(soc_addr);
          upsErr=KUPS_SENDTO_ERR;
          return -1;
          }
        } // konec poslani dat
      fd_set fd_ups;
      // nastavime vsechny ukazatele na nulu
      FD_ZERO (&fd_ups);
      // nastavime reakci na nas socket
      FD_SET (soc_addr,&fd_ups);
      // nastavime timeout
      ups_timeout.tv_sec=ups_get_timeout;
      ups_timeout.tv_usec=0;
      // aktivujeme select zajimaji nas jen prichozi pakety
      if ((sel_ret = select (soc_addr+1,(fd_set *)&fd_ups,(fd_set *)0L,(fd_set *)0L,&ups_timeout)) <0 ) {
        closeUpsDate(soc_addr);
        upsErr=KUPS_SELECT_ERR;
        return -1;
        }
      // data neprisla - UDP dame jeste jednu sanci
      if (( ! upsProtocol ) && ( ! sel_ret )) { // zajima nas sel_ret=0 zaporne hodnoty jsme uz odfiltrovali
        // posleme jeste jeden paket
        if (sendto (soc_addr, (char *)sbuffer, strlen((char *)sbuffer), 0, (struct sockaddr *)&upsAddr, sizeof(upsAddr))<0) {
          closeUpsDate(soc_addr);
          upsErr=KUPS_SENDTO_ERR;
          return -1;
          }
        fd_set fd_ups;
      //  FD_ZERO (&fd_ups);
      //  FD_SET (soc_addr,&fd_ups);
        ups_timeout.tv_sec=ups_get_timeout2;
      //  ups_timeout.tv_usec=0;
        if ((sel_ret = select (soc_addr+1,(fd_set *)&fd_ups,(fd_set *)0L,(fd_set *)0L,&ups_timeout)) <0 ) {
          closeUpsDate(soc_addr);
          upsErr=KUPS_SELECT_ERR;
          return -1;
          }
        } // end if ((  ! upsProtocol........
      if ( !sel_ret) { // opet neprisli zadna data
        closeUpsDate(soc_addr);
        upsErr=KUPS_NO_SERVER_DATA;
        return -1;
        }
      else {
        bool endRecv = false;
        char *startRbuffer = rbuffer;
        ups_timeout.tv_sec=1;
        ups_timeout.tv_usec=0; // 10 mikrosekund pro docitani radky
        do {
          if (upsProtocol)	{
            //pro tcp pouzijem recv
            if (recv (soc_addr, (char *)rbuffer, rbuffer_len, 0) <0 )	{
              closeUpsDate(soc_addr);
              upsErr=KUPS_RECV_ERR;
              return -1;
              }
            }  // konec ctene pres TCP
          else {
            //int  upsAddr_len;
            int upsAddr_len = sizeof (upsAddr);
            if (recvfrom (soc_addr, (char *)rbuffer, rbuffer_len, 0, (struct sockaddr *)&upsAddr,(socklen_t *)&upsAddr_len) <0 ) {
              closeUpsDate(soc_addr);
              upsErr=KUPS_RECVFROM_ERR;
              return -1;
              }
            } // konec cteni pres UDP
            if ((endString != 0) && (!ifEnd(endString,startRbuffer))) {
              sel_ret = select (soc_addr+1,(fd_set *)&fd_ups,(fd_set *)0L,(fd_set *)0L,&ups_timeout);
              if (sel_ret < 0) {
                closeUpsDate(soc_addr);
                upsErr=KUPS_SELECT_ERR;
                return -1;
                }
              else {
                if (sel_ret==0)  endRecv=false; //select vraci 0 kdyz nic neprislo
                else {
                  rbuffer_len-=strlen(rbuffer);
                  rbuffer+=strlen(rbuffer);
                  endRecv=true;
                  }
                }
              }
            else endRecv=false;
          } while (endRecv);
        }
      }// konec upsNetOk true
    }
  else {
    closeUpsDate(soc_addr);
    upsErr=KUPS_NO_DATA;
    return -1;
    }
  return 0;
  }

/**************Rozparsuje radku na 1 az 3 pole*****************/
void KNutNet::findWords(char *line, char*& word1, char*& word2, char*& word3) {
  char *endStr;
  word1=0L;
  word2=0L;
  word3=0L;
  if ((line != 0) && (strlen(line))) {
    word1=line;
    if ((endStr=strchr (line,32)) != 0L) { // hledame prvni mezeru
      endStr[0]='\0';
      endStr++;
      while ((endStr[0] == ' ') && (endStr[0]=='\n') && (endStr=='\0')) endStr++;
      if (strlen(endStr)) {
        word2=endStr;
        if (endStr[0]=='"') {
          word2++; // preskocime "
          if ((endStr=strchr(word2,34)) != 0L) endStr[0]='\0';
          }
        else if ((endStr=strchr(word2,32)) != 0L) endStr[0]='\0';
        if (endStr) {
          endStr++;
          while ((endStr[0]=='\0') && (endStr[0]=='\n') && (endStr[0] == ' ')) endStr++;
          if (strlen(endStr)) {
            word3=endStr;
            if ((endStr=strchr (line,32)) != 0L) endStr[0]='\0';
            }
          }
        }
      }
    }
  }


void KNutNet::correctBuffer (char *buffer) {
  int n;

  if ((n=strlen(buffer))>0) {
    if (buffer[n-1] == '\n') buffer[n-1] = '\0';
    if ((n>1) && (buffer[n-2] == '\r')) buffer[n-2] = '\0';
    }
  }


void KNutNet::deleteVars (void) {
// smaze kompletne vse promene pro UPSku
upsVars *uVars,*pVars;
uVars = upsFirstName;
struct enumItem *firstEnumItem, *pEnumItem;

upsIComm *uIComm, *pIComm;
uIComm = commFirstName;

while (uVars ) {
  pVars = uVars;
  uVars = uVars-> upsNext;
  if (pVars->upsVarName) delete pVars->upsVarName; // smazeme jmeno
  if (pVars->upsValue) delete pVars->upsValue; // smazeme hodnotu
  if ((firstEnumItem = pVars->enumValues)) {
    while (firstEnumItem) {
      pEnumItem = firstEnumItem;
      firstEnumItem = firstEnumItem->itemNext;
      delete pEnumItem->enumString;
      delete pEnumItem;
      }
    }
  delete pVars; // smazeme structuru pro jednu polozku
  }
//nastavi ukazatel na prvni promenou na nic (0L)
upsFirstName = 0;

while ( uIComm ) {
  pIComm = uIComm;
  uIComm = uIComm-> upsNext;
  if (pIComm->upsCommName) delete pIComm->upsCommName; // smazeme jmeno
  delete pIComm; // smazeme structuru pro jednu polozku
  }
//nastavi ukazatel na prvni promenou, na nic (0L)
commFirstName = 0;
}
  

bool KNutNet::ifEnd(char *token, char *string) {
  int lenToken = strlen(token);
  int lenString = strlen(string);
  if (lenToken > lenString) return false;
  string +=(lenString + lenString);
  if (strcmp(string,token)) return false;
  return true;
}


int KNutNet::getValue   (int soc_addr, struct upsVars *uk_vars) {
  char in_buffer[SBUFFER_LEN], out_buffer[RBUFFER_LEN];
  char *out_value, *upsname, *varname;

  strcpy ((char *)in_buffer,"REQ ");
  strcat ((char *)in_buffer,uk_vars->upsVarName);	// jmeno promene
  // pokud existuje pridame jmeno UPS-ky
  if ((upsName != 0L) && (strlen(upsName)>0)) {
    strcat ((char *)in_buffer,"@");
    strcat ((char *)in_buffer,upsName);
    }
  strcat ((char *)in_buffer,"\n");
  //vynulujeme buffer pro prijate data
  bzero ((char *)out_buffer,RBUFFER_LEN);
  // pridat dotaz

  if (getUpsData (soc_addr,in_buffer,sizeof(in_buffer),out_buffer,sizeof(out_buffer)) != -1) {
    //odstranime CRLF
    correctBuffer (out_buffer);
    out_value=0L;
    if ((varname=strchr (out_buffer,32)) != 0L) { // hledame prvni mezeru
      // mezera nalezena
      varname[0]='\0'; varname++;
      if (! strcmp("ANS",out_buffer)) {
        // je to odpoved
        if ((out_value=strchr (varname,32)) != 0L) { // hledame druhou mezeru
          out_value[0]='\0';out_value++;
          if ((upsname=strchr (varname,64)) != 0L) upsname[0]='\0';upsname++;
          // pokud neni odpoved na promenou smazeme odkaz
          if ( strcmp(varname,uk_vars->upsVarName)) {
            upsErr=KUPS_UNKNOWN_ANSWER;
            closeUpsDate (soc_addr);
            //netMutex.unlock();
            netMutex=false;
            return -1;// neni to odpoved na spravnou promenou
          }
        }
      else { // nebyla nalezena treti hodnota "VALUE"
        upsErr=KUPS_UNKNOWN_FORMAT;
        closeUpsDate (soc_addr);
        //netMutex.unlock();
        netMutex=false;
        return -1;
        }
      }
    else {  // odpoved neni ANS
      if (!strcmp("ERR",out_buffer)) {
        if ((out_value=strchr (varname,32)) != 0L) { // hledame druhou mezeru
          out_value[0]='\0';out_value++;
          upsErr=upsTranslateError(out_value);
          closeUpsDate (soc_addr);
          //netMutex.unlock();
          netMutex=false;
          return -1;
          }
        else { // odpoved je jenom ERR bez dalsi hodnoty
          upsErr=KUPS_UNKNOWN_FORMAT;
          closeUpsDate (soc_addr);
          //netMutex.unlock();
          netMutex=false;
          return -1;
          }
        }
      else { // odpoved neni ANS ani ERR
        upsErr=KUPS_UNKNOWN_ANSWER;
        closeUpsDate (soc_addr);
        //netMutex.unlock();
        netMutex=false;
        return -1;
        }
      }
    }
  else { // odpoved je jedno nebo zadne slovo
    upsErr=KUPS_UNKNOWN_ANSWER;
    closeUpsDate (soc_addr);
    //netMutex.unlock();
    netMutex=false;
    return -1;
    } // spatny format dat
    // test pro starsi format modulu vraceli chybu v hodnote promene
  if ((upsErr=upsOldTranslateError(out_value))) {
    closeUpsDate (soc_addr);
    //netMutex.unlock();
    netMutex=false;
    return -1;
    // zalozime hodnotu do tabulky;
    }
  if (!strcmp("NA",out_value)) uk_vars->upsVarNa=true;
  if ((strlen(out_value)+1) > uk_vars->upsCharLength) {	// pokud je pridelena pamet mensi zvetsime jeji velikost
    if (uk_vars->upsValue != 0L) delete uk_vars->upsValue;
      unsigned long lenAllocMem = strlen(out_value)+1;
      if (lenAllocMem < 20 ) lenAllocMem = 20; // minimalne pozadame o 20 znaku
      uk_vars->upsValue=new char[lenAllocMem];
      if (uk_vars->upsValue == 0L) {
        upsNetOk = false;
        upsErr=KUPS_LOW_MEM;
        uk_vars->upsValue = 0L;
        uk_vars->upsCharLength=0;
        //netMutex.unlock();
        netMutex=false;
        return -1;
        }
      }
    strcpy (uk_vars->upsValue,out_value);
    // testujem zda jde o status
    if (!strcmp(uk_vars->upsVarName,"STATUS")) genStatusFlags (uk_vars); //nechame zavolat prevod hodnoty pro STATUS
    return 0;
    } // getUpsData - upsErr je jiz nastaveno
  else {
    //netMutex.unlock();
    netMutex=false;
    return -1;
    }
  }


int KNutNet::upsTranslateError (char *string) {
  if (!strcmp (string,"VAR-NOT-SUPPORTED")) return KUPS_VAR_NOT_SUPPORTED;
  if (!strcmp (string,"VAR-UNKNOWN")) return KUPS_VAR_UNKNOWN;

  if (!strcmp (string,"ACCESS-DENIED")) return KUPS_ACCESS_DENIED;
  if (!strcmp (string,"PASSWORD-REQUIRED")) return KUPS_PASSWORD_REQUIRED;
  if (!strcmp (string,"PASSWORD-INCORRECT")) return KUPS_PASSWORD_INCORRECT;
  if (!strcmp (string,"UNKNOWN-UPS")) return KUPS_UNKNOWN_UPS;
  if (!strcmp (string,"ALREADY-LOGGED_IN")) return KUPS_ALREADY_LOGGED_IN;
  if (!strcmp (string,"ALREADY-SET-PASSWORD")) return KUPS_ALREADY_SET_PASSWORD;
  if (!strcmp (string,"UNKNOWN-COMMAND")) return KUPS_UNKNOWN_COMMAND;

  if (!strcmp (string,"UNKNOWN-INSTCMD")) return KUPS_UNKNOWN_INSTCMD;
  if (!strcmp (string,"CMD-NOT-SUPPORTED")) return KUPS_CMD_NOT_SUPPORTED;

  if (!strcmp (string,"NO-RESPONSE")) return KUPS_NO_RESPONSE;
  if (!strcmp (string,"UNKNOWN-REPLY")) return KUPS_UNKNOWN_REPLY;
  if (!strcmp (string,"NOT-IMPLEMENTED")) return KUPS_NOT_IMPLEMENTED;
  if (!strcmp (string,"COMMAND-FAILED")) return KUPS_COMMAND_FAILED;


  if (!strcmp (string,"MISSING-ARGUMENT")) return KUPS_MISSING_ARGUMENT;
  if (!strcmp (string,"DATA-STALE")) return KUPS_DATA_STALE;
  if (!strcmp (string,"UNKNOWN-TYPE")) return KUPS_UNKNOWN_TYPE;

  return KUPS_UNKNOWN_ERR;
  }


int KNutNet::upsOldTranslateError (char *string) {
  if (!strcmp (string,"NOT-SUPPORTED")) return KUPS_VAR_NOT_SUPPORTED;
  if (!strcmp (string,"UNKNOWN")) return KUPS_VAR_UNKNOWN;
  if (!strcmp (string,"DATA-STALE")) return KUPS_DATA_STALE;
  return 0; // nebylo nalezeno
  }


//Vytvori a nastavi socket a vrati jeho popisovac
int KNutNet::openUpsDate (void) {
  int soc_addr;
  struct sockaddr_in my_addr;

  if (upsNetOk) {
    // spojime se se serverem
    // vytvorime socket
    if (upsProtocol) soc_addr = socket (AF_INET,SOCK_STREAM,0);
    else soc_addr = socket (AF_INET,SOCK_DGRAM,0);
    if (soc_addr < 0) {
      upsNetOk = false;
      upsErr=KUPS_SOCKET_ERR;
      return -1;
      }
    // provedeme bind - connect
    bzero((char *) &my_addr,sizeof(my_addr));
    my_addr.sin_family = AF_INET;
    my_addr.sin_addr.s_addr = htonl(INADDR_ANY);
    my_addr.sin_port = htons(0);

    if (upsProtocol) {
      //pro tcp pouzijem connect
      if (connect (soc_addr,(struct sockaddr *)&upsAddr,sizeof(upsAddr)) <0) {
        closeUpsDate(soc_addr);
        upsNetOk = false;
        upsErr=KUPS_CONNECT_ERR;
        return -1;
        }
      }
    else {
      // pro udp pouzijem bind
      // pomoci bindu si priradime nejakou volnou mistni adresu
      if (bind (soc_addr,(struct sockaddr *)&my_addr,sizeof(my_addr)) < 0) {
        closeUpsDate(soc_addr);
        upsNetOk = false;
        upsErr=KUPS_BIND_ERR;
        return -1;
        }
      }
    return soc_addr;
    } // upsNetOk neni nastaveno vratime -1
  else return -1;
  }


int KNutNet::sendComm (int socAddr, char *command, char *arg1, char *arg2, char *inBuffer, int inBufferLen, char *outBuffer, int outBufferLen, bool useUpsName ) {
  char *word1, *word2, *word3;

  strcpy ((char *)inBuffer,command);
  strcat ((char *)inBuffer," ");
  strcat ((char *)inBuffer,arg1);
  if ( useUpsName && (upsName != 0L) && (strlen(upsName)>0)) {
    strcat ((char *)inBuffer,"@");
    strcat ((char *)inBuffer,upsName);
    }
  if ((arg2) && strlen(arg2)) {
  strcat ((char *)inBuffer," ");
  strcat ((char *)inBuffer,arg2);
    }
  strcat ((char *)inBuffer,"\n");
  bzero ((char *)outBuffer,outBufferLen);
  if (getUpsData (socAddr,inBuffer,inBufferLen,outBuffer,outBufferLen) != -1) {
    //odstranime CRLF
    correctBuffer (outBuffer);
    findWords (outBuffer,word1,word2,word3);
    if (!word1) { // zadna odpoved
       upsErr=KUPS_UNKNOWN_ANSWER;
       return -1;
       }
    if (strcmp(word1,"OK")) {
      // neni rovno OK
      if (!strcmp(word1,"ERR")) {
        if (word2) {
          upsErr=upsTranslateError (word2);
          return -1;
          }
        else {
          upsErr=KUPS_UNKNOWN_FORMAT;
          return -1;
          }
        }
      else {
        //neznama odpoved
        upsErr=KUPS_UNKNOWN_ANSWER;
        return -1;
        }
      }  //(strcmp(word1,"OK"))
    } else return -1; // nemohu nacist data
  return 0;
  }

void KNutNet::upsSetType (struct upsVars *uVars) {

  if (! strcmp (uVars->upsVarName,"STATUS"))
    uVars->upsVarActivate=true;
  else uVars->upsVarActivate=false;
  uVars->upsValue=0L;
  uVars->upsCharLength=0;
  uVars->upsDescription=0L;
  uVars->upsVarType=true;
  uVars->upsValueType=true;
  uVars->upsVarMax=0;
  uVars->enumValues=0L;
  }

void KNutNet::setRWVars (char *string, bool valueType, int varMax, struct enumItem *enumValues) {
  if ((upsNetOk) && (string != 0L)) {
    upsVars *uVars;
    uVars=upsFirstName;
    while (uVars != 0L ) {
      // promena nalezena
      if (!strcmp(uVars->upsVarName,string)) {
        uVars->upsVarType=false;
        uVars->upsValueType=valueType;
        uVars->upsVarMax=varMax;
        uVars->enumValues=enumValues;
        uVars=0L; // konec prohledavani;
        }
      else uVars = uVars-> upsNext;
      }
    }
  }




/******************************************************************/
/*                                                                */
/*                          Public Funkce                         */
/*                                                                */
/******************************************************************/

KNutNet::KNutNet (char *name, bool protocol, unsigned short port) : upsPort(port), upsProtocol(protocol)
  {
  //pokud se nepodari nastavit vse spravne je nastaveno upsNetOk na false
  char *uk;  //* pomocny ukazatel
  struct hostent *phe;  // struktura pro
  long return_address;
  int length_upsAddress = 0;


  numberVars = 0;
  numberRWVars = 0;
  numberIComms = 0;

  upsNetOk = true;
  upsErr = 0; //zadna chyba  - je nutne nastavit
  upsName = upsAddress = upsIpAddress = 0L;
  upsFirstName = 0L;  // zadne jmeno promene neni nacteno
  commFirstName = 0L;  // zadne jmeno promene neni nacteno
  upsStatusVar = 1; //promena STATUS (bitova)
  // priallokujeme pamet pro name a address


    if ((uk = strchr(name,(int)'@')) !=0L) {
      int delka = uk -name;
      uk++;
      if (strlen(uk)) {
        length_upsAddress = strlen(uk);
        if ((upsAddress = new char[length_upsAddress+1]) == NULL) {
          upsNetOk = false;
          upsErr=KUPS_LOW_MEM;
          return;
          }
        strcpy (upsAddress,uk);
        }
      if (delka) {
        if ((upsName = new char[delka+1]) == NULL) {
          upsNetOk = false;
          upsErr=KUPS_LOW_MEM;
          return;
          }
         strncpy (upsName, name,delka);
        upsName[delka]='\0';
        }
      }
    else {
      length_upsAddress = strlen(name);
      if ((upsAddress = new char[length_upsAddress+1]) == NULL) {
        upsNetOk = false;
        upsErr=KUPS_LOW_MEM;
        return;
        }
      strcpy (upsAddress,name);
      } // konec else


   //  pokud je upsAddress NULL tak koncime s chybou
  if (length_upsAddress == 0) {
    upsNetOk = false;
    upsErr=KUPS_NULL_ADDRESS;
    return;
    }
  // zjistime IP adresu
  // vynulujeme strukturu
  bzero ((char *) &upsAddr, sizeof (upsAddr));
  upsAddr.sin_family = AF_INET;
  //nastavime port
  upsAddr.sin_port = htons(upsPort);

//  if ((address=inet_addr(upsAddress)) == -1) {
  if ((return_address=inet_addr(upsAddress)) == -1) {
    // neni to teckova adresa zkusime jmenou
    if ((phe = gethostbyname(upsAddress)) != 0L) {
      // adresa nalezena
      // prevedeme adresu
      bcopy(phe->h_addr,(char *)&upsAddr.sin_addr,phe->h_length);
      }
    else {
      upsNetOk = false;
      upsErr=KUPS_NO_SUCH_HOST;
      return;
      }
    }
  else {
    // prevedeme adresu
    upsAddr.sin_addr.s_addr = (unsigned long)return_address;
    }
  // v upsAddr.sin_addr.s_addr mame ulozenou prevedenou adresu
  netMutex=false;
  }

KNutNet::~KNutNet (){
if (upsAddress ) delete upsAddress;
if (upsName ) delete upsName;
//smazeme promene
deleteVars();
};

int KNutNet::getError ( void ) { return upsErr; };
// vraci kod chyby v posledni funkci


void KNutNet::genStatusFlags (struct upsVars *uVars) {
     // vynulujeme status
   upsStatusVar = 0;
  // zapracujeme promenou
  if (uVars == 0L) return;
  else  {
    // STATUS existuje

    char *sVar = new char[strlen(uVars->upsValue)+1];
    if (sVar == NULL) return;
    strcpy (sVar,uVars->upsValue);

    char *word, *endstr;
    word=sVar; //	prvni slovo
    while (word != 0L) {
    if ((endstr=strchr (word,32)) != 0L) { // hledame prvni mezeru
        endstr[0]='\0';
        endstr++;
        }
      //pokud nebude nalezena mezera je endstr nastaveno na NULL
      //zpracujeme slova
      if (! strcmp ("OFF",word)) upsStatusVar +=1;
      if (! strcmp ("OL",word)) upsStatusVar +=2;
      if (! strcmp ("OB",word)) upsStatusVar +=4;
      if (! strcmp ("LB",word)) upsStatusVar +=8;
      if (! strcmp ("CAL",word)) upsStatusVar +=16;
      if (! strcmp ("TRIM",word)) upsStatusVar +=32;
      if (! strcmp ("BOOST",word)) upsStatusVar +=64;
      if (! strcmp ("OVER",word)) upsStatusVar +=128;
      if (! strcmp ("RB",word)) upsStatusVar +=256;
//OFF     -  1 ups je vypnuta
//OL      -  2 ups je bezi na sit
//OB      -  4 ups bezi na baterie
//LB      -  8 baterie je vybyta (pokud je zaroven OB dojde k shutdownu)
//CAL     - 16 je spustena kalibrace
//OVER    -128 ups je pretizena
//RB      -256 ups pozaduje vymenu baterie
      word=endstr;
      }
    delete sVar;
    }
  }

//*************BEGIN getUpsVars**************************************************
int KNutNet::getUpsVars ( void) {
// getUpsVars nacte promene a jejich typ

  if (upsNetOk) {
    char in_buffer[SBUFFER_LEN], out_buffer[RBUFFER_LEN], inOutBuffer[RBUFFER_LEN];
    int soc_addr = 0L;
    numberVars = numberRWVars = numberIComms =0; // nastavime citace
    // upsNetOk = true;
    if  (upsFirstName != 0L) deleteVars();

//**************** Nacteme vsechny promene ********************
    if ((soc_addr=openUpsDate()) != -1) {
      // spojeni je otevreno
      // pokud existuje pridame take jmeno UPS-ky
      if ((upsName != 0L) && (strlen(upsName)>0)) {
        strcpy ((char *)in_buffer,"LISTVARS ");
        strcat ((char *)in_buffer,upsName);
        strcat ((char *)in_buffer,"\n");
        }
      else strcpy ((char *)in_buffer,"LISTVARS\n");
      //vynulujeme buffer pro prijate data
      bzero ((char *)out_buffer,RBUFFER_LEN);

      if (getUpsData (soc_addr,in_buffer,sizeof(in_buffer),out_buffer,sizeof(out_buffer)) != -1) {
        // precteme data
        if (strlen(out_buffer)>5) {
          // Odstranime CRLF
          correctBuffer (out_buffer);
          // precteme jednotliva slova
          char *word, *endstr;
          struct upsVars *uVars;
          int count = 1;
          word=out_buffer; //	prvni slovo
          while (word != 0L) {
            if ((endstr=strchr (word,32)) != 0L) { // hledame prvni mezeru
              endstr[0]='\0';
              endstr++;
              }
            //  pokud nenajde mezeru je endstr nastaveno na NULL
            switch (count) {
              case 1:
                // vyndame prvni polozku
                if (! strcmp (word,"VARS")) count++;
                else {
                  if (! strcmp (word,"ERR"))
                    upsErr=upsTranslateError (endstr); // prevede chybu na jeji kod
                  else upsErr=KUPS_UNKNOWN_ANSWER;
                  closeUpsDate (soc_addr);  // zavreme spojeni;
                  return -1;
                  }
                break;
              case 2:
                //count++;
                if ((strlen(word)>0) && (word[0]=='@')) break;
              default:
                // pridame polozku do tabulky
                uVars = new upsVars;
                if (uVars == 0L)  {
                  upsNetOk = false;
                  upsErr=KUPS_LOW_MEM;
                  closeUpsDate (soc_addr);
                  return -1;
                  }
                uVars->upsVarName = new char[strlen(word)+1];
                if (uVars->upsVarName == 0L) {
                  upsNetOk = false;
                  upsErr=KUPS_LOW_MEM;
                  closeUpsDate (soc_addr);
                  return -1;
                  }
                uVars->upsNext = upsFirstName;
                upsFirstName = uVars;
                strcpy (uVars->upsVarName,word); // prekopirujeme jmeno
                // je nutno nastavit typ  a vynulovat hodnoty
                upsSetType (uVars);
                uVars->upsVarNa=false; // hodnoty jsou ok
                //count++;
                numberVars++;
                break;
              }
            word=endstr;
            }
          } // end strlen(out_buffer)
        else {
          // prectene data jsmou mensi nez 3 znaky
          upsErr=KUPS_NO_DATA;
          closeUpsDate (soc_addr);
          return -1;
          }
        }// end getUpsData
      else {
        closeUpsDate (soc_addr);
        return -1 ;// nepodarilo se nic precist
        }
    //******** precteme RW promenne ***********
      // pokud existuje pridame jmeno UPS-ky
      if ((upsName != 0L) && (strlen(upsName)>0)) {
        strcpy ((char *)in_buffer,"LISTRW ");
        strcat ((char *)in_buffer,upsName);
        strcat ((char *)in_buffer,"\n");
        }
      else strcpy ((char *)in_buffer,"LISTRW\n");
      //vynulujeme buffer pro prijate data
      bzero ((char *)out_buffer,RBUFFER_LEN);
      if (getUpsData (soc_addr,in_buffer,sizeof(in_buffer),out_buffer,sizeof(out_buffer)) != -1) {
        // precteme data
//        //test -odstranit
//        strcpy((char *)out_buffer,"RW LOWXFER\n");

        if (strlen(out_buffer)>2) {
          // Odstranime CRLF
          correctBuffer (out_buffer);
          // precteme jednotliva slova
          char *word, *endstr;
          int count = 1;
          bool valueType;
          int varMax;
          struct enumItem *enumMember;
          struct enumItem *enumFirstMember;
          struct enumItem *enumEndMember;
          word=out_buffer; //	prvni slovo
          while (word != 0L) {
            if ((endstr=strchr (word,32)) != 0L) { // hledame prvni mezeru
              endstr[0]='\0';
              endstr++;
              }
            switch (count) {
              case 1:
                // vyndame prvni polozku
                if (! strcmp (word,"RW")) count++;
                else {
                  if (! strcmp (word,"ERR"))
                    upsErr=upsTranslateError (endstr); // prevede chybu na jeji kod
                  else upsErr=KUPS_UNKNOWN_ANSWER;
                  closeUpsDate (soc_addr);  // zavreme spojeni;
                  return -1;
                  }
                break;
              case 2:
                //count++;
                if ((strlen(word)>0) && (word[0]=='@')) break;
              default:
                 // zjistime informaci o promene
                 strcpy ((char *)in_buffer,"VARTYPE");
                 // pokud existuje pridame jmeno UPS-ky
                 if ((upsName != 0L) && (strlen(upsName)>0)) {
                   strcat ((char *)in_buffer," ");
                   strcat ((char *)in_buffer,upsName);
                   }
                 strcat ((char *)in_buffer," ");
                 strcat ((char *)in_buffer,word);
                 strcat ((char *)in_buffer,"\n");

                 //vynulujeme buffer pro prijate data
                 bzero ((char *)inOutBuffer,RBUFFER_LEN);
                 if (getUpsData (soc_addr,in_buffer,sizeof(in_buffer),inOutBuffer,sizeof(inOutBuffer)) != -1) {
                   // precteme data
//                   //test -odstranit
//                   strcpy((char *)inOutBuffer,"TYPE ENUM 3\n");
                   if (strlen(inOutBuffer)>5) {
                     // Odstranime CRLF
                     correctBuffer (inOutBuffer);
                     // precteme jednotliva slova
                     char *word1, *word2, *word3;
                     findWords(inOutBuffer,word1,word2,word3);
                     if (! strcmp (word1,"TYPE")) {
                       if ((word2==0) || (word3==0)) {
                         upsErr=KUPS_UNKNOWN_FORMAT;
                         closeUpsDate (soc_addr);  // zavreme spojeni;
                         return -1;
                         }
                       else {
                         if (! strcmp (word2,"ENUM")) valueType=false;
                         else {
                           if (! strcmp (word2,"STRING")) valueType=true;
                           // else error
                           else {
                             upsErr=KUPS_UNKNOWN_ANSWER;
                             closeUpsDate (soc_addr);
                             return -1;
                             }
                           }
                         if (strlen(word3) >0) varMax=atoi(word3);
                         }
                       }
                     else {
                       if (! strcmp (word1,"ERR")) {
                         if (word2==0) upsErr=KUPS_UNKNOWN_ERR;
                         else upsErr=upsTranslateError(word2); // prevede chybu na jeji kod
                         }
                       else upsErr=KUPS_UNKNOWN_ANSWER;
                       closeUpsDate (soc_addr);  // zavreme spojeni;
                       return -1;
                       }
                      }
                   else {
                     // prectene data jsmou mensi nez 3 znaky
                     upsErr=KUPS_NO_DATA;
                     closeUpsDate (soc_addr);
                     return -1;
                     }
                   }// konec cteni informaci o promene
                 else {
                   closeUpsDate (soc_addr);
                   return -1 ;// nepodarilo se nic precist
                   }
                 if (!valueType) {
                   // nacteme enum hodnoty

                   strcpy ((char *)in_buffer,"ENUM");
                   strcat ((char *)in_buffer," ");
                   strcat ((char *)in_buffer,word);
                                  // pokud existuje pridame jmeno UPS-ky
                   if ((upsName != 0L) && (strlen(upsName)>0)) {
                     strcat ((char *)in_buffer," ");
                     strcat ((char *)in_buffer,upsName);
                     }
                   strcat ((char *)in_buffer,"\n");
                   bzero ((char *)inOutBuffer,RBUFFER_LEN);
                   if (getUpsData (soc_addr,in_buffer,sizeof(in_buffer),inOutBuffer,sizeof(inOutBuffer),"END\n") != -1) {
                     // budeme zpracovavat po radkach
//                   //test -odstranit
//                   strcpy((char *)inOutBuffer,"ENUM LOWXFER\nOPTION \"220\" SELECTED\nOPTION \"200\"\nOPTION \"180\"\nEND\n");
                   // Odstranime CRLF
                   correctBuffer (inOutBuffer);
                     char *inLine, *inEndLine, *word1, *word2, *word3;
                     int inCountLine=1;
                     inLine=inOutBuffer; //  prvni radka
                     while (inLine != 0L) {
                       if ((inEndLine=strchr(inLine,'\n')) != 0L) { // hledame prvni mezeru
                         inEndLine[0]='\0';
                         inEndLine++;
                         int lineLen;
                         if (((lineLen = strlen(inLine)) > 0) && (inLine[lineLen-2]=='\r'))
                           inLine[strlen(inLine)-2]='\0';
                         }
                       //testujeme  slovo
                       findWords(inLine,word1,word2,word3);
                         if (word1==0) {
                           upsErr=KUPS_UNKNOWN_FORMAT;
                           closeUpsDate (soc_addr);
                           return -1;
                           }
                         switch (inCountLine) {
                           case 1: // prvni radka
                             // vyndame prvni polozku
                             if (strcmp (word1,"ENUM")) {
                               if (! strcmp (word1,"ERR"))
                                  upsErr=upsTranslateError (word2); // prevede chybu na jeji kod
                               else upsErr=KUPS_UNKNOWN_ANSWER;
                               closeUpsDate (soc_addr);  // zavreme spojeni;
                               return -1;
                               }
                             else {
                               enumFirstMember=0L;
                               varMax=0; // pro jistotu si pocet variant spocteme sami
                               if ((word2==0) || (strcmp (word2,word))) {
                                 upsErr=KUPS_UNKNOWN_FORMAT;
                                 closeUpsDate (soc_addr);
                                 return -1;
                                 }
                               }
                           break;
                           default:
                           // dalsi radky
                             if (! strcmp (word1,"OPTION")) {
                               if (word2 !=0) {
                                 char* stringValue;
                                 if ((stringValue = new char[strlen(word2)+1]) != 0) {
                                   if ((enumMember = new struct enumItem)!=0) {
                                     strcpy(stringValue,word2);
                                     enumMember->enumString=stringValue;
                                     if (enumFirstMember != 0) enumEndMember->itemNext=enumMember;
                                     else enumFirstMember=enumMember;
                                     enumEndMember=enumMember;
                                     enumMember->itemNext=0;
                                     varMax++;
                                     }
                                   }
                                 }
                               }
                             else {
                               if (! strcmp (word1,"END")) {
                                 inEndLine=0L; //konec zpracovani
                                 }
                               else {
                                 if (! strcmp (word,"ERR"))
                                   upsErr=upsTranslateError (word2); // prevede chybu na jeji kod
                                 else upsErr=KUPS_UNKNOWN_ANSWER;
                                 closeUpsDate (soc_addr);  // zavreme spojeni;
                                 return -1;
                                 }
                               }
                           break;
                           } // end switch
                       inCountLine++;
                       inLine=inEndLine;
                       }
                     }
                   else {
                     // prectene data jsmou mensi nez 3 znaky
                     upsErr=KUPS_NO_DATA;
                     closeUpsDate (soc_addr);
                     return -1;
                     }
                   }
                 else enumFirstMember=0L; // pro stringovou promenou vynulujeme
                 // pridame polozku do tabulky
                 // nastav promenou jako RW
                 setRWVars (word,valueType,varMax,enumFirstMember);
                 //count++;
                 numberRWVars++;
                 break;
              }
            word=endstr;
            }
          } // end strlen(out_buffer
        else {
          // prectene data jsmou mensi nez 3 znaky
          upsErr=KUPS_NO_DATA;
          closeUpsDate (soc_addr);
          return -1;
          }
        } // konec getUpsData pro RW
      else {
        closeUpsDate (soc_addr);
        return -1 ;// nepodarilo se nic precist
        }

//******* precteme INSTANT COMMANDS **************
      // pokud existuje pridame jmeno UPS-ky
      if ((upsName != 0L) && (strlen(upsName)>0)) {
        strcpy ((char *)in_buffer,"LISTINSTCMD ");
        strcat ((char *)in_buffer,upsName);
        strcat ((char *)in_buffer,"\n");
        }
      else strcpy ((char *)in_buffer,"LISTINSTCMD\n");
      //vynulujeme buffer pro prijate data
      bzero ((char *)out_buffer,RBUFFER_LEN);
      if (getUpsData (soc_addr,in_buffer,sizeof(in_buffer),out_buffer,sizeof(out_buffer)) != -1) {
        // precteme data
//        //test - odstranit
//        strcpy((char *)out_buffer,"INSTCMDS FPTEST BTEST0 BTEST1 CAL0 CAL1\n");
        if (strlen(out_buffer)>8) {
          // Odstranime CRLF
          correctBuffer (out_buffer);
          // precteme jednotliva slova
          struct upsIComm *uIComm;
          char *word, *endstr;
          int count = 1;
          word=out_buffer; //	prvni slovo
          while (word != 0L) {
            if ((endstr=strchr (word,32)) != 0L) { // hledame prvni mezeru
              endstr[0]='\0';
              endstr++;
              }
            switch (count) {
              case 1:
                // vyndame prvni polozku
                if (! strcmp (word,"INSTCMDS")) count++;
                else {
                  if (! strcmp (word,"ERR"))
                    upsErr=upsTranslateError (endstr); // prevede chybu na jeji kod
                  else upsErr=KUPS_UNKNOWN_ANSWER;
                  closeUpsDate (soc_addr);  // zavreme spojeni;
                  return -1;
                  }
                break;
              case 2:
                count++;
                if ((strlen(word)>0) && (word[0]=='@')) break;
              default:
                // pridame polozku do tabulky
                // pridej prikaz do tabulky prikazu
                uIComm = new upsIComm;
                if (uIComm == 0L)  {
                  upsNetOk = false;
                  upsErr=KUPS_LOW_MEM;
                  closeUpsDate (soc_addr);
                  return -1;
                  }
                uIComm->upsCommName = new char[strlen(word)+1];
                if (uIComm->upsCommName == 0L) {
                  upsNetOk = false;
                  upsErr=KUPS_LOW_MEM;
                  closeUpsDate (soc_addr);
                  return -1;
                  }
                uIComm->upsNext = commFirstName;
                commFirstName = uIComm;
                strcpy (uIComm->upsCommName,word); // prekopirujeme jmeno
                // je nutno nastavit typ  a vynulovat hodnoty
                //count++;
                numberIComms++;
                break;
              }
            word=endstr;
            }
          } // end strlen(out_buffer
        else {
          // prectene data jsmou mensi nez 9 znaky
          upsErr=KUPS_NO_DATA;
          closeUpsDate (soc_addr);
          return -1;
          }
        } // konec getUpsData pro RW
      else {
        closeUpsDate (soc_addr);
        return -1 ;// nepodarilo se nic precist
        }
      closeUpsDate (soc_addr);  // zavreme spojeni;
      } // konec po otevreni spojeni
    else return -1; // nepodarilo se otevrit spojeni

    } //konec if upsNetOk
  else {
    upsErr=KUPS_NO_UPSNET_OK;
    return 0; // upsNetOk je false nemohu provest operaci
    }
  return 0;
  }
//***************************ENG getUpsVar***********************************************



//***************************BEGIN getUpsValues******************************************
int KNutNet::getUpsValues (bool allVars ) {// allVars = true vse; allVars = false jen activate
  // Nacte hodnotu promenych
  if (upsNetOk) {
// tuto cast pouzijem az uz nebudeme podporovat starsi verze KDE
//    if (netMutex.locked()) {
//      // proces bezi pockame na dokonceni
//      // nema vyznam ho znovu cist
//      netMutex.lock(); // cekame na volny pristup
//      netMutex.unlock();
//      return 0;
//      }
//    netMutex.lock();
//
    if (netMutex) {
      while (netMutex) {};
      if (!allVars) return 0; // pokud je zadano vse musime vzdy nacist data
      }
    netMutex = true;
    upsVars *uk_vars;
    int soc_addr = 0L;
    uk_vars = upsFirstName;

    if ((soc_addr = openUpsDate()) != -1) {
      while (uk_vars != 0L) {
        if ((allVars) || (uk_vars->upsVarActivate)) {
          if (getValue (soc_addr, uk_vars)) return -1;
          }
        uk_vars=uk_vars->upsNext; // zkusime dalsi promenou
        } // end while
      closeUpsDate (soc_addr);
      //netMutex.unlock();
      netMutex=false;
      return 0;
      } // neni mozno otevrit spojeni
    else {
      //netMutex.unlock();
      netMutex=false;
      return -1;
      }
    } //upsNetOK
  else {
    upsErr=KUPS_NO_UPSNET_OK;
    return -1;
    }
  }
//*************************************ENG getUpsValues*******************************





//***************************BEGIN getUpsValue******************************************
int KNutNet::getUpsValue (char *upsVarName ) {
  // Nacte hodnotu promenych
  if (upsNetOk) {
// tuto cast pouzijem az uz nebudeme podporovat starsi verze KDE
//    if (netMutex.locked()) {
//      // proces bezi pockame na dokonceni
//      // nema vyznam ho znovu cist
//      netMutex.lock(); // cekame na volny pristup
//      netMutex.unlock();
//      return 0;
//      }
//    netMutex.lock();
//
    if (netMutex) while (netMutex) {};
    netMutex = true;
    upsVars *uk_vars;
    int soc_addr = 0L;
    uk_vars = upsFirstName;

    if ((soc_addr = openUpsDate()) != -1) {
      while (uk_vars != 0L) {
        if (!strcmp(upsVarName,uk_vars->upsVarName)) {
          if (getValue (soc_addr, uk_vars)) return -1;
          closeUpsDate (soc_addr);
          netMutex=false;
          return 0; //koncime
          }
        uk_vars=uk_vars->upsNext; // zkusime dalsi promenou
        } // end while
      closeUpsDate (soc_addr);
      //netMutex.unlock();
      netMutex=false;
      upsErr=KUPS_VAR_NOT_FIND;
      return -1;
      } // neni mozno otevrit spojeni
    else {
      //netMutex.unlock();
      netMutex=false;
      return -1;
      }
    } //upsNetOK
  else {
    upsErr=KUPS_NO_UPSNET_OK;
    return -1;
    }
  }
//*************************************ENG getUpsValue*******************************





int KNutNet::instantCommand (char *command, char *userName, char*password) {
  char inBuffer[SBUFFER_LEN], outBuffer[RBUFFER_LEN];
  int socAddr = 0L;

  if (upsNetOk) {
// tuto cast pouzijem az uz nebudeme podporovat starsi verze KDE
//    if (netMutex.locked()) {
//      // proces bezi pockame na dokonceni
//      netMutex.lock(); // cekame na volny pristup
//      }
//    netMutex.lock();
//
    if (netMutex) while (netMutex) {};
    netMutex = true;

    if ((socAddr=openUpsDate()) != -1) {
      // spojeni je otevreno
      if (!sendComm(socAddr,"USERNAME", userName, 0L, inBuffer,SBUFFER_LEN,outBuffer,RBUFFER_LEN)) {
        if (!sendComm(socAddr,"PASSWORD", password, 0L, inBuffer,SBUFFER_LEN,outBuffer,RBUFFER_LEN)) {
          if (!sendComm(socAddr,"INSTCMD", command, 0L, inBuffer,SBUFFER_LEN,outBuffer,RBUFFER_LEN,true)) {
            closeUpsDate(socAddr);
            netMutex=false;
            return 0;
            }
          }
        } //username
      closeUpsDate(socAddr);
      }
    netMutex=false;
    return -1;
    }  //upsNetOk
  else {
    upsErr=KUPS_NO_UPSNET_OK;
    return -1;
    }
  }


int KNutNet::setVariable (char *variable, char *value, char *userName, char*password) {
    char inBuffer[SBUFFER_LEN], outBuffer[RBUFFER_LEN];
    int socAddr = 0L;

  if (upsNetOk) {
// tuto cast pouzijem az uz nebudeme podporovat starsi verze KDE
//    if (netMutex.locked()) {
//      // proces bezi pockame na dokonceni
//      netMutex.lock(); // cekame na volny pristup
//      }
//    netMutex.lock();
//
    if (netMutex) while (netMutex) {};
    netMutex = true;
    
    if ((socAddr=openUpsDate()) != -1) {
      // spojeni je otevreno
      if (!sendComm(socAddr,"USERNAME", userName, 0L, inBuffer, SBUFFER_LEN,outBuffer,SBUFFER_LEN)) {
        if (!sendComm(socAddr,"PASSWORD", password, 0L, inBuffer,SBUFFER_LEN,outBuffer,SBUFFER_LEN)) {
          if (!sendComm(socAddr,"SET", variable, value, inBuffer,SBUFFER_LEN,outBuffer,SBUFFER_LEN,true)) {
            closeUpsDate(socAddr);
            netMutex=false;
            return 0;
            }
          }
        }
      closeUpsDate(socAddr);
      }
    netMutex=false;
    return -1;
    }  //upsNetOk
  else {
    upsErr=KUPS_NO_UPSNET_OK;
    return -1;
    }
  }



//*************************************begin readNumberVars***************************
int KNutNet::readNumberVars (int typVar) {
//  Vraci pocet promenych

  if (upsNetOk) {
    switch (typVar) {
      case ALL_VARS:
        return numberVars;
        break;
      case RO_VARS:
        return numberVars - numberRWVars;
        break;
      case RW_VARS:
        return numberRWVars;
        break;
      default: return -1;
      }
    }
  else {
    upsErr = KUPS_NO_UPSNET_OK;
    return -1;
    }
  }
//******************************END readNumberVars*********************************

//*************************************begin readNumberComms***************************
int KNutNet::readNumberComms (void) {
//  Vraci pocet prikazu

  if (upsNetOk) return numberIComms;
  else {
    upsErr = KUPS_NO_UPSNET_OK;
    return -1;
    }
  }
//******************************END readNumberVars*********************************



//******************************BEGIN readComms************************************

int KNutNet::readIComm (int seqNumber, struct upsRIComm& allComm) {
// precte vsechny hodnoty pro najednou
//verze pro poradi

  upsIComm *uIComm;

  if (upsNetOk) {
    int n = 1;

    uIComm=commFirstName;
    while (uIComm != 0L ) {
      if (n == seqNumber) {
        //upsVarName
        int i = strlen (uIComm->upsCommName);
        if (i>UPS_COMM_NAME_LENGTH)  i = UPS_COMM_NAME_LENGTH;
        strncpy (allComm.upsCommName,uIComm->upsCommName,i);
        allComm.upsCommName[i]='\0';
        return 0;
        }
      else {
        uIComm = uIComm-> upsNext;
        n++;
        }
      }
    upsErr=KUPS_COMM_NOT_FIND;
    return -1;
    }
  else {
    upsErr = KUPS_NO_UPSNET_OK;
    return -1;
    }
  }

//******************************END readComms**************************************

//******************************BEGIN readVars***************************************
int KNutNet::readVars (char *name, struct upsRVar& allVars) {
// precte vsechny hodnoty pro najednou
// verze pro jmeno
  upsVars *uVars;

  if (upsNetOk) {
    uVars=upsFirstName;
    while (uVars != 0L ) {
      if (! strcmp (name,uVars->upsVarName)) {
      //upsVarName
        int i=strlen (uVars->upsVarName);
        if (i>UPS_VAR_NAME_LENGTH)  i=UPS_VAR_NAME_LENGTH; // maximalni delka stringu je pro upsRVAr pevne danna
        strncpy (allVars.upsVarName,uVars->upsVarName,i);
        allVars.upsVarName[i]='\0';
        //upsVarNa
        allVars.upsVarNa=uVars->upsVarNa;
        //upsVarActivate
        allVars.upsVarActivate=uVars->upsVarActivate;
        //upsVarType
        allVars.upsVarType=uVars->upsVarType;
        //upsMax
        allVars.upsVarMax=uVars->upsVarMax;
        //valueType
        allVars.upsValueType=uVars->upsValueType;
        //upsValue
        int ii;
        if (uVars->upsValue != 0L) {
          ii=strlen (uVars->upsValue);
          if (ii>UPS_VAR_CHAR_LENGTH)  ii=UPS_VAR_CHAR_LENGTH;
          strncpy (allVars.upsValue,uVars->upsValue,ii);
          }
        else ii=0;
        allVars.upsValue[ii]='\0'; // ulozime konecovou znacku

        return 0;
        }
      else uVars = uVars-> upsNext;
      }
    upsErr=KUPS_VAR_NOT_FIND;
    return -1;
    }
  else {
    upsErr = KUPS_NO_UPSNET_OK;
    return -1;
    }
  }

int KNutNet::readVars (int seqNumber, struct upsRVar& allVars, int typVar) {
// precte vsechny hodnoty pro najednou
//verze pro poradi
  upsVars *uVars;

  if (upsNetOk) {
    int n = 1;

    uVars=upsFirstName;
    while (uVars != 0L ) {
      if ((typVar== ALL_VARS) || ((typVar==RO_VARS) && (uVars->upsVarType)) ||
         ((typVar==RW_VARS) && (!uVars->upsVarType))) {
        if (n == seqNumber) {
          //upsVarName
          int i = strlen (uVars->upsVarName);
          if (i>UPS_VAR_NAME_LENGTH)  i = UPS_VAR_NAME_LENGTH;
          strncpy (allVars.upsVarName,uVars->upsVarName,i);
          allVars.upsVarName[i]='\0';
          //upsVarNa
          allVars.upsVarNa=uVars->upsVarNa;
          //upsVarActivate
          allVars.upsVarActivate=uVars->upsVarActivate;
          //upsVarType
          allVars.upsVarType=uVars->upsVarType;
          //upsMax
          allVars.upsVarMax=uVars->upsVarMax;
          //valueType
          allVars.upsValueType=uVars->upsValueType;
          //upsValue
          int ii;
          if (uVars->upsValue != 0L) {
            ii=strlen (uVars->upsValue);
            if (ii>UPS_VAR_CHAR_LENGTH)  ii=UPS_VAR_CHAR_LENGTH;
            strncpy (allVars.upsValue,uVars->upsValue,ii);
            }
          else ii=0;
          allVars.upsValue[ii]='\0';

          // ukoncime pocitani
          return 0;
          }
        else {
//          uVars = uVars-> upsNext;
          n++;
          }
        }
      uVars = uVars-> upsNext;
      }
    upsErr=KUPS_VAR_NOT_FIND;
    return -1;
    }
  else {
    upsErr = KUPS_NO_UPSNET_OK;
    return -1;
    }
  }
//*************************END readVars*************************************************



//****************************BEGIN readStringVar*****************************
char* KNutNet::readStringVar ( char *name) {
  // vraci hodnotu promene pokud je znakova
  if (upsNetOk) {

    upsVars *uVars;
//    char *sVar = 0L;

    uVars=upsFirstName;
    while (uVars != 0L ) {
      if (! strcmp(name,uVars->upsVarName)) {
        // promena nalezena
        return uVars->upsValue;
        }
      else uVars = uVars-> upsNext; //zkusime dalsi promenou
      } // konec while
    upsErr=KUPS_VAR_NOT_FIND; //nebylo nic nalezeno
    return 0L;
    }
  else {
    upsErr = KUPS_NO_UPSNET_OK;
    return 0L;
    }
  }


//char *KNutNet::readStringVar ( int seqNumber ) {
//  // vraci hodnotu promene pokud je znakova

//  if (upsNetOk) {
//    upsVars *uVars;
//    int n=1;

//    uVars=upsFirstName;
//    while (uVars != 0L ) {
//      if (seqNumber == n) {
//      // promena nalezena
//        return uVars->upsValue;
//        //uVars = 0L; // ukoncime pocitani
//        }
//      else {
//        uVars = uVars-> upsNext;
//        n++;
//        }
//      } // konec while
//    upsErr = KUPS_VAR_NOT_FIND;
//    return 0L;
//    }
//  else {
//    upsErr = KUPS_NO_UPSNET_OK;
//    return 0L;
//    }
//  }

//**************************END readStringVar*********************************************

//**************************BEGIN readTypeVar********************************************
//int KNutNet::readTypeVar ( char *name ) {
//  // vraci typ promene
//  upsVars *uVars;
//
//  if (upsNetOk) {
//    uVars=upsFirstName;
//    while (uVars != 0L ) {
//      if (! strcmp(name,uVars->upsVarName)) return uVars->upsVarType;
//      else uVars = uVars-> upsNext;
//      }
//    upsErr=KUPS_VAR_NOT_FIND;
//    return -1;
//    }
//  else {
//    upsErr = KUPS_NO_UPSNET_OK;
//    return -1;
//    }
//  }

//int KNutNet::readTypeVar ( int seqNumber ) {
//  upsVars *uVars;
//  int n=1;
//
//  if (upsNetOk) {
//    uVars=upsFirstName;
//   while (uVars != 0L ) {
//      if (seqNumber == n)	return uVars->upsVarType;
//      else {
//        uVars = uVars-> upsNext;
//        n++;
//        }
//      } // end while
//    upsErr=KUPS_VAR_NOT_FIND;
//    return -1;
//    }
//  else {
//    upsErr = KUPS_NO_UPSNET_OK;
//    return -1;
//    }
//  }
//**************************END readTypeVar************************************


//**************************BEGIN readNameVar*********************************
//// vraci nazev promene
//char *KNutNet::readNameVar ( int seqNumber ) {
//
//  if (upsNetOk) {
//    upsVars *uVars;
//    int n=1;
//    char *sVar = 0L;
//    uVars=upsFirstName;
//    while (uVars != 0L ) {
//      if (seqNumber == n) {
//        // promena nalezena
//        sVar = uVars->upsVarName;
//        return sVar;
//        }
//      else {
//        uVars = uVars-> upsNext;
//        n++;
//        }
//      }
//    upsErr=KUPS_VAR_NOT_FIND;
//    return 0L;
//    }
//  else {
//    upsErr = KUPS_NO_UPSNET_OK;
//    return 0L;
//    }
//  }
//***********************************END readNameVar************************************/

//***********************************BEGIN readEnumValueVar*****************************
char* KNutNet::readEnumValueVar (char *name, int valueNumber) {
  if (upsNetOk) {
    struct upsVars *uVars;
    struct enumItem *pEnum;
    uVars=upsFirstName;
      while (uVars) {
      if (! strcmp(name,uVars->upsVarName)) {
        // promena nalezena
        // najdeme hodnotu
        if ((valueNumber > 0) || (valueNumber < (uVars->upsVarMax+1))) {
             // zde pridame presun z tabulky vyctovych hodnot
          pEnum=uVars->enumValues;
          int n=1;
          while (pEnum) {
            if (n == valueNumber) return pEnum->enumString;
            else {
              n++;
              pEnum=pEnum->itemNext;
              }
            }
          upsErr=KUPS_VAR_NOT_FIND;
          return 0L;
          }
        else {
          upsErr=KUPS_VAR_NOT_FIND;
          return 0L;
          }
        upsErr=KUPS_VAR_NOT_FIND;
        uVars = 0L; // ukoncime pocitani
        return 0;
        }
      else  uVars = uVars-> upsNext;
      } // konec while
    upsErr=KUPS_VAR_NOT_FIND;
    return 0L;
    }
  else {
    upsErr=KUPS_NO_UPSNET_OK;
    return 0L;
    }
  }
//***********************************END readEnumValueVar*****************************


//***********************************BEGIN readStatus***********************************

int KNutNet::readStatus(void) {
  if (upsNetOk) return upsStatusVar; else return -1;
  }

//***********************************END readStatus*************************************

//**************************BEGIN setActivate**********************
// nastavi promenou pro nacteni hodnot procedurou  getUpsValues
int KNutNet::setActivate ( char *name ) {
  if (upsNetOk) {
    upsVars *uVars;
    uVars=upsFirstName;
      while (uVars != 0L ) {
      if (! strcmp(name,uVars->upsVarName)) {
        // promena nalezena
        uVars->upsVarActivate=true;
//        uVars = 0L; // ukoncime pocitani
        return 0;
        }
      else  uVars = uVars-> upsNext;
      } // konec while
    upsErr=KUPS_VAR_NOT_FIND;
    return -1;
    }
  else {
    upsErr=KUPS_NO_UPSNET_OK;
    return -1;
    }
  }

// nastavi promenou pro nacteni hodnot procedurou  getUpsValues
//int KNutNet::setActivate ( int seqNumber ) {
//
//  if (upsNetOk) {
//    upsVars *uVars;
//    int n=1;
//    uVars=upsFirstName;
//    while (uVars != 0L ) {
//      if (seqNumber == n) {
//        // promena nalezena
//        uVars->upsVarActivate=true;
//        //uVars = 0L; // ukoncime pocitani
//        return 0;
//        }
//      else {
//        uVars = uVars-> upsNext;
//        n++;
//        }
//      } // konec while
//    return -1;
//    upsErr=KUPS_VAR_NOT_FIND;
//    }
//  else {
//    upsErr=KUPS_NO_UPSNET_OK;
//    return -1;
//    }
//  }


//***********************************END set Activate**********************************

//**************************BEGIN unSetActivate**********************
// zrusi nastaveni promene pro nacteni hodnot procedurou  getUpsValues
  int KNutNet::unSetActivate ( char *name ) {

  if (upsNetOk) {
    upsVars *uVars;
    uVars=upsFirstName;
    while (uVars != 0L ) {
      if (! strcmp(name,uVars->upsVarName)) {
        // promena nalezena
        uVars->upsVarActivate=false;
        //uVars = 0L; // ukoncime pocitani
        return 0;
        }
      else uVars = uVars-> upsNext;
      } // konec while
    upsErr=KUPS_VAR_NOT_FIND;
    return -1;
    }
  else {
    upsErr=KUPS_NO_UPSNET_OK;
    return -1;
    }
  }

// zrusi nastaveni promene pro nacteni hodnot procedurou  getUpsValues
//int KNutNet::unSetActivate ( int seqNumber ) {

//  if (upsNetOk) {
//    upsVars *uVars;
//    int n=1;
//    uVars=upsFirstName;
//    while (uVars != 0L ) {
//      if (seqNumber == n) {
//        // promena nalezena
//        uVars->upsVarActivate=false;
//        //uVars = 0L; // ukoncime pocitani
//        return 0;
//        }
//      else {
//        uVars = uVars-> upsNext;
//        n++;
//        }
//      }
//    upsErr=KUPS_VAR_NOT_FIND;
//    return -1;
//    }
//  else {
//    upsErr=KUPS_NO_UPSNET_OK;
//    return -1;
//    }
//  }

//***********************************END unSetActivate**********************************


//*********************************BEGIN unSetActivateAll**********************************
// zrusi nastaveni vsech promenych pro nacteni hodnot procedurou  getUpsValues
int KNutNet::unSetActivateAll ( void ) {

  if (upsNetOk) {
    upsVars *uVars;
    uVars=upsFirstName;
    while (uVars != 0L ) {
      // promena nalezena
      uVars->upsVarActivate=false;
      uVars = uVars-> upsNext;
      }
    return 0;
    }
  else {
    upsErr=KUPS_NO_UPSNET_OK;
    return -1;
    }
  }

//***********************************END unSetActivateAll**********************************

// zrusi nastaveni promene pro nacteni hodnot procedurou  getUpsValues
int KNutNet::existName ( char *name ) {
  if (upsNetOk) {
    upsVars *uVars;
    uVars=upsFirstName;
    while (uVars != 0L ) {
      if (! strcmp(name,uVars->upsVarName)) return 1; // promena nalezena
      else uVars = uVars-> upsNext;
      } // konec while
    return 0;
    }
  else {
    upsErr=KUPS_NO_UPSNET_OK;
    return -1;
    }
  }




