/***************************************************************************
                          knutinstcomms.cpp  -  description
                             -------------------
    begin                : ct rj 24 2002
    copyright            : (C) 2002 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knutinstcomms.h"
#include "knutprintupsvar.h"

#include <qlayout.h> 
#include <qframe.h>
#include <qlabel.h>

#include <kcombobox.h>
#include <kmessagebox.h>


KNutInstComms::KNutInstComms(QString uName, QString password, KNutNet* upsNet, QWidget* parent,  const char* name, bool modal)
: KDialogBase(Plain, i18n("Instant commands"),Ok|Cancel,Ok, parent, name, modal, true), myUpsNet(upsNet){

  upsRIComm myStructIComm;

    QFrame *page = plainPage();
    QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );
    QLabel *label1 = new QLabel (i18n("RUN INSTANT COMMAND"),page,"label1");
    label1->setAlignment(Qt::AlignHCenter);
    topLayout->addWidget(label1);
   
    QLabel *label2 = new QLabel (i18n("Command:"),page,"label2");
    instCommBox = new KComboBox(page,"instcommbox");

    QGridLayout *passLayout = new QGridLayout (3,2,5,"passLayout");
    QLabel *labelName = new QLabel (i18n("User name:"),page,"labelName");
    QLabel *labelPassword = new QLabel (i18n("Password:"),page,"labelPassword");
    lineEditName = new KLineEdit( page, "LineEditName" );
    lineEditName->setText(uName);
    lineEditPassword = new KLineEdit( page, "LineEditName" );
    lineEditPassword->setText(password);
    lineEditPassword->setEchoMode(QLineEdit::Password);
     
    topLayout->addLayout(passLayout);

    passLayout->addWidget(label2,0,0);
    passLayout->addWidget(instCommBox,0,1);

    passLayout->addWidget(labelName,1,0);
    passLayout->addWidget(labelPassword,2,0);
    passLayout->addWidget(lineEditName,1,1);
    passLayout->addWidget(lineEditPassword,2,1);

    topLayout->addStretch(10);

   //naplnime ComboBox
    int n = myUpsNet->readNumberComms()+1;
    for (int i =1; i < n ; i++) {
      myUpsNet->readIComm(i, myStructIComm);
      instCommBox->insertItem(myStructIComm.upsCommName);
      }
    }                        


KNutInstComms::~KNutInstComms(){
}


void KNutInstComms::slotOk() {
   if (!myUpsNet->instantCommand((char *)instCommBox->currentText().latin1(),(char *)lineEditName->text().latin1(),(char *)lineEditPassword->text().latin1())) accept();
  else {
    //Nahlasime chybu
    KNutPrintUpsVar::showError (myUpsNet->getError());
    }
  }


