/***************************************************************************
                          knutfrontpanel.h  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTFRONTPANEL_H
#define KNUTFRONTPANEL_H

#define PANEL_TEXT_TOP 8
#define PANEL_TEXT_BOTTOM 4
#define PANEL_TEXT_HIGH 25
#define DEFAULT_PANEL_FLAGS 1615 //1+2+4+8+64+512+1024


#define PB_ON_LINE 1 // Panel Bulb On Line
#define PB_ON_BATT 2 // Panel Buln On Battery
#define PB_OVER 4    // Panel Bulb Overloading
#define PB_BATT_LOW 8    // Panel Bulb Battery Low
#define PB_REP_BATT 16    // Panel Bulb Replace Battery
#define PB_CAL 32    // Panel Bulb Calibration
#define PB_MFR_MOD 64    // FRM + Model
#define PB_MFR 128    // FRM
#define PB_MODEL 256    // Model
#define PB_SERIAL 512    // Serial
#define PB_FIRM 1024    // Firmware Revision
#define PB_RUN 2048    // Panel LCD Number Runtime


#include <qframe.h>
#include <qlabel.h>
#include <qcolor.h>
#include <qlcdnumber.h>
#include <qpalette.h>
#include <qfont.h>

/**
  *@author Daniel Prynych
  */

/** Trida slouzi pro zobrazeni panelu, ktery zobrazuje informace o UPS.
 *
 * @author Daniel Prynych
 * @short Hlavni panel
 * @version 0.2
 */

class KNutFrontPanel : public QFrame  {
  Q_OBJECT
  public:

/**
 * Konstruktor - vytvori panel, ktery zobrazuje stav UPS-ky.
 *
 * @param width Udava sirku panelu.
 * @param flags Udava ktere casti se maji na panelu zobrazit.
 * @param panelFonts Odkaz na fonts ktery se ma pouzit pro vykreslovani, pokud je = 0 pouzije se systemovy font pri aplikaci.
 * @since  0.4
 */
  KNutFrontPanel( QPalette *paletteIn, QWidget *parent = 0, unsigned int flags = DEFAULT_PANEL_FLAGS, QFont *panelFonts = 0L ,const char *name = 0, int width = 180);

/**
 * Destruktor
 *
 * @since  0.2
 */
  ~KNutFrontPanel();


/**
 * Vykresli na panelu udaje.
 *
 * @since  0.2
 */
 void paintPanel( void);

/**
 * Vrati vysku panelu.
 *
 * @since  0.1
 */
 int getPanelHeight( void);

/**
 * Vrati nastaveni panelu.
 *
 * @since  0.1
 */
 unsigned int getPanelFlags( void);

/**
 * Vykresli na panelu udaje.
 *
 * @param height udava vysku panelu.
 *
 * @since  0.1
 */
 void setPanelFlags( int upsPanelFlags);

/**
 * Zobrazi na panelu jmeno UPS-ky.
 *
 * @param upsPanelName Text ktery se zobrazi na panelu (adresa UPS-ky).
 *
 * @since  0.1
 */
	void setAllNameUps(QString panelUpsAllName);

/**
 * Zobrazi na panelu jmeno UPS-ky.
 *
 * @param upsPanelName Text ktery se zobrazi na panelu (adresa UPS-ky).
 *
 * @since  0.2
 */
  void setNameUps(QString panelUpsName );

/**
 * Zobrazi na panelu jmeno vyrobce UPS-ky.
 *
 * @param panelUpsFRM Text ktery se zobrazi na panelu (adresa UPS-ky).
 *
 * @since  0.1
 */
  void setMFRUps(QString panelUpsFRM );

/**
 * Zobrazi na panelu seriove cislo UPS-ky.
 *
 * @param panelUpsSerial Text ktery se zobrazi na panelu (seriove cislo UPS-ky).
 *
 * @since  0.1
 */
  void setSerialUps(QString panelUpsSerial );

/**
 * Zobrazi na panelu verzi firmwaru cislo UPS-ky.
 *
 * @param upsPanelFormRev Text ktery se zobrazi na panelu (verze firmwaru UPS-ky).
 *
 * @since  0.1
 */
  void setFirmRevUps(QString upsPanelFormRev );

/**
 * Zhasne indikacni prvky na panelu.
 *
 * @since  0.2
 */
  void cleanPanel(void);

/**
 * Rozsviti indikacni prvky na panelu.
 *
 * @param panelBulbs Kod pro urceni rozsvicenych indikacnich prvku.
 *
 * @since  0.1
 */
  void setPanel(int panelBulbs);


/**
 * Nastavi hodnotu runtime.
 *
 * @param Runtime hodnota ktera se zobrazi jako runtime.
 *
 * @since  0.1
 */
 void setRuntime(int runtime);


  public slots:
/**
 * Zmeni font pro vykresleni.
 *
 * @panelFonts Novy font.
 *
 * @since  0.1
 */
void slotSetPanelFont(QFont newPanelFont);

  private:
void changePanelFont (void);

  QLabel* textLabel1;
  QLabel* textLabel2;
  QLabel* textLabel3;
  QLabel* textLabel4;
  QLabel* textLabel5;
  QLabel* textLabel6;
  QLabel* textLabel7;
  QLabel* textLabel8;
  QLabel* textLabel9;
  QLabel* textLabel10;
  QLabel* textLabel11;

  QLabel* textLabelManufac;
  QLabel* textLabelName;
  QLabel* textLabelSerial;
  QLabel* textLabelFirm;
  QLabel* textLabelRun;


  QFrame* frameOL;
  QFrame* frameOB;
  QFrame* frameOVER;
  QFrame* frameLB;
  QFrame* frameRB;
  QFrame* frameCAL;

  QLCDNumber* LCDNumber1;
  QPalette LCDPaletteOk, LCDPaletteErr;

  QColor upsOk, upsError, upsBack;
  QColor bgColor; // barva pozadi panelu;

  QFont panelFont;        // font pro nadpis
  QFont panelBoldFont;    // font pro data

  unsigned int panelFlags; // urcuji ktera radka bude rozsvicena 1 OL, 2 OB, 3 OVER, 4 RB, CAL 5 ...
  int rowY;

  int serialWidth, mfrWidth, nameWidth, firmWidth, runWidth;   // delka nadpisu pro serial ...
  int textWidth; // maximalni sirka radky textu v okne
  int panelHeight;
  int panelWidth;

  QPalette* myPalette;

};

#endif

