/***************************************************************************
                          knutclient.cpp  -  description
                             -------------------
    begin                : t srp 21 19:12:20 CEST 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knutclient.h"
#include "knutprintupsvar.h"
#include "knutinstcomms.h"
#include "knutrwvar.h"

#include <kmessagebox.h>
#include <kstdaction.h>
#include <kconfig.h>
#include <ksimpleconfig.h>
#include <kstatusbar.h>
#include <kaction.h>


#include <qfont.h>
#include <qtimer.h>
#include <qpalette.h>
#include <qbrush.h>
#include <qcolor.h>

#include <math.h>

//#include <iostream>
#include <qstring.h>

#include <stdlib.h>
#include <unistd.h>


/*********************************************************************************************/
/*                                                                                           */
/*                         PRIVATE FUNCTIONS                                                 */
/*                                                                                           */
/*********************************************************************************************/

//  const char *nameUpsVars[] = {
//  "NONE", "UTILITY", "BATTPCT", "UPSTEMP", "ACFREQ", "LOADPCT", "AMBTEMP", "AMBHUMID","BATTVOLT","OUTVOLT",CURRENT};

extern const char *nameUpsVars[];


void KNutClient::setSize (bool showPanels) {
  // bohuzel zatim to neumim jinak, takze musim zjistit rozdil mezi
  // oknem cele aplikace a vnitrni plochou a tu pak zadat pres setMinimum...
    int diffMinW=minimumWidth()-area->minimumWidth();
    int diffMinH=minimumHeight()-area->minimumHeight();

    int row =0;
    int col=0;
    int maxCols =0;
    int maxRows =0;

    if (!activeUpsInfo.netError) {
      for (int i=0; i< NUMBER_OF_VARS; i++) {
        if (activeUpsInfo.upsVarCode[i] != 0) {
          if (maxCols < settingData.countCols) maxCols++;
          maxRows = row+1;
          // jestlize activeUpsInfo.upsAnalogs =0 nejsou aktivovany
          if (activeUpsInfo.upsAnalogs[i]) {
            activeUpsInfo.upsAnalogs[i]->move (FRONT_PANEL_WIDTH + SPACE_PANELS + (SPACE_PANELS)+(col*(ANALOG_WIDTH+SPACE_PANELS)),SPACE_PANELS+(row*(ANALOG_WIDTH+SPACE_PANELS)));
            if (showPanels) activeUpsInfo.upsAnalogs[i]->show();
            }
          col++;
          if (col > (settingData.countCols-1) ) {col=0; row++;}; // prechod na dalsi radku
          }
        }
      }
    // musime nastavit velikost
    int minWidthArea = (ANALOG_WIDTH + SPACE_PANELS)*maxCols +FRONT_PANEL_WIDTH +2*SPACE_PANELS; // sirka
    int minHeightArea = (ANALOG_WIDTH + SPACE_PANELS)*(maxRows) + SPACE_PANELS; // minimalni velikost podle mericich panelu

    int minWA = MIN_WIDTH_AREA;
    if (minWidthArea < minWA ) minWidthArea = MIN_WIDTH_AREA;

    if ((frontPanel->getPanelHeight()+2*SPACE_PANELS)> minHeightArea) minHeightArea = frontPanel->getPanelHeight() +2*SPACE_PANELS; // velikost nemuze byt mensi nez panel
    area->setMinimumSize (minWidthArea,minHeightArea);
    // viz vyse zatim to neumim jinak
    int minWidthAll = minWidthArea+diffMinW;
    int minHeightAll = minHeightArea+diffMinH;
    if (minWidthAll < 0) minWidthAll = 0;
    if (minHeightAll < 0) minHeightAll = 0;
    setMinimumSize (minWidthAll,minHeightAll);
    resize(1,1);
  }

void KNutClient::setActiveXFerVars (bool activate) {
  if (activate) {
    // podkud neexustuje jedna z promenych neaktivujeme ani jednu
    if (!(activeUps->setActivate((char *)"LOWXFER")))
      if (activeUps->setActivate((char *)"HIGHXFER"))
        activeUps->unSetActivate((char *)"LOWXFER");
  }
 else {
    activeUps->unSetActivate((char *)"LOWXFER");
    activeUps->unSetActivate((char *)"HIGHXFER");
    }
  }  
  
void KNutClient::setActiveUpsVars (bool nameVars) {
  // nastavujeme jen pokud existuji nejake promene
  if ( activeUps->readNumberVars() > 0) {
    // deaktivujeme veskere promene
    activeUps->unSetActivateAll();
    if (nameVars) {
      activeUps->setActivate((char *)"MFR");
      activeUps->setActivate((char *)"MODEL");

      activeUps->setActivate((char *)"SERIAL");
      activeUps->setActivate((char *)"FIRMREV");

      activeUps->setActivate((char *)"LOWXFER");
      activeUps->setActivate((char *)"HIGHXFER");
      }
    else {
      for (int j=0; j < NUMBER_OF_VARS; j++) {
        if (activeUpsInfo.upsVarCode[j] != 0 ) activeUps->setActivate ((char *)nameUpsVars[activeUpsInfo.upsVarCode[j]]);
        }
      activeUps->setActivate((char *)"RUNTIME"); //runtime je vzdy pridano v merenym polozkam
      }
    // status se nastavi vzdy
    activeUps->setActivate((char *)"STATUS");
    // xfer se nastavi vzdy pokud existuje
    // podrebujeme ho znat jeste pred startem a pak behen behu programu
    setActiveXFerVars(true);
    }
  }

void KNutClient::initAnalogs (void) {
  for (int i=0; i< NUMBER_OF_VARS; i++) activeUpsInfo.upsAnalogs[i]=0L;
  }

void KNutClient::deActivateAnalogs (void) {
  for (int i=0; i< NUMBER_OF_VARS; i++) {
    if (activeUpsInfo.upsAnalogs[i] != 0) delete activeUpsInfo.upsAnalogs[i]; // uvolnime meraky
    activeUpsInfo.upsAnalogs[i]=0L;
    }
  }

void KNutClient::activateAnalogs (void) {
  VarStrucDef analogMemberData;
  // vyjmeme promene ktere ups nepodporuje
  int ii =0;
  for (int i=0; i< NUMBER_OF_VARS; i++) {
    // otestujeme zda dane UPS podporuje tuto promenou
    // pokud existuje vrati 1
    if (activeUps->existName((char *)nameUpsVars[activeUpsInfo.upsVarCode[i]])) {
      activeUpsInfo.upsVarCode[ii++] = activeUpsInfo.upsVarCode[i];
      }
    }
  for (int i=ii; i< NUMBER_OF_VARS; i++) activeUpsInfo.upsVarCode[i]=0;// doplnime zbytek nulami to znamena zadna promena

  for (int i=0; i< NUMBER_OF_VARS; i++) {
    if (activeUpsInfo.upsVarCode[i] != 0) {
      analogRecords->getData (activeUpsInfo.upsVarCode[i], analogMemberData);
      activeUpsInfo.scaleEnd[i]=analogMemberData.end;
      activeUpsInfo.scaleStart[i]=analogMemberData.start;
      QColor analogFingerColor, analogScaleColor, analogFontColor;
      if (settingData.customOAnalogColor) {
        analogFingerColor = settingData.analogFingerColor;
        analogScaleColor = settingData.analogScaleColor;
        analogFontColor = settingData.analogFontColor;
        }
      else {
        analogFingerColor = DEFAULT_FINGER_COLOR;
        analogScaleColor = DEFAULT_SCALE_COLOR;
        analogFontColor = DEFAULT_FONT_COLOR;
        }

      if (settingData.customFont)
        activeUpsInfo.upsAnalogs[i] = new KAnalog( area,0L,analogMemberData.start,analogMemberData.end,analogMemberData.typeAnalog,analogMemberData.numberItem,analogMemberData.numberInItem,analogFingerColor,analogScaleColor,analogFontColor,&settingData.aPanelFont);
      else 	
        activeUpsInfo.upsAnalogs[i] = new KAnalog( area,0L,analogMemberData.start,analogMemberData.end,analogMemberData.typeAnalog,analogMemberData.numberItem,analogMemberData.numberInItem,analogFingerColor,analogScaleColor,analogFontColor,&settingData.systemFont);
      //nastavime barvu mezikruzi
      if (settingData.customOAnalogColor) {
        activeUpsInfo.upsAnalogs[i]->setArcColor(1,settingData.analogOKColor);
        activeUpsInfo.upsAnalogs[i]->setArcColor(2,settingData.analogWarnningColor);
        activeUpsInfo.upsAnalogs[i]->setArcColor(3,settingData.analogErrorColor);
        }
      // po vygenerovani panelu jsou standartni barvy nastaveny automaticky
      //nastavime mezikruzi
      for (int j = 0; j < 5; j++ ) {
        if (!((analogMemberData.scaleData[j].start == 0) && (analogMemberData.scaleData[j].end ==0 ))) {
          activeUpsInfo.upsAnalogs[i]->addArc (analogMemberData.scaleData[j].start,analogMemberData.scaleData[j].end,analogMemberData.scaleData[j].scaleColor, false);
        }
      }
      activeUpsInfo.upsAnalogs[i]->setText(analogMemberData.nameAnalog,analogMemberData.nameUnit);
      activeUpsInfo.upsAnalogs[i]->setPalette(aPanelPalette);
      }
    }
  }

void KNutClient::timeout (void) {
//  struct VarStrucDef analogPanelData;
  char *nutStringVar;

  statusBar()->clear();
  if (activeUps->getUpsValues(false) != -1) {
    if (errorUpsData) { errorUpsData=false; }
    int upsStatus;
    // precteme status a nastavime zarovky panelu
    if (( upsStatus = activeUps->readStatus ())	!= -1) frontPanel->setPanel(upsStatus);
    // precteme runtime a nastavime panel

    if (! (nutStringVar = activeUps->readStringVar((char *)"RUNTIME")))
      frontPanel->setRuntime(0);
    else
      frontPanel->setRuntime( atoi(nutStringVar));

    // provedeme meraky;
    for (int i=0; i< NUMBER_OF_VARS; i++) {
      if (activeUpsInfo.upsVarCode[i] != 0) {
        float numVar;
        if (!(nutStringVar = activeUps->readStringVar ((char *)nameUpsVars[activeUpsInfo.upsVarCode[i]])))
           numVar=0;
        else
          numVar = atof(nutStringVar);

        switch (activeUpsInfo.upsVarCode[i]) {
          case VAR_CURRENT :
            if (activeUpsInfo.scaleEnd[i] < MAX_CURRENT) {
              if (activeUpsInfo.scaleEnd[i] < numVar) {
                activeUpsInfo.scaleEnd[i]=(static_cast<int>(floor((numVar+1)/5)))*5 +5;
                if (activeUpsInfo.scaleEnd[i] > MAX_CURRENT) activeUpsInfo.scaleEnd[i]=MAX_CURRENT;
                activeUpsInfo.upsAnalogs[i]->setRange(activeUpsInfo.scaleStart[i],activeUpsInfo.scaleEnd[i],true);
              }
            }
            break;
          case VAR_BATTVOLT :
            if (activeUpsInfo.scaleEnd[i] < MAX_BATTVOLT) {
              if (activeUpsInfo.scaleEnd[i] < numVar) {
                activeUpsInfo.scaleEnd[i]=(static_cast<int>(floor((numVar+1)/10)))*10 +10;
                if (activeUpsInfo.scaleEnd[i] > MAX_BATTVOLT) activeUpsInfo.scaleEnd[i]=MAX_BATTVOLT;
                activeUpsInfo.upsAnalogs[i]->setRange(activeUpsInfo.scaleStart[i],activeUpsInfo.scaleEnd[i],true);
                }
              }
            break;
          case VAR_BATT_CURRENT :
            if (activeUpsInfo.scaleEnd[i] < MAX_BAT_CURRENT) {
              if ((activeUpsInfo.scaleEnd[i] < numVar) || (activeUpsInfo.scaleStart[i] > numVar)) {
                if ((numVar >10) || (numVar<-15)) {
                  if ((numVar >20) || (numVar<-30)) {
                    activeUpsInfo.scaleEnd[i]=30;
                    activeUpsInfo.scaleStart[i]=-45;
                    }
                  else {
                    activeUpsInfo.scaleEnd[i]=20;
                    activeUpsInfo.scaleStart[i]=-30;
                    }
                  activeUpsInfo.upsAnalogs[i]->setRange(activeUpsInfo.scaleStart[i],activeUpsInfo.scaleEnd[i],true);
                  }
                }
              }
            break;
          }
        if ((settingData.lowHighXfer) && (existLowHighXfer)) {
          char *nutStringVar;
          if ((nutStringVar = activeUps->readStringVar("LOWXFER"))) {
            float helpLowXfer = atof(nutStringVar);
            if ((nutStringVar =  activeUps->readStringVar("HIGHXFER"))) {
              float helpHighXfer = atof(nutStringVar);
              if ((helpLowXfer != lowXfer) || (helpHighXfer != highXfer)) {
                lowXfer=helpLowXfer;
                highXfer=helpHighXfer;
//  Nasledujici radky jsou nesmyslne tezko muze dojit ke zmene z 230 na 120 V              
//                if (abs((int)(230 - (lowXfer + (highXfer  - lowXfer) /2))) > abs((int)(120 - (lowXfer + (highXfer  - lowXfer) /2)))) {
//                  analogRecords->setVoltage(120);
//                  analogRecords->setFrequency(60);
//                  }
//                else {
//                  analogRecords->setVoltage(230);
//                  analogRecords->setFrequency(50);
//                  }
                analogRecords->setXfer(lowXfer,highXfer);
                //                slotSetConfig(CHANGE_XFER);
                repaintAnalogPanels (true, true, false, false); //freq volt

                }
              } 
            }  
          }
        activeUpsInfo.upsAnalogs[i]->setFinger ( numVar); // nastavi hodnotu rucicky
        }
      }
    }
  else {
    statusBar() -> message (QString (i18n("I can't get data from UPS %1 < %2 >").arg(activeUpsInfo.name).arg(activeUpsInfo.upsName)), 2000);
    errorUpsData=true;
    }
  upsTimer->start( activeUpsInfo.delay, TRUE ); // nastartujem znovu
  }

void KNutClient::upsActivate ( void ) {
  // aktivujeme spojeni
  char *nutStringVar;

  errorUpsData=false;
  activeUps = new KNutNet( (char *)activeUpsInfo.upsName.latin1(),activeUpsInfo.tcp,activeUpsInfo.port);
  if (activeUps->getError() != 0)	{
    activeUpsInfo.netError=activeUps->getError(); // aktivace ups skoncila s chybou
    KNutPrintUpsVar::showError (activeUps->getError());
    errorUpsData=true;
    }
  else {
    if (activeUps->getUpsVars() != 0) {
       activeUpsInfo.netError=activeUps->getError(); // aktivace ups skoncila s chybou
       KNutPrintUpsVar::showError (activeUps->getError()); // zjistime promene ktere zname
       errorUpsData=true;
       }
    else {
      // Nastavime promene ktere je potreba zjistovat
      setActiveUpsVars (true); // nastavime aktivaci promenych jen u promenych MFR, MODEL, SERIAL, FIRMREV, LOWXFER a HIGHXFER
      // tyto promene jseo precteny jen jednou protoze se nemeni	
      int countRevision = 10; // pocet max opakovani po kterych muzeme zjistovat hodnoty
      while ( countRevision > 0) {
        if ((activeUps->getUpsValues(false)) != -1) { // precteme hodnoty
          manufacturer = activeUps->readStringVar((char *)"MFR");
          upsModel = activeUps->readStringVar((char *)"MODEL");
          QString allUpsName = manufacturer + " " + upsModel;
          frontPanel->setAllNameUps (allUpsName);
          frontPanel->setMFRUps (manufacturer);
          frontPanel->setNameUps (upsModel);

          serial = activeUps->readStringVar((char *)"SERIAL");
          frontPanel->setSerialUps (serial);
          firmrev = activeUps->readStringVar((char *)"FIRMREV");
          frontPanel->setFirmRevUps (firmrev);
          //Zjistime zda existuji LOWXFER a HIGHXFER pripadne jeji hodnoty

          if (! (nutStringVar = activeUps->readStringVar((char *)"LOWXFER"))) {
            lowXfer =-1;
            highXfer=-1;
            existLowHighXfer = false;
            }
          else {
            lowXfer = atof(nutStringVar);
            if  (! (nutStringVar = activeUps->readStringVar((char *)"HIGHXFER"))) {
              highXfer = -1;
              existLowHighXfer = false;
              }
            else {
              highXfer = atof(nutStringVar);
              existLowHighXfer = true;
              }
            }

          int upsStatus;
          if ((upsStatus = activeUps->readStatus ())	!= -1) frontPanel->setPanel(upsStatus);
          countRevision = 0; //neopakujeme
          }
        else {
         // nepodarilo se precist data zkusime znova
          statusBar() -> changeItem (QString (i18n("I can't get data from UPS %1 < %2 >").arg(activeUpsInfo.name).arg(activeUpsInfo.upsName)), 0);
          errorUpsData=true; // byla nalezena chyba
          countRevision--;
          sleep (2); // cekame 2 sekundy
          }
        } // konec while
      // pokud je pouzito XFER nastavime hodnoty
      if (settingData.lowHighXfer) {
     // xfer je nastaveno
        if (existLowHighXfer) {
          if (abs((int)(230 - (lowXfer + (highXfer  - lowXfer) /2))) > abs((int)(120 - (lowXfer + (highXfer  - lowXfer) /2)))) {
            analogRecords->setVoltage(120);
            analogRecords->setFrequency(60);
            }
          else {
            analogRecords->setVoltage(230);
            analogRecords->setFrequency(50);
            }
          analogRecords->setXfer(lowXfer,highXfer);
          }
        }
      else {
        //pokud se nepouziva XFers nemusime nacitat hodnoty pro XFer neustale znova
        // XFer deaktivujeme az zde protoze je potrebujeme aspon jednou nacist pokud existuje
        setActiveXFerVars(false);
        } 
      activateAnalogs ();
      setActiveUpsVars (false);		// nastavime aktivaci u vybranych (v Pref. diag.) promenych
      upsTimer->start( 1, TRUE ); // provedeme hned test zbytku promenych oby se nastavili meraky
      // casovac nacte hodnoty a provede prekresleni
      }
    }
  }

void KNutClient::upsDeactivate (void) {
  if (activeUps != 0L) {
    activeUpsInfo.netError=0; // zadna chyba
    upsTimer->stop();
    deActivateAnalogs();
    delete activeUps;
    activeUps = 0L;
    frontPanel->cleanPanel();
    }
  }


void KNutClient::initStatusBar ( void ) {
  // nastavime hlavni hlaseni v statusbaru
  statusBar() -> insertItem (i18n("Ready."), 0, true);
  statusBar()-> setItemAlignment(0,Qt::AlignHCenter|Qt::AlignVCenter);
  }


void KNutClient::initToolBar ( void ) {
  QLabel *upsNazev = new QLabel ("UPS : ",toolBar("mainToolBar"));
  // upsNazev je navazan na toolBar neni potreba volat destruktor
  toolBar ("mainToolBar")->insertWidget (0,upsNazev->sizeHint().width(),upsNazev);
  toolBar ("mainToolBar")->insertCombo("",1,false, SIGNAL (activated (const QString &)),this,SLOT (slotLoadUps (const QString &)));
  // bude se pouze vybirat-------------------^^^
  KComboBox *combo = toolBar("mainToolBar")->getCombo(1);
  combo->clear();
  toolBar("mainToolBar")->setBarPos (KToolBar::Top);
  //nastavime toolBar nepresovatelny
  setToolBarsMovable(false);
  }


void KNutClient::initAction ( void ) {
  quit           = KStdAction::quit (this, SLOT (slotCloseKnutClient()), actionCollection());
  quit->setStatusText(i18n("Quits the application"));

  preferencesUps = KStdAction::preferences (this, SLOT (slotPreferencesUps()), actionCollection(),"options_configure");
  new KAction(i18n("Showing UPS variables and commands"),0,this,SLOT(slotPrintUPSVars()),actionCollection(),"printupsvars");
  new KAction(i18n("Running instant commands"),0,this,SLOT(slotInstComms()),actionCollection(),"instcomms");
  new KAction(i18n("Setting RW variables"),0,this,SLOT(slotRWVars()),actionCollection(),"rwvars");
  KStdAction::showToolbar (this, SLOT (slotShowToolBar()), actionCollection());
  KStdAction::showStatusbar (this, SLOT (slotShowStatusBar()), actionCollection());
  }

void KNutClient::initVars ( void ) {
  minHeightArea = MIN_HEIGHT_AREA; //minimalni veklikost plochy
  minWidthArea = MIN_WIDTH_AREA;

  activeUpsIndex = -1;
  activeUpsInfo.name="";
  activeUpsInfo.netError=0; // zadna chyba
  activeUps = 0L; // nastavime promene na 0L

  settingData.countCols = DEFAULT_COUNT_COLS; // pocet meraku v radce;
  settingData.panelFlags = DEFAULT_PANEL_FLAGS; // STANDART_PANEL_FLAGS; // informace v hlavnim panelu
  errorUpsData=false;
  settingData.systemFont = kapp->font(); // systemovy font pri startu
  settingData.aPanelFont = settingData.systemFont; // inicializace pro fonty
  settingData.mPanelFont = settingData.systemFont;

  //nastavime fonty
  mainPalette= kapp->palette();
  areaPalette=mainPalette;
  mPanelPalette=mainPalette;
  aPanelPalette=mainPalette;
  }

  void KNutClient::loadConfiguration ( void ) {
  QString groupName;
  UpsInfo upsData; // struktura obsahuje udaje o UPS
  QFont appFont = kapp->font(); // systemovy font pri startu
  settingData.areYouSure=kapp->config()->readBoolEntry("AreYouSure",FALSE);
  settingData.x=kapp->config()->readNumEntry("PosX",0);
  settingData.y=kapp->config()->readNumEntry("PosY",0);
  settingData.countCols=kapp->config()->readNumEntry("NumberOfCols",DEFAULT_COUNT_COLS);
  settingData.panelFlags=kapp->config()->readUnsignedNumEntry("PanelFlags",DEFAULT_PANEL_FLAGS);
  settingData.inputFrequency=kapp->config()->readNumEntry("InputFrequency",DEFAULT_INPUT_FREQUENCE);
  settingData.inputVoltage=kapp->config()->readNumEntry("InputVoltage",DEFAULT_INPUT_VOLTAGE);
  settingData.lowHighXfer=kapp->config()->readBoolEntry("LowHighXfer",FALSE);
  settingData.customFont=kapp->config()->readBoolEntry("CustomFont",FALSE);
  settingData.aPanelFont=kapp->config()->readFontEntry("AnalogPanelFont",&appFont);
  settingData.mPanelFont=kapp->config()->readFontEntry("MainPanelFont",&appFont);
  int upsCount=kapp->config()->readNumEntry("NumberOfUpsRecords",0);
  settingData.customBColor=kapp->config()->readBoolEntry("CustomBColor",FALSE);
  settingData.mainBackgroundColor=kapp->config()->readColorEntry ("MainBackGroundColor",& DEFAULT_BG_COLOR);
  settingData.customBPanelColor=kapp->config()->readBoolEntry("CustomBPanelColor",FALSE);
  settingData.customBAnalogColor=kapp->config()->readBoolEntry("CustomBAnalogColor",FALSE);
  settingData.customOAnalogColor=kapp->config()->readBoolEntry("CustomOAnalogColor",FALSE);
  settingData.mPanelBackgroundColor=kapp->config()->readColorEntry ("MPanelBackGroundColor",& DEFAULT_BG_COLOR);
  settingData.aPanelBackgroundColor=kapp->config()->readColorEntry ("APanelBackGroundColor",& DEFAULT_BG_COLOR);
  settingData.analogFingerColor=kapp->config()->readColorEntry ("AnalogFingerColor",& DEFAULT_FINGER_COLOR);
  settingData.analogOKColor=kapp->config()->readColorEntry ("AnalogOKColor",& DEFAULT_OK_COLOR);
  settingData.analogWarnningColor=kapp->config()->readColorEntry ("AnalogWarnningColor",& DEFAULT_WARNNING_COLOR);
  settingData.analogErrorColor=kapp->config()->readColorEntry ("AnalogErrorColor",& DEFAULT_ERROR_COLOR);
  settingData.analogScaleColor=kapp->config()->readColorEntry ("AnalogScaleColor",& DEFAULT_SCALE_COLOR);
  settingData.analogFontColor=kapp->config()->readColorEntry ("AnalogFontColor",& DEFAULT_FONT_COLOR);

  activeUpsInfo.name=kapp->config()->readEntry("ActiveUps","");
  
  for (int i = 0; i < upsCount; i++) {
    groupName.sprintf ("UPS %d",i);
    kapp->config()->setGroup (groupName);
    if ((upsData.name = kapp->config()->readEntry ("Name")) != QString::null)	{
      // zaznam existuje pokracujeme dale
      if ((upsData.upsName = kapp->config()->readEntry ("UpsName")) != QString::null)	{
        // zaznam existuje pokracujeme dale a nacteme zbytek hodnote
        upsData.delay = kapp->config()->readNumEntry("Delay",DEFAULT_DELAY);
        upsData.port = kapp->config()->readNumEntry("Port",DEFAULT_PORT);
        upsData.tcp = kapp->config()->readBoolEntry("Tcp",TRUE);
        upsData.userName=kapp->config()->readEntry("UserName","");
        upsData.password=kapp->config()->readEntry("Password","");
        upsData.savePassword=kapp->config()->readBoolEntry("SavePassword",false);
        for (int j=0; j < NUMBER_OF_VARS; j++) {
          groupName.sprintf ("Var %d",j);
          upsData.upsVarCode[j]=kapp->config()->readNumEntry (groupName,0);
          }
        upsRecords->add (upsData);
        }
      }
    }
  }

void KNutClient::saveConfiguration ( void ) {
  QString groupName;
  QString codeName;
  UpsInfo upsData; // struktura obsahuje udaje o UPS
  int upsCount = upsRecords->getCount();

  kapp->config()->setGroup ("");
  kapp->config()->writeEntry ("ActiveUps",(QString)activeUpsInfo.name);
  kapp->config()->writeEntry ("AnalogFontColor",settingData.analogFontColor);
  kapp->config()->writeEntry ("AnalogScaleColor",settingData.analogScaleColor);
  kapp->config()->writeEntry ("AnalogErrorColor",settingData.analogErrorColor);
  kapp->config()->writeEntry ("AnalogWarnningColor",settingData.analogWarnningColor);
  kapp->config()->writeEntry ("AnalogOKColor",settingData.analogOKColor);
  kapp->config()->writeEntry ("AnalogFingerColor",settingData.analogFingerColor);
  kapp->config()->writeEntry ("APanelBackGroundColor",settingData.aPanelBackgroundColor);
  kapp->config()->writeEntry ("MPanelBackGroundColor",settingData.mPanelBackgroundColor);
  kapp->config()->writeEntry ("MainBackGroundColor",settingData.mainBackgroundColor);
  kapp->config()->writeEntry ("NumberOfUpsRecords",upsCount);
  kapp->config()->writeEntry ("CustomFont",settingData.customFont);
  kapp->config()->writeEntry ("AnalogPanelFont",settingData.aPanelFont);
  kapp->config()->writeEntry ("MainPanelFont",settingData.mPanelFont);
  kapp->config()->writeEntry ("CustomBColor",(settingData.customBColor));
  kapp->config()->writeEntry ("CustomBPanelColor",(settingData.customBPanelColor));
  kapp->config()->writeEntry ("CustomBAnalogColor",(settingData.customBAnalogColor));
  kapp->config()->writeEntry ("CustomOAnalogColor",(settingData.customOAnalogColor));
  kapp->config()->writeEntry ("LowHighXfer",(settingData.lowHighXfer));
  kapp->config()->writeEntry ("InputVoltage",(settingData.inputVoltage));
  kapp->config()->writeEntry ("InputFrequence",(settingData.inputFrequency));
  kapp->config()->writeEntry ("PanelFlags",(settingData.panelFlags | 3));
  kapp->config()->writeEntry ("NumberOfCols",settingData.countCols);
  kapp->config()->writeEntry ("AreYouSure",settingData.areYouSure);
  kapp->config()->writeEntry ("PosY",y());
  kapp->config()->writeEntry ("PosX",x());

  for (int i=0; i<upsCount; i++) {
    groupName.sprintf ("UPS %d",i);
    kapp->config()->setGroup (groupName);
    upsRecords->get(i,upsData);
    kapp->config()->writeEntry ("Tcp",upsData.tcp);
    kapp->config()->writeEntry ("Port",upsData.port);
    kapp->config()->writeEntry ("Delay",upsData.delay);
    kapp->config()->writeEntry ("UpsName",upsData.upsName);
    kapp->config()->writeEntry ("Name",upsData.name);
    if (upsData.savePassword) {
      kapp->config()->writeEntry ("UserName",upsData.userName);
      kapp->config()->writeEntry ("Password",upsData.password);
      }
    kapp->config()->writeEntry ("SavePassword",upsData.savePassword);
    for (int j=0; j < NUMBER_OF_VARS; j++) {
      groupName.sprintf ("Var %d",j);
      kapp->config()->writeEntry (groupName,upsData.upsVarCode[j]);
      }
    kapp->config()->setGroup ("");
    }
  kapp->config()->sync();
  }

void KNutClient::setActiveUpsInfo (UpsRecord* upsRecordPointer) {
  //presuneme jmena  z databaze ups-ek - je nahrana z config. souboru
  activeUpsInfo.name = upsRecordPointer->name;
  activeUpsInfo.upsName = upsRecordPointer->upsName;
  activeUpsInfo.delay = upsRecordPointer->delay;
  activeUpsInfo.port = upsRecordPointer->port;
  activeUpsInfo.tcp = upsRecordPointer->tcp;
  activeUpsInfo.userName = upsRecordPointer->userName;
  activeUpsInfo.password = upsRecordPointer->password;
  for (int i =0; i < NUMBER_OF_VARS; i++) activeUpsInfo.upsVarCode[i] = 0; // vynulujeme polozky
  int ii = 0;
  for (int i =0; i < NUMBER_OF_VARS; i++)
    if (upsRecordPointer->upsVarCode[i]>0) activeUpsInfo.upsVarCode[ii++] = upsRecordPointer->upsVarCode[i];
  }


  
void KNutClient::activeConfiguration (bool anRepaint) {
  int activeUpsNameIndex = -1; // zadne upsName neni aktivni
  KComboBox *combo = toolBar(0)->getCombo(1);
  // pokud je anRepaint false je je naplneno combo
  // pokud je true zrusime ups a znovu vytvorime vcetne analog. panelu

  //naplnime combo to provedem vzdy
  combo->clear();
  for (int i=0; i < upsRecords->getCount (); i++) {
    combo->insertItem (*upsRecords->getName(i));
    // ulozime si poradove cislo jmena aktivniho ups
    if ((*upsRecords->getName(i)) == activeUpsInfo.name) activeUpsNameIndex = i;
    }

  //activujeme panely
  if ( anRepaint ) { // je nutno znovy odpojit a pripojit
    // nastavime puvodni text pokud byl nalezen
    if (activeUpsNameIndex != -1) combo->setCurrentItem( activeUpsNameIndex );
    // zmena po nastaveni;
    if ( activeUpsInfo.name != "") { // zrusime stare nastaveni
      // pokud to je prvni nastaveni nic neuvolnujeme
      upsDeactivate (); // funkce sama kontroluje zda muze uvolnit prostredky
      activeUpsInfo.name = "";
      }
    if ( !combo->currentText().isEmpty()) {
      // activujeme novou UPS
      UpsRecord* upsRecordPointer;
      if ((upsRecordPointer = upsRecords->findName(combo->currentText ())) != 0L) {
        //presuneme jmena  z databaze ups-ek - je nahrana z config. souboru
        setActiveUpsInfo (upsRecordPointer);
        upsActivate (); // activujeme ups
        }  // konec if ((upsRecordPointer .. findName
      else activeUpsInfo.name=""; // chyba v systemu nenalezl jmeno
      } // konec if ... isEmpy
    setSize(true); // true proto ze chceme zobrazit i analogove panely
    } // konec anRepaint
  }


void KNutClient::repaintAnalogPanels (bool repaintFrequencyPanels, bool repaintVoltagePanels, bool repaintAllPanels, bool repaintBGAPanels) {
VarStrucDef analogMemberData;

  // pregenerovani panelu slozi pro settingMain a setting Analog
  for (int i=0; i< NUMBER_OF_VARS; i++) {
    if ((activeUpsInfo.upsVarCode[i]) && (activeUpsInfo.upsAnalogs[i])) {
      if (((activeUpsInfo.upsVarCode[i] == ACFREQ) && (repaintFrequencyPanels)) ||
           (((activeUpsInfo.upsVarCode[i] == UTILITY) ||
             (activeUpsInfo.upsVarCode[i] == OUTVOLT)) && (repaintVoltagePanels))) {
        analogRecords->getData (activeUpsInfo.upsVarCode[i], analogMemberData); // nacteme data
        activeUpsInfo.upsAnalogs[i]->hide();// schovame analogovy panel
        activeUpsInfo.upsAnalogs[i]->delArc(); //zrusime segmenty
        activeUpsInfo.upsAnalogs[i]->setRange (analogMemberData.start,analogMemberData.end);
        for (int j = 0; j < 5; j++ ) {
          if (!((analogMemberData.scaleData[j].start == 0) && (analogMemberData.scaleData[j].end ==0 ))) {
            activeUpsInfo.upsAnalogs[i]->addArc (analogMemberData.scaleData[j].start,analogMemberData.scaleData[j].end,analogMemberData.scaleData[j].scaleColor, false);
            } // end if (!
          }// end for (int i=0
        activeUpsInfo.upsAnalogs[i]->repaint(); // prekreslime
        activeUpsInfo.upsAnalogs[i]->show(); //zobrazime merak
        } // end if (((activeUpsInfo
      if (repaintAllPanels) {
        if (repaintBGAPanels) {   // prekresli pozadi analogovych panelu
          activeUpsInfo.upsAnalogs[i]->setPalette(aPanelPalette);
          }
        if (repaintAllPanels) {
          if (settingData.customOAnalogColor) {
             activeUpsInfo.upsAnalogs[i]->setFingerColor(settingData.analogFingerColor);
             activeUpsInfo.upsAnalogs[i]->setArcColor(1,settingData.analogOKColor);
             activeUpsInfo.upsAnalogs[i]->setArcColor(2,settingData.analogWarnningColor);
             activeUpsInfo.upsAnalogs[i]->setArcColor(3,settingData.analogErrorColor);
             activeUpsInfo.upsAnalogs[i]->setScaleColor(settingData.analogScaleColor);
             activeUpsInfo.upsAnalogs[i]->setFontColor(settingData.analogFontColor);
            }
          else {
            activeUpsInfo.upsAnalogs[i]->setFingerColor (DEFAULT_FINGER_COLOR);
            activeUpsInfo.upsAnalogs[i]->setDefaultArcColor();
            activeUpsInfo.upsAnalogs[i]->setScaleColor (DEFAULT_SCALE_COLOR);
            activeUpsInfo.upsAnalogs[i]->setFontColor (DEFAULT_FONT_COLOR);
            }
          activeUpsInfo.upsAnalogs[i]->repaintAll();
          }
        }
      }
    } // end for
  }

  


  
/*********************************************************************************************/
/*                                                                                           */
/*                         PUBLIC FUNCTIONS                                                  */
/*                                                                                           */
/*********************************************************************************************/

/***********************  Konstruktor  BEGIN *************************************************/
KNutClient::KNutClient(QWidget* parent, const char *name) : KMainWindow(parent, name) {


//  setPalette(mainPalette);
   
  initVars ();
  setPalette(mainPalette);
  initStatusBar ();
  initAction ();
//  createGUI ("/home/dan/Projekty/knutclient/knutclient/knutclientui.rc"); // pred distribuci nezapomenou odstranit retezec
  // createGUI vytvori zakladni strukturu podle souboru knutclientui.rc
  createGUI ();
  initToolBar ();

  // vytvorime zaznamy
  upsRecords = new KNutUpsData();
  analogRecords = new KNutVarData();

  // vynulujeme odkazy na analogove merice
  initAnalogs ();
  //nahrajeme configuraci
  loadConfiguration();

  //nastavime vstupni frekvenci a vstupni napeti
  analogRecords->setFrequency(settingData.inputFrequency);
  analogRecords->setVoltage(settingData.inputVoltage);

  // Vytvorime hlavni plochu
  area = new QLabel (this);
  setCentralWidget (area);

  if (settingData.customBPanelColor) {
    mPanelPalette.setColor(QPalette::Active,QColorGroup::Background,settingData.mPanelBackgroundColor);
    }

  if (settingData.customFont)	
    frontPanel = new KNutFrontPanel (&mPanelPalette,area,settingData.panelFlags,&settingData.mPanelFont,"FrontPanel",FRONT_PANEL_WIDTH);
  else 	
    frontPanel = new KNutFrontPanel (&mPanelPalette,area,settingData.panelFlags,&settingData.systemFont,"FrontPanel",FRONT_PANEL_WIDTH);

  frontPanel->setPalette(mPanelPalette);
  frontPanel->move (SPACE_PANELS,SPACE_PANELS);

  // nastavime barvu pro centralni widget
 if (settingData.customBColor) {
    areaPalette.setColor(QPalette::Active,QColorGroup::Background,settingData.mainBackgroundColor);
    }
  area->setPalette(areaPalette);

 // nastavime paletu pro analogove panely 
 if (settingData.customBAnalogColor) {
    aPanelPalette.setColor(QPalette::Active,QColorGroup::Background,settingData.aPanelBackgroundColor);
    }

  
  //Zadne UPS neni aktivovano
  activeUps = 0L;
  // nastavime casovac
  upsTimer = new QTimer (this);
  connect( upsTimer, SIGNAL(timeout()), SLOT(timeout()) );

  int mva = MIN_WIDTH_AREA;
  int mha = MIN_HEIGHT_AREA;
  area->setMinimumSize ( mva ,mha);
  for (int i =0; i < NUMBER_OF_VARS; i++) activeUpsInfo.upsVarCode[i] = 0; // vynulujeme polozky

  // Nastavime COMBO  a pripadne aktivujeme spojeni na UPS a merici panely
  activeConfiguration (true);
  move (settingData.x,settingData.y); // presuneme hlavni okno na jeho misto
  }

/****************  DESTRUCTOR BEGIN  ********************************/
KNutClient::~KNutClient() {
  //  vypneme casovac
  upsTimer->stop();
  // uvolnime ups-ku
  if (activeUps != 0L) {
   delete activeUps;
   }
  delete upsRecords;
  delete analogRecords;
  }


void KNutClient::slotShowToolBar() {
  statusBar()->message(i18n("Toggle the toolbar..."),2000);
  if(toolBar("mainToolBar")->isVisible()) toolBar("mainToolBar")->hide();
  else toolBar("mainToolBar")->show();
  resize(1,1);
  setSize();
  }


void KNutClient::slotShowStatusBar() {
  statusBar()->message(i18n("Toggle the statusbar..."),2000);
  if(statusBar()->isVisible()) statusBar()->hide();
  else statusBar()->show();
  resize(1,1);
  setSize();
  }


void KNutClient::slotPrintUPSVars() {
  KNutPrintUpsVar *windowUpsVars = new KNutPrintUpsVar(activeUps);
  if (windowUpsVars->upsOk()) {
    windowUpsVars->exec();
    }
  delete windowUpsVars;
}


void KNutClient::slotInstComms() {

  if (activeUps->readNumberComms ()) {
    KNutInstComms *windowInstComms = new KNutInstComms(activeUpsInfo.userName,activeUpsInfo.password,activeUps);
    windowInstComms->exec();
    delete windowInstComms;
    }
  }

void KNutClient::slotRWVars() {

  if (activeUps->readNumberVars (RW_VARS)) {
    KNutRWVar *windowRWVars = new KNutRWVar(activeUpsInfo.userName,activeUpsInfo.password,activeUps);
    connect (windowRWVars,SIGNAL(signalChangeRWVars(QString)),this,SLOT(slotChangeRWVars(QString)));
    windowRWVars->exec();
    delete windowRWVars;
    }
  }


void KNutClient::slotPreferencesUps() {
  prefDlg = new KNutPrefDlg( upsRecords, analogRecords, &settingData, toolBar(0)->getCombo(1)->currentText()); // aktivujene dialog pro preference
  connect (prefDlg,SIGNAL(signalChangeConfig(unsigned int)),this,SLOT(slotSetConfig(unsigned int)));

  prefDlg->exec();
  delete prefDlg;
  }

void KNutClient::slotChangeRWVars ( QString varName) {
  }


void KNutClient::slotSetConfig (unsigned int changeSetting) {

  VarStrucDef analogMemberData;
  bool repaintVoltagePanels = false;
  bool repaintFrequencyPanels = false;
  bool repaintAllPanels = false;
  bool repaintOAPanels = false;
  bool repaintBGAPanels = false;

  // Main Setting
  
  // Nastavime zmenu barvy pozadi
  if (changeSetting & CHANGE_CUSTOM_BCOLOR) {
    if (!settingData.customBColor) { // nastavime barvu pozadi podle systemu
      area->setPalette (mainPalette);
      }
    else {
      areaPalette.setColor(QPalette::Active,QColorGroup::Background,settingData.mainBackgroundColor);
      area->setPalette (areaPalette);
      }   
    }
  else {
    if (changeSetting & CHANGE_MBCOLOR ) {
      areaPalette.setColor(QPalette::Active,QColorGroup::Background,settingData.mainBackgroundColor);
      area->setPalette (areaPalette);
      }
    }      

  // Nastavime pozadi pod panely
  // nastavime frevenci
  // nastavime  napeti
  // je zapnuto XFER a existuje na UPS

     // aktivujem nebo deaktivuje nacitani XFER hodnot
  if (changeSetting & CHANGE_XFER) {
    if (settingData.lowHighXfer)
      setActiveXFerVars(true);
    else
      setActiveXFerVars(true);
    }
  
  if ((changeSetting & CHANGE_XFER) || // je provedena nejaka zmena na napeti nebo frekvence
      (changeSetting & CHANGE_VOLTAGE) || (changeSetting & CHANGE_FREQUENCY)) {

    if ((changeSetting & CHANGE_XFER) && (settingData.lowHighXfer) && (existLowHighXfer)) {
    // xfer bylo aktivovano
      if (changeSetting & CHANGE_XFER) {
        if (abs((int)(230 - (lowXfer + (highXfer  - lowXfer) /2))) > abs((int)(120 - (lowXfer + (highXfer  - lowXfer) /2)))) {
          analogRecords->setVoltage(120);
          analogRecords->setFrequency(60);
          }         
        else {
          analogRecords->setVoltage(230);
          analogRecords->setFrequency(50);
          }
        analogRecords->setXfer(lowXfer,highXfer);
        repaintVoltagePanels = true;
        repaintFrequencyPanels = true;
        }
      }
    else {
    // XFER neni aktivovano nebo je nepodporuje UPS
    if ((changeSetting & CHANGE_VOLTAGE) || ((changeSetting & CHANGE_XFER))) {
    // byla aktivovana zmena napeti nebo zmena xfer a zaroven ho ups podporuje
      analogRecords->setVoltage(settingData.inputVoltage);
      repaintVoltagePanels=true;
      }
    if ((changeSetting & CHANGE_FREQUENCY) || ((changeSetting & CHANGE_XFER))) {
    // byla aktivovana zmena napeti nebo zmena xfer a zaroven ho ups podporuje
      analogRecords->setFrequency(settingData.inputFrequency);
      repaintFrequencyPanels=true;
      }
    }
  }

  // Analog setting
  if ((changeSetting & CHANGE_CUSTOM_APANEL_BCOLOR) || // je provedena zmena barvy panelu
      (changeSetting & CHANGE_APBCOLOR)) {
  if (settingData.customBAnalogColor) {
    aPanelPalette.setColor(QPalette::Active,QColorGroup::Background,settingData.aPanelBackgroundColor);
    repaintAllPanels=true;
    repaintBGAPanels=true;
    }
  else {
    aPanelPalette = mainPalette;
    repaintAllPanels=true;
    repaintBGAPanels=true;
    }
  }

  if ((changeSetting & CHANGE_CUSTOM_APANEL_OCOLOR) || // je provedena zmena barvy panelu
      (changeSetting & CHANGE_APOCOLOR)) {
     if (settingData.customOAnalogColor) {
       repaintAllPanels=true;
       repaintOAPanels=true;
       }  
     else {
       repaintAllPanels=true;
       repaintOAPanels=true;
       }
    }
      
    // pregenerovani panelu slozi pro settingMain a setting Analog
  repaintAnalogPanels (repaintFrequencyPanels, repaintVoltagePanels, repaintAllPanels, repaintBGAPanels);

  if (	activeUpsInfo.name != "") {
    setSize();
    }

  // UPS Setting
  if (changeSetting & CHANGE_UPS_SETTING ) activeConfiguration (true);

  // Main Panel Setting
  // zmena barvy pozadi;
  if (changeSetting & CHANGE_CUSTOM_MPANEL_BCOLOR) {
    if (!settingData.customBPanelColor) { // nastavime barvu pozadi podle systemu
      frontPanel->setPalette (mainPalette);
      }
    else {
      mPanelPalette.setColor(QPalette::Active,QColorGroup::Background,settingData.mPanelBackgroundColor);
      frontPanel->setPalette (mPanelPalette);
      }
    }
  else {
    if (changeSetting & CHANGE_MPBCOLOR ) {
      mPanelPalette.setColor(QPalette::Active,QColorGroup::Background,settingData.mPanelBackgroundColor);
      frontPanel->setPalette (mPanelPalette);
      }
    }
    
  if (changeSetting & CHANGE_MAIN_PANEL_SETTING ) {
    if (settingData.panelFlags != frontPanel->getPanelFlags()) {
      frontPanel->setPanelFlags(settingData.panelFlags);
      //aktivujema a presuneme prvky panelu
      frontPanel->paintPanel();
      // prenastavime velikost
      setSize();
      }
    }
    
  // Font panel setting
  if (changeSetting & CHANGE_ANALOG_FONT ) {
    QFont newAnalogFont;
    if (settingData.customFont) {
      newAnalogFont=settingData.aPanelFont;
      }
    else {
      newAnalogFont=settingData.systemFont;
      }
    for (int i=0; i< NUMBER_OF_VARS; i++) {
      if ((activeUpsInfo.upsVarCode[i]) && (activeUpsInfo.upsAnalogs[i])) {
        activeUpsInfo.upsAnalogs[i]->slotSetAllFont(newAnalogFont);
        }
      }
    }
  if (changeSetting & CHANGE_PANEL_FONT ) {
    QFont newPanelFont;
    if (settingData.customFont) {
      frontPanel->slotSetPanelFont(settingData.mPanelFont);
      }
    else {
      frontPanel->slotSetPanelFont(settingData.systemFont);
      }
    }
  }


void KNutClient::slotLoadUps (const QString &name) {
  if ((name != activeUpsInfo.name) || (errorUpsData)) { //aktivace nove UPS je povolena jen pri zmene nebo pokud je nastavena chyba
    if (activeUpsInfo.name != "") {
      // zrusit spojeni pokud existuje
      upsDeactivate ();
      //nastavime neexistujici spojeni
      if (name == "") activeUpsInfo.name = "";
      }
    if (name != "") {
      UpsRecord* upsRecordPointer;
      //navazeme spojeni
      if ((upsRecordPointer = upsRecords->findName(name)) != 0L) {
        setActiveUpsInfo(upsRecordPointer);
        upsActivate (); // activujeme ups
        setSize(true); // musime prekreslit a zobrazit panely
        }
      else activeUpsInfo.name=""; // chyba v systemu, nenalezl jmeno
      }
    statusBar()->clear();
    }
  }


void KNutClient::slotCloseKnutClient (void) {
  if (settingData.areYouSure) {
    if (KMessageBox::warningYesNo (0,i18n("Are you sure ?")) == 3) close();
    }
  else close();
  }

void KNutClient::closeEvent( QCloseEvent *e ){
    saveConfiguration ();
    e->accept();
  }
