/***************************************************************************
                          kanalog.cpp  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/* pocitani uhlu */
/* nula je ve 3 hodiny */
/* prirustek je kladny ve smeru hod rucicek */
#include "kanalog.h"

#include <stdio.h>
#include <math.h>

#include <qpainter.h>
#include <qframe.h>
#include <qfontmetrics.h>
#include <qfont.h>
#include <qbitmap.h>
#include <qpaintdevice.h>

#include <kapp.h>

//#include <iostream>


void KAnalog::KresliCMK ( QPainter *paint ) {

  float Astart, Aend;

  // pocitani uhlu
  //nula je ve 3 hodiny
  // prirustek je kladny proti smeru hod rucicek

  float rozsah = horni_mez-dolni_mez;
  float jednotka = (uhel_zobrazeni/rozsah);
  bool vykresleno = false;

  int smerMK = (-1)*smer;
  // nakreslime kruhove vysece
  for (int i=0;i<pocet_zvyrazneni;i++) {
    if ((zvyrazneni[i].start < horni_mez) && (zvyrazneni[i].end > dolni_mez)) {
      if (zvyrazneni[i].start < dolni_mez) Astart = dolni_mez; else Astart = zvyrazneni[i].start;
      if (zvyrazneni[i].end > horni_mez) Aend = horni_mez; else Aend = zvyrazneni[i].end;
      paint->setBrush ( barvy_arc[zvyrazneni[i].barva] );
      paint->setPen (NoPen);
      paint->drawPie(stred_x-sirkaMK/2,stred_y-sirkaMK/2,sirkaMK,sirkaMK,(int)((((Astart-dolni_mez)*jednotka)*(smerMK)+pocatecni_uhel)*16),(int)((smerMK)*((Aend-Astart)*jednotka)*16));
      vykresleno = true; // bylo provedeno vykresleni
      }
    }
  if ((pocet_zvyrazneni > 0) && (vykresleno)) { // kreslime jen pokud bylo kreslena kruhova vysec
    // musime vybarvit stred kotouce
//    paint->setBrush ( pozadi );
    paint->setBrush ( Qt::white );
    paint->drawPie(stred_x-(sirkaMK/2)+6,stred_y-(sirkaMK/2)+6,sirkaMK-12,sirkaMK-12,(int)(pocatecni_uhel*16+24*smer),(int)((-smer)*(uhel_zobrazeni*16+48)));
    }
  }

void KAnalog::KresliSt ( QPainter *paint ) {

  int poz_x, poz_y, r_vyska, r_sirka;
  float posun, uhel;

  float upi = 0.0174532;
  int smer_st = -smer;

  paint->save();  // ulozime
  QString cislo;
  paint->setPen(barvaTextu);
  paint->setFont(st_font);

  QFontMetrics fm = paint->fontMetrics();
  r_vyska = ((fm.ascent()) / 2);
  posun = ((float)(horni_mez-dolni_mez))/pocet_casti;
  for (int i=0; i<=(pocet_casti);i++) {
    cislo.sprintf( "%3.0f",dolni_mez+i*posun);
    cislo=cislo.stripWhiteSpace();
    r_sirka = (fm.width(cislo))/2;
    uhel = (pocatecni_uhel+ ((uhel_zobrazeni/pocet_casti)*i*smer_st))*upi;
    poz_x = (int)((cos(uhel)*vzdalenost_st+stred_x) - r_sirka);
    poz_y = (int)((stred_y-sin(uhel)*vzdalenost_st) + r_vyska);
    paint->drawText (poz_x,poz_y,cislo);
    }
  paint->restore();
  }


void KAnalog::KresliText ( QPainter *paint ) {

//	QPainter p;
  QString nadpis1;
  QString nadpis2;
  int index;

  if (AnNadpis.length() >1) {
    if ((index = AnNadpis.find(" ")) != -1) {
    // mezera nalezena
      nadpis1 = AnNadpis.left(index);
      nadpis2 = AnNadpis.mid(index+1,(uint)(AnNadpis.length() - index - 1));
      }
    } else index = -1;

  paint->setPen(barvaTextu);
  paint->setFont(text_font);
  QFontMetrics fm = paint->fontMetrics();
  int r_vyska = fm.height()/ 2;
  switch (typ_zobrazeni)	{
    // kruznice - kreslime dve radky nad sebou cemtrovane
    case 1 :
      if (index == -1 ) paint->drawText( stred_x - fm.width(AnNadpis)/2, 104 + r_vyska , AnNadpis);
      else {
        // mame dve slova
        paint->drawText( stred_x - fm.width(nadpis1)/2, 106 + r_vyska/2 - 2, nadpis1);
        paint->drawText( stred_x - fm.width(nadpis2)/2, 106 + (r_vyska*3)/2 + 2, nadpis2);
        }
      paint->drawText( stred_x - fm.width(AnMJ)/2, 44 + r_vyska , AnMJ);
      break;
      // ctvrt oblouk kreslime dve radky nad sebou centrovane v pravem hornim rohu
    case 2 :
      if (index == -1 ) paint->drawText( 121 - fm.width(AnNadpis) , 6 + r_vyska , AnNadpis);
      else {
        paint->drawText( 121 - fm.width(nadpis1) , 6 + r_vyska , nadpis1);
        paint->drawText( 121 - fm.width(nadpis2) , 10 + r_vyska*2 , nadpis2);
        }
      paint->drawText( stred_x , 68 + r_vyska*2 , AnMJ);
      break;
    // horni oblouk
    case 3 :
      paint->drawText( stred_x - fm.width(AnNadpis)/2, 6 + r_vyska , AnNadpis);
      paint->drawText( PIX_POZADI_WIDTH -5 -fm.width(AnMJ), PIX_POZADI_WIDTH -r_vyska, AnMJ);

      break;
    }
  }

void KAnalog::KresliRucicku ( QPainter *p, float pozice) {

  double uhel;

  QString cislo;
  cislo.sprintf( "%5.1f",pozice);
  cislo=cislo.stripWhiteSpace();

  int delka = sirkaMK / 2 - 4;

  if (pozice < dolni_mez) pozice=dolni_mez;
  else {
    if (pozice > horni_mez) pozice = horni_mez;
    }
  /* nakresleni rucicky*/
  uhel = ((uhel_zobrazeni/(horni_mez-dolni_mez))*(pozice-dolni_mez))*((-1)*smer)+pocatecni_uhel;

  p->setPen(barvaTextu);
  p->setFont(text_font);
  QFontMetrics fm = p->fontMetrics();
  int r_vyska = fm.height()/ 2;

  switch (typ_zobrazeni) {
    case 1 :
      p->drawText( stred_x - fm.width(cislo)/2, 75 + r_vyska , cislo);
    break;
    case 2 :
      p->drawText( stred_x , 57 + r_vyska , cislo);
    break;
    case 3 :
      p->drawText( 5, PIX_POZADI_WIDTH -r_vyska, cislo);
    break;
    }

  p->setBrush( rucicka ); // nastavime barvu
  p->setPen ( rucicka );
  QPointArray pts;
  // k posuvu a k otoceni pouziva funkce paintu
  p->translate (stred_x, stred_y);
  p->rotate(-uhel);
  pts.setPoints( 4, -2, 0, 0, -2, delka, 0, 0, 2 );
  p->drawPolygon( pts );
  }



void KAnalog::KresliStupnici ( QPainter *paint ) {

  int horni_mez = sirkaMK/2;
  int dolni_h_mez = horni_mez - 10;
  int dolni_mez = horni_mez -6 ;
  int smer_stup = (-1)*smer;
  paint->save();
  paint->setPen ( stupnice);

  paint->translate( stred_x, stred_y );

  float stupne = smer_stup * (uhel_zobrazeni/(pocet_casti*(pocet_dilku)));

  // nakresleni prvni linky

  paint->rotate( -pocatecni_uhel);
  paint->drawLine( dolni_h_mez,0,horni_mez,0 );

  for ( int i=0; i<(pocet_casti); i++ ) {
    for ( int j=0; j<(pocet_dilku-1); j++) {
      paint->rotate( -stupne );
      paint->drawLine( dolni_mez,0,horni_mez,0 );
      }
    paint->rotate( -stupne );
    paint->drawLine( dolni_h_mez,0,horni_mez,0 );
    }
  paint->restore();
  }

/*********************************************************************/


KAnalog::KAnalog( QWidget *parent, const char *name, int Astart, int Aend, int type, int numberItem, int numberInItem, QColor Afinger, QColor Ascale, QColor AFont, QFont *analogFonts )
    : QFrame( parent, name ), dolni_mez(Astart), horni_mez(Aend), typ_zobrazeni(type), pocet_casti(numberItem), pocet_dilku(numberInItem), rucicka(Afinger), stupnice(Ascale) ,barvaTextu(AFont) {

  zobrazPozadi = true;
  zobrazRucicku = true;

  if (pocet_casti > 6) pocet_casti=6;
  else if (pocet_casti < 2) pocet_casti=2;


  if ( pocet_dilku > 6 ) pocet_dilku = 6;
  if ( pocet_dilku == 0 ) {
    if (pocet_casti < 4) pocet_dilku =5;
    else {
      if (pocet_casti < 6) pocet_dilku=4;
      else  pocet_dilku =3;
      }
    }

  pozice_rucicky=dolni_mez;
  /* hodnoty zavisle na typu zobrazeni */
  switch (typ_zobrazeni) {
  case 1 :
    smer = 1; /* smer =1 ve smeru (clockwise), smer =-1 proti smeru hod. rucicek */
    uhel_zobrazeni=270;
    pocatecni_uhel=225;
    stred_x=PIX_POZADI_WIDTH/2;
    stred_y=PIX_POZADI_WIDTH/2;
    sirkaMK=118;
    vzdalenost_st=37;
    break;
  case 2 :
    smer = -1; /* smer =1 ve smeru (clockwise), smer =-1 proti smeru hod. rucicek */
    uhel_zobrazeni=90;
    pocatecni_uhel=0;
    stred_x=13; //oprava
    stred_y=110; //oprava 107
    sirkaMK=210;
    vzdalenost_st=83;
    break;
  case 3 :
    smer = 1; /* smer =1 ve smeru (clockwise), smer =-1 proti smeru hod. rucicek */
    uhel_zobrazeni=90;
    pocatecni_uhel=135;
    stred_x=PIX_POZADI_WIDTH/2;
    stred_y=PIX_POZADI_WIDTH-15; //21
    sirkaMK=170;
    vzdalenost_st=65;
    break;
  }
  // konec hodnot zavislych na typu zobrazeni

  if (analogFonts == 0) { // pokud neni predan font nastavi se systemovy font
    st_font = kapp->font();
    text_font = kapp->font();
  }
  else {
    st_font= *analogFonts;
    text_font= *analogFonts;
  }

  pocet_zvyrazneni = 0;
  setMinimumSize( ANALOG_WIDTH , ANALOG_WIDTH );
  setMaximumSize( ANALOG_WIDTH , ANALOG_WIDTH );
  setFrameStyle( QFrame::Box | QFrame::Raised );
  setLineWidth( 2 );

  vrstvaPozadi= new QPixmap( ANALOG_WIDTH-8,ANALOG_WIDTH-8 ); // 4 body na kazde strane vynechame  na ramecek
  vrstvaStupnice = new QPixmap (  ANALOG_WIDTH-8,ANALOG_WIDTH-8  ); //
  vrstvaRucicky = new QPixmap (  ANALOG_WIDTH-8,ANALOG_WIDTH-8  ); //
  kompletVrstva = new QPixmap (  ANALOG_WIDTH-8,ANALOG_WIDTH-8  ); //

  setDefaultArcColor(); // nastavime standartni registry
  }

KAnalog::~KAnalog() {

  delete (vrstvaRucicky);
  delete (vrstvaPozadi);
  delete (kompletVrstva);
}

void KAnalog::setFingerColor (QColor fingerColor,  bool run ) {

  rucicka = fingerColor;
  if (run) {
     repaint ();
     zobrazRucicku = true;
    }
  }

void KAnalog::setFontColor (QColor fontColor,  bool run ) {

  barvaTextu = fontColor;
  if (run) {
     repaint ();
     zobrazPozadi = true;
    }
  }
  

void KAnalog::setScaleColor (QColor scale,  bool run) {

  zobrazPozadi = true;
  stupnice = scale;
  if (run) {
    zobrazPozadi=true;
    repaint ();
    }
  }


void KAnalog::setFinger (float finger, bool run ) {
  if (pozice_rucicky != finger) {
    pozice_rucicky = finger;
    zobrazRucicku = true; // pri jakemkoliv prekresleni prekreslime rucicku
    if (run) repaint ();
    }
  }



void KAnalog::setMember (int Count, bool run) {

  zobrazPozadi = true;
  pocet_casti=Count;
  if (run) {
    zobrazPozadi=true;
    repaint ();
    }
  }


void KAnalog::addArc (float a, float b, int regColor, bool run) {

  zobrazPozadi = true;
  if (pocet_zvyrazneni < 5) {
    zvyrazneni[pocet_zvyrazneni].start=a;
    zvyrazneni[pocet_zvyrazneni].end=b;
    if ((regColor <0) || (regColor > 8)) regColor=0;
    zvyrazneni[pocet_zvyrazneni++].barva=regColor;
    }
  if (run) {
    zobrazPozadi=true;
    repaint ();
    }
  }


void KAnalog::delArc (bool run) {

  zobrazPozadi = true;
  pocet_zvyrazneni = 0;
  if (run) {
    zobrazPozadi=true;
    repaint ();
    }
  }



void KAnalog::setRange (int Astart, int Aend , bool run) {

  zobrazPozadi = true;
  dolni_mez=Astart;
  horni_mez=Aend;
  // pokud zmenime rozasah musime prekrelit i rucicku
  zobrazRucicku = true;
  if (run) {
     zobrazPozadi=true;
     repaint ();
     }
  }


void KAnalog::setText (QString text_down, QString text_up, bool run) {

  zobrazPozadi = true;
  AnNadpis=text_down;
  AnMJ=text_up;
  if (run) {
    zobrazPozadi=true;
    repaint();
    }
  }

void KAnalog::setDefaultArcColor(bool run) {
   barvy_arc[0] = Qt::white;
   barvy_arc[1] = Qt::green;
   barvy_arc[2] = Qt::yellow;
   barvy_arc[3] = Qt::red;
   barvy_arc[4] = Qt::blue;
   barvy_arc[5] = Qt::cyan;
   barvy_arc[6] = Qt::magenta;
   barvy_arc[7] = Qt::gray;
   barvy_arc[8] = Qt::black;
  if (run) {
    zobrazPozadi=true;
    repaint();
    }
  }

void KAnalog::setArcColor(int reg, QColor color ) {
  if ((reg > -1) && (reg < 9)) barvy_arc[reg] = color;
  }

      
void KAnalog::resizeEvent( QResizeEvent * ) {
}

void KAnalog::repaintAll (void) {
  zobrazPozadi = true;
  zobrazRucicku = true;
  repaint ();
  }
  

void KAnalog::paintEvent( QPaintEvent *e ) {
  if (isVisible()) {
    QFrame::paintEvent(e);
    QPainter paint;

    if (zobrazPozadi) {
//      vrstvaPozadi->fill( pozadi );  //barva pozadi
      vrstvaPozadi->fill( this,0,0 );  //barva pozadi
      vrstvaStupnice->fill( Qt::white );  //barva pozadi
      paint.begin( vrstvaStupnice ); // kreslime na plochu pozadi
      //nakresleni mezikruzi
      KresliCMK ( &paint );
      // nakresleni stupnice
      KresliStupnici ( &paint );
      paint.end();
      vrstvaStupnice->setMask(vrstvaStupnice->createHeuristicMask());
      bitBlt( vrstvaPozadi, 0, 0, vrstvaStupnice, 0, 0, PIX_POZADI_WIDTH, PIX_POZADI_WIDTH, CopyROP,false ); //nakopirujeme rucicku
      paint.begin( vrstvaPozadi ); // kreslime na plochu pozadi
      // kresleni cisel
      KresliSt( &paint );
      // napsani nadpisu
      KresliText( &paint );
      paint.end ();
    }
    // kresleni rucicky
    if (zobrazRucicku) {
      vrstvaRucicky->fill( Qt::white );  //barva pozadi
      paint.begin( vrstvaRucicky ); // kreslime na plochu rucicky
      KresliRucicku ( &paint, pozice_rucicky);
      paint.end ();
    }
    if ((zobrazPozadi) || (zobrazRucicku)) { // novou kompletni vrstvu sestavime jen pokud doslo ke zmene
      bitBlt( kompletVrstva, 0, 0, vrstvaPozadi, 0, 0, PIX_POZADI_WIDTH, PIX_POZADI_WIDTH, CopyROP); //nakopirujeme vrstvu
      bitBlt( kompletVrstva, 0, 0, vrstvaRucicky, 0, 0, PIX_POZADI_WIDTH, PIX_POZADI_WIDTH, AndROP ); //nakopirujeme rucicku
     }
    bitBlt( this , PIX_POZADI_START, PIX_POZADI_START, kompletVrstva, 0, 0, PIX_POZADI_WIDTH, PIX_POZADI_WIDTH, CopyROP); //nakopirujeme vrstvu
    zobrazRucicku = false;
    zobrazPozadi = false; // od priste kreslime jen rucicku
    }
  }

void KAnalog::slotSetScaleFont(QFont newScaleFont){
  st_font = newScaleFont;
  zobrazPozadi=true;
  zobrazRucicku=true;
  repaint();
  }

void KAnalog::slotSetTextFont(QFont newTextFont){
  text_font = newTextFont;
  zobrazPozadi=true;
  zobrazRucicku=true;
  repaint();
  }

void KAnalog::slotSetAllFont(QFont newAllFont){
  st_font = newAllFont;
  text_font = newAllFont;
  zobrazPozadi=true;
  zobrazRucicku=true;
  repaint();
  }

