/***************************************************************************
                          napstertransfer.h  -  description
                             -------------------
    begin                : Sat Jan 22 2000
    copyright            : (C) 2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef NAPSTERTRANSFER_H
#define NAPSTERTRANSFER_H


/**The base class for napster file transfers.
It is used by NapsterDownload and NapsterUpload
classes
  *@author John Donoghue
  */

#include <qstring.h>

#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/socket.h>

#include <pthread.h>
#include <sys/time.h>

#include "ezthread.h"
class KSocket;

class NapsterTransfer
  : public EZThread
{

public:
  enum 
  { 
         //DL_GETERROR=-7,
         DL_REMOTEERROR=-6, DL_TIMEOUT=-5,DL_NOLOCALFILE=-4,DL_NOCONNECT=-3,
         DL_KILLED=-2,DL_ERROR=-1,
         DL_QUEUED=0,
         DL_INIT=1,
         DL_DOWNLOADING=2,DL_FINISHED=3 
  };

  bool isConnected() { return _connected; }

  // must provide a start function for the download type
  virtual bool start(int listen=-1,long sz=0)=0;

  virtual ~NapsterTransfer();

  bool cancel(); // kill the download

  //void setInit() { _status=DL_INIT; }   // required for dload2 :(

//  bool getInfo(long *status,long *read,long *total,long *bps);
  bool getInfo(long *status,long *read,long *total,long *bps, long *timeleft);

  QString getLocalName() { return _destname; }
 
  inline const char * getData() { return _buffer; }

  bool isDownload() { return _downloadtype; }
protected:
  // only can be created by inherited classes
  // such as Upload/Download
	NapsterTransfer(unsigned long ip,int port,const char *filename,const char *user,
        int speed,const char *desti,bool isdownload);

  void setSigpipeHandler();
protected:
  bool _downloadtype;
  
  struct sockaddr_in _sockaddr;

  QString _address;
  int _port;
  
  long _totalsize;
  long _readsize;
  //long _status;
  long _status;

  QString _filename;
  int _speed;
  QString _user;
  QString _dest;
  QString _destname;

  time_t _starttime;

  bool _terminate;
  bool _connected;

  int _timeoutval;

  long _bps;
  long _oldreadsize;

  char _buffer[2048];

};

#endif

